/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.IOException;
import org.apache.spark.SparkEnv;
import org.apache.spark.shuffle.ShuffleMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.UnsafeKVExternalSorter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import org.apache.spark.unsafe.memory.MemoryLocation;
import org.apache.spark.unsafe.memory.TaskMemoryManager;
import org.spark-project.guava.annotations.VisibleForTesting;

public final class UnsafeFixedWidthAggregationMap {
    private final byte[] emptyAggregationBuffer;
    private final StructType aggregationBufferSchema;
    private final StructType groupingKeySchema;
    private final UnsafeProjection groupingKeyProjection;
    private final BytesToBytesMap map;
    private final UnsafeRow currentAggregationBuffer = new UnsafeRow();
    private final boolean enablePerfMetrics;

    public static boolean supportsAggregationBufferSchema(StructType schema2) {
        for (StructField field : schema2.fields()) {
            if (UnsafeRow.isMutable((DataType)field.dataType())) continue;
            return false;
        }
        return true;
    }

    public UnsafeFixedWidthAggregationMap(InternalRow emptyAggregationBuffer, StructType aggregationBufferSchema, StructType groupingKeySchema, TaskMemoryManager taskMemoryManager, ShuffleMemoryManager shuffleMemoryManager, int initialCapacity, long pageSizeBytes, boolean enablePerfMetrics) {
        this.aggregationBufferSchema = aggregationBufferSchema;
        this.groupingKeyProjection = UnsafeProjection.create((StructType)groupingKeySchema);
        this.groupingKeySchema = groupingKeySchema;
        this.map = new BytesToBytesMap(taskMemoryManager, shuffleMemoryManager, initialCapacity, pageSizeBytes, enablePerfMetrics);
        this.enablePerfMetrics = enablePerfMetrics;
        UnsafeProjection valueProjection = UnsafeProjection.create((StructType)aggregationBufferSchema);
        this.emptyAggregationBuffer = valueProjection.apply(emptyAggregationBuffer).getBytes();
    }

    public UnsafeRow getAggregationBuffer(InternalRow groupingKey) {
        UnsafeRow unsafeGroupingKeyRow = this.groupingKeyProjection.apply(groupingKey);
        return this.getAggregationBufferFromUnsafeRow(unsafeGroupingKeyRow);
    }

    public UnsafeRow getAggregationBufferFromUnsafeRow(UnsafeRow unsafeGroupingKeyRow) {
        boolean putSucceeded;
        BytesToBytesMap.Location loc = this.map.lookup(unsafeGroupingKeyRow.getBaseObject(), unsafeGroupingKeyRow.getBaseOffset(), unsafeGroupingKeyRow.getSizeInBytes());
        if (!loc.isDefined() && !(putSucceeded = loc.putNewKey(unsafeGroupingKeyRow.getBaseObject(), unsafeGroupingKeyRow.getBaseOffset(), unsafeGroupingKeyRow.getSizeInBytes(), (Object)this.emptyAggregationBuffer, (long)Platform.BYTE_ARRAY_OFFSET, this.emptyAggregationBuffer.length))) {
            return null;
        }
        MemoryLocation address = loc.getValueAddress();
        this.currentAggregationBuffer.pointTo(address.getBaseObject(), address.getBaseOffset(), this.aggregationBufferSchema.length(), loc.getValueLength());
        return this.currentAggregationBuffer;
    }

    public KVIterator<UnsafeRow, UnsafeRow> iterator() {
        return new KVIterator<UnsafeRow, UnsafeRow>(){
            private final BytesToBytesMap.BytesToBytesMapIterator mapLocationIterator;
            private final UnsafeRow key;
            private final UnsafeRow value;
            {
                this.mapLocationIterator = UnsafeFixedWidthAggregationMap.this.map.destructiveIterator();
                this.key = new UnsafeRow();
                this.value = new UnsafeRow();
            }

            public boolean next() {
                if (this.mapLocationIterator.hasNext()) {
                    BytesToBytesMap.Location loc = this.mapLocationIterator.next();
                    MemoryLocation keyAddress = loc.getKeyAddress();
                    MemoryLocation valueAddress = loc.getValueAddress();
                    this.key.pointTo(keyAddress.getBaseObject(), keyAddress.getBaseOffset(), UnsafeFixedWidthAggregationMap.this.groupingKeySchema.length(), loc.getKeyLength());
                    this.value.pointTo(valueAddress.getBaseObject(), valueAddress.getBaseOffset(), UnsafeFixedWidthAggregationMap.this.aggregationBufferSchema.length(), loc.getValueLength());
                    return true;
                }
                return false;
            }

            public UnsafeRow getKey() {
                return this.key;
            }

            public UnsafeRow getValue() {
                return this.value;
            }

            public void close() {
            }
        };
    }

    public long getPeakMemoryUsedBytes() {
        return this.map.getPeakMemoryUsedBytes();
    }

    @VisibleForTesting
    public int getNumDataPages() {
        return this.map.getNumDataPages();
    }

    public void free() {
        this.map.free();
    }

    public void printPerfMetrics() {
        if (!this.enablePerfMetrics) {
            throw new IllegalStateException("Perf metrics not enabled");
        }
        System.out.println("Average probes per lookup: " + this.map.getAverageProbesPerLookup());
        System.out.println("Number of hash collisions: " + this.map.getNumHashCollisions());
        System.out.println("Time spent resizing (ns): " + this.map.getTimeSpentResizingNs());
        System.out.println("Total memory consumption (bytes): " + this.map.getTotalMemoryConsumption());
    }

    public UnsafeKVExternalSorter destructAndCreateExternalSorter() throws IOException {
        UnsafeKVExternalSorter sorter = new UnsafeKVExternalSorter(this.groupingKeySchema, this.aggregationBufferSchema, SparkEnv.get().blockManager(), this.map.getShuffleMemoryManager(), this.map.getPageSizeBytes(), this.map);
        return sorter;
    }
}

