/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.InferSchema$;
import org.apache.spark.sql.execution.datasources.json.JSONOptions;
import org.apache.spark.sql.execution.datasources.json.JacksonParser$;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001E\u0011aBS:p]\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!!n]8o\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\n\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\u0006_\u0001!\t\u0005M\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u00032u\u0001+\u0005c\u0001\u00143i%\u00111g\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]B\u0011!\u0002;za\u0016\u001c\u0018BA\u001d7\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006w9\u0002\r\u0001P\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003{yj\u0011\u0001C\u0005\u0003\u007f!\u0011Ab\u00159be.\u001cVm]:j_:DQ!\u0011\u0018A\u0002\t\u000bqa\u001c9uS>t7\u000f\u0005\u0003&\u0007\u0012\"\u0013B\u0001#.\u0005\ri\u0015\r\u001d\u0005\u0006\r:\u0002\raR\u0001\u0006M&dWm\u001d\t\u0004\u0011B\u001bfBA%O\u001d\tQU*D\u0001L\u0015\ta\u0005#\u0001\u0004=e>|GOP\u0005\u0002Q%\u0011qjJ\u0001\ba\u0006\u001c7.Y4f\u0013\t\t&KA\u0002TKFT!aT\u0014\u0011\u0005QKV\"A+\u000b\u0005Y;\u0016A\u00014t\u0015\tAF\"\u0001\u0004iC\u0012|w\u000e]\u0005\u00035V\u0013!BR5mKN#\u0018\r^;t\u0011\u0015a\u0006\u0001\"\u0011^\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0015q\u0016M\u00196l!\t\u0019r,\u0003\u0002a\t\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")1h\u0017a\u0001y!)1m\u0017a\u0001I\u0006\u0019!n\u001c2\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001d<\u0016!C7baJ,G-^2f\u0013\tIgMA\u0002K_\nDQ!Q.A\u0002\tCQ\u0001\\.A\u0002Q\n!\u0002Z1uCN\u001b\u0007.Z7b\u0011\u0015q\u0007\u0001\"\u0011p\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015\u001dA|\u0018\u0011AA\u0002\u0003\u000f\tY!a\u0006\u0002\u001aA!a%]:w\u0013\t\u0011xEA\u0005Gk:\u001cG/[8ocA\u00111\u0003^\u0005\u0003k\u0012\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0004\u0011^L\u0018B\u0001=S\u0005!IE/\u001a:bi>\u0014\bC\u0001>~\u001b\u0005Y(B\u0001?\t\u0003!\u0019\u0017\r^1msN$\u0018B\u0001@|\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u000bmj\u0007\u0019\u0001\u001f\t\u000b1l\u0007\u0019\u0001\u001b\t\r\u0005\u0015Q\u000e1\u00015\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007BBA\u0005[\u0002\u0007A'\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u000f\u00055Q\u000e1\u0001\u0002\u0010\u00059a-\u001b7uKJ\u001c\b\u0003\u0002%Q\u0003#\u00012aFA\n\u0013\r\t)\u0002\u0007\u0002\u0007\r&dG/\u001a:\t\u000b\u0005k\u0007\u0019\u0001\"\t\u000f\u0005mQ\u000e1\u0001\u0002\u001e\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\tX\u0003\u0011\u0019wN\u001c4\n\t\u0005\u001d\u0012\u0011\u0005\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005i1M]3bi\u0016\u0014\u0015m]3SI\u0012$b!a\f\u0002<\u0005u\u0002#BA\u0019\u0003o!SBAA\u001a\u0015\r\t)DC\u0001\u0004e\u0012$\u0017\u0002BA\u001d\u0003g\u00111A\u0015#E\u0011\u0019Y\u0014\u0011\u0006a\u0001y!9\u0011qHA\u0015\u0001\u00049\u0015AC5oaV$\b+\u0019;ig\"9\u00111\t\u0001\u0005\n\u0005\u0015\u0013\u0001E2iK\u000e\\7i\u001c8tiJ\f\u0017N\u001c;t)\u0011\t9%!\u0014\u0011\u0007\u0019\nI%C\u0002\u0002L\u001d\u0012A!\u00168ji\"9\u0011qJA!\u0001\u0004!\u0014AB:dQ\u0016l\u0017\r\u0003\u0004\u0002T\u0001!\teI\u0001\ti>\u001cFO]5oO\"9\u0011q\u000b\u0001\u0005B\u0005e\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005m\u0003c\u0001\u0014\u0002^%\u0019\u0011qL\u0014\u0003\u0007%sG\u000fC\u0004\u0002d\u0001!\t%!\u001a\u0002\r\u0015\fX/\u00197t)\u0011\t9'!\u001c\u0011\u0007\u0019\nI'C\u0002\u0002l\u001d\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002p\u0005\u0005\u0004\u0019AA9\u0003\u0015yG\u000f[3s!\r1\u00131O\u0005\u0004\u0003k:#aA!os\u0002")
public class JsonFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "json";
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        None$ none$;
        if (files.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            JSONOptions parsedOptions = new JSONOptions(options);
            String columnNameOfCorruptRecord = (String)parsedOptions.columnNameOfCorruptRecord().getOrElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final String apply() {
                    return this.sparkSession$1.sessionState().conf().columnNameOfCorruptRecord();
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            });
            FileStatus[] jsonFiles = (FileStatus[])((TraversableOnce)files.filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    String name = status.getPath().getName();
                    return name.startsWith("_") || name.startsWith(".");
                }
            })).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            StructType jsonSchema = InferSchema$.MODULE$.infer(this.createBaseRdd(sparkSession, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])jsonFiles)), columnNameOfCorruptRecord, parsedOptions);
            this.checkConstraints(jsonSchema);
            none$ = new Some((Object)jsonSchema);
        }
        return none$;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options);
        parsedOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, bucketId, dataSchema, context);
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptions parsedOptions = new JSONOptions(options);
        String columnNameOfCorruptRecord = (String)parsedOptions.columnNameOfCorruptRecord().getOrElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$2;

            public final String apply() {
                return this.sparkSession$2.sessionState().conf().columnNameOfCorruptRecord();
            }
            {
                this.sparkSession$2 = sparkSession$2;
            }
        });
        return new Serializable(this, requiredSchema, broadcastedHadoopConf, parsedOptions, columnNameOfCorruptRecord){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final JSONOptions parsedOptions$1;
            private final String columnNameOfCorruptRecord$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<B> lines = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Text x$1) {
                        return x$1.toString();
                    }
                });
                return JacksonParser$.MODULE$.parseJson(lines, this.requiredSchema$1, this.columnNameOfCorruptRecord$1, this.parsedOptions$1);
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.parsedOptions$1 = parsedOptions$1;
                this.columnNameOfCorruptRecord$1 = columnNameOfCorruptRecord$1;
            }
        };
    }

    private RDD<String> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths) {
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConf());
        Configuration conf = job.getConfiguration();
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$2) {
                return x$2.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (paths.nonEmpty()) {
            FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        }
        return sparkSession.sparkContext().hadoopRDD((JobConf)conf, TextInputFormat.class, LongWritable.class, Text.class, sparkSession.sparkContext().hadoopRDD$default$5()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<LongWritable, Text> x$3) {
                return ((Text)x$3._2()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    private void checkConstraints(StructType schema) {
        if (schema.fieldNames().length != ((String[])Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).distinct()).length) {
            String duplicateColumns = ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, String[]>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        String[] ys = (String[])A1._2();
                        if (ys.length > 1) {
                            object = new StringBuilder().append((Object)"\"").append((Object)x).append((Object)"\"").toString();
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String[]> x1) {
                    String[] ys;
                    Tuple2<String, String[]> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (String[])tuple2._2()).length > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate column(s) : ", " found, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateColumns}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot save to JSON format"})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public String toString() {
        return "JSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof JsonFileFormat;
    }
}

