/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\rf!B\u0001\u0003\u0001!\u0001\"!\u0005)beF,X\r\u001e$jY\u00164uN]7bi*\u00111\u0001B\u0001\ba\u0006\u0014\u0018/^3u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001cb\u0001A\t\u00187\u0005:\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\r\u0005\u0002\u001935\tA!\u0003\u0002\u001b\t\tQa)\u001b7f\r>\u0014X.\u0019;\u0011\u0005qyR\"A\u000f\u000b\u0005yA\u0011aB:pkJ\u001cWm]\u0005\u0003Au\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u0011!%J\u0007\u0002G)\u0011AEC\u0001\tS:$XM\u001d8bY&\u0011ae\t\u0002\b\u0019><w-\u001b8h!\t\u0011\u0002&\u0003\u0002*'\ta1+\u001a:jC2L'0\u00192mK\")1\u0006\u0001C\u0001[\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001/!\ty\u0003!D\u0001\u0003\u0011\u0015\t\u0004\u0001\"\u00113\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u00014!\t!tG\u0004\u0002\u0013k%\u0011agE\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027'!)1\b\u0001C!e\u0005AAo\\*ue&tw\rC\u0003>\u0001\u0011\u0005c(\u0001\u0005iCND7i\u001c3f)\u0005y\u0004C\u0001\nA\u0013\t\t5CA\u0002J]RDQa\u0011\u0001\u0005B\u0011\u000ba!Z9vC2\u001cHCA#I!\t\u0011b)\u0003\u0002H'\t9!i\\8mK\u0006t\u0007\"B%C\u0001\u0004Q\u0015!B8uQ\u0016\u0014\bC\u0001\nL\u0013\ta5CA\u0002B]fDQA\u0014\u0001\u0005B=\u000bA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$R\u0001U*ZG\"\u0004\"\u0001G)\n\u0005I#!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002+N\u0001\u0004)\u0016\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001,X\u001b\u0005A\u0011B\u0001-\t\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015QV\n1\u0001\\\u0003\rQwN\u0019\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b\u0011\"\\1qe\u0016$WoY3\u000b\u0005\u0001d\u0011A\u00025bI>|\u0007/\u0003\u0002c;\n\u0019!j\u001c2\t\u000b\u0011l\u0005\u0019A3\u0002\u000f=\u0004H/[8ogB!AGZ\u001a4\u0013\t9\u0017HA\u0002NCBDQ!['A\u0002)\f!\u0002Z1uCN\u001b\u0007.Z7b!\tYg.D\u0001m\u0015\ti\u0007\"A\u0003usB,7/\u0003\u0002pY\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bE\u0004A\u0011\u0001:\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005gZ<\u0018\u0010E\u0002\u0013i*L!!^\n\u0003\r=\u0003H/[8o\u0011\u0015!\u0006\u000f1\u0001V\u0011\u0015A\b\u000f1\u0001f\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\u0006uB\u0004\ra_\u0001\u0006M&dWm\u001d\t\u0006y\u0006%\u0011q\u0002\b\u0004{\u0006\u0015ab\u0001@\u0002\u00045\tqPC\u0002\u0002\u00021\na\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0007\u0005\u001d1#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0004'\u0016\f(bAA\u0004'A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016}\u000b!AZ:\n\t\u0005e\u00111\u0003\u0002\u000b\r&dWm\u0015;biV\u001chABA\u000f\u0001\u0001\u000byBA\u0005GS2,G+\u001f9fgN1\u00111D\t\u0002\"\u001d\u00022AEA\u0012\u0013\r\t)c\u0005\u0002\b!J|G-^2u\u0011-\tI#a\u0007\u0003\u0016\u0004%\t!a\u000b\u0002\t\u0011\fG/Y\u000b\u0002w\"Q\u0011qFA\u000e\u0005#\u0005\u000b\u0011B>\u0002\u000b\u0011\fG/\u0019\u0011\t\u0017\u0005M\u00121\u0004BK\u0002\u0013\u0005\u00111F\u0001\t[\u0016$\u0018\rZ1uC\"Q\u0011qGA\u000e\u0005#\u0005\u000b\u0011B>\u0002\u00135,G/\u00193bi\u0006\u0004\u0003bCA\u001e\u00037\u0011)\u001a!C\u0001\u0003W\tabY8n[>tW*\u001a;bI\u0006$\u0018\r\u0003\u0006\u0002@\u0005m!\u0011#Q\u0001\nm\fqbY8n[>tW*\u001a;bI\u0006$\u0018\r\t\u0005\bW\u0005mA\u0011AA\")!\t)%!\u0013\u0002L\u00055\u0003\u0003BA$\u00037i\u0011\u0001\u0001\u0005\b\u0003S\t\t\u00051\u0001|\u0011\u001d\t\u0019$!\u0011A\u0002mDq!a\u000f\u0002B\u0001\u00071\u0010\u0003\u0006\u0002R\u0005m\u0011\u0011!C\u0001\u0003'\nAaY8qsRA\u0011QIA+\u0003/\nI\u0006C\u0005\u0002*\u0005=\u0003\u0013!a\u0001w\"I\u00111GA(!\u0003\u0005\ra\u001f\u0005\n\u0003w\ty\u0005%AA\u0002mD!\"!\u0018\u0002\u001cE\u0005I\u0011AA0\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0019+\u0007m\f\u0019g\u000b\u0002\u0002fA!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!C;oG\",7m[3e\u0015\r\tygE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA:\u0003S\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t9(a\u0007\u0012\u0002\u0013\u0005\u0011qL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\tY(a\u0007\u0012\u0002\u0013\u0005\u0011qL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\ty(a\u0007\u0002\u0002\u0013\u0005\u0013\u0011Q\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u000e\u0006!!.\u0019<b\u0013\rA\u0014q\u0011\u0005\u000b\u0003'\u000bY\"!A\u0005\u0002\u0005U\u0015\u0001\u00049s_\u0012,8\r^!sSRLX#A \t\u0015\u0005e\u00151DA\u0001\n\u0003\tY*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007)\u000bi\nC\u0005\u0002 \u0006]\u0015\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\t\u0015\u0005\r\u00161DA\u0001\n\u0003\n)+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\u000bE\u0003\u0002*\u0006=&*\u0004\u0002\u0002,*\u0019\u0011QV\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0006-&\u0001C%uKJ\fGo\u001c:\t\u0015\u0005U\u00161DA\u0001\n\u0003\t9,\u0001\u0005dC:,\u0015/^1m)\r)\u0015\u0011\u0018\u0005\n\u0003?\u000b\u0019,!AA\u0002)C\u0001\"PA\u000e\u0003\u0003%\tE\u0010\u0005\nw\u0005m\u0011\u0011!C!\u0003\u007f#\"!a!\t\u0013\r\u000bY\"!A\u0005B\u0005\rGcA#\u0002F\"I\u0011qTAa\u0003\u0003\u0005\rAS\u0004\n\u0003\u0013\u0004\u0011\u0011!E\u0001\u0003\u0017\f\u0011BR5mKRK\b/Z:\u0011\t\u0005\u001d\u0013Q\u001a\u0004\n\u0003;\u0001\u0011\u0011!E\u0001\u0003\u001f\u001cR!!4\u0002R\u001e\u0002\u0012\"a5\u0002Zn\\80!\u0012\u000e\u0005\u0005U'bAAl'\u00059!/\u001e8uS6,\u0017\u0002BAn\u0003+\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001dY\u0013Q\u001aC\u0001\u0003?$\"!a3\t\u0013m\ni-!A\u0005F\u0005}\u0006BCAs\u0003\u001b\f\t\u0011\"!\u0002h\u0006)\u0011\r\u001d9msRA\u0011QIAu\u0003W\fi\u000fC\u0004\u0002*\u0005\r\b\u0019A>\t\u000f\u0005M\u00121\u001da\u0001w\"9\u00111HAr\u0001\u0004Y\bBCAy\u0003\u001b\f\t\u0011\"!\u0002t\u00069QO\\1qa2LH\u0003BA{\u0003{\u0004BA\u0005;\u0002xB1!#!?|wnL1!a?\u0014\u0005\u0019!V\u000f\u001d7fg!Q\u0011q`Ax\u0003\u0003\u0005\r!!\u0012\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003\u0004\u00055\u0017\u0011!C\u0005\u0005\u000b\t1B]3bIJ+7o\u001c7wKR\u0011!q\u0001\t\u0005\u0003\u000b\u0013I!\u0003\u0003\u0003\f\u0005\u001d%AB(cU\u0016\u001cG\u000fC\u0004\u0003\u0010\u0001!IA!\u0005\u0002\u0015M\u0004H.\u001b;GS2,7\u000f\u0006\u0003\u0002F\tM\u0001b\u0002B\u000b\u0005\u001b\u0001\ra_\u0001\tC2dg)\u001b7fg\"9!\u0011\u0004\u0001\u0005\n\tm\u0011!D5t'VlW.\u0019:z\r&dW\rF\u0002F\u0005;A\u0001Ba\b\u0003\u0018\u0001\u0007!\u0011E\u0001\u0005M&dW\r\u0005\u0003\u0002\u0012\t\r\u0012\u0002\u0002B\u0013\u0003'\u0011A\u0001U1uQ\"9!\u0011\u0006\u0001\u0005B\t-\u0012\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#B#\u0003.\t=\u0002B\u0002+\u0003(\u0001\u0007Q\u000bC\u0004\u00032\t\u001d\u0002\u0019\u00016\u0002\rM\u001c\u0007.Z7b\u0011\u001d\u0011)\u0004\u0001C!\u0005o\t1\"[:Ta2LG/\u00192mKR9QI!\u000f\u0003<\tu\u0002B\u0002+\u00034\u0001\u0007Q\u000b\u0003\u0004e\u0005g\u0001\r!\u001a\u0005\t\u0005\u007f\u0011\u0019\u00041\u0001\u0003\"\u0005!\u0001/\u0019;i\u0011!\u0011\u0019\u0005\u0001C!\u0011\t\u0015\u0013A\b2vS2$'+Z1eKJ<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]Z\u000bG.^3t)A\u00119Ea\u0019\u0003f\t\u001d$1\u000eB8\u0005w\u0012i\bE\u0004\u0013\u0005\u0013\u0012iEa\u0015\n\u0007\t-3CA\u0005Gk:\u001cG/[8ocA\u0019\u0001Da\u0014\n\u0007\tECAA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015a(Q\u000bB,\u0013\u0011\t\t,!\u0004\u0011\t\te#qL\u0007\u0003\u00057R1A!\u0018\t\u0003!\u0019\u0017\r^1msN$\u0018\u0002\u0002B1\u00057\u00121\"\u00138uKJt\u0017\r\u001c*po\"1AK!\u0011A\u0002UCa!\u001bB!\u0001\u0004Q\u0007b\u0002B5\u0005\u0003\u0002\rA[\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9!Q\u000eB!\u0001\u0004Q\u0017A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0005c\u0012\t\u00051\u0001\u0003t\u00059a-\u001b7uKJ\u001c\b#\u0002?\u0002\n\tU\u0004c\u0001\u000f\u0003x%\u0019!\u0011P\u000f\u0003\r\u0019KG\u000e^3s\u0011\u0019!'\u0011\ta\u0001K\"A!q\u0010B!\u0001\u0004\u0011\t)\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004BAa!\u0003\n6\u0011!Q\u0011\u0006\u0004\u0005\u000f{\u0016\u0001B2p]\u001aLAAa#\u0003\u0006\ni1i\u001c8gS\u001e,(/\u0019;j_:DqAa$\u0001\t\u0003\u0012\t*A\u0006ck&dGMU3bI\u0016\u0014H\u0003\u0005B$\u0005'\u0013)Ja&\u0003\u001a\nm%Q\u0014BP\u0011\u0019!&Q\u0012a\u0001+\"1\u0011N!$A\u0002)DqA!\u001b\u0003\u000e\u0002\u0007!\u000eC\u0004\u0003n\t5\u0005\u0019\u00016\t\u0011\tE$Q\u0012a\u0001\u0005gBa\u0001\u001aBG\u0001\u0004)\u0007\u0002\u0003B@\u0005\u001b\u0003\rA!!\t\u000f\t\r\u0006\u0001\"\u0011\u0003&\u0006Y!-^5mI^\u0013\u0018\u000e^3s)\u001d\u0001&q\u0015BY\u0005gC\u0001B!+\u0003\"\u0002\u0007!1V\u0001\u000bgFd7i\u001c8uKb$\bc\u0001,\u0003.&\u0019!q\u0016\u0005\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0004j\u0005C\u0003\rA\u001b\u0005\u0007I\n\u0005\u0006\u0019A3\b\u0011\t]&\u0001#\u0001\t\u0005s\u000b\u0011\u0003U1scV,GOR5mK\u001a{'/\\1u!\ry#1\u0018\u0004\b\u0003\tA\t\u0001\u0003B_'\u0015\u0011Y,E\u0011(\u0011\u001dY#1\u0018C\u0001\u0005\u0003$\"A!/\t\u0011\t\u0015'1\u0018C\u0005\u0005\u000f\fAc\u001c<feJLG-Z'j]N\u0003H.\u001b;TSj,GC\u0002Be\u0005\u001f\u0014I\u000eE\u0002\u0013\u0005\u0017L1A!4\u0014\u0005\u0011)f.\u001b;\t\u0011\tE'1\u0019a\u0001\u0005'\f\u0001\u0003]1scV,GO\u00117pG.\u001c\u0016N_3\u0011\u0007I\u0011).C\u0002\u0003XN\u0011A\u0001T8oO\"A!q\u0011Bb\u0001\u0004\u0011\t\tC\u0005\u0003^\nmF\u0011\u0001\u0002\u0003`\u00061\u0012N\\5uS\u0006d\u0017N_3M_\u000e\fGNS8c\rVt7\r\u0006\n\u0003b\n\u0015(q\u001eBz\u0005k\u00149Pa?\u0003\u0000\u000e\rA\u0003\u0002Be\u0005GDaA\u0017Bn\u0001\u0004Y\u0006\u0002\u0003Bt\u00057\u0004\rA!;\u0002\u001fI,\u0017/^5sK\u0012\u001cu\u000e\\;n]N\u0004BA\u0005Bvg%\u0019!Q^\n\u0003\u000b\u0005\u0013(/Y=\t\u0011\tE$1\u001ca\u0001\u0005c\u0004RA\u0005Bv\u0005kBa!\u001bBn\u0001\u0004Q\u0007\u0002\u0003Bi\u00057\u0004\rAa5\t\u000f\te(1\u001ca\u0001\u000b\u0006\u0001Ro]3NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0005{\u0014Y\u000e1\u0001F\u0003U\u0001\u0018M]9vKR4\u0015\u000e\u001c;feB+8\u000f\u001b#po:Dqa!\u0001\u0003\\\u0002\u0007Q)\u0001\u000bbgN,X.\u001a\"j]\u0006\u0014\u00180S:TiJLgn\u001a\u0005\b\u0007\u000b\u0011Y\u000e1\u0001F\u0003Y\t7o];nK&sG/\u000f\u001cJgRKW.Z:uC6\u0004\b\"CB\u0005\u0005w#\tAAB\u0006\u0003mIg.\u001b;jC2L'0\u001a#sSZ,'oU5eK*{'MR;oGR11QBB\t\u0007/!BA!3\u0004\u0010!1!la\u0002A\u0002mC\u0001ba\u0005\u0004\b\u0001\u00071QC\u0001\u000bS:\u0004X\u000f\u001e$jY\u0016\u001c\b#\u0002\n\u0003l\u0006=\u0001\u0002\u0003Bi\u0007\u000f\u0001\rAa5\t\u0013\rm!1\u0018C\u0001\u0005\ru\u0011A\u0003:fC\u0012\u001c6\r[3nCR)1oa\b\u00042!A1\u0011EB\r\u0001\u0004\u0019\u0019#A\u0004g_>$XM]:\u0011\u000bq\fIa!\n\u0011\t\r\u001d2QF\u0007\u0003\u0007SQ1\u0001YB\u0016\u0015\t\u0019A\"\u0003\u0003\u00040\r%\"A\u0002$p_R,'\u000f\u0003\u0004U\u00073\u0001\r!\u0016\u0005\n\u0007k\u0011Y\f\"\u0001\t\u0007o\t1$\\3sO\u0016lU\r^1ti>\u0014X\rU1scV,GoU2iK6\fG#\u00026\u0004:\ru\u0002bBB\u001e\u0007g\u0001\rA[\u0001\u0010[\u0016$\u0018m\u001d;pe\u0016\u001c6\r[3nC\"91qHB\u001a\u0001\u0004Q\u0017!\u00049beF,X\r^*dQ\u0016l\u0017\rC\u0005\u0004D\tmF\u0011\u0001\u0002\u0004F\u0005QR.\u001a:hK6K7o]5oO:+H\u000e\\1cY\u00164\u0015.\u001a7egR)!na\u0012\u0004J!911HB!\u0001\u0004Q\u0007bBB \u0007\u0003\u0002\rA\u001b\u0005\t\u0007\u001b\u0012Y\f\"\u0001\u0004P\u00051R.\u001a:hKN\u001b\u0007.Z7bg&s\u0007+\u0019:bY2,G\u000eF\u0003t\u0007#\u001a)\u0006C\u0004\u0004T\r-\u0003\u0019A>\u0002\u0019\u0019LG.Z:U_R{Wo\u00195\t\rQ\u001bY\u00051\u0001V\u0011!\u0019IFa/\u0005\u0002\rm\u0013\u0001\u0006:fC\u0012\u001c6\r[3nC\u001a\u0013x.\u001c$p_R,'\u000fF\u0003k\u0007;\u001a\t\u0007\u0003\u0005\u0004`\r]\u0003\u0019AB\u0013\u0003\u00191wn\u001c;fe\"A11MB,\u0001\u0004\u0019)'A\u0005d_:4XM\u001d;feB\u0019qfa\u001a\n\u0007\r%$A\u0001\fQCJ\fX/\u001a;TG\",W.Y\"p]Z,'\u000f^3s\u0011!\u0019iGa/\u0005\n\r=\u0014a\u00063fg\u0016\u0014\u0018.\u00197ju\u0016\u001c6\r[3nCN#(/\u001b8h)\r\u00198\u0011\u000f\u0005\b\u0007g\u001aY\u00071\u00014\u00031\u00198\r[3nCN#(/\u001b8h\u0011)\u00199Ha/C\u0002\u0013\u00051\u0011P\u0001\u0014CB\f7\r[3QCJ\fX/\u001a;M_\u001e<WM]\u000b\u0003\u0007w\u0002Ba! \u0004\b6\u00111q\u0010\u0006\u0005\u0007\u0003\u001b\u0019)A\u0004m_\u001e<\u0017N\\4\u000b\t\r\u0015\u00151R\u0001\u0005kRLG.\u0003\u0003\u0004\n\u000e}$A\u0002'pO\u001e,'\u000fC\u0005\u0004\u000e\nm\u0006\u0015!\u0003\u0004|\u0005!\u0012\r]1dQ\u0016\u0004\u0016M]9vKRdunZ4fe\u0002B!b!%\u0003<\n\u0007I\u0011AB=\u00035\u0001\u0018M]9vKRdunZ4fe\"I1Q\u0013B^A\u0003%11P\u0001\u000fa\u0006\u0014\u0018/^3u\u0019><w-\u001a:!\u0011)\u0019IJa/C\u0002\u0013\u000511T\u0001\u001ce\u0016$\u0017N]3diB\u000b'/];fi2{wm\u001d,jCNce\t\u000e&\u0016\u0005\t%\u0007\"CBP\u0005w\u0003\u000b\u0011\u0002Be\u0003q\u0011X\rZ5sK\u000e$\b+\u0019:rk\u0016$Hj\\4t-&\f7\u000b\u0014$5\u0015\u0002B!Ba\u0001\u0003<\u0006\u0005I\u0011\u0002B\u0003\u0001")
public class ParquetFileFormat
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private volatile ParquetFileFormat$FileTypes$ FileTypes$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void redirectParquetLogsViaSLF4J() {
        ParquetFileFormat$.MODULE$.redirectParquetLogsViaSLF4J();
    }

    public static java.util.logging.Logger parquetLogger() {
        return ParquetFileFormat$.MODULE$.parquetLogger();
    }

    public static java.util.logging.Logger apacheParquetLogger() {
        return ParquetFileFormat$.MODULE$.apacheParquetLogger();
    }

    public static StructType readSchemaFromFooter(Footer footer, ParquetSchemaConverter parquetSchemaConverter) {
        return ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, parquetSchemaConverter);
    }

    public static Option<StructType> mergeSchemasInParallel(Seq<FileStatus> seq, SparkSession sparkSession) {
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel(seq, sparkSession);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParquetFileFormat$FileTypes$ FileTypes$lzycompute() {
        ParquetFileFormat parquetFileFormat = this;
        synchronized (parquetFileFormat) {
            if (this.FileTypes$module != null) return this.FileTypes$module;
            this.FileTypes$module = new ParquetFileFormat$FileTypes$(this);
            return this.FileTypes$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "ParquetFormat";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof ParquetFileFormat;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, ParquetOutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, ParquetOutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)dataSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetBinaryAsString())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetINT96AsTimestamp())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set("parquet.compression", parquetOptions.compressionCodec());
        if (conf.get("parquet.enable.summary-metadata") == null) {
            conf.setBoolean("parquet.enable.summary-metadata", false);
        }
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, bucketId, context);
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        ParquetOptions parquetOptions = new ParquetOptions(parameters, sparkSession.sessionState().conf());
        boolean shouldMergeSchemas = parquetOptions.mergeSchema();
        boolean mergeRespectSummaries = BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_SCHEMA_RESPECT_SUMMARIES()));
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.metadata().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            }).orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.data().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            })).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetFileFormat$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    public ParquetFileFormat$FileTypes$ FileTypes() {
        return this.FileTypes$module == null ? this.FileTypes$lzycompute() : this.FileTypes$module;
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles2) {
        FileStatus[] leaves = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)allFiles2.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath()) || !f.getPath().getName().startsWith("_") && !f.getPath().getName().startsWith(".");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })).toArray(ClassTag$.MODULE$.apply(FileStatus.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(f.getPath());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$2) {
                String string = x$2.getPath().getName();
                String string2 = "_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_common_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$4) {
                return x$4.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return this.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), ParquetSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)requiredSchema);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING())));
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP())));
        None$ pushed = new StringOps(Predef$.MODULE$.augmentString(sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()))).toBoolean() ? ((TraversableOnce)filters.flatMap((Function1)new Serializable(this, requiredSchema){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;

            public final Iterable<FilterPredicate> apply(Filter x$5) {
                return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.requiredSchema$1, x$5));
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
            }
        }) : None$.MODULE$;
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        boolean enableVectorizedReader = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && resultSchema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$6) {
                return x$6.dataType() instanceof AtomicType;
            }
        });
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        return new Serializable(this, partitionSchema, requiredSchema, (Option)pushed, broadcastedHadoopConf, enableVectorizedReader, returningBatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetFileFormat $outer;
            public final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final Option pushed$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final boolean enableVectorizedReader$1;
            private final boolean returningBatch$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedParquetRecordReader;
                Predef$.MODULE$.assert(file.partitionValues().numFields() == this.partitionSchema$1.size());
                FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                ParquetInputSplit split = new ParquetInputSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), attemptId);
                if (this.enableVectorizedReader$1) {
                    VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader();
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildReader$1 $outer;
                        private final PartitionedFile file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionSchema$1, this.file$1.partitionValues()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                    vectorizedReader.initBatch(this.partitionSchema$1, file.partitionValues());
                    if (this.returningBatch$1) {
                        vectorizedReader.enableReturningBatches();
                    }
                    vectorizedParquetRecordReader = vectorizedReader;
                } else {
                    ParquetRecordReader parquetRecordReader;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to parquet-mr"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    Option option = this.pushed$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate filter2 = (FilterPredicate)some.x();
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport(), FilterCompat.get((FilterPredicate)filter2, null));
                    } else {
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new ParquetReadSupport());
                    }
                    ParquetRecordReader reader = parquetRecordReader;
                    reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    vectorizedParquetRecordReader = reader;
                }
                VectorizedParquetRecordReader parquetReader = vectorizedParquetRecordReader;
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(parquetReader);
                if (parquetReader instanceof VectorizedParquetRecordReader && this.enableVectorizedReader$1) {
                    recordReaderIterator = iter;
                } else {
                    Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    JoinedRow joinedRow = new JoinedRow();
                    UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    recordReaderIterator = iter.map(new Serializable(this, file, joinedRow, appendPartitionColumns){
                        public static final long serialVersionUID = 0L;
                        private final PartitionedFile file$1;
                        private final JoinedRow joinedRow$1;
                        private final UnsafeProjection appendPartitionColumns$1;

                        public final UnsafeRow apply(InternalRow d) {
                            return this.appendPartitionColumns$1.apply((InternalRow)this.joinedRow$1.apply(d, this.file$1.partitionValues()));
                        }
                        {
                            this.file$1 = file$1;
                            this.joinedRow$1 = joinedRow$1;
                            this.appendPartitionColumns$1 = appendPartitionColumns$1;
                        }
                    });
                }
                return recordReaderIterator;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.pushed$1 = pushed$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.returningBatch$1 = returningBatch$1;
            }
        };
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return new ParquetOutputWriterFactory(sqlContext.conf(), dataSchema, sqlContext.sessionState().newHadoopConf(), options);
    }

    public ParquetFileFormat() {
        FileFormat$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }

    public class FileTypes
    implements Product,
    Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ ParquetFileFormat $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 0: {
                    seq = this.data();
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ParquetFileFormat org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(ParquetFileFormat $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

