/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.File;
import java.net.URI;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LoadDataCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001>\u0011q\u0002T8bI\u0012\u000bG/Y\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0006\u0001AQb\u0004\n\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011qCB\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011D\u0005\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002\u001c95\t!!\u0003\u0002\u001e\u0005\ty!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0004Qe>$Wo\u0019;\u0011\u0005})\u0013B\u0001\u0014!\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0003A!f\u0001\n\u0003I\u0013!\u0002;bE2,W#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\na\u0001^1cY\u0016\u0004\u0003\u0002C\u0019\u0001\u0005+\u0007I\u0011\u0001\u001a\u0002\tA\fG\u000f[\u000b\u0002gA\u0011Ag\u000e\b\u0003?UJ!A\u000e\u0011\u0002\rA\u0013X\rZ3g\u0013\tA\u0014H\u0001\u0004TiJLgn\u001a\u0006\u0003m\u0001B\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0006a\u0006$\b\u000e\t\u0005\t{\u0001\u0011)\u001a!C\u0001}\u00059\u0011n\u001d'pG\u0006dW#A \u0011\u0005}\u0001\u0015BA!!\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0011\u0001\u0003\u0012\u0003\u0006IaP\u0001\tSNdunY1mA!AQ\t\u0001BK\u0002\u0013\u0005a(A\u0006jg>3XM]<sSR,\u0007\u0002C$\u0001\u0005#\u0005\u000b\u0011B \u0002\u0019%\u001cxJ^3soJLG/\u001a\u0011\t\u0011%\u0003!Q3A\u0005\u0002)\u000b\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003-\u00032a\b'O\u0013\ti\u0005E\u0001\u0004PaRLwN\u001c\t\u0003\u001f\u000et!\u0001\u00151\u000f\u0005EsfB\u0001*^\u001d\t\u0019FL\u0004\u0002U7:\u0011QK\u0017\b\u0003-fk\u0011a\u0016\u0006\u00031:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011qLF\u0001\bG\u0006$\u0018\r\\8h\u0013\t\t'-\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002`-%\u0011A-\u001a\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002bE\"Aq\r\u0001B\tB\u0003%1*\u0001\u0006qCJ$\u0018\u000e^5p]\u0002BQ!\u001b\u0001\u0005\u0002)\fa\u0001P5oSRtDCB6m[:|\u0007\u000f\u0005\u0002\u001c\u0001!)\u0001\u0006\u001ba\u0001U!)\u0011\u0007\u001ba\u0001g!)Q\b\u001ba\u0001\u007f!)Q\t\u001ba\u0001\u007f!)\u0011\n\u001ba\u0001\u0017\")!\u000f\u0001C!g\u0006\u0019!/\u001e8\u0015\u0007Q\f\u0019\u0001E\u0002vuvt!A\u001e=\u000f\u0005Y;\u0018\"A\u0011\n\u0005e\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003wr\u00141aU3r\u0015\tI\b\u0005\u0005\u0002\u007f\u007f6\ta!C\u0002\u0002\u0002\u0019\u00111AU8x\u0011\u001d\t)!\u001da\u0001\u0003\u000f\tAb\u001d9be.\u001cVm]:j_:\u00042A`A\u0005\u0013\r\tYA\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\n\u0003\u001f\u0001\u0011\u0011!C\u0001\u0003#\tAaY8qsRY1.a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011!A\u0013Q\u0002I\u0001\u0002\u0004Q\u0003\u0002C\u0019\u0002\u000eA\u0005\t\u0019A\u001a\t\u0011u\ni\u0001%AA\u0002}B\u0001\"RA\u0007!\u0003\u0005\ra\u0010\u0005\t\u0013\u00065\u0001\u0013!a\u0001\u0017\"I\u0011q\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019CK\u0002+\u0003KY#!a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003c\u0001\u0013AC1o]>$\u0018\r^5p]&!\u0011QGA\u0016\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003s\u0001\u0011\u0013!C\u0001\u0003w\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002>)\u001a1'!\n\t\u0013\u0005\u0005\u0003!%A\u0005\u0002\u0005\r\u0013AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000bR3aPA\u0013\u0011%\tI\u0005AI\u0001\n\u0003\t\u0019%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u00055\u0003!%A\u0005\u0002\u0005=\u0013AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0003#R3aSA\u0013\u0011%\t)\u0006AA\u0001\n\u0003\n9&A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'\u0001\u0003mC:<'BAA2\u0003\u0011Q\u0017M^1\n\u0007a\ni\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000e\t\u0004?\u0005=\u0014bAA9A\t\u0019\u0011J\u001c;\t\u0013\u0005U\u0004!!A\u0005\u0002\u0005]\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003s\ny\bE\u0002 \u0003wJ1!! !\u0005\r\te.\u001f\u0005\u000b\u0003\u0003\u000b\u0019(!AA\u0002\u00055\u0014a\u0001=%c!I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013qQ\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0012\t\u0007\u0003\u0017\u000b\t*!\u001f\u000e\u0005\u00055%bAAHA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0015Q\u0012\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0011\u0011T\u0001\tG\u0006tW)];bYR\u0019q(a'\t\u0015\u0005\u0005\u0015QSA\u0001\u0002\u0004\tI\bC\u0005\u0002 \u0002\t\t\u0011\"\u0011\u0002\"\u00061Q-];bYN$2aPAR\u0011)\t\t)!(\u0002\u0002\u0003\u0007\u0011\u0011P\u0004\n\u0003O\u0013\u0011\u0011!E\u0001\u0003S\u000bq\u0002T8bI\u0012\u000bG/Y\"p[6\fg\u000e\u001a\t\u00047\u0005-f\u0001C\u0001\u0003\u0003\u0003E\t!!,\u0014\u000b\u0005-\u0016q\u0016\u0013\u0011\u0015\u0005E\u0016q\u0017\u00164\u007f}Z5.\u0004\u0002\u00024*\u0019\u0011Q\u0017\u0011\u0002\u000fI,h\u000e^5nK&!\u0011\u0011XAZ\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\u000e\u0005\bS\u0006-F\u0011AA_)\t\tI\u000b\u0003\u0006\u0002B\u0006-\u0016\u0011!C#\u0003\u0007\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033B!\"a2\u0002,\u0006\u0005I\u0011QAe\u0003\u0015\t\u0007\u000f\u001d7z)-Y\u00171ZAg\u0003\u001f\f\t.a5\t\r!\n)\r1\u0001+\u0011\u0019\t\u0014Q\u0019a\u0001g!1Q(!2A\u0002}Ba!RAc\u0001\u0004y\u0004BB%\u0002F\u0002\u00071\n\u0003\u0006\u0002X\u0006-\u0016\u0011!CA\u00033\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\\\u0006\r\b\u0003B\u0010M\u0003;\u0004\u0002bHApUMzthS\u0005\u0004\u0003C\u0004#A\u0002+va2,W\u0007C\u0005\u0002f\u0006U\u0017\u0011!a\u0001W\u0006\u0019\u0001\u0010\n\u0019\t\u0015\u0005%\u00181VA\u0001\n\u0013\tY/A\u0006sK\u0006$'+Z:pYZ,GCAAw!\u0011\tY&a<\n\t\u0005E\u0018Q\f\u0002\u0007\u001f\nTWm\u0019;")
public class LoadDataCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final String path;
    private final boolean isLocal;
    private final boolean isOverwrite;
    private final Option<Map<String, String>> partition;

    public static Function1<Tuple5<TableIdentifier, String, Object, Object, Option<Map<String, String>>>, LoadDataCommand> tupled() {
        return LoadDataCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<Object, Function1<Object, Function1<Option<Map<String, String>>, LoadDataCommand>>>>> curried() {
        return LoadDataCommand$.MODULE$.curried();
    }

    @Override
    public Seq<Attribute> output() {
        return RunnableCommand$class.output(this);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return RunnableCommand$class.children(this);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String path() {
        return this.path;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isOverwrite() {
        return this.isOverwrite;
    }

    public Option<Map<String, String>> partition() {
        return this.partition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        URI loadPath;
        URI uRI;
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable targetTable = catalog.getTableMetadata(this.table());
        String tableIdentwithDB = targetTable.identifier().quotedString();
        if (DDLUtils$.MODULE$.isDatasourceTable(targetTable)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA is not supported for datasource tables: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (targetTable.partitionColumnNames().nonEmpty()) {
            if (this.partition().isEmpty()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table '", "' is partitioned, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but no partition spec is provided"})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (targetTable.partitionColumnNames().size() != ((TraversableOnce)this.partition().get()).size()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table '", "' is partitioned, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but number of columns in provided partition spec (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((TraversableOnce)this.partition().get()).size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"do not match number of partitioned columns in table "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(s", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)targetTable.partitionColumnNames().size())}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            ((MapLike)this.partition().get()).keys().foreach((Function1)new Serializable(this, targetTable, tableIdentwithDB){
                public static final long serialVersionUID = 0L;
                private final CatalogTable targetTable$1;
                private final String tableIdentwithDB$1;

                public final void apply(String colName) {
                    if (this.targetTable$1.partitionColumnNames().contains((Object)colName)) {
                        return;
                    }
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table '", "' is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentwithDB$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned, but the specified partition spec refers to a column that is "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not partitioned: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                {
                    this.targetTable$1 = targetTable$1;
                    this.tableIdentwithDB$1 = tableIdentwithDB$1;
                }
            });
        } else if (this.partition().nonEmpty()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA target table '", "' is not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentwithDB}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned, but a partition spec was provided."})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.isLocal()) {
            URI uri = Utils$.MODULE$.resolveURI(this.path());
            if (!new File(uri.getPath()).exists()) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA input path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            uRI = uri;
        } else {
            URI uri = new URI(this.path());
            if (uri.getScheme() == null || uri.getAuthority() == null) {
                String authority;
                String defaultFSConf = sparkSession.sessionState().newHadoopConf().get("fs.default.name");
                URI defaultFS = defaultFSConf == null ? new URI("") : new URI(defaultFSConf);
                String scheme = uri.getScheme() == null ? defaultFS.getScheme() : uri.getScheme();
                String string = authority = uri.getAuthority() == null ? defaultFS.getAuthority() : uri.getAuthority();
                if (scheme == null) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOAD DATA: URI scheme is required for non-local input paths: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                String uriPath = uri.getPath();
                String absolutePath = uriPath != null && uriPath.startsWith("/") ? uriPath : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/user/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("user.name"), uriPath}));
                uRI = new URI(scheme, authority, absolutePath, uri.getQuery(), uri.getFragment());
            } else {
                uRI = loadPath = uri;
            }
        }
        if (this.partition().nonEmpty()) {
            catalog.loadPartition(targetTable.identifier(), loadPath.toString(), (Map)this.partition().get(), this.isOverwrite(), false, true, false);
            return (Seq)Seq$.MODULE$.empty();
        } else {
            catalog.loadTable(targetTable.identifier(), loadPath.toString(), this.isOverwrite(), false);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public LoadDataCommand copy(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        return new LoadDataCommand(table, path, isLocal, isOverwrite, partition);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public String copy$default$2() {
        return this.path();
    }

    public boolean copy$default$3() {
        return this.isLocal();
    }

    public boolean copy$default$4() {
        return this.isOverwrite();
    }

    public Option<Map<String, String>> copy$default$5() {
        return this.partition();
    }

    public String productPrefix() {
        return "LoadDataCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = this.partition();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isOverwrite());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isLocal());
                break;
            }
            case 1: {
                object = this.path();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LoadDataCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LoadDataCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        LoadDataCommand loadDataCommand = (LoadDataCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = loadDataCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.path();
        String string2 = loadDataCommand.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.isLocal() != loadDataCommand.isLocal()) return false;
        if (this.isOverwrite() != loadDataCommand.isOverwrite()) return false;
        Option<Map<String, String>> option = this.partition();
        Option<Map<String, String>> option2 = loadDataCommand.partition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!loadDataCommand.canEqual(this)) return false;
        return true;
    }

    public LoadDataCommand(TableIdentifier table, String path, boolean isLocal, boolean isOverwrite, Option<Map<String, String>> partition) {
        this.table = table;
        this.path = path;
        this.isLocal = isLocal;
        this.isOverwrite = isOverwrite;
        this.partition = partition;
        RunnableCommand$class.$init$(this);
    }
}

