/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class CompactibleFileStreamLog$ {
    public static final CompactibleFileStreamLog$ MODULE$;
    private final String COMPACT_FILE_SUFFIX;

    static {
        new CompactibleFileStreamLog$();
    }

    public String COMPACT_FILE_SUFFIX() {
        return this.COMPACT_FILE_SUFFIX;
    }

    public long getBatchIdFromFileName(String fileName) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(fileName)).stripSuffix(this.COMPACT_FILE_SUFFIX()))).toLong();
    }

    public boolean isCompactionBatch(long batchId, int compactInterval) {
        return (batchId + 1L) % (long)compactInterval == 0L;
    }

    public Seq<Object> getValidBatchesBeforeCompactionBatch(long compactionBatchId, int compactInterval) {
        Predef$.MODULE$.assert(this.isCompactionBatch(compactionBatchId, compactInterval), (Function0)new Serializable(compactionBatchId){
            public static final long serialVersionUID = 0L;
            private final long compactionBatchId$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a compaction batch"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.compactionBatchId$1)}));
            }
            {
                this.compactionBatchId$1 = compactionBatchId$1;
            }
        });
        return new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(0L, compactionBatchId - (long)compactInterval))).until((Object)BoxesRunTime.boxToLong((long)compactionBatchId));
    }

    public Seq<Object> getAllValidBatches(long batchId, long compactInterval) {
        Predef$.MODULE$.assert(batchId >= 0L);
        long start = package$.MODULE$.max(0L, (batchId + 1L) / compactInterval * compactInterval - 1L);
        return new RichLong(Predef$.MODULE$.longWrapper(start)).to((Object)BoxesRunTime.boxToLong((long)batchId));
    }

    public long nextCompactionBatchId(long batchId, long compactInterval) {
        return (batchId + compactInterval + 1L) / compactInterval * compactInterval - 1L;
    }

    private CompactibleFileStreamLog$() {
        MODULE$ = this;
        this.COMPACT_FILE_SUFFIX = ".compact";
    }
}

