/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class ParquetReadSupport$ {
    public static final ParquetReadSupport$ MODULE$;
    private final String SPARK_ROW_REQUESTED_SCHEMA;
    private final String SPARK_METADATA_KEY;

    static {
        new ParquetReadSupport$();
    }

    public String SPARK_ROW_REQUESTED_SCHEMA() {
        return this.SPARK_ROW_REQUESTED_SCHEMA;
    }

    public String SPARK_METADATA_KEY() {
        return this.SPARK_METADATA_KEY;
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetSchema.asGroupType(), catalystSchema);
        return clippedParquetFields.isEmpty() ? ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE() : (MessageType)Types.buildMessage().addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public Type org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType(Type parquetType, DataType catalystType) {
        MapType mapType;
        Type type;
        ArrayType arrayType;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType && !this.isPrimitiveCatalystType((arrayType = (ArrayType)dataType).elementType())) {
            type = this.clipParquetListType(parquetType.asGroupType(), arrayType.elementType());
        } else if (!(!(dataType instanceof MapType) || this.isPrimitiveCatalystType((mapType = (MapType)dataType).keyType()) && this.isPrimitiveCatalystType(mapType.valueType()))) {
            type = this.clipParquetMapType(parquetType.asGroupType(), mapType.keyType(), mapType.valueType());
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            type = this.clipParquetGroup(parquetType.asGroupType(), structType);
        } else {
            type = parquetType;
        }
        return type;
    }

    private boolean isPrimitiveCatalystType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = !bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Type clipParquetListType(GroupType parquetList, DataType elementType) {
        GroupType repeatedGroup;
        Type type;
        block5: {
            block4: {
                Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(elementType));
                if (parquetList.getOriginalType() == null && parquetList.isRepetition(Type.Repetition.REPEATED)) {
                    type = this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType((Type)parquetList, elementType);
                    return type;
                }
                OriginalType originalType = parquetList.getOriginalType();
                OriginalType originalType2 = OriginalType.LIST;
                Predef$.MODULE$.assert(!(originalType != null ? !originalType.equals(originalType2) : originalType2 != null), (Function0)new Serializable(parquetList){
                    public static final long serialVersionUID = 0L;
                    private final GroupType parquetList$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Invalid Parquet schema. Original type of annotated Parquet lists must be LIST: ").append((Object)this.parquetList$1.toString()).toString();
                    }
                    {
                        this.parquetList$1 = parquetList$1;
                    }
                });
                Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED), (Function0)new Serializable(parquetList){
                    public static final long serialVersionUID = 0L;
                    private final GroupType parquetList$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append((Object)this.parquetList$1).toString();
                    }
                    {
                        this.parquetList$1 = parquetList$1;
                    }
                });
                Predef$.MODULE$.assert(!parquetList.getType(0).isPrimitive());
                repeatedGroup = parquetList.getType(0).asGroupType();
                if (repeatedGroup.getFieldCount() > 1) break block4;
                String string = repeatedGroup.getName();
                String string2 = "array";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = repeatedGroup.getName();
                String string4 = new StringBuilder().append((Object)parquetList.getName()).append((Object)"_tuple").toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType((Type)repeatedGroup, elementType)).named(parquetList.getName());
            return type;
        }
        type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField((Type)Types.repeatedGroup().addField(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType(repeatedGroup.getType(0), elementType)).named(repeatedGroup.getName())).named(parquetList.getName());
        return type;
    }

    private GroupType clipParquetMapType(GroupType parquetMap, DataType keyType, DataType valueType) {
        Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(keyType) || !this.isPrimitiveCatalystType(valueType));
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        GroupType clippedRepeatedGroup = (GroupType)((Types.BaseGroupBuilder)Types.repeatedGroup().as(repeatedGroup.getOriginalType())).addField(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType(parquetKeyType, keyType)).addField(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType(parquetValueType, valueType)).named(repeatedGroup.getName());
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetMap.getRepetition()).as(parquetMap.getOriginalType())).addField((Type)clippedRepeatedGroup).named(parquetMap.getName());
    }

    private GroupType clipParquetGroup(GroupType parquetRecord, StructType structType) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetRecord, structType);
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetRecord.getRepetition()).as(parquetRecord.getOriginalType())).addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(parquetRecord.getName());
    }

    private Seq<Type> clipParquetGroupFields(GroupType parquetRecord, StructType structType) {
        Map parquetFieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord.getFields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Type> apply(Type f) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)f.getName()), (Object)f);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        boolean x$2 = false;
        boolean x$3 = ParquetSchemaConverter$.MODULE$.$lessinit$greater$default$1();
        boolean x$4 = ParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2();
        boolean x$5 = ParquetSchemaConverter$.MODULE$.$lessinit$greater$default$4();
        ParquetSchemaConverter toParquet = new ParquetSchemaConverter(x$3, x$4, x$2, x$5);
        return (Seq)structType.map((Function1)new Serializable(parquetFieldMap, toParquet){
            public static final long serialVersionUID = 0L;
            private final Map parquetFieldMap$1;
            public final ParquetSchemaConverter toParquet$1;

            public final Type apply(StructField f) {
                return (Type)this.parquetFieldMap$1.get((Object)f.name()).map((Function1)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final StructField f$1;

                    public final Type apply(Type x$1) {
                        return ParquetReadSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$clipParquetType(x$1, this.f$1.dataType());
                    }
                    {
                        this.f$1 = f$1;
                    }
                }).getOrElse((Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.clipParquetGroupFields.1 $outer;
                    private final StructField f$1;

                    public final Type apply() {
                        return this.$outer.toParquet$1.convertField(this.f$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.parquetFieldMap$1 = parquetFieldMap$1;
                this.toParquet$1 = toParquet$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public StructType expandUDT(StructType schema) {
        return (StructType)this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1((DataType)schema);
    }

    public final DataType org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1(DataType dataType) {
        DataType dataType2;
        DataType dataType3 = dataType;
        if (dataType3 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType3;
            dataType2 = arrayType.copy(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1(arrayType.elementType()), arrayType.copy$default$2());
        } else if (dataType3 instanceof MapType) {
            MapType mapType = (MapType)dataType3;
            dataType2 = mapType.copy(this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1(mapType.keyType()), this.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1(mapType.valueType()), mapType.copy$default$3());
        } else if (dataType3 instanceof StructType) {
            StructType structType = (StructType)dataType3;
            StructField[] expandedFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])structType.fields()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(StructField f) {
                    DataType x$6 = ParquetReadSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$expand$1(f.dataType());
                    String x$7 = f.copy$default$1();
                    boolean x$8 = f.copy$default$3();
                    Metadata x$9 = f.copy$default$4();
                    return f.copy(x$7, x$6, x$8, x$9);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            dataType2 = structType.copy(expandedFields);
        } else if (dataType3 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        } else {
            dataType2 = dataType3;
        }
        return dataType2;
    }

    private ParquetReadSupport$() {
        MODULE$ = this;
        this.SPARK_ROW_REQUESTED_SCHEMA = "org.apache.spark.sql.parquet.row.requested_schema";
        this.SPARK_METADATA_KEY = "org.apache.spark.sql.parquet.row.metadata";
    }
}

