/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001>\u0011QC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7M\u0003\u0002\u0004\t\u0005AQ\r_2iC:<WM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tAQ\t_2iC:<W\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004Qe>$Wo\u0019;\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0002A!f\u0001\n\u0003y\u0012\u0001B7pI\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003K\u0019\nQ\u0001\u001d7b]NT!a\n\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0012\u0003\u001b\t\u0013x.\u00193dCN$Xj\u001c3f\u0011!Y\u0003A!E!\u0002\u0013\u0001\u0013!B7pI\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\u0011I!A\r\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005E\u0001\u0001\"\u0002\u00106\u0001\u0004\u0001\u0003\"B\u00176\u0001\u0004y\u0003\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011I\u001f\u0002\u000f5,GO]5dgV\ta\b\u0005\u0003@\t\u001asU\"\u0001!\u000b\u0005\u0005\u0013\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0019e#\u0001\u0006d_2dWm\u0019;j_:L!!\u0012!\u0003\u00075\u000b\u0007\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h!\ty%+D\u0001Q\u0015\t\tF!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003'B\u0013\u0011bU)M\u001b\u0016$(/[2\t\u0011U\u0003\u0001\u0012!Q!\ny\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\u0006/\u0002!\t\u0005W\u0001\u0013_V$\b/\u001e;QCJ$\u0018\u000e^5p]&tw-F\u0001Z!\t\t#,\u0003\u0002\\E\ta\u0001+\u0019:uSRLwN\\5oO\"AQ\f\u0001EC\u0002\u0013\u0005c&A\u0007dC:|g.[2bY&TX\r\u001a\u0005\t?\u0002A\t\u0011)Q\u0005_\u0005q1-\u00198p]&\u001c\u0017\r\\5{K\u0012\u0004\u0003bB1\u0001\u0005\u0004%IAY\u0001\bi&lWm\\;u+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003!!WO]1uS>t'B\u00015\u0017\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003U\u0016\u0014\u0001\u0002R;sCRLwN\u001c\u0005\u0007Y\u0002\u0001\u000b\u0011B2\u0002\u0011QLW.Z8vi\u0002B#a\u001b8\u0011\u0005Uy\u0017B\u00019\u0017\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005s\u0001!\u0015\r\u0011\"\u0003t\u00039\u0011X\r\\1uS>tg)\u001e;ve\u0016,\u0012\u0001\u001e\t\u0004kZDX\"A4\n\u0005]<'A\u0002$viV\u0014X\rE\u0002zyzl\u0011A\u001f\u0006\u0003w\"\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005uT(!\u0003\"s_\u0006$7-Y:u!\t)r0C\u0002\u0002\u0002Y\u00111!\u00118z\u0011%\t)\u0001\u0001E\u0001B\u0003&A/A\bsK2\fG/[8o\rV$XO]3!Q\r\t\u0019A\u001c\u0005\b\u0003\u0017\u0001A\u0011KA\u0007\u0003%!w\u000e\u0015:fa\u0006\u0014X\r\u0006\u0002\u0002\u0010A\u0019Q#!\u0005\n\u0007\u0005MaC\u0001\u0003V]&$\bbBA\f\u0001\u0011E\u0013\u0011D\u0001\nI>,\u00050Z2vi\u0016$\"!a\u0007\u0011\r\u0005u\u00111EA\u0014\u001b\t\tyBC\u0002\u0002\"!\t1A\u001d3e\u0013\u0011\t)#a\b\u0003\u0007I#E\t\u0005\u0003\u0002*\u0005-R\"\u0001\u0014\n\u0007\u00055bEA\u0006J]R,'O\\1m%><\b\u0002CA\u0019\u0001\u0011Ec!a\r\u0002%\u0011|W\t_3dkR,'I]8bI\u000e\f7\u000f^\u000b\u0005\u0003k\ti\u0004\u0006\u0002\u00028A!\u0011\u0010`A\u001d!\u0011\tY$!\u0010\r\u0001\u0011A\u0011qHA\u0018\u0005\u0004\t\tEA\u0001U#\r\t\u0019E \t\u0004+\u0005\u0015\u0013bAA$-\t9aj\u001c;iS:<\u0007\"CA&\u0001\u0005\u0005I\u0011AA'\u0003\u0011\u0019w\u000e]=\u0015\u000ba\ny%!\u0015\t\u0011y\tI\u0005%AA\u0002\u0001B\u0001\"LA%!\u0003\u0005\ra\f\u0005\n\u0003+\u0002\u0011\u0013!C\u0001\u0003/\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002Z)\u001a\u0001%a\u0017,\u0005\u0005u\u0003\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u001a\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\n\tGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u000f\u0016\u0004_\u0005m\u0003\"CA<\u0001\u0005\u0005I\u0011IA=\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\ta\tC\u0005\u0002~\u0001\t\t\u0011\"\u0001\u0002\u0000\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0011\t\u0004+\u0005\r\u0015bAAC-\t\u0019\u0011J\u001c;\t\u0013\u0005%\u0005!!A\u0005\u0002\u0005-\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004}\u00065\u0005BCAH\u0003\u000f\u000b\t\u00111\u0001\u0002\u0002\u0006\u0019\u0001\u0010J\u0019\t\u0013\u0005M\u0005!!A\u0005B\u0005U\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\u0005#BAM\u00037sX\"\u0001\"\n\u0007\u0005u%I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\t\u000bAA\u0001\n\u0003\t\u0019+\u0001\u0005dC:,\u0015/^1m)\u0011\t)+a+\u0011\u0007U\t9+C\u0002\u0002*Z\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0010\u0006}\u0015\u0011!a\u0001}\"I\u0011q\u0016\u0001\u0002\u0002\u0013\u0005\u0013\u0011W\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u00161\u0017\u0005\n\u0003\u001f\u000bi+!AA\u0002y<q!a.\u0003\u0011\u0003\tI,A\u000bCe>\fGmY1ti\u0016C8\r[1oO\u0016,\u00050Z2\u0011\u0007E\tYL\u0002\u0004\u0002\u0005!\u0005\u0011QX\n\u0006\u0003w\u000byL\u0007\t\u0004+\u0005\u0005\u0017bAAb-\t1\u0011I\\=SK\u001aDqANA^\t\u0003\t9\r\u0006\u0002\u0002:\"Y\u00111ZA^\u0005\u0004%\t\u0001BAg\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/\u0006\u0002\u0002PB\u0019Q/!5\n\u0007\u0005MwMA\u0010Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0011\"a6\u0002<\u0002\u0006I!a4\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b\u0005\u0003\u0006\u0002\\\u0006m\u0016\u0011!CA\u0003;\fQ!\u00199qYf$R\u0001OAp\u0003CDaAHAm\u0001\u0004\u0001\u0003BB\u0017\u0002Z\u0002\u0007q\u0006\u0003\u0006\u0002f\u0006m\u0016\u0011!CA\u0003O\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002j\u0006U\b#B\u000b\u0002l\u0006=\u0018bAAw-\t1q\n\u001d;j_:\u0004R!FAyA=J1!a=\u0017\u0005\u0019!V\u000f\u001d7fe!I\u0011q_Ar\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\u0002\u0004BCA~\u0003w\u000b\t\u0011\"\u0003\u0002~\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0010E\u0002H\u0005\u0003I1Aa\u0001I\u0005\u0019y%M[3di\u0002")
public class BroadcastExchangeExec
extends Exchange {
    private final BroadcastMode mode;
    private final SparkPlan child;
    private Map<String, SQLMetric> metrics;
    private SparkPlan canonicalized;
    private final transient Duration timeout;
    private transient Future<Broadcast<Object>> relationFuture;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private Map metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.metrics;
        }
    }

    private SparkPlan canonicalized$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = new BroadcastExchangeExec(this.mode().canonicalized(), (SparkPlan)this.child().canonicalized());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.canonicalized;
        }
    }

    private Future relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0)new Serializable(this, executionId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BroadcastExchangeExec $outer;
                    public final String executionId$1;

                    public final Broadcast<Object> apply() {
                        return (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.$outer.sparkContext(), this.executionId$1, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$relationFuture$1 $outer;

                            public final Broadcast<Object> apply() {
                                try {
                                    long beforeCollect = System.nanoTime();
                                    InternalRow[] input = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().child().executeCollect();
                                    if (input.length >= 512000000) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table with more than 512 millions rows: ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.length)})));
                                    }
                                    long beforeBuild = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                                    long dataSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])input).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(InternalRow x$1) {
                                            return ((UnsafeRow)x$1).getSizeInBytes();
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("dataSize").$plus$eq(dataSize);
                                    if (dataSize >= 0x200000000L) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table that is larger than 8GB: ", " GB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(dataSize >> 30))})));
                                    }
                                    Object relation = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().mode().transform(input);
                                    long beforeBroadcast = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                                    Broadcast broadcasted = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                                    SQLMetrics$.MODULE$.postDriverMetricUpdates(this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext(), this.$outer.executionId$1, (Seq<SQLMetric>)this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().metrics().values().toSeq());
                                    return broadcasted;
                                }
                                catch (OutOfMemoryError outOfMemoryError) {
                                    throw new OutOfMemoryError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough memory to build and broadcast the table to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all worker nodes. As a workaround, you can either disable broadcast by setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to -1 or increase the spark driver "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory by setting ", " to a higher value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark.driver.memory"}))).toString()).initCause(outOfMemoryError.getCause());
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ BroadcastExchangeExec org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.executionId$1 = executionId$1;
                    }
                }, (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
            return this.relationFuture;
        }
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public SparkPlan canonicalized() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    private Duration timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return this.bitmap$trans$0 ? this.relationFuture : this.relationFuture$lzycompute();
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        return (Broadcast)ThreadUtils$.MODULE$.awaitResult(this.relationFuture(), this.timeout());
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        SparkPlan sparkPlan;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                sparkPlan = this.child();
                break;
            }
            case 0: {
                sparkPlan = this.mode();
            }
        }
        return sparkPlan;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        int timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0 ? Duration$.MODULE$.Inf() : new package.DurationInt(package$.MODULE$.DurationInt(timeoutValue)).seconds();
    }
}

