/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.execution.stat.StatFunctions;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StatFunctions$
implements Logging {
    public static final StatFunctions$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new StatFunctions$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Seq<Seq<Object>> multipleApproxQuantiles(Dataset<Row> df, Seq<String> cols, Seq<Object> probabilities, double relativeError) {
        Predef$.MODULE$.require(relativeError >= 0.0, (Function0)new Serializable(relativeError){
            public static final long serialVersionUID = 0L;
            private final double relativeError$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Relative Error must be non-negative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.relativeError$1)}));
            }
            {
                this.relativeError$1 = relativeError$1;
            }
        });
        Seq columns2 = (Seq)cols.map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$1;

            public final Column apply(String colName) {
                StructField field = this.df$1.schema().apply(colName);
                Predef$.MODULE$.require(field.dataType() instanceof NumericType, (Function0)new Serializable(this, colName, field){
                    public static final long serialVersionUID = 0L;
                    private final String colName$1;
                    private final StructField field$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Quantile calculation for column ", " with data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.colName$1, this.field$1.dataType()}))).append((Object)" is not supported.").toString();
                    }
                    {
                        this.colName$1 = colName$1;
                        this.field$1 = field$1;
                    }
                });
                return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply(colName).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3()));
            }
            {
                this.df$1 = df$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        QuantileSummaries[] emptySummaries = (QuantileSummaries[])Array$.MODULE$.fill(cols.size(), (Function0)new Serializable(relativeError){
            public static final long serialVersionUID = 0L;
            private final double relativeError$1;

            public final QuantileSummaries apply() {
                return new QuantileSummaries(QuantileSummaries$.MODULE$.defaultCompressThreshold(), this.relativeError$1, QuantileSummaries$.MODULE$.$lessinit$greater$default$3(), QuantileSummaries$.MODULE$.$lessinit$greater$default$4());
            }
            {
                this.relativeError$1 = relativeError$1;
            }
        }, ClassTag$.MODULE$.apply(QuantileSummaries.class));
        QuantileSummaries[] summaries = (QuantileSummaries[])df.select((Seq<Column>)columns2).rdd().aggregate((Object)emptySummaries, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries[] apply(QuantileSummaries[] summaries, Row row) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$apply$1(summaries, row);
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries[] apply(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$merge$1(sum1, sum2);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(QuantileSummaries.class)));
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])summaries).map((Function1)new Serializable(probabilities){
            public static final long serialVersionUID = 0L;
            private final Seq probabilities$1;

            public final Seq<Object> apply(QuantileSummaries summary) {
                return (Seq)this.probabilities$1.flatMap((Function1)new Serializable(this, summary){
                    public static final long serialVersionUID = 0L;
                    private final QuantileSummaries summary$1;

                    public final Iterable<Object> apply(double quantile) {
                        return Option$.MODULE$.option2Iterable(this.summary$1.query(quantile));
                    }
                    {
                        this.summary$1 = summary$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.probabilities$1 = probabilities$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public double pearsonCorrelation(Dataset<Row> df, Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "correlation");
        return counts.Ck() / package$.MODULE$.sqrt(counts.MkX() * counts.MkY());
    }

    private StatFunctions.CovarianceCounter collectStatisticalData(Dataset<Row> df, Seq<String> cols, String functionName) {
        Predef$.MODULE$.require(cols.length() == 2, (Function0)new Serializable(functionName){
            public static final long serialVersionUID = 0L;
            private final String functionName$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently ", " calculation is supported "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.functionName$1}))).append((Object)"between two columns.").toString();
            }
            {
                this.functionName$1 = functionName$1;
            }
        });
        ((IterableLike)cols.map((Function1)new Serializable(df){
            public static final long serialVersionUID = 0L;
            private final Dataset df$2;

            public final Tuple2<String, Option<StructField>> apply(String name) {
                return new Tuple2((Object)name, (Object)Predef$.MODULE$.refArrayOps((Object[])this.df$2.schema().fields()).find((Function1)new Serializable(this, name){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(StructField x$1) {
                        String string = x$1.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                }));
            }
            {
                this.df$2 = df$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(functionName){
            public static final long serialVersionUID = 0L;
            public final String functionName$1;

            public final void apply(Tuple2<String, Option<StructField>> x0$2) {
                Tuple2<String, Option<StructField>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Option data = (Option)tuple2._2();
                    Predef$.MODULE$.require(data.nonEmpty(), (Function0)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final String name$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find column with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$2}));
                        }
                        {
                            this.name$2 = name$2;
                        }
                    });
                    Predef$.MODULE$.require(((StructField)data.get()).dataType() instanceof NumericType, (Function0)new Serializable(this, data){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.collectStatisticalData.3 $outer;
                        private final Option data$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently ", " calculation "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.functionName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for columns with dataType ", " not supported."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((StructField)this.data$1.get()).dataType()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.data$1 = data$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.functionName$1 = functionName$1;
            }
        });
        Seq columns2 = (Seq)cols.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(String n) {
                return Column$.MODULE$.apply((Expression)new Cast(Column$.MODULE$.apply(n).expr(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (StatFunctions.CovarianceCounter)df.select((Seq<Column>)columns2).queryExecution().toRdd().aggregate((Object)new StatFunctions.CovarianceCounter(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StatFunctions.CovarianceCounter apply(StatFunctions.CovarianceCounter counter, InternalRow row) {
                return counter.add(row.getDouble(0), row.getDouble(1));
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StatFunctions.CovarianceCounter apply(StatFunctions.CovarianceCounter baseCounter, StatFunctions.CovarianceCounter other) {
                return baseCounter.merge(other);
            }
        }, ClassTag$.MODULE$.apply(StatFunctions.CovarianceCounter.class));
    }

    public double calculateCov(Dataset<Row> df, Seq<String> cols) {
        StatFunctions.CovarianceCounter counts = this.collectStatisticalData(df, cols, "covariance");
        return counts.cov();
    }

    public Dataset<Row> crossTabulate(Dataset<Row> df, String col1, String col2) {
        Map distinctCol2;
        int columnSize;
        String tableName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{col1, col2}));
        Row[] counts = (Row[])df.groupBy(col1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{col2})).agg(functions$.MODULE$.count("*"), (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).take((int)1000000.0);
        if (counts.length == (int)1000000.0) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The maximum limit of 1e6 pairs have been collected, which may not be all of the pairs. Please try reducing the amount of distinct items in your columns.";
                }
            });
        }
        Predef$.MODULE$.require((double)(columnSize = (distinctCol2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])counts).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Row e) {
                return StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(e.get(1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct()).sorted((Ordering)Ordering.String$.MODULE$)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms())).size()) < 10000.0, (Function0)new Serializable(col2, columnSize){
            public static final long serialVersionUID = 0L;
            private final String col2$1;
            private final int columnSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of distinct values for ", ", can't "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col2$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exceed 1e4. Currently ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.columnSize$1)}))).toString();
            }
            {
                this.col2$1 = col2$1;
                this.columnSize$1 = columnSize$1;
            }
        });
        Seq table = ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])counts).groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Row x$2) {
                return x$2.get(0);
            }
        }).map((Function1)new Serializable(distinctCol2, columnSize){
            public static final long serialVersionUID = 0L;
            public final Map distinctCol2$1;
            private final int columnSize$1;

            public final GenericInternalRow apply(Tuple2<Object, Row[]> x0$3) {
                Tuple2<Object, Row[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    Object col1Item = tuple2._1();
                    Row[] rows = (Row[])tuple2._2();
                    GenericInternalRow countsRow = new GenericInternalRow(this.columnSize$1 + 1);
                    Predef$.MODULE$.refArrayOps((Object[])rows).foreach((Function1)new Serializable(this, countsRow){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.8 $outer;
                        private final GenericInternalRow countsRow$1;

                        public final void apply(Row row) {
                            int columnIndex = BoxesRunTime.unboxToInt((Object)this.$outer.distinctCol2$1.get((Object)StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(row.get(1))).get());
                            this.countsRow$1.setLong(columnIndex + 1, row.getLong(2));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.countsRow$1 = countsRow$1;
                        }
                    });
                    countsRow.update(0, (Object)UTF8String.fromString((String)StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(col1Item)));
                    GenericInternalRow genericInternalRow = countsRow;
                    return genericInternalRow;
                }
                throw new MatchError(tuple2);
            }
            {
                this.distinctCol2$1 = distinctCol2$1;
                this.columnSize$1 = columnSize$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Seq headerNames = (Seq)((TraversableLike)distinctCol2.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$3) {
                return x$3._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(Tuple2<Object, Object> r2) {
                return new StructField(StatFunctions$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$$cleanColumnName$1(r2._1().toString()), (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom());
        StructField structField = new StructField(tableName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema = StructType$.MODULE$.apply((Seq)headerNames.$plus$colon((Object)structField, Seq$.MODULE$.canBuildFrom()));
        return Dataset$.MODULE$.ofRows(df.sparkSession(), (LogicalPlan)new LocalRelation(schema.toAttributes(), table)).na().fill(0.0);
    }

    public final QuantileSummaries[] org$apache$spark$sql$execution$stat$StatFunctions$$apply$1(QuantileSummaries[] summaries, Row row) {
        for (int i = 0; i < summaries.length; ++i) {
            double v;
            if (row.isNullAt(i) || Predef$.MODULE$.double2Double(v = row.getDouble(i)).isNaN()) continue;
            summaries[i] = summaries[i].insert(v);
        }
        return summaries;
    }

    public final QuantileSummaries[] org$apache$spark$sql$execution$stat$StatFunctions$$merge$1(QuantileSummaries[] sum1, QuantileSummaries[] sum2) {
        return (QuantileSummaries[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sum1).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sum2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final QuantileSummaries apply(Tuple2<QuantileSummaries, QuantileSummaries> x0$1) {
                Tuple2<QuantileSummaries, QuantileSummaries> tuple2 = x0$1;
                if (tuple2 != null) {
                    QuantileSummaries s1 = (QuantileSummaries)tuple2._1();
                    QuantileSummaries s2 = (QuantileSummaries)tuple2._2();
                    QuantileSummaries quantileSummaries = s1.compress().merge(s2.compress());
                    return quantileSummaries;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(QuantileSummaries.class)));
    }

    public final String org$apache$spark$sql$execution$stat$StatFunctions$$cleanElement$1(Object element) {
        return element == null ? "null" : element.toString();
    }

    public final String org$apache$spark$sql$execution$stat$StatFunctions$$cleanColumnName$1(String name) {
        return name.replace("`", "");
    }

    private StatFunctions$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

