/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.package$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMq!B\u0001\u0003\u0011\u0003y\u0011\u0001D'f[>\u0014\u0018p\u0015;sK\u0006l'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\r\u001b\u0016lwN]=TiJ,\u0017-\\\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=Aq!I\tC\u0002\u0013E!%\u0001\bdkJ\u0014XM\u001c;CY>\u001c7.\u00133\u0016\u0003\r\u0002\"\u0001J\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\r\u0005$x.\\5d\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tqSEA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007aE\u0001\u000b\u0011B\u0012\u0002\u001f\r,(O]3oi\ncwnY6JI\u0002BqAM\tC\u0002\u0013E!%\u0001\bnK6|'/_*ue\u0016\fW.\u00133\t\rQ\n\u0002\u0015!\u0003$\u0003=iW-\\8ssN#(/Z1n\u0013\u0012\u0004\u0003\"\u0002\u001c\u0012\t\u00039\u0014!B1qa2LXc\u0001\u001d\u0003NR)\u0011Ha4\u0003VB!\u0001C\u000fBf\r\u0011\u0011\"\u0001Q\u001e\u0016\u0005q\n7C\u0002\u001e\u0015{\u00013%\u0004\u0005\u0002\u0011}%\u0011qH\u0001\u0002\u0007'>,(oY3\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rC\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0015\u0013%a\u0002'pO\u001eLgn\u001a\t\u0003+\u001dK!\u0001\u0013\f\u0003\u000fA\u0013x\u000eZ;di\"A!J\u000fBK\u0002\u0013\u00051*\u0001\u0002jIV\tA\n\u0005\u0002\u0016\u001b&\u0011aJ\u0006\u0002\u0004\u0013:$\b\u0002\u0003);\u0005#\u0005\u000b\u0011\u0002'\u0002\u0007%$\u0007\u0005\u0003\u0005Su\tU\r\u0011\"\u0001T\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u0002)B\u0011QKV\u0007\u0002\r%\u0011qK\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\u0002C-;\u0005#\u0005\u000b\u0011\u0002+\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0005\t7j\u0012\u0019\u0011)A\u00069\u0006QQM^5eK:\u001cW\r\n\u001a\u0011\u0007Ukv,\u0003\u0002_\r\t9QI\\2pI\u0016\u0014\bC\u00011b\u0019\u0001!QA\u0019\u001eC\u0002\r\u0014\u0011!Q\t\u0003I\u001e\u0004\"!F3\n\u0005\u00194\"a\u0002(pi\"Lgn\u001a\t\u0003+!L!!\u001b\f\u0003\u0007\u0005s\u0017\u0010C\u0003\u001fu\u0011\u00051\u000eF\u0002m_B$\"!\u001c8\u0011\u0007AQt\fC\u0003\\U\u0002\u000fA\fC\u0003KU\u0002\u0007A\nC\u0003SU\u0002\u0007A\u000bC\u0004su\t\u0007I\u0011C:\u0002\u000f\u0015t7m\u001c3feV\tA\u000fE\u0002vu~k\u0011A\u001e\u0006\u0003ob\f\u0001\"\u001a8d_\u0012,'o\u001d\u0006\u0003s\u001a\t\u0001bY1uC2L8\u000f^\u0005\u0003wZ\u0014\u0011#\u0012=qe\u0016\u001c8/[8o\u000b:\u001cw\u000eZ3s\u0011\u0019i(\b)A\u0005i\u0006AQM\\2pI\u0016\u0014\b\u0005\u0003\u0005\u0000u\t\u0007I\u0011CA\u0001\u0003-awnZ5dC2\u0004F.\u00198\u0016\u0005\u0005\r\u0001c\u0001\t\u0002\u0006%\u0019\u0011q\u0001\u0002\u00035M#(/Z1nS:<W\t_3dkRLwN\u001c*fY\u0006$\u0018n\u001c8\t\u0011\u0005-!\b)A\u0005\u0003\u0007\tA\u0002\\8hS\u000e\fG\u000e\u00157b]\u0002B\u0011\"a\u0004;\u0005\u0004%\t\"!\u0005\u0002\r=,H\u000f];u+\t\t\u0019\u0002\u0005\u0004\u0002\u0016\u0005\u0015\u00121\u0006\b\u0005\u0003/\t\tC\u0004\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\r\tiBD\u0001\u0007yI|w\u000e\u001e \n\u0003]I1!a\t\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\n\u0002*\t\u00191+Z9\u000b\u0007\u0005\rb\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004_\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0003\u00026\u0005=\"!C!uiJL'-\u001e;f\u0011!\tID\u000fQ\u0001\n\u0005M\u0011aB8viB,H\u000f\t\u0005\n\u0003{Q$\u0019!C\t\u0003\u007f\tqAY1uG\",7/\u0006\u0002\u0002BA1\u00111IA'\u0003#j!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\b[V$\u0018M\u00197f\u0015\r\tYEF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA(\u0003\u000b\u0012!\u0002T5ti\n+hMZ3s!\u0011)\u00161K0\n\u0007\u0005UcAA\u0004ECR\f7/\u001a;\t\u0011\u0005e#\b)A\u0005\u0003\u0003\n\u0001BY1uG\",7\u000f\t\u0015\t\u0003/\ni&a\u001c\u0002rA!\u0011qLA6\u001b\t\t\tGC\u0002)\u0003GRA!!\u001a\u0002h\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005%\u0014!\u00026bm\u0006D\u0018\u0002BA7\u0003C\u0012\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0005\u0005M\u0014\u0001\u0002;iSND\u0011\"a\u001e;\u0001\u0004%\t\"!\u001f\u0002\u001b\r,(O]3oi>3gm]3u+\t\tY\bE\u0002\u0011\u0003{J1!a \u0003\u0005)auN\\4PM\u001a\u001cX\r\u001e\u0005\n\u0003\u0007S\u0004\u0019!C\t\u0003\u000b\u000b\u0011cY;se\u0016tGo\u00144gg\u0016$x\fJ3r)\u0011\t9)!$\u0011\u0007U\tI)C\u0002\u0002\fZ\u0011A!\u00168ji\"Q\u0011qRAA\u0003\u0003\u0005\r!a\u001f\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\u0014j\u0002\u000b\u0015BA>\u00039\u0019WO\u001d:f]R|eMZ:fi\u0002B\u0003\"!%\u0002^\u0005=\u0014\u0011\u000f\u0005\n\u00033S\u0004\u0019!C\t\u0003s\n1\u0003\\1ti>3gm]3u\u0007>lW.\u001b;uK\u0012D\u0011\"!(;\u0001\u0004%\t\"a(\u0002/1\f7\u000f^(gMN,GoQ8n[&$H/\u001a3`I\u0015\fH\u0003BAD\u0003CC!\"a$\u0002\u001c\u0006\u0005\t\u0019AA>\u0011!\t)K\u000fQ!\n\u0005m\u0014\u0001\u00067bgR|eMZ:fi\u000e{W.\\5ui\u0016$\u0007\u0005\u000b\u0005\u0002$\u0006u\u0013qNA9\u0011\u001d\tYK\u000fC\u0001\u0003[\u000baa]2iK6\fWCAAX!\u0011\t\t,a.\u000e\u0005\u0005M&bAA[\r\u0005)A/\u001f9fg&!\u0011\u0011XAZ\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003{SD\u0011AA`\u0003\u0011!x\u000eR*\u0015\u0005\u0005E\u0003bBAbu\u0011\u0005\u0011QY\u0001\u0005i>$e\t\u0006\u0002\u0002HB!\u0011\u0011ZAo\u001d\u0011\tY-a7\u000f\t\u00055\u0017\u0011\u001c\b\u0005\u0003\u001f\f9N\u0004\u0003\u0002R\u0006Ug\u0002BA\r\u0003'L\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011bAA\u0012\r%!\u0011q\\Aq\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002$\u0019Aq!!:;\t\u0003\t9/A\u0004bI\u0012$\u0015\r^1\u0015\t\u0005%\u0018q\u001e\t\u0004!\u0005-\u0018bAAw\u0005\t1qJ\u001a4tKRD\u0001\"!=\u0002d\u0002\u0007\u00111_\u0001\u0005I\u0006$\u0018\r\u0005\u0003\u0016\u0003k|\u0016bAA|-\tQAH]3qK\u0006$X\r\u001a \t\u000f\u0005\u0015(\b\"\u0001\u0002|R!\u0011\u0011^A\u007f\u0011!\t\t0!?A\u0002\u0005}\b#BA\u000b\u0005\u0003y\u0016\u0002\u0002B\u0002\u0003S\u0011q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\u0005\b\u0005\u000fQD\u0011\tB\u0005\u0003!!xn\u0015;sS:<GC\u0001B\u0006!\u0011\u0011iAa\u0005\u000f\u0007U\u0011y!C\u0002\u0003\u0012Y\ta\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u000b\u0005/\u0011aa\u0015;sS:<'b\u0001B\t-!9!1\u0004\u001e\u0005B\tu\u0011!C4fi>3gm]3u+\t\u0011y\u0002E\u0003\u0016\u0005C\tI/C\u0002\u0003$Y\u0011aa\u00149uS>t\u0007b\u0002B\u0014u\u0011\u0005#\u0011F\u0001\tO\u0016$()\u0019;dQR1\u0011q\u0019B\u0016\u0005_A\u0001B!\f\u0003&\u0001\u0007!qD\u0001\u0006gR\f'\u000f\u001e\u0005\t\u0005c\u0011)\u00031\u0001\u0002j\u0006\u0019QM\u001c3\t\u000f\tU\"\b\"\u0011\u00038\u000511m\\7nSR$B!a\"\u0003:!A!\u0011\u0007B\u001a\u0001\u0004\tI\u000fC\u0004\u0003>i\"\tEa\u0010\u0002\tM$x\u000e\u001d\u000b\u0003\u0003\u000fCqAa\u0011;\t\u0003\u0011y$A\u0003sKN,G\u000fC\u0005\u0003Hi\n\t\u0011\"\u0001\u0003J\u0005!1m\u001c9z+\u0011\u0011YEa\u0015\u0015\r\t5#\u0011\fB.)\u0011\u0011yE!\u0016\u0011\tAQ$\u0011\u000b\t\u0004A\nMCA\u00022\u0003F\t\u00071\rC\u0004\\\u0005\u000b\u0002\u001dAa\u0016\u0011\tUk&\u0011\u000b\u0005\t\u0015\n\u0015\u0003\u0013!a\u0001\u0019\"A!K!\u0012\u0011\u0002\u0003\u0007A\u000bC\u0005\u0003`i\n\n\u0011\"\u0001\u0003b\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003\u0002B2\u0005o*\"A!\u001a+\u00071\u00139g\u000b\u0002\u0003jA!!1\u000eB:\u001b\t\u0011iG\u0003\u0003\u0003p\tE\u0014!C;oG\",7m[3e\u0015\r\t)GF\u0005\u0005\u0005k\u0012iGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$aA\u0019B/\u0005\u0004\u0019\u0007\"\u0003B>uE\u0005I\u0011\u0001B?\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*BAa \u0003\u0004V\u0011!\u0011\u0011\u0016\u0004)\n\u001dDA\u00022\u0003z\t\u00071\rC\u0005\u0003\bj\n\t\u0011\"\u0011\u0003\n\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa#\u0011\t\t5%1S\u0007\u0003\u0005\u001fS1A!%,\u0003\u0011a\u0017M\\4\n\t\tU!q\u0012\u0005\t\u0005/S\u0014\u0011!C\u0001\u0017\u0006a\u0001O]8ek\u000e$\u0018I]5us\"I!1\u0014\u001e\u0002\u0002\u0013\u0005!QT\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r9'q\u0014\u0005\n\u0003\u001f\u0013I*!AA\u00021C\u0011Ba);\u0003\u0003%\tE!*\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa*\u0011\u000b\t%&1V4\u000e\u0005\u0005%\u0013\u0002\u0002BW\u0003\u0013\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0005cS\u0014\u0011!C\u0001\u0005g\u000b\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005k\u0013Y\fE\u0002\u0016\u0005oK1A!/\u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"a$\u00030\u0006\u0005\t\u0019A4\t\u0013\t}&(!A\u0005B\t\u0005\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u00031C\u0011B!2;\u0003\u0003%\tEa2\u0002\r\u0015\fX/\u00197t)\u0011\u0011)L!3\t\u0013\u0005=%1YA\u0001\u0002\u00049\u0007c\u00011\u0003N\u0012)!-\u000eb\u0001G\"I!\u0011[\u001b\u0002\u0002\u0003\u000f!1[\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003B+^\u0005\u0017DQAU\u001bA\u0004QC\u0001BN\t\u0002\u0002\u0013\u0005%\u0011\\\u000b\u0005\u00057\u0014\u0019\u000f\u0006\u0004\u0003^\n%(1\u001e\u000b\u0005\u0005?\u0014)\u000f\u0005\u0003\u0011u\t\u0005\bc\u00011\u0003d\u00121!Ma6C\u0002\rDqa\u0017Bl\u0001\b\u00119\u000f\u0005\u0003V;\n\u0005\bB\u0002&\u0003X\u0002\u0007A\n\u0003\u0004S\u0005/\u0004\r\u0001\u0016\u0005\n\u0005_\f\u0012\u0011!CA\u0005c\fq!\u001e8baBd\u00170\u0006\u0003\u0003t\u000e\u0015A\u0003\u0002B{\u0005{\u0004R!\u0006B\u0011\u0005o\u0004R!\u0006B}\u0019RK1Aa?\u0017\u0005\u0019!V\u000f\u001d7fe!Q!q Bw\u0003\u0003\u0005\ra!\u0001\u0002\u0007a$\u0003\u0007\u0005\u0003\u0011u\r\r\u0001c\u00011\u0004\u0006\u00111!M!<C\u0002\rD\u0011b!\u0003\u0012\u0003\u0003%Iaa\u0003\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007\u001b\u0001BA!$\u0004\u0010%!1\u0011\u0003BH\u0005\u0019y%M[3di\u0002")
public class MemoryStream<A>
implements Source,
Logging,
Product,
Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final Encoder<A> evidence$2;
    private final ExpressionEncoder<A> encoder;
    private final StreamingExecutionRelation logicalPlan;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<Dataset<A>> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> MemoryStream<A> apply(Encoder<A> encoder, SQLContext sQLContext) {
        return MemoryStream$.MODULE$.apply(encoder, sQLContext);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public ExpressionEncoder<A> encoder() {
        return this.encoder;
    }

    public StreamingExecutionRelation logicalPlan() {
        return this.logicalPlan;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<Dataset<A>> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    @Override
    public StructType schema() {
        return this.encoder().schema();
    }

    public Dataset<A> toDS() {
        return Dataset$.MODULE$.apply(this.sqlContext().sparkSession(), (LogicalPlan)this.logicalPlan(), this.evidence$2);
    }

    public Dataset<Row> toDF() {
        return Dataset$.MODULE$.ofRows(this.sqlContext().sparkSession(), (LogicalPlan)this.logicalPlan());
    }

    public Offset addData(Seq<A> data) {
        return this.addData((TraversableOnce<A>)data.toTraversable());
    }

    public Offset addData(TraversableOnce<A> data) {
        Dataset<A> ds = this.sqlContext().implicits().localSeqToDatasetHolder(data.toVector(), this.evidence$2).toDS();
        this.logDebug((Function0<String>)new Serializable(this, ds){
            public static final long serialVersionUID = 0L;
            private final Dataset ds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding ds: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ds$1}));
            }
            {
                this.ds$1 = ds$1;
            }
        });
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq(ds);
            LongOffset longOffset = this.currentOffset();
            return longOffset;
        }
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryStream[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.truncatedString(this.output(), ",")}));
    }

    @Override
    public synchronized Option<Offset> getOffset() {
        return this.currentOffset().offset() == -1L ? None$.MODULE$ : new Some((Object)this.currentOffset());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        Object object;
        int startOrdinal = (int)((LongOffset)start2.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<LongOffset> apply(Offset offset) {
                return LongOffset$.MODULE$.convert(offset);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongOffset apply() {
                return new LongOffset(-1L);
            }
        })).offset() + 1;
        int endOrdinal = (int)((LongOffset)LongOffset$.MODULE$.convert(end).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongOffset apply() {
                return new LongOffset(-1L);
            }
        })).offset() + 1;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            object = this.batches().slice(sliceStart, sliceEnd);
        }
        ListBuffer newBlocks = (ListBuffer)object;
        this.logDebug((Function0<String>)new Serializable(this, startOrdinal, endOrdinal, newBlocks){
            public static final long serialVersionUID = 0L;
            private final int startOrdinal$1;
            private final int endOrdinal$1;
            private final ListBuffer newBlocks$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryBatch [", ", ", "]: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.startOrdinal$1), BoxesRunTime.boxToInteger((int)this.endOrdinal$1), ((TraversableForwarder)this.newBlocks$1.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<A> apply(Dataset<A> x$1) {
                        return Predef$.MODULE$.genericArrayOps(x$1.collect());
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())).mkString(", ")}));
            }
            {
                void var4_4;
                this.startOrdinal$1 = startOrdinal$1;
                this.endOrdinal$1 = endOrdinal$1;
                this.newBlocks$1 = var4_4;
            }
        });
        return (Dataset)((TraversableOnce)newBlocks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Dataset<Row> apply(Dataset<A> x$2) {
                return x$2.toDF();
            }
        }, ListBuffer$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Dataset<Row> apply(Dataset<Row> x$3, Dataset<Row> x$4) {
                return x$3.union(x$4);
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                return scala.sys.package$.MODULE$.error("No data selected!");
            }
        });
    }

    @Override
    public synchronized void commit(Offset end) {
        Option<LongOffset> option = LongOffset$.MODULE$.convert(end);
        if (option instanceof Some) {
            Some some = (Some)option;
            LongOffset lo = (LongOffset)some.x();
            this.check$1(lo, end);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        None$ none$ = None$.MODULE$;
        Option<LongOffset> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MemoryStream.commit() received an offset (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{end}))).append((Object)"that did not originate with an instance of this class").toString());
        }
        throw new MatchError(option);
    }

    @Override
    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Encoder<A> evidence$2) {
        return new MemoryStream<A>(id, sqlContext, evidence$2);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.id());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    private final void check$1(LongOffset newOffset, Offset end$1) {
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Offsets committed out of order: ", " followed by ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.lastOffsetCommitted(), end$1})));
        }
        this.batches().trimStart(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public MemoryStream(int id, SQLContext sqlContext, Encoder<A> evidence$2) {
        this.id = id;
        this.sqlContext = sqlContext;
        this.evidence$2 = evidence$2;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        Product.class.$init$((Product)this);
        this.encoder = package$.MODULE$.encoderFor(evidence$2);
        this.logicalPlan = StreamingExecutionRelation$.MODULE$.apply(this);
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

