/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.SaveIntoDataSourceCommand;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t}f\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019m\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u0013)\u0012A\u00013t!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\b\t\u0006$\u0018m]3u!\tQ2\u0004\u0004\u0001\u0005\u000bq\u0001!\u0019A\u000f\u0003\u0003Q\u000b\"AH\u0011\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0012\n\u0005\rz!aA!os\"1Q\u0005\u0001C\u0001\u0005\u0019\na\u0001P5oSRtDCA\u0014)!\r1\u0002!\u0007\u0005\u0006)\u0011\u0002\r!\u0006\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\t!g-F\u0001-!\ti\u0003G\u0004\u0002\u0017]%\u0011qFA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011qF\u0001\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0007\u00114\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0003n_\u0012,GCA\u00149\u0011\u0015IT\u00071\u0001;\u0003!\u0019\u0018M^3N_\u0012,\u0007C\u0001\f<\u0013\ta$A\u0001\u0005TCZ,Wj\u001c3f\u0011\u00151\u0004\u0001\"\u0001?)\t9s\bC\u0003:{\u0001\u0007\u0001\t\u0005\u0002B\t:\u0011aBQ\u0005\u0003\u0007>\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111i\u0004\u0005\u0006\u0011\u0002!\t!S\u0001\u0007M>\u0014X.\u0019;\u0015\u0005\u001dR\u0005\"B&H\u0001\u0004\u0001\u0015AB:pkJ\u001cW\rC\u0003N\u0001\u0011\u0005a*\u0001\u0004paRLwN\u001c\u000b\u0004O=\u000b\u0006\"\u0002)M\u0001\u0004\u0001\u0015aA6fs\")!\u000b\u0014a\u0001\u0001\u0006)a/\u00197vK\")Q\n\u0001C\u0001)R\u0019q%\u0016,\t\u000bA\u001b\u0006\u0019\u0001!\t\u000bI\u001b\u0006\u0019A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:DQ!\u0014\u0001\u0005\u0002m#2a\n/^\u0011\u0015\u0001&\f1\u0001A\u0011\u0015\u0011&\f1\u0001_!\tqq,\u0003\u0002a\u001f\t!Aj\u001c8h\u0011\u0015i\u0005\u0001\"\u0001c)\r93\r\u001a\u0005\u0006!\u0006\u0004\r\u0001\u0011\u0005\u0006%\u0006\u0004\r!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\r\u0011{WO\u00197f\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u001dy\u0007\u000f^5p]N$\"aJ6\t\u000b%D\u0007\u0019\u00017\u0011\t5\u0004\b\tQ\u0007\u0002]*\u0011qnD\u0001\u000bG>dG.Z2uS>t\u0017BA9o\u0005\ri\u0015\r\u001d\u0005\u0006S\u0002!\ta\u001d\u000b\u0003OQDQ!\u001b:A\u0002U\u0004BA^>A\u00016\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!!]<\t\u000bu\u0004A\u0011\u0001@\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0003O}Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\u0005d_2t\u0015-\\3t!\u0011q\u0011Q\u0001!\n\u0007\u0005\u001dqB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3\u0001`A\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0011q\u0002\u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0001BY;dW\u0016$()\u001f\u000b\bO\u0005u\u0011qEA\u0016\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012A\u00038v[\n+8m[3ugB\u0019a\"a\t\n\u0007\u0005\u0015rBA\u0002J]RDq!!\u000b\u0002\u0018\u0001\u0007\u0001)A\u0004d_2t\u0015-\\3\t\u0011\u0005\u0005\u0011q\u0003a\u0001\u0003\u0007AC!a\u0006\u0002\f!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012AB:peR\u0014\u0015\u0010F\u0003(\u0003k\t9\u0004C\u0004\u0002*\u0005=\u0002\u0019\u0001!\t\u0011\u0005\u0005\u0011q\u0006a\u0001\u0003\u0007AC!a\f\u0002\f!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001B:bm\u0016$B!!\u0011\u0002HA\u0019a\"a\u0011\n\u0007\u0005\u0015sB\u0001\u0003V]&$\bbBA%\u0003w\u0001\r\u0001Q\u0001\u0005a\u0006$\b\u000eC\u0004\u0002>\u0001!\t!!\u0014\u0015\u0005\u0005\u0005\u0003bBA)\u0001\u0011\u0005\u00111K\u0001\u000bS:\u001cXM\u001d;J]R|G\u0003BA!\u0003+Bq!a\u0016\u0002P\u0001\u0007\u0001)A\u0005uC\ndWMT1nK\"9\u0011\u0011\u000b\u0001\u0005\n\u0005mC\u0003BA!\u0003;B\u0001\"a\u0018\u0002Z\u0001\u0007\u0011\u0011M\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d$!\u0001\u0005dCR\fG._:u\u0013\u0011\tY'!\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJDq!a\u001c\u0001\t\u0013\t\t(A\u0007hKR\u0014UoY6fiN\u0003XmY\u000b\u0003\u0003g\u0002RADA;\u0003sJ1!a\u001e\u0010\u0005\u0019y\u0005\u000f^5p]B!\u00111PAA\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0015\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003\u0007\u000biH\u0001\u0006Ck\u000e\\W\r^*qK\u000eDq!a\"\u0001\t\u0013\tI)A\tbgN,'\u000f\u001e(pi\n+8m[3uK\u0012$B!!\u0011\u0002\f\"9\u0011QRAC\u0001\u0004\u0001\u0015!C8qKJ\fG/[8o\u0011\u001d\t\t\n\u0001C\u0005\u0003'\u000bA#Y:tKJ$hj\u001c;QCJ$\u0018\u000e^5p]\u0016$G\u0003BA!\u0003+Cq!!$\u0002\u0010\u0002\u0007\u0001\tC\u0004\u0002\u001a\u0002!\t!a'\u0002\u0017M\fg/Z!t)\u0006\u0014G.\u001a\u000b\u0005\u0003\u0003\ni\nC\u0004\u0002X\u0005]\u0005\u0019\u0001!\t\u000f\u0005e\u0005\u0001\"\u0003\u0002\"R!\u0011\u0011IAR\u0011!\ty&a(A\u0002\u0005\u0005\u0004bBAT\u0001\u0011%\u0011\u0011V\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0003\u0002B\u0005-\u0006\u0002CA0\u0003K\u0003\r!!\u0019\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\u0006!!\u000e\u001a2d)!\t\t%a-\u00028\u0006m\u0006bBA[\u0003[\u0003\r\u0001Q\u0001\u0004kJd\u0007bBA]\u0003[\u0003\r\u0001Q\u0001\u0006i\u0006\u0014G.\u001a\u0005\t\u0003{\u000bi\u000b1\u0001\u0002@\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u00042A^Aa\u0013\r\t\u0019m\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAd\u0001\u0011\u0005\u0011\u0011Z\u0001\u0005UN|g\u000e\u0006\u0003\u0002B\u0005-\u0007bBA%\u0003\u000b\u0004\r\u0001\u0011\u0005\b\u0003\u001f\u0004A\u0011AAi\u0003\u001d\u0001\u0018M]9vKR$B!!\u0011\u0002T\"9\u0011\u0011JAg\u0001\u0004\u0001\u0005bBAl\u0001\u0011\u0005\u0011\u0011\\\u0001\u0004_J\u001cG\u0003BA!\u00037Dq!!\u0013\u0002V\u0002\u0007\u0001\tC\u0004\u0002`\u0002!\t!!9\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003\u0003\n\u0019\u000fC\u0004\u0002J\u0005u\u0007\u0019\u0001!\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002j\u0006\u00191m\u001d<\u0015\t\u0005\u0005\u00131\u001e\u0005\b\u0003\u0013\n)\u000f1\u0001A\u0011\u001d\ty\u000f\u0001C\u0005\u0003c\f!B];o\u0007>lW.\u00198e)\u0019\t\u0019P!\u0003\u0003\u0014Q!\u0011\u0011IA{\u0011!\t90!<A\u0002\u0005e\u0018aB2p[6\fg\u000e\u001a\t\u0005\u0003w\u0014)!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003\u001dawnZ5dC2TAAa\u0001\u0002f\u0005)\u0001\u000f\\1og&!!qAA\u007f\u0005-aunZ5dC2\u0004F.\u00198\t\u0011\t-\u0011Q\u001ea\u0001\u0005\u001b\tqa]3tg&|g\u000eE\u0002\u0017\u0005\u001fI1A!\u0005\u0003\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\u0011)\"!<A\u0002\u0001\u000bAA\\1nK\"A1\n\u0001a\u0001\n\u0013\u0011I\"F\u0001A\u0011%\u0011i\u0002\u0001a\u0001\n\u0013\u0011y\"\u0001\u0006t_V\u00148-Z0%KF$B!!\u0011\u0003\"!I!1\u0005B\u000e\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0004b\u0002B\u0014\u0001\u0001\u0006K\u0001Q\u0001\bg>,(oY3!\u0011!1\u0004\u00011A\u0005\n\t-R#\u0001\u001e\t\u0013\t=\u0002\u00011A\u0005\n\tE\u0012\u0001C7pI\u0016|F%Z9\u0015\t\u0005\u0005#1\u0007\u0005\n\u0005G\u0011i#!AA\u0002iBqAa\u000e\u0001A\u0003&!(A\u0003n_\u0012,\u0007\u0005C\u0005\u0003<\u0001\u0011\r\u0011\"\u0003\u0003>\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011!q\b\t\u0007\u0005\u0003\u00129\u0005\u0011!\u000e\u0005\t\r#b\u0001B#]\u00069Q.\u001e;bE2,\u0017\u0002\u0002B%\u0005\u0007\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0003\u0005\u0003N\u0001\u0001\u000b\u0011\u0002B \u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA!I!\u0011\u000b\u0001A\u0002\u0013%!1K\u0001\u0014a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]\u000b\u0003\u0005+\u0002RADA;\u0005/\u0002RA!\u0017\u0003h\u0001sAAa\u0017\u0003f9!!Q\fB2\u001b\t\u0011yFC\u0002\u0003b)\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0005=z\u0011\u0002\u0002B5\u0005W\u00121aU3r\u0015\tys\u0002C\u0005\u0003p\u0001\u0001\r\u0011\"\u0003\u0003r\u00059\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og~#S-\u001d\u000b\u0005\u0003\u0003\u0012\u0019\b\u0003\u0006\u0003$\t5\u0014\u0011!a\u0001\u0005+B\u0001Ba\u001e\u0001A\u0003&!QK\u0001\u0015a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn\u001d\u0011\t\u0013\tm\u0004\u00011A\u0005\n\tM\u0013!\u00052vG.,GoQ8mk6tg*Y7fg\"I!q\u0010\u0001A\u0002\u0013%!\u0011Q\u0001\u0016EV\u001c7.\u001a;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\t\tEa!\t\u0015\t\r\"QPA\u0001\u0002\u0004\u0011)\u0006\u0003\u0005\u0003\b\u0002\u0001\u000b\u0015\u0002B+\u0003I\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0011\t\u0013\u0005}\u0001\u00011A\u0005\n\t-UC\u0001BG!\u0015q\u0011QOA\u0011\u0011%\u0011\t\n\u0001a\u0001\n\u0013\u0011\u0019*\u0001\bok6\u0014UoY6fiN|F%Z9\u0015\t\u0005\u0005#Q\u0013\u0005\u000b\u0005G\u0011y)!AA\u0002\t5\u0005\u0002\u0003BM\u0001\u0001\u0006KA!$\u0002\u00179,XNQ;dW\u0016$8\u000f\t\u0005\n\u0005;\u0003\u0001\u0019!C\u0005\u0005'\nqb]8si\u000e{G.^7o\u001d\u0006lWm\u001d\u0005\n\u0005C\u0003\u0001\u0019!C\u0005\u0005G\u000b1c]8si\u000e{G.^7o\u001d\u0006lWm]0%KF$B!!\u0011\u0003&\"Q!1\u0005BP\u0003\u0003\u0005\rA!\u0016\t\u0011\t%\u0006\u0001)Q\u0005\u0005+\n\u0001c]8si\u000e{G.^7o\u001d\u0006lWm\u001d\u0011)\u0007\u0001\u0011i\u000b\u0005\u0003\u00030\nef\u0002\u0002BY\u0005kk!Aa-\u000b\u0007\u0005EA!\u0003\u0003\u00038\nM\u0016AE%oi\u0016\u0014h-Y2f'R\f'-\u001b7jifLAAa/\u0003>\n11\u000b^1cY\u0016TAAa.\u00034\u0002")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        block9: {
            SaveMode saveMode2;
            block6: {
                boolean bl;
                String string;
                block8: {
                    block7: {
                        block5: {
                            String string2 = string = saveMode.toLowerCase(Locale.ROOT);
                            if ("overwrite" != null ? !"overwrite".equals(string2) : string2 != null) break block5;
                            saveMode2 = SaveMode.Overwrite;
                            break block6;
                        }
                        String string3 = string;
                        if ("append" != null ? !"append".equals(string3) : string3 != null) break block7;
                        saveMode2 = SaveMode.Append;
                        break block6;
                    }
                    String string4 = string;
                    if ("ignore" != null ? !"ignore".equals(string4) : string4 != null) break block8;
                    saveMode2 = SaveMode.Ignore;
                    break block6;
                }
                String string5 = string;
                if (!("error" != null ? !"error".equals(string5) : string5 != null)) {
                    bl = true;
                } else {
                    String string6 = string;
                    bl = !("default" != null ? !"default".equals(string6) : string6 != null);
                }
                if (!bl) break block9;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted save modes are 'overwrite', 'append', 'ignore', 'error'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)new SaveIntoDataSourceCommand(this.df().logicalPlan(), this.source(), (Seq<String>)((Seq)this.partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()), this.mode()));
    }

    public void insertInto(String tableName) {
        this.insertInto(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already be defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().isDefined()) {
            Predef$.MODULE$.require(this.numBuckets().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "sortBy must be used together with bucketBy";
                }
            });
        }
        return this.numBuckets().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final BucketSpec apply(int n) {
                return new BucketSpec(n, (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().get(), (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private void assertNotBucketed(String operation) {
        if (this.numBuckets().isDefined() || this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support bucketing right now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support partitioning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog2 = this.df().sparkSession().sessionState().catalog();
        boolean tableExists2 = catalog2.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0)new Serializable(this, catalog2){
            public static final long serialVersionUID = 0L;
            private final SessionCatalog catalog$1;

            public final String apply() {
                return this.catalog$1.getCurrentDatabase();
            }
            {
                this.catalog$1 = catalog$1;
            }
        });
        Some x$3 = new Some((Object)db);
        String x$4 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$4, (Option)x$3);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists2), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode2 = SaveMode.Ignore;
                SaveMode saveMode3 = saveMode;
                if (!(saveMode2 != null ? !((Object)((Object)saveMode2)).equals((Object)saveMode3) : saveMode3 != null)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode4 = SaveMode.ErrorIfExists;
                SaveMode saveMode5 = saveMode;
                if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null)) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdent})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl) {
                SaveMode saveMode6 = SaveMode.Overwrite;
                SaveMode saveMode7 = saveMode;
                if (!(saveMode6 != null ? !((Object)((Object)saveMode6)).equals((Object)saveMode7) : saveMode7 != null)) {
                    HiveTableRelation hiveTableRelation;
                    BaseRelation baseRelation;
                    LogicalRelation logicalRelation;
                    BaseRelation dest;
                    Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            LogicalRelation logicalRelation;
                            BaseRelation src;
                            A1 A1 = x1;
                            if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                                BaseRelation baseRelation = src;
                                object = baseRelation;
                            } else if (A1 instanceof HiveTableRelation) {
                                HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                                object = hiveTableRelation.tableMeta().identifier();
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(LogicalPlan x1) {
                            LogicalRelation logicalRelation;
                            BaseRelation src;
                            LogicalPlan logicalPlan2 = x1;
                            boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                            return bl;
                        }
                    });
                    LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                    LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                    if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot overwrite table ", " that is also being read from"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot overwrite table ", " that is also being read from"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    catalog2.dropTable(tableIdentWithDB, true, false);
                    this.createTable(tableIdentWithDB);
                    catalog2.refreshTable(tableIdentWithDB);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        }), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        try {
            long start2 = System.nanoTime();
            qe.toRdd();
            long end = System.nanoTime();
            session.listenerManager().onSuccess(name, qe, end - start2);
            return;
        }
        catch (Exception exception) {
            session.listenerManager().onFailure(name, qe, exception);
            throw exception;
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$sortColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames = x$1;
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$sortColumnNames = None$.MODULE$;
    }
}

