/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand$$anonfun$org$apache$spark$sql$execution$command$AnalyzeTableCommand$;
import org.apache.spark.sql.internal.SessionState;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class AnalyzeTableCommand$
implements Logging,
Serializable {
    public static final AnalyzeTableCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AnalyzeTableCommand$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public long calculateTotalSize(SessionState sessionState2, CatalogTable catalogTable) {
        long l;
        if (catalogTable.partitionColumnNames().isEmpty()) {
            l = this.org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize(sessionState2, catalogTable.identifier(), (Option<URI>)catalogTable.storage().locationUri());
        } else {
            Seq partitions = sessionState2.catalog().listPartitions(catalogTable.identifier(), sessionState2.catalog().listPartitions$default$2());
            l = BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1)new Serializable(sessionState2, catalogTable){
                public static final long serialVersionUID = 0L;
                private final SessionState sessionState$1;
                private final CatalogTable catalogTable$1;

                public final long apply(CatalogTablePartition p) {
                    return AnalyzeTableCommand$.MODULE$.org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize(this.sessionState$1, this.catalogTable$1.identifier(), (Option<URI>)p.storage().locationUri());
                }
                {
                    this.sessionState$1 = sessionState$1;
                    this.catalogTable$1 = catalogTable$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }
        return l;
    }

    public long org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize(SessionState sessionState2, TableIdentifier tableId, Option<URI> locationUri) {
        String stagingDir = sessionState2.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        return BoxesRunTime.unboxToLong((Object)locationUri.map((Function1)new Serializable(sessionState2, tableId, stagingDir){
            public static final long serialVersionUID = 0L;
            private final SessionState sessionState$3;
            public final TableIdentifier tableId$1;
            private final String stagingDir$1;

            public final long apply(URI p) {
                long l;
                Path path = new Path(p);
                try {
                    FileSystem fs = path.getFileSystem(this.sessionState$3.newHadoopConf());
                    l = AnalyzeTableCommand$.MODULE$.org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize$1(fs, path, this.stagingDir$1);
                }
                catch (Throwable throwable) {
                    long l2;
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    AnalyzeTableCommand$.MODULE$.logWarning((Function0<String>)new Serializable(this, e){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize$2 $outer;
                        private final Throwable e$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get the size of table ", " in the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableId$1.table()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database ", " because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableId$1.database(), this.e$1.toString()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    }, e);
                    l = l2 = 0L;
                }
                return l;
            }
            {
                this.sessionState$3 = sessionState$3;
                this.tableId$1 = tableId$1;
                this.stagingDir$1 = stagingDir$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public AnalyzeTableCommand apply(TableIdentifier tableIdent, boolean noscan) {
        return new AnalyzeTableCommand(tableIdent, noscan);
    }

    public Option<Tuple2<TableIdentifier, Object>> unapply(AnalyzeTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.tableIdent(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.noscan())));
    }

    public boolean apply$default$2() {
        return true;
    }

    public boolean $lessinit$greater$default$2() {
        return true;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final long org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize$1(FileSystem fs, Path path, String stagingDir$1) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDirectory() ? BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path)).map((Function1)new Serializable(stagingDir$1, fs){
            public static final long serialVersionUID = 0L;
            private final String stagingDir$1;
            private final FileSystem fs$1;

            public final long apply(FileStatus status) {
                return status.getPath().getName().startsWith(this.stagingDir$1) ? 0L : AnalyzeTableCommand$.MODULE$.org$apache$spark$sql$execution$command$AnalyzeTableCommand$$calculateLocationSize$1(this.fs$1, status.getPath(), this.stagingDir$1);
            }
            {
                this.stagingDir$1 = stagingDir$1;
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    private AnalyzeTableCommand$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

