/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.Exception$;

public final class CSVInferSchema$ {
    public static final CSVInferSchema$ MODULE$;
    private final IndexedSeq<DataType> org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence;
    private final Function2<DataType, DataType, Option<DataType>> findTightestCommonType;

    static {
        new CSVInferSchema$();
    }

    public StructType infer(RDD<String[]> tokenRDD, String[] header, CSVOptions options) {
        StructField[] structFieldArray;
        if (options.inferSchemaFlag()) {
            DataType[] startType = (DataType[])Array$.MODULE$.fill(header.length, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final NullType$ apply() {
                    return NullType$.MODULE$;
                }
            }, ClassTag$.MODULE$.apply(DataType.class));
            DataType[] rootTypes = (DataType[])tokenRDD.aggregate((Object)startType, (Function2)new Serializable(options){
                public static final long serialVersionUID = 0L;
                private final CSVOptions options$1;

                public final DataType[] apply(DataType[] rowSoFar, String[] next2) {
                    return CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$inferRowType(this.options$1, rowSoFar, next2);
                }
                {
                    this.options$1 = options$1;
                }
            }, (Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final DataType[] apply(DataType[] first, DataType[] second) {
                    return CSVInferSchema$.MODULE$.mergeRowTypes(first, second);
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DataType.class)));
            structFieldArray = (StructField[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])header).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rootTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(Tuple2<String, DataType> x0$1) {
                    Tuple2<String, DataType> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String thisHeader = (String)tuple2._1();
                        DataType rootType = (DataType)tuple2._2();
                        DataType dataType = rootType;
                        Object object = dataType instanceof NullType ? StringType$.MODULE$ : dataType;
                        StringType$ dType = object;
                        StructField structField = new StructField(thisHeader, (DataType)dType, true, StructField$.MODULE$.apply$default$4());
                        return structField;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        } else {
            structFieldArray = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        }
        StructField[] fields = structFieldArray;
        return new StructType(fields);
    }

    public DataType[] org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$inferRowType(CSVOptions options, DataType[] rowSoFar, String[] next2) {
        for (int i = 0; i < package$.MODULE$.min(rowSoFar.length, next2.length); ++i) {
            rowSoFar[i] = this.inferField(rowSoFar[i], next2[i], options);
        }
        return rowSoFar;
    }

    public DataType[] mergeRowTypes(DataType[] first, DataType[] second) {
        return (DataType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])first).zipAll((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])second), (Object)NullType$.MODULE$, (Object)NullType$.MODULE$, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(Tuple2<DataType, DataType> x0$2) {
                Tuple2<DataType, DataType> tuple2 = x0$2;
                if (tuple2 != null) {
                    DataType a = (DataType)tuple2._1();
                    DataType b = (DataType)tuple2._2();
                    DataType dataType = (DataType)((Option)CSVInferSchema$.MODULE$.findTightestCommonType().apply((Object)a, (Object)b)).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final NullType$ apply() {
                            return NullType$.MODULE$;
                        }
                    });
                    return dataType;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)));
    }

    public DataType inferField(DataType typeSoFar, String field, CSVOptions options) {
        DataType dataType;
        block15: {
            DataType dataType2;
            block6: {
                DataType dataType3;
                block8: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        block9: {
                                            block7: {
                                                block5: {
                                                    block4: {
                                                        if (field == null || field.isEmpty()) break block4;
                                                        String string = field;
                                                        String string2 = options.nullValue();
                                                        if (string != null ? !string.equals(string2) : string2 != null) break block5;
                                                    }
                                                    dataType2 = typeSoFar;
                                                    break block6;
                                                }
                                                dataType = typeSoFar;
                                                NullType$ nullType$ = NullType$.MODULE$;
                                                DataType dataType4 = dataType;
                                                if (nullType$ != null ? !nullType$.equals(dataType4) : dataType4 != null) break block7;
                                                dataType3 = this.tryParseInteger(field, options);
                                                break block8;
                                            }
                                            IntegerType$ integerType$ = IntegerType$.MODULE$;
                                            DataType dataType5 = dataType;
                                            if (integerType$ != null ? !integerType$.equals(dataType5) : dataType5 != null) break block9;
                                            dataType3 = this.tryParseInteger(field, options);
                                            break block8;
                                        }
                                        LongType$ longType$ = LongType$.MODULE$;
                                        DataType dataType6 = dataType;
                                        if (longType$ != null ? !longType$.equals(dataType6) : dataType6 != null) break block10;
                                        dataType3 = this.tryParseLong(field, options);
                                        break block8;
                                    }
                                    if (!(dataType instanceof DecimalType)) break block11;
                                    dataType3 = (DataType)((Option)this.findTightestCommonType().apply((Object)typeSoFar, (Object)this.tryParseDecimal(field, options))).getOrElse((Function0)new Serializable(){
                                        public static final long serialVersionUID = 0L;

                                        public final StringType$ apply() {
                                            return StringType$.MODULE$;
                                        }
                                    });
                                    break block8;
                                }
                                DoubleType$ doubleType$ = DoubleType$.MODULE$;
                                DataType dataType7 = dataType;
                                if (doubleType$ != null ? !doubleType$.equals(dataType7) : dataType7 != null) break block12;
                                dataType3 = this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(field, options);
                                break block8;
                            }
                            TimestampType$ timestampType$ = TimestampType$.MODULE$;
                            DataType dataType8 = dataType;
                            if (timestampType$ != null ? !timestampType$.equals(dataType8) : dataType8 != null) break block13;
                            dataType3 = this.tryParseTimestamp(field, options);
                            break block8;
                        }
                        BooleanType$ booleanType$ = BooleanType$.MODULE$;
                        DataType dataType9 = dataType;
                        if (booleanType$ != null ? !booleanType$.equals(dataType9) : dataType9 != null) break block14;
                        dataType3 = this.tryParseBoolean(field, options);
                        break block8;
                    }
                    StringType$ stringType$ = StringType$.MODULE$;
                    DataType dataType10 = dataType;
                    if (stringType$ != null ? !stringType$.equals(dataType10) : dataType10 != null) break block15;
                    dataType3 = StringType$.MODULE$;
                }
                dataType2 = dataType3;
            }
            return dataType2;
        }
        if (dataType != null) {
            DataType dataType11 = dataType;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType11})));
        }
        throw new MatchError((Object)dataType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isInfOrNan(String field, CSVOptions options) {
        String string = field;
        String string2 = options.nanValue();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = field;
        String string4 = options.negativeInf();
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        String string5 = field;
        String string6 = options.positiveInf();
        if (string5 != null) {
            if (!string5.equals(string6)) return false;
            return true;
        }
        if (string6 == null) return true;
        return false;
    }

    private DataType tryParseInteger(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$1)).toInt();
            }
            {
                this.field$1 = field$1;
            }
        }).isDefined() ? IntegerType$.MODULE$ : this.tryParseLong(field, options);
    }

    private DataType tryParseLong(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$2)).toLong();
            }
            {
                this.field$2 = field$2;
            }
        }).isDefined() ? LongType$.MODULE$ : this.tryParseDecimal(field, options);
    }

    private DataType tryParseDecimal(String field, CSVOptions options) {
        Option decimalTry = Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$3;
            private final CSVOptions options$2;

            public final DataType apply() {
                BigDecimal bigDecimal = new BigDecimal(this.field$3);
                return bigDecimal.scale() <= 0 ? new DecimalType(bigDecimal.precision(), bigDecimal.scale()) : CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(this.field$3, this.options$2);
            }
            {
                this.field$3 = field$3;
                this.options$2 = options$2;
            }
        });
        return (DataType)decimalTry.getOrElse((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$3;
            private final CSVOptions options$2;

            public final DataType apply() {
                return CSVInferSchema$.MODULE$.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(this.field$3, this.options$2);
            }
            {
                this.field$3 = field$3;
                this.options$2 = options$2;
            }
        });
    }

    public DataType org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$tryParseDouble(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$4;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$4)).toDouble();
            }
            {
                this.field$4 = field$4;
            }
        }).isDefined() || this.isInfOrNan(field, options) ? DoubleType$.MODULE$ : this.tryParseTimestamp(field, options);
    }

    private DataType tryParseTimestamp(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field, options){
            public static final long serialVersionUID = 0L;
            private final String field$5;
            private final CSVOptions options$3;

            public final Date apply() {
                return this.options$3.timestampFormat().parse(this.field$5);
            }
            {
                this.field$5 = field$5;
                this.options$3 = options$3;
            }
        }).isDefined() ? TimestampType$.MODULE$ : (Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$5;

            public final Date apply() {
                return DateTimeUtils$.MODULE$.stringToTime(this.field$5);
            }
            {
                this.field$5 = field$5;
            }
        }).isDefined() ? TimestampType$.MODULE$ : this.tryParseBoolean(field, options));
    }

    private DataType tryParseBoolean(String field, CSVOptions options) {
        return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(field){
            public static final long serialVersionUID = 0L;
            private final String field$6;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.field$6)).toBoolean();
            }
            {
                this.field$6 = field$6;
            }
        }).isDefined() ? BooleanType$.MODULE$ : this.stringType();
    }

    private DataType stringType() {
        return StringType$.MODULE$;
    }

    public IndexedSeq<DataType> org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence() {
        return this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence;
    }

    public Function2<DataType, DataType, Option<DataType>> findTightestCommonType() {
        return this.findTightestCommonType;
    }

    private CSVInferSchema$() {
        MODULE$ = this;
        this.org$apache$spark$sql$execution$datasources$csv$CSVInferSchema$$numericPrecedence = TypeCoercion$.MODULE$.numericPrecedence();
        this.findTightestCommonType = new anonfun.7();
    }
}

