/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.java;

import java.util.HashSet;
import java.util.List;
import org.apache.spark.sql.api.java.ArrayType;
import org.apache.spark.sql.api.java.BinaryType;
import org.apache.spark.sql.api.java.BooleanType;
import org.apache.spark.sql.api.java.ByteType;
import org.apache.spark.sql.api.java.DateType;
import org.apache.spark.sql.api.java.DoubleType;
import org.apache.spark.sql.api.java.FloatType;
import org.apache.spark.sql.api.java.IntegerType;
import org.apache.spark.sql.api.java.LongType;
import org.apache.spark.sql.api.java.MapType;
import org.apache.spark.sql.api.java.Metadata;
import org.apache.spark.sql.api.java.MetadataBuilder;
import org.apache.spark.sql.api.java.NullType;
import org.apache.spark.sql.api.java.ShortType;
import org.apache.spark.sql.api.java.StringType;
import org.apache.spark.sql.api.java.StructField;
import org.apache.spark.sql.api.java.StructType;
import org.apache.spark.sql.api.java.TimestampType;

public abstract class DataType {
    public static final StringType StringType = new StringType();
    public static final BinaryType BinaryType = new BinaryType();
    public static final BooleanType BooleanType = new BooleanType();
    public static final DateType DateType = new DateType();
    public static final TimestampType TimestampType = new TimestampType();
    public static final DoubleType DoubleType = new DoubleType();
    public static final FloatType FloatType = new FloatType();
    public static final ByteType ByteType = new ByteType();
    public static final IntegerType IntegerType = new IntegerType();
    public static final LongType LongType = new LongType();
    public static final ShortType ShortType = new ShortType();
    public static final NullType NullType = new NullType();

    public static ArrayType createArrayType(DataType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, true);
    }

    public static ArrayType createArrayType(DataType elementType, boolean containsNull) {
        if (elementType == null) {
            throw new IllegalArgumentException("elementType should not be null.");
        }
        return new ArrayType(elementType, containsNull);
    }

    public static MapType createMapType(DataType keyType, DataType valueType) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, true);
    }

    public static MapType createMapType(DataType keyType, DataType valueType, boolean valueContainsNull) {
        if (keyType == null) {
            throw new IllegalArgumentException("keyType should not be null.");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType should not be null.");
        }
        return new MapType(keyType, valueType, valueContainsNull);
    }

    public static StructField createStructField(String name, DataType dataType, boolean nullable, Metadata metadata) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null.");
        }
        if (dataType == null) {
            throw new IllegalArgumentException("dataType should not be null.");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("metadata should not be null.");
        }
        return new StructField(name, dataType, nullable, metadata);
    }

    public static StructField createStructField(String name, DataType dataType, boolean nullable) {
        return DataType.createStructField(name, dataType, nullable, new MetadataBuilder().build());
    }

    public static StructType createStructType(List<StructField> fields) {
        return DataType.createStructType(fields.toArray(new StructField[0]));
    }

    public static StructType createStructType(StructField[] fields) {
        if (fields == null) {
            throw new IllegalArgumentException("fields should not be null.");
        }
        HashSet<String> distinctNames = new HashSet<String>();
        for (StructField field : fields) {
            if (field == null) {
                throw new IllegalArgumentException("fields should not contain any null.");
            }
            distinctNames.add(field.getName());
        }
        if (distinctNames.size() != fields.length) {
            throw new IllegalArgumentException("fields should have distinct names.");
        }
        return new StructType(fields);
    }
}

