/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.java;

import org.apache.spark.sql.api.java.DataType;

public class DecimalType
extends DataType {
    private boolean hasPrecisionInfo;
    private int precision;
    private int scale;

    public DecimalType(int precision, int scale) {
        this.hasPrecisionInfo = true;
        this.precision = precision;
        this.scale = scale;
    }

    public DecimalType() {
        this.hasPrecisionInfo = false;
        this.precision = -1;
        this.scale = -1;
    }

    public boolean isUnlimited() {
        return !this.hasPrecisionInfo;
    }

    public boolean isFixed() {
        return this.hasPrecisionInfo;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalType that = (DecimalType)o;
        if (this.hasPrecisionInfo != that.hasPrecisionInfo) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        return this.scale == that.scale;
    }

    public int hashCode() {
        int result = this.hasPrecisionInfo ? 1 : 0;
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }
}

