/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.java;

import org.apache.spark.sql.api.java.DataType;
import org.apache.spark.sql.api.java.Metadata;

public class StructField {
    private String name;
    private DataType dataType;
    private boolean nullable;
    private Metadata metadata;

    protected StructField(String name, DataType dataType, boolean nullable, Metadata metadata) {
        this.name = name;
        this.dataType = dataType;
        this.nullable = nullable;
        this.metadata = metadata;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructField that = (StructField)o;
        if (this.nullable != that.nullable) {
            return false;
        }
        if (!this.dataType.equals(that.dataType)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.metadata.equals((Object)that.metadata);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.dataType.hashCode();
        result = 31 * result + (this.nullable ? 1 : 0);
        result = 31 * result + this.metadata.hashCode();
        return result;
    }
}

