/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.sql.Connection;
import java.util.Properties;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.package$JDBCWriteDetails$;
import org.apache.spark.sql.sources.CreateTableUsingAsSelect;
import org.apache.spark.sql.sources.ResolvedDataSource$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0005\u00114\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005%!\u0015\r^1Ge\u0006lW\r\u0003\u0004\u001a\u0001\u0011\u0005!AG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ma\u0002CA\u000b\u0001\u0011\u0015\u0019\u0002\u00041\u0001\u0015\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0011iw\u000eZ3\u0015\u0005m\u0001\u0003\"B\u0011\u001e\u0001\u0004\u0011\u0013\u0001C:bm\u0016lu\u000eZ3\u0011\u0005U\u0019\u0013B\u0001\u0013\u0003\u0005!\u0019\u0016M^3N_\u0012,\u0007\"\u0002\u0010\u0001\t\u00031CCA\u000e(\u0011\u0015\tS\u00051\u0001)!\tICF\u0004\u0002\u000eU%\u00111FD\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,\u001d!)\u0001\u0007\u0001C\u0001c\u00051am\u001c:nCR$\"a\u0007\u001a\t\u000bMz\u0003\u0019\u0001\u0015\u0002\rM|WO]2f\u0011\u0015)\u0004\u0001\"\u00017\u0003\u0019y\u0007\u000f^5p]R\u00191dN\u001d\t\u000ba\"\u0004\u0019\u0001\u0015\u0002\u0007-,\u0017\u0010C\u0003;i\u0001\u0007\u0001&A\u0003wC2,X\rC\u0003=\u0001\u0011\u0005Q(A\u0004paRLwN\\:\u0015\u0005mq\u0004\"\u0002\u001f<\u0001\u0004y\u0004\u0003\u0002!DQ!j\u0011!\u0011\u0006\u0003\u0005:\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0015IA\u0002NCBDQ\u0001\u0010\u0001\u0005\u0002\u0019#\"aG$\t\u000bq*\u0005\u0019\u0001%\u0011\t%s\u0005\u0006K\u0007\u0002\u0015*\u00111\nT\u0001\u0005kRLGNC\u0001N\u0003\u0011Q\u0017M^1\n\u0005\u0011S\u0005\"\u0002)\u0001\t\u0003\t\u0016a\u00039beRLG/[8o\u0005f$\"a\u0007*\t\u000bM{\u0005\u0019\u0001+\u0002\u0011\r|GNT1nKN\u00042!D+)\u0013\t1fB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB#a\u0014-\u0011\u0005ecV\"\u0001.\u000b\u0005ms\u0011AC1o]>$\u0018\r^5p]&\u0011QL\u0017\u0002\bm\u0006\u0014\u0018M]4t\u0011\u0015y\u0006\u0001\"\u0001a\u0003\u0011\u0019\u0018M^3\u0015\u0005\u0005$\u0007CA\u0007c\u0013\t\u0019gB\u0001\u0003V]&$\b\"B3_\u0001\u0004A\u0013\u0001\u00029bi\"DQa\u0018\u0001\u0005\u0002\u001d$\u0012!\u0019\u0005\u0006S\u0002!\tA[\u0001\u000bS:\u001cXM\u001d;J]R|GCA1l\u0011\u0015a\u0007\u000e1\u0001)\u0003%!\u0018M\u00197f\u001d\u0006lW\rC\u0003o\u0001\u0011\u0005q.A\u0006tCZ,\u0017i\u001d+bE2,GCA1q\u0011\u0015aW\u000e1\u0001)\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0011QGMY2\u0015\t\u0005$h\u000f\u001f\u0005\u0006kF\u0004\r\u0001K\u0001\u0004kJd\u0007\"B<r\u0001\u0004A\u0013!\u0002;bE2,\u0007\"B=r\u0001\u0004Q\u0018\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0005\u0002Jw&\u0011AP\u0013\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u0002@\u0001\t\u0003y\u0018\u0001\u00026t_:$2!YA\u0001\u0011\u0015)W\u00101\u0001)\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\tq\u0001]1scV,G\u000fF\u0002b\u0003\u0013Aa!ZA\u0002\u0001\u0004A\u0003\u0002C\u001a\u0001\u0001\u0004%I!!\u0004\u0016\u0003!B\u0011\"!\u0005\u0001\u0001\u0004%I!a\u0005\u0002\u0015M|WO]2f?\u0012*\u0017\u000fF\u0002b\u0003+A\u0011\"a\u0006\u0002\u0010\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013\u0007C\u0004\u0002\u001c\u0001\u0001\u000b\u0015\u0002\u0015\u0002\u000fM|WO]2fA!Aa\u0004\u0001a\u0001\n\u0013\ty\"F\u0001#\u0011%\t\u0019\u0003\u0001a\u0001\n\u0013\t)#\u0001\u0005n_\u0012,w\fJ3r)\r\t\u0017q\u0005\u0005\n\u0003/\t\t#!AA\u0002\tBq!a\u000b\u0001A\u0003&!%A\u0003n_\u0012,\u0007\u0005C\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011\u00111\u0007\t\u0007\u0003k\tY\u0004\u000b\u0015\u000e\u0005\u0005]\"bAA\u001d\u0003\u00069Q.\u001e;bE2,\u0017\u0002BA\u001f\u0003o\u0011q\u0001S1tQ6\u000b\u0007\u000fC\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002D\u0005\u0001R\r\u001f;sC>\u0003H/[8og~#S-\u001d\u000b\u0004C\u0006\u0015\u0003BCA\f\u0003\u007f\t\t\u00111\u0001\u00024!A\u0011\u0011\n\u0001!B\u0013\t\u0019$A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0005\n\u0003\u001b\u0002\u0001\u0019!C\u0005\u0003\u001f\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N,\"!!\u0015\u0011\u000b5\t\u0019&a\u0016\n\u0007\u0005UcB\u0001\u0004PaRLwN\u001c\t\u0006\u00033\nI\u0007\u000b\b\u0005\u00037\n)G\u0004\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGC\u0001\u0007yI|w\u000e\u001e \n\u0003=I1!a\u001a\u000f\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001b\u0002n\t\u00191+Z9\u000b\u0007\u0005\u001dd\u0002C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t\u00059\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og~#S-\u001d\u000b\u0004C\u0006U\u0004BCA\f\u0003_\n\t\u00111\u0001\u0002R!A\u0011\u0011\u0010\u0001!B\u0013\t\t&\u0001\u000bqCJ$\u0018\u000e^5p]&twmQ8mk6t7\u000f\t\u0015\u0004\u0001\u0005u\u0004\u0003BA@\u0003\u0007k!!!!\u000b\u0005m#\u0011\u0002BAC\u0003\u0003\u0013A\"\u0012=qKJLW.\u001a8uC2\u0004")
public final class DataFrameWriter {
    private final DataFrame df;
    private String source;
    private SaveMode mode;
    private HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;

    public DataFrameWriter partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter mode(String saveMode) {
        block6: {
            SaveMode saveMode2;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = saveMode.toLowerCase();
                            if (!"overwrite".equals(string)) break block2;
                            saveMode2 = SaveMode.Overwrite;
                            break block3;
                        }
                        if (!"append".equals(string)) break block4;
                        saveMode2 = SaveMode.Append;
                        break block3;
                    }
                    if (!"ignore".equals(string)) break block5;
                    saveMode2 = SaveMode.Ignore;
                    break block3;
                }
                boolean bl = "error".equals(string) ? true : "default".equals(string);
                if (!bl) break block6;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted modes are 'overwrite', 'append', 'ignore', 'error'.").toString());
    }

    public DataFrameWriter format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter options(Map<String, String> options2) {
        this.extraOptions().$plus$plus$eq(options2);
        return this;
    }

    public DataFrameWriter options(java.util.Map<String, String> options2) {
        this.options((Map<String, String>)JavaConversions$.MODULE$.mapAsScalaMap(options2));
        return this;
    }

    public DataFrameWriter partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        ResolvedDataSource$.MODULE$.apply(this.df.sqlContext(), this.source(), (String[])this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(Seq<String> x$1) {
                return (String[])x$1.toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }), this.mode(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.df);
    }

    public void insertInto(String tableName) {
        Option partitions = this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Option<String>> apply(Seq<String> x$2) {
                return ((TraversableOnce)x$2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Option<String>> apply(String col2) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)col2), (Object)None$.MODULE$);
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            }
        });
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        boolean overwrite = !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null);
        this.df.sqlContext().executePlan((LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName})), UnresolvedRelation$.MODULE$.apply$default$2()), (scala.collection.immutable.Map)partitions.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<String, Option<String>> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        }), this.df.logicalPlan(), overwrite, false)).toRdd();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveAsTable(String tableName) {
        String string = tableName;
        if (this.df.sqlContext().catalog().tableExists((Seq)Nil$.MODULE$.$colon$colon((Object)string))) {
            SaveMode saveMode = this.mode();
            SaveMode saveMode2 = SaveMode.Overwrite;
            if (saveMode == null ? saveMode2 != null : !((Object)((Object)saveMode)).equals((Object)saveMode2)) {
                SaveMode saveMode3 = this.mode();
                if (((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode3)) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode3)) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3());
                }
                if (!((Object)((Object)SaveMode.Append)).equals((Object)saveMode3)) throw new MatchError((Object)saveMode3);
                this.insertInto(tableName);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        CreateTableUsingAsSelect cmd = new CreateTableUsingAsSelect(tableName, this.source(), false, (String[])this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(Seq<String> x$4) {
                return (String[])x$4.toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }), this.mode(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.df.logicalPlan());
        this.df.sqlContext().executePlan((LogicalPlan)cmd).toRdd();
    }

    /*
     * WARNING - void declaration
     */
    public void jdbc(String url, String table, Properties connectionProperties) {
        Connection conn;
        block7: {
            Object object;
            boolean tableExists2;
            block6: {
                conn = JdbcUtils$.MODULE$.createConnection(url, connectionProperties);
                try {
                    tableExists2 = JdbcUtils$.MODULE$.tableExists(conn, table);
                    SaveMode saveMode = this.mode();
                    SaveMode saveMode2 = SaveMode.Ignore;
                    if ((saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null) || !tableExists2) break block6;
                }
                catch (Throwable throwable) {
                    void var4_4;
                    var4_4.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            SaveMode saveMode = this.mode();
            SaveMode saveMode3 = SaveMode.ErrorIfExists;
            if (!(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode3) : saveMode3 != null) && tableExists2) {
                throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
            }
            SaveMode saveMode4 = this.mode();
            SaveMode saveMode5 = SaveMode.Overwrite;
            if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null) && tableExists2) {
                JdbcUtils$.MODULE$.dropTable(conn, table);
                tableExists2 = false;
            }
            if (tableExists2) {
                object = BoxedUnit.UNIT;
                break block7;
            }
            String schema2 = package$JDBCWriteDetails$.MODULE$.schemaString(this.df, url);
            String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, schema2}));
            object = BoxesRunTime.boxToInteger((int)conn.prepareStatement(sql).executeUpdate());
        }
        conn.close();
        package$JDBCWriteDetails$.MODULE$.saveTable(this.df, url, table, connectionProperties);
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    public DataFrameWriter(DataFrame df) {
        this.df = df;
        this.source = df.sqlContext().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
    }
}

