/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.parquet;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.analysis.UnresolvedException;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.parquet.ParquetRelation;
import org.apache.spark.sql.parquet.ParquetTypesConverter$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import parquet.Log;
import parquet.hadoop.ParquetOutputCommitter;
import parquet.hadoop.metadata.CompressionCodecName;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.sys.package$;

public final class ParquetRelation$
implements Serializable {
    public static final ParquetRelation$ MODULE$;
    private final Map<String, CompressionCodecName> shortParquetCompressionCodecNames;

    static {
        new ParquetRelation$();
    }

    public void enableLogForwarding() {
        Class.forName(Log.class.getName());
        Logger parquetLogger = Logger.getLogger("parquet");
        Predef$.MODULE$.refArrayOps((Object[])parquetLogger.getHandlers()).foreach((Function1)new Serializable(parquetLogger){
            public static final long serialVersionUID = 0L;
            private final Logger parquetLogger$1;

            public final void apply(Handler x$1) {
                this.parquetLogger$1.removeHandler(x$1);
            }
            {
                this.parquetLogger$1 = parquetLogger$1;
            }
        });
        if (!parquetLogger.getUseParentHandlers()) {
            parquetLogger.setUseParentHandlers(true);
        }
        Class.forName(ParquetOutputCommitter.class.getName());
        Logger.getLogger(ParquetOutputCommitter.class.getName()).setLevel(Level.OFF);
    }

    public Map<String, CompressionCodecName> shortParquetCompressionCodecNames() {
        return this.shortParquetCompressionCodecNames;
    }

    public ParquetRelation create(String pathString, LogicalPlan child, Configuration conf, SQLContext sqlContext) {
        if (child.resolved()) {
            return this.createEmpty(pathString, (Seq<Attribute>)child.output(), false, conf, sqlContext);
        }
        throw new UnresolvedException((TreeNode)child, "Attempt to create Parquet table from unresolved child (when schema is not available)");
    }

    public ParquetRelation createEmpty(String pathString, Seq<Attribute> attributes, boolean allowExisting, Configuration conf, SQLContext sqlContext) {
        Path path = this.checkPath(pathString, allowExisting, conf);
        conf.set("parquet.compression", ((Enum)this.shortParquetCompressionCodecNames().getOrElse((Object)sqlContext.conf().parquetCompressionCodec().toUpperCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CompressionCodecName apply() {
                return CompressionCodecName.UNCOMPRESSED;
            }
        })).name());
        this.enableLogForwarding();
        StructType schema2 = StructType$.MODULE$.fromAttributes(attributes).asNullable();
        Seq newAttributes = schema2.toAttributes();
        ParquetTypesConverter$.MODULE$.writeMetaData((Seq<Attribute>)newAttributes, path, conf);
        return new ParquetRelation(conf, sqlContext, path, newAttributes){
            private final Seq<AttributeReference> output;

            public Seq<AttributeReference> output() {
                return this.output;
            }
            {
                this.output = newAttributes$1;
            }
        };
    }

    private Path checkPath(String pathStr, boolean allowExisting, Configuration conf) {
        if (pathStr == null) {
            throw new IllegalArgumentException("Unable to create ParquetRelation: path is null");
        }
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create ParquetRelation: incorrectly formatted path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathStr})));
        }
        Path path = origPath.makeQualified(fs);
        if (!allowExisting && fs.exists(path)) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pathStr})));
        }
        if (fs.exists(path) && !fs.getFileStatus(path).getPermission().getUserAction().implies(FsAction.READ_WRITE)) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create ParquetRelation: path ", " not read-writable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        return path;
    }

    public ParquetRelation apply(String path, Option<Configuration> conf, SQLContext sqlContext, Seq<Attribute> partitioningAttributes) {
        return new ParquetRelation(path, conf, sqlContext, partitioningAttributes);
    }

    public Option<Tuple4<String, Option<Configuration>, SQLContext, Seq<Attribute>>> unapply(ParquetRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.path(), x$0.conf(), (Object)x$0.sqlContext(), x$0.partitioningAttributes()));
    }

    public Seq<Attribute> apply$default$4() {
        return Nil$.MODULE$;
    }

    public Seq<Attribute> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ParquetRelation$() {
        MODULE$ = this;
        this.shortParquetCompressionCodecNames = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"NONE"), (Object)CompressionCodecName.UNCOMPRESSED), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UNCOMPRESSED"), (Object)CompressionCodecName.UNCOMPRESSED), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"SNAPPY"), (Object)CompressionCodecName.SNAPPY), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GZIP"), (Object)CompressionCodecName.GZIP), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"LZO"), (Object)CompressionCodecName.LZO)}));
    }
}

