/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UTF8String;
import org.apache.spark.sql.types.UTF8String$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class SparkSqlSerializer2$
implements Serializable {
    public static final SparkSqlSerializer2$ MODULE$;
    private final int NULL;
    private final int NOT_NULL;

    static {
        new SparkSqlSerializer2$();
    }

    public final int NULL() {
        return 0;
    }

    public final int NOT_NULL() {
        return 1;
    }

    public boolean support(DataType[] schema2) {
        if (schema2 == null) {
            return true;
        }
        boolean allNullTypes = true;
        for (int i = 0; i < schema2.length; ++i) {
            BoxedUnit boxedUnit;
            DataType dataType = schema2[i];
            if (NullType$.MODULE$.equals(dataType)) {
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (dataType instanceof UserDefinedType) {
                allNullTypes = false;
                return false;
            }
            if (dataType instanceof ArrayType) {
                allNullTypes = false;
                return false;
            }
            if (dataType instanceof MapType) {
                allNullTypes = false;
                return false;
            }
            if (dataType instanceof StructType) {
                allNullTypes = false;
                return false;
            }
            allNullTypes = false;
            boxedUnit = BoxedUnit.UNIT;
        }
        return !allNullTypes;
    }

    public Function1<Row, BoxedUnit> createSerializationFunction(DataType[] schema2, DataOutputStream out) {
        return new Serializable(schema2, out){
            public static final long serialVersionUID = 0L;
            private final DataType[] schema$1;
            private final DataOutputStream out$1;

            public final void apply(Row row) {
                if (this.schema$1 != null) {
                    for (int i = 0; i < this.schema$1.length; ++i) {
                        BoxedUnit boxedUnit;
                        DataType dataType = this.schema$1[i];
                        if (NullType$.MODULE$.equals(dataType)) {
                            boxedUnit = BoxedUnit.UNIT;
                            continue;
                        }
                        if (BooleanType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit2;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit2 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeBoolean(row.getBoolean(i));
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit2;
                            continue;
                        }
                        if (ByteType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit3;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit3 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeByte(row.getByte(i));
                                boxedUnit3 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit3;
                            continue;
                        }
                        if (ShortType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit4;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeShort(row.getShort(i));
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit4;
                            continue;
                        }
                        if (IntegerType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit5;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit5 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeInt(row.getInt(i));
                                boxedUnit5 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit5;
                            continue;
                        }
                        if (LongType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit6;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit6 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeLong(row.getLong(i));
                                boxedUnit6 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit6;
                            continue;
                        }
                        if (FloatType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit7;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit7 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeFloat(row.getFloat(i));
                                boxedUnit7 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit7;
                            continue;
                        }
                        if (DoubleType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit8;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit8 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeDouble(row.getDouble(i));
                                boxedUnit8 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit8;
                            continue;
                        }
                        if (dataType instanceof DecimalType) {
                            BoxedUnit boxedUnit9;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit9 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                Decimal value = (Decimal)row.apply(i);
                                BigDecimal javaBigDecimal = value.toJavaBigDecimal();
                                byte[] bytes = javaBigDecimal.unscaledValue().toByteArray();
                                this.out$1.writeInt(bytes.length);
                                this.out$1.write(bytes);
                                this.out$1.writeInt(javaBigDecimal.scale());
                                boxedUnit9 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit9;
                            continue;
                        }
                        if (DateType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit10;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit10 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                this.out$1.writeInt(BoxesRunTime.unboxToInt((Object)row.getAs(i)));
                                boxedUnit10 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit10;
                            continue;
                        }
                        if (TimestampType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit11;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit11 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                Timestamp timestamp = (Timestamp)row.getAs(i);
                                long time = timestamp.getTime();
                                int nanos = timestamp.getNanos();
                                this.out$1.writeLong(time - (long)(nanos / 1000000));
                                this.out$1.writeInt(nanos);
                                boxedUnit11 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit11;
                            continue;
                        }
                        if (StringType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit12;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit12 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                byte[] bytes = ((UTF8String)row.getAs(i)).getBytes();
                                this.out$1.writeInt(bytes.length);
                                this.out$1.write(bytes);
                                boxedUnit12 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit12;
                            continue;
                        }
                        if (BinaryType$.MODULE$.equals(dataType)) {
                            BoxedUnit boxedUnit13;
                            if (row.isNullAt(i)) {
                                this.out$1.writeByte(0);
                                boxedUnit13 = BoxedUnit.UNIT;
                            } else {
                                this.out$1.writeByte(1);
                                byte[] bytes = (byte[])row.getAs(i);
                                this.out$1.writeInt(bytes.length);
                                this.out$1.write(bytes);
                                boxedUnit13 = BoxedUnit.UNIT;
                            }
                            boxedUnit = boxedUnit13;
                            continue;
                        }
                        throw new MatchError((Object)dataType);
                    }
                }
            }
            {
                this.schema$1 = schema$1;
                this.out$1 = out$1;
            }
        };
    }

    public Function1<MutableRow, Row> createDeserializationFunction(DataType[] schema2, DataInputStream in2) {
        return schema2 == null ? new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply(MutableRow mutableRow) {
                return null;
            }
        } : new Serializable(schema2, in2){
            public static final long serialVersionUID = 0L;
            private final DataType[] schema$3;
            private final DataInputStream in$1;

            public final MutableRow apply(MutableRow mutableRow) {
                for (int i = 0; i < this.schema$3.length; ++i) {
                    BoxedUnit boxedUnit;
                    DataType dataType = this.schema$3[i];
                    if (NullType$.MODULE$.equals(dataType)) {
                        mutableRow.setNullAt(i);
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    if (BooleanType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit2;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setBoolean(i, this.in$1.readBoolean());
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit2;
                        continue;
                    }
                    if (ByteType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit3;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setByte(i, this.in$1.readByte());
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit3;
                        continue;
                    }
                    if (ShortType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit4;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setShort(i, this.in$1.readShort());
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit4;
                        continue;
                    }
                    if (IntegerType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit5;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setInt(i, this.in$1.readInt());
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit5;
                        continue;
                    }
                    if (LongType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit6;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit6 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setLong(i, this.in$1.readLong());
                            boxedUnit6 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit6;
                        continue;
                    }
                    if (FloatType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit7;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit7 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setFloat(i, this.in$1.readFloat());
                            boxedUnit7 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit7;
                        continue;
                    }
                    if (DoubleType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit8;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit8 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.setDouble(i, this.in$1.readDouble());
                            boxedUnit8 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit8;
                        continue;
                    }
                    if (dataType instanceof DecimalType) {
                        BoxedUnit boxedUnit9;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit9 = BoxedUnit.UNIT;
                        } else {
                            int length = this.in$1.readInt();
                            byte[] bytes = new byte[length];
                            this.in$1.readFully(bytes);
                            BigInteger unscaledVal = new BigInteger(bytes);
                            int scale = this.in$1.readInt();
                            mutableRow.update(i, (Object)Decimal$.MODULE$.apply(new BigDecimal(unscaledVal, scale)));
                            boxedUnit9 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit9;
                        continue;
                    }
                    if (DateType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit10;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit10 = BoxedUnit.UNIT;
                        } else {
                            mutableRow.update(i, (Object)BoxesRunTime.boxToInteger((int)this.in$1.readInt()));
                            boxedUnit10 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit10;
                        continue;
                    }
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit11;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit11 = BoxedUnit.UNIT;
                        } else {
                            long time = this.in$1.readLong();
                            int nanos = this.in$1.readInt();
                            Timestamp timestamp = new Timestamp(time);
                            timestamp.setNanos(nanos);
                            mutableRow.update(i, (Object)timestamp);
                            boxedUnit11 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit11;
                        continue;
                    }
                    if (StringType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit12;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit12 = BoxedUnit.UNIT;
                        } else {
                            int length = this.in$1.readInt();
                            byte[] bytes = new byte[length];
                            this.in$1.readFully(bytes);
                            mutableRow.update(i, (Object)UTF8String$.MODULE$.apply(bytes));
                            boxedUnit12 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit12;
                        continue;
                    }
                    if (BinaryType$.MODULE$.equals(dataType)) {
                        BoxedUnit boxedUnit13;
                        if (this.in$1.readByte() == 0) {
                            mutableRow.setNullAt(i);
                            boxedUnit13 = BoxedUnit.UNIT;
                        } else {
                            int length = this.in$1.readInt();
                            byte[] bytes = new byte[length];
                            this.in$1.readFully(bytes);
                            mutableRow.update(i, (Object)bytes);
                            boxedUnit13 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit13;
                        continue;
                    }
                    throw new MatchError((Object)dataType);
                }
                return mutableRow;
            }
            {
                this.schema$3 = schema$3;
                this.in$1 = in$1;
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkSqlSerializer2$() {
        MODULE$ = this;
    }
}

