/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.json.JacksonParser$;
import org.apache.spark.sql.execution.datasources.json.JacksonUtils$;
import org.apache.spark.sql.types.ArrayBasedMapData$;
import org.apache.spark.sql.types.ArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.GenericArrayData;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapData;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class JacksonParser$ {
    public static final JacksonParser$ MODULE$;

    static {
        new JacksonParser$();
    }

    public RDD<InternalRow> apply(RDD<String> json, StructType schema2, String columnNameOfCorruptRecords) {
        return this.parseJson(json, schema2, columnNameOfCorruptRecords);
    }

    public Object convertField(JsonFactory factory, JsonParser parser, DataType schema2) {
        Tuple2 tuple2;
        while (true) {
            DataType udt;
            block26: {
                Object object;
                block6: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                block18: {
                                                    block17: {
                                                        block16: {
                                                            block15: {
                                                                block14: {
                                                                    block13: {
                                                                        block12: {
                                                                            DataType dataType;
                                                                            block11: {
                                                                                block10: {
                                                                                    block9: {
                                                                                        block8: {
                                                                                            JsonToken jsonToken;
                                                                                            block7: {
                                                                                                JsonToken jsonToken2;
                                                                                                block5: {
                                                                                                    JsonToken jsonToken3;
                                                                                                    boolean bl;
                                                                                                    if ((tuple2 = new Tuple2((Object)parser.getCurrentToken(), (Object)schema2)) == null || !(bl = (jsonToken3 = (JsonToken)tuple2._1()) == null ? true : JsonToken.VALUE_NULL.equals(jsonToken3))) break block5;
                                                                                                    object = null;
                                                                                                    break block6;
                                                                                                }
                                                                                                if (tuple2 != null && JsonToken.FIELD_NAME.equals(jsonToken2 = (JsonToken)tuple2._1())) {
                                                                                                    parser.nextToken();
                                                                                                    continue;
                                                                                                }
                                                                                                if (tuple2 == null) break block7;
                                                                                                JsonToken jsonToken4 = (JsonToken)tuple2._1();
                                                                                                DataType dataType2 = (DataType)tuple2._2();
                                                                                                if (!JsonToken.VALUE_STRING.equals(jsonToken4) || !StringType$.MODULE$.equals(dataType2)) break block7;
                                                                                                object = UTF8String.fromString((String)parser.getText());
                                                                                                break block6;
                                                                                            }
                                                                                            if (tuple2 == null || !JsonToken.VALUE_STRING.equals(jsonToken = (JsonToken)tuple2._1()) || parser.getTextLength() >= 1) break block8;
                                                                                            object = null;
                                                                                            break block6;
                                                                                        }
                                                                                        if (tuple2 == null) break block9;
                                                                                        JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                                        DataType dataType3 = (DataType)tuple2._2();
                                                                                        if (!JsonToken.VALUE_STRING.equals(jsonToken) || !DateType$.MODULE$.equals(dataType3)) break block9;
                                                                                        object = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime(parser.getText()).getTime()));
                                                                                        break block6;
                                                                                    }
                                                                                    if (tuple2 == null) break block10;
                                                                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                                    DataType dataType4 = (DataType)tuple2._2();
                                                                                    if (!JsonToken.VALUE_STRING.equals(jsonToken) || !TimestampType$.MODULE$.equals(dataType4)) break block10;
                                                                                    object = BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.stringToTime(parser.getText()).getTime() * 1000L));
                                                                                    break block6;
                                                                                }
                                                                                if (tuple2 == null) break block11;
                                                                                JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                                DataType dataType5 = (DataType)tuple2._2();
                                                                                if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken) || !TimestampType$.MODULE$.equals(dataType5)) break block11;
                                                                                object = BoxesRunTime.boxToLong((long)(parser.getLongValue() * 1000L));
                                                                                break block6;
                                                                            }
                                                                            if (tuple2 == null || !StringType$.MODULE$.equals(dataType = (DataType)tuple2._2())) break block12;
                                                                            ByteArrayOutputStream writer = new ByteArrayOutputStream();
                                                                            JsonGenerator generator = factory.createGenerator((OutputStream)writer, JsonEncoding.UTF8);
                                                                            generator.copyCurrentStructure(parser);
                                                                            generator.close();
                                                                            object = UTF8String.fromBytes((byte[])writer.toByteArray());
                                                                            break block6;
                                                                        }
                                                                        if (tuple2 == null) break block13;
                                                                        JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                        DataType dataType = (DataType)tuple2._2();
                                                                        boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                                                                        if (!bl || !FloatType$.MODULE$.equals(dataType)) break block13;
                                                                        object = BoxesRunTime.boxToFloat((float)parser.getFloatValue());
                                                                        break block6;
                                                                    }
                                                                    if (tuple2 == null) break block14;
                                                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                    DataType dataType = (DataType)tuple2._2();
                                                                    boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                                                                    if (!bl || !DoubleType$.MODULE$.equals(dataType)) break block14;
                                                                    object = BoxesRunTime.boxToDouble((double)parser.getDoubleValue());
                                                                    break block6;
                                                                }
                                                                if (tuple2 == null) break block15;
                                                                JsonToken jsonToken = (JsonToken)tuple2._1();
                                                                DataType dt = (DataType)tuple2._2();
                                                                boolean bl = JsonToken.VALUE_NUMBER_INT.equals(jsonToken) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken);
                                                                if (!bl || !(dt instanceof DecimalType)) break block15;
                                                                DecimalType decimalType = (DecimalType)dt;
                                                                object = Decimal$.MODULE$.apply(parser.getDecimalValue(), decimalType.precision(), decimalType.scale());
                                                                break block6;
                                                            }
                                                            if (tuple2 == null) break block16;
                                                            JsonToken jsonToken = (JsonToken)tuple2._1();
                                                            DataType dataType = (DataType)tuple2._2();
                                                            if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken) || !ByteType$.MODULE$.equals(dataType)) break block16;
                                                            object = BoxesRunTime.boxToByte((byte)parser.getByteValue());
                                                            break block6;
                                                        }
                                                        if (tuple2 == null) break block17;
                                                        JsonToken jsonToken = (JsonToken)tuple2._1();
                                                        DataType dataType = (DataType)tuple2._2();
                                                        if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken) || !ShortType$.MODULE$.equals(dataType)) break block17;
                                                        object = BoxesRunTime.boxToShort((short)parser.getShortValue());
                                                        break block6;
                                                    }
                                                    if (tuple2 == null) break block18;
                                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                                    DataType dataType = (DataType)tuple2._2();
                                                    if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken) || !IntegerType$.MODULE$.equals(dataType)) break block18;
                                                    object = BoxesRunTime.boxToInteger((int)parser.getIntValue());
                                                    break block6;
                                                }
                                                if (tuple2 == null) break block19;
                                                JsonToken jsonToken = (JsonToken)tuple2._1();
                                                DataType dataType = (DataType)tuple2._2();
                                                if (!JsonToken.VALUE_NUMBER_INT.equals(jsonToken) || !LongType$.MODULE$.equals(dataType)) break block19;
                                                object = BoxesRunTime.boxToLong((long)parser.getLongValue());
                                                break block6;
                                            }
                                            if (tuple2 == null) break block20;
                                            JsonToken jsonToken = (JsonToken)tuple2._1();
                                            DataType dataType = (DataType)tuple2._2();
                                            if (!JsonToken.VALUE_TRUE.equals(jsonToken) || !BooleanType$.MODULE$.equals(dataType)) break block20;
                                            object = BoxesRunTime.boxToBoolean((boolean)true);
                                            break block6;
                                        }
                                        if (tuple2 == null) break block21;
                                        JsonToken jsonToken = (JsonToken)tuple2._1();
                                        DataType dataType = (DataType)tuple2._2();
                                        if (!JsonToken.VALUE_FALSE.equals(jsonToken) || !BooleanType$.MODULE$.equals(dataType)) break block21;
                                        object = BoxesRunTime.boxToBoolean((boolean)false);
                                        break block6;
                                    }
                                    if (tuple2 == null) break block22;
                                    JsonToken jsonToken = (JsonToken)tuple2._1();
                                    DataType st = (DataType)tuple2._2();
                                    if (!JsonToken.START_OBJECT.equals(jsonToken) || !(st instanceof StructType)) break block22;
                                    StructType structType = (StructType)st;
                                    object = this.convertObject(factory, parser, structType);
                                    break block6;
                                }
                                if (tuple2 == null) break block23;
                                JsonToken jsonToken = (JsonToken)tuple2._1();
                                DataType st = (DataType)tuple2._2();
                                if (!JsonToken.START_ARRAY.equals(jsonToken) || !(st instanceof StructType)) break block23;
                                StructType structType = (StructType)st;
                                object = this.convertArray(factory, parser, (DataType)structType);
                                break block6;
                            }
                            if (tuple2 == null) break block24;
                            JsonToken jsonToken = (JsonToken)tuple2._1();
                            DataType dataType = (DataType)tuple2._2();
                            if (!JsonToken.START_ARRAY.equals(jsonToken) || !(dataType instanceof ArrayType)) break block24;
                            ArrayType arrayType = (ArrayType)dataType;
                            DataType st = arrayType.elementType();
                            object = this.convertArray(factory, parser, st);
                            break block6;
                        }
                        if (tuple2 == null) break block25;
                        JsonToken jsonToken = (JsonToken)tuple2._1();
                        DataType dataType = (DataType)tuple2._2();
                        if (!JsonToken.START_OBJECT.equals(jsonToken) || !(dataType instanceof ArrayType)) break block25;
                        ArrayType arrayType = (ArrayType)dataType;
                        DataType st = arrayType.elementType();
                        Object object2 = this.convertField(factory, parser, st);
                        object = Nil$.MODULE$.$colon$colon(object2);
                        break block6;
                    }
                    if (tuple2 == null) break block26;
                    JsonToken jsonToken = (JsonToken)tuple2._1();
                    DataType dataType = (DataType)tuple2._2();
                    if (!JsonToken.START_OBJECT.equals(jsonToken) || !(dataType instanceof MapType)) break block26;
                    MapType mapType = (MapType)dataType;
                    DataType dataType6 = mapType.keyType();
                    DataType kt = mapType.valueType();
                    if (!StringType$.MODULE$.equals(dataType6)) break block26;
                    object = this.convertMap(factory, parser, kt);
                }
                return object;
            }
            if (tuple2 == null || !((udt = (DataType)tuple2._2()) instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)udt;
            schema2 = userDefinedType.sqlType();
        }
        throw new MatchError((Object)tuple2);
    }

    private InternalRow convertObject(JsonFactory factory, JsonParser parser, StructType schema2) {
        GenericMutableRow row = new GenericMutableRow(schema2.length());
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            JsonParser jsonParser;
            Option option = schema2.getFieldIndex(parser.getCurrentName());
            if (option instanceof Some) {
                Some some = (Some)option;
                int index = BoxesRunTime.unboxToInt((Object)some.x());
                row.update(index, this.convertField(factory, parser, schema2.apply(index).dataType()));
                jsonParser = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                jsonParser = parser.skipChildren();
                continue;
            }
            throw new MatchError((Object)option);
        }
        return row;
    }

    private MapData convertMap(JsonFactory factory, JsonParser parser, DataType valueType) {
        ArrayBuffer keys = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
            keys.$plus$eq((Object)UTF8String.fromString((String)parser.getCurrentName()));
            values.$plus$eq(this.convertField(factory, parser, valueType));
        }
        return ArrayBasedMapData$.MODULE$.apply((Object[])keys.toArray(ClassTag$.MODULE$.Any()), (Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    private ArrayData convertArray(JsonFactory factory, JsonParser parser, DataType elementType) {
        ArrayBuffer values = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
            values.$plus$eq(this.convertField(factory, parser, elementType));
        }
        return new GenericArrayData((Object[])values.toArray(ClassTag$.MODULE$.Any()));
    }

    private RDD<InternalRow> parseJson(RDD<String> json, StructType schema2, String columnNameOfCorruptRecords) {
        return json.mapPartitions((Function1)new Serializable(schema2, columnNameOfCorruptRecords){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            public final String columnNameOfCorruptRecords$1;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                JsonFactory factory = new JsonFactory();
                return iter.flatMap((Function1)new Serializable(this, factory){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.parseJson.1 $outer;
                    private final JsonFactory factory$1;

                    public final GenTraversableOnce<InternalRow> apply(String record) {
                        Seq seq;
                        try {
                            Seq seq2;
                            JsonParser parser = this.factory$1.createParser(record);
                            parser.nextToken();
                            Object object = JacksonParser$.MODULE$.convertField(this.factory$1, parser, (DataType)this.$outer.schema$1);
                            if (object == null) {
                                seq2 = JacksonParser$.MODULE$.org$apache$spark$sql$execution$datasources$json$JacksonParser$$failedRecord$1(record, this.$outer.schema$1, this.$outer.columnNameOfCorruptRecords$1);
                            } else if (object instanceof InternalRow) {
                                InternalRow internalRow;
                                InternalRow internalRow2 = internalRow = (InternalRow)object;
                                seq2 = Nil$.MODULE$.$colon$colon((Object)internalRow2);
                            } else if (object instanceof ArrayData) {
                                ArrayData arrayData = (ArrayData)object;
                                seq2 = arrayData.numElements() == 0 ? Nil$.MODULE$ : Predef$.MODULE$.refArrayOps((Object[])arrayData.toArray((DataType)this.$outer.schema$1, ClassTag$.MODULE$.apply(InternalRow.class)));
                            } else {
                                throw package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse record ", ". Please make sure that each line of the file "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record}))).append((Object)"(or each string in the RDD) is a valid JSON object or an array of JSON objects.").toString());
                            }
                            seq = seq2;
                        }
                        catch (JsonProcessingException jsonProcessingException) {
                            seq = JacksonParser$.MODULE$.org$apache$spark$sql$execution$datasources$json$JacksonParser$$failedRecord$1(record, this.$outer.schema$1, this.$outer.columnNameOfCorruptRecords$1);
                        }
                        return seq;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.factory$1 = factory$1;
                    }
                });
            }
            {
                this.schema$1 = schema$1;
                this.columnNameOfCorruptRecords$1 = columnNameOfCorruptRecords$1;
            }
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public final Seq org$apache$spark$sql$execution$datasources$json$JacksonParser$$failedRecord$1(String record, StructType schema$1, String columnNameOfCorruptRecords$1) {
        GenericMutableRow row = new GenericMutableRow(schema$1.length());
        schema$1.getFieldIndex(columnNameOfCorruptRecords$1).foreach((Function1)new Serializable(schema$1, record, row){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;
            private final String record$1;
            private final GenericMutableRow row$1;

            public final void apply(int corruptIndex) {
                this.apply$mcVI$sp(corruptIndex);
            }

            public void apply$mcVI$sp(int corruptIndex) {
                DataType dataType = this.schema$1.apply(corruptIndex).dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                Predef$.MODULE$.require(!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null));
                this.row$1.update(corruptIndex, (Object)UTF8String.fromString((String)this.record$1));
            }
            {
                this.schema$1 = schema$1;
                this.record$1 = record$1;
                this.row$1 = row$1;
            }
        });
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenericMutableRow[]{row}));
    }

    private JacksonParser$() {
        MODULE$ = this;
    }
}

