/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.Logging;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.datasources.parquet.CatalystReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try$;

public final class ParquetTypesConverter$
implements Logging {
    public static final ParquetTypesConverter$ MODULE$;
    private final int[] BYTES_FOR_PRECISION;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ParquetTypesConverter$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean isPrimitiveType(DataType ctype) {
        DataType dataType = ctype;
        boolean bl = dataType instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)))));
        boolean bl2 = bl;
        return bl2;
    }

    public int[] BYTES_FOR_PRECISION() {
        return this.BYTES_FOR_PRECISION;
    }

    public MessageType convertFromAttributes(Seq<Attribute> attributes) {
        CatalystSchemaConverter converter = new CatalystSchemaConverter();
        return converter.convert(StructType$.MODULE$.fromAttributes(attributes));
    }

    public Seq<Attribute> convertFromString(String string) {
        DataType dataType = (DataType)Try$.MODULE$.apply((Function0)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String string$1;

            public final DataType apply() {
                return DataType$.MODULE$.fromJson(this.string$1);
            }
            {
                this.string$1 = string$1;
            }
        }).getOrElse((Function0)new Serializable(string){
            public static final long serialVersionUID = 0L;
            private final String string$1;

            public final DataType apply() {
                return DataType$.MODULE$.fromCaseClassString(this.string$1);
            }
            {
                this.string$1 = string$1;
            }
        });
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Seq seq = structType.toAttributes();
            return seq;
        }
        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can convert ", " to row"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public String convertToString(Seq<Attribute> schema2) {
        ((IterableLike)schema2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return x$1.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String name) {
                CatalystSchemaConverter$.MODULE$.checkFieldName(name);
            }
        });
        return StructType$.MODULE$.fromAttributes(schema2).json();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeMetaData(Seq<Attribute> attributes, Path origPath, Configuration conf) {
        Object object;
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to write Parquet metadata: path is null");
        }
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to write Parquet metadata: path ", " is incorrectly formatted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        if (fs.exists(path) && !fs.getFileStatus(path).isDir()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to write to directory ", " but found file"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        }
        Path metadataPath = new Path(path, "_metadata");
        if (fs.exists(metadataPath)) {
            try {
                object = BoxesRunTime.boxToBoolean((boolean)fs.delete(metadataPath, true));
            }
            catch (IOException iOException) {
                void var6_6;
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to delete previous PARQUET_METADATA_FILE at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_6})));
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        HashMap<String, String> extraMetadata = new HashMap<String, String>();
        extraMetadata.put(CatalystReadSupport$.MODULE$.SPARK_METADATA_KEY(), this.convertToString(attributes));
        MessageType parquetSchema = this.convertFromAttributes(attributes);
        FileMetaData metaData = new FileMetaData(parquetSchema, extraMetadata, "Spark");
        Footer footer = new Footer(path, new ParquetMetadata(metaData, JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$)));
        ParquetFileWriter.writeMetadataFile((Configuration)conf, (Path)path, (List)JavaConversions$.MODULE$.seqAsJavaList((Seq)Nil$.MODULE$.$colon$colon((Object)footer)));
    }

    public ParquetMetadata readMetaData(Path origPath, Option<Configuration> configuration) {
        if (origPath == null) {
            throw new IllegalArgumentException("Unable to read Parquet metadata: path is null");
        }
        Job job = new Job();
        Configuration conf = (Configuration)configuration.getOrElse((Function0)new Serializable(job){
            public static final long serialVersionUID = 0L;
            private final Job job$1;

            public final Configuration apply() {
                return ContextUtil.getConfiguration((JobContext)this.job$1);
            }
            {
                this.job$1 = job$1;
            }
        });
        FileSystem fs = origPath.getFileSystem(conf);
        if (fs == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Incorrectly formatted Parquet metadata path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origPath})));
        }
        Path path = origPath.makeQualified(fs);
        FileStatus[] children = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.globStatus(path)).flatMap((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final SeqLike<FileStatus, Object> apply(FileStatus status) {
                return status.isDir() ? Predef$.MODULE$.refArrayOps((Object[])this.fs$1.listStatus(status.getPath())) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{status}));
            }
            {
                this.fs$1 = fs$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(FileStatus status) {
                String name = status.getPath().getName();
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0) != '.') {
                    if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(name), 0) != '_') return false;
                }
                String string = name;
                String string2 = "_metadata";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }
        });
        return (ParquetMetadata)Predef$.MODULE$.refArrayOps((Object[])children).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_metadata";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        }).orElse((Function0)new Serializable(children){
            public static final long serialVersionUID = 0L;
            private final FileStatus[] children$1;

            public final Option<FileStatus> apply() {
                return Predef$.MODULE$.refArrayOps((Object[])this.children$1).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$4) {
                        String string = x$4.getPath().getName();
                        String string2 = "_metadata";
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
            {
                this.children$1 = children$1;
            }
        }).map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final ParquetMetadata apply(FileStatus x$5) {
                return ParquetFileReader.readFooter((Configuration)this.conf$1, (FileStatus)x$5, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            }
            {
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find Parquet metadata at path ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1})));
            }
            {
                this.path$1 = path$1;
            }
        });
    }

    private ParquetTypesConverter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.BYTES_FOR_PRECISION = (int[])Array$.MODULE$.tabulate(38, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int precision) {
                return this.apply$mcII$sp(precision);
            }

            /*
             * WARNING - void declaration
             */
            public int apply$mcII$sp(int precision) {
                void var2_2;
                int length = 1;
                while (package$.MODULE$.pow(2.0, (double)(8 * length - 1)) < package$.MODULE$.pow(10.0, (double)precision)) {
                    ++length;
                }
                return (int)var2_2;
            }
        }, ClassTag$.MODULE$.Int());
    }
}

