/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.Logging;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.SqlParser$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource;
import org.apache.spark.sql.execution.datasources.ResolvedDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.JSONRelation;
import org.apache.spark.sql.execution.datasources.json.JSONRelation$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\tA!\u0003\u0002\u0016\t\t9Aj\\4hS:<\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0015M\fHnQ8oi\u0016DH\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tQ1+\u0015'D_:$X\r\u001f;\t\ru\u0001A\u0011\u0001\u0002\u001f\u0003\u0019a\u0014N\\5u}Q\u0011q\u0004\t\t\u00033\u0001AQa\u0006\u000fA\u0002aAQA\t\u0001\u0005\u0002\r\naAZ8s[\u0006$HCA\u0010%\u0011\u0015)\u0013\u00051\u0001'\u0003\u0019\u0019x.\u001e:dKB\u0011qE\u000b\b\u0003\u001b!J!!\u000b\b\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003S9AQA\f\u0001\u0005\u0002=\naa]2iK6\fGCA\u00101\u0011\u0015qS\u00061\u00012!\t\u0011T'D\u00014\u0015\t!$!A\u0003usB,7/\u0003\u00027g\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000ba\u0002A\u0011A\u001d\u0002\r=\u0004H/[8o)\ry\"\b\u0010\u0005\u0006w]\u0002\rAJ\u0001\u0004W\u0016L\b\"B\u001f8\u0001\u00041\u0013!\u0002<bYV,\u0007\"B \u0001\t\u0003\u0001\u0015aB8qi&|gn\u001d\u000b\u0003?\u0005CQa\u0010 A\u0002\t\u0003Ba\u0011$'M5\tAI\u0003\u0002F\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d#%aA'ba\")q\b\u0001C\u0001\u0013R\u0011qD\u0013\u0005\u0006\u007f!\u0003\ra\u0013\t\u0005\u0019F3c%D\u0001N\u0015\tqu*\u0001\u0003vi&d'\"\u0001)\u0002\t)\fg/Y\u0005\u0003\u000f6CQa\u0015\u0001\u0005\u0002Q\u000bA\u0001\\8bIR\u0011Q\u000b\u0017\t\u00033YK!a\u0016\u0002\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B-S\u0001\u00041\u0013\u0001\u00029bi\"DQa\u0015\u0001\u0005\u0002m#\u0012!\u0016\u0005\u0006'\u0002!\t!\u0018\u000b\u0003+zCQa\u0018/A\u0002\u0001\fQ\u0001]1uQN\u00042!D1'\u0013\t\u0011gB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB#\u0001\u00183\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dt\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011N\u001a\u0002\bm\u0006\u0014\u0018M]4t\u0011\u0015Y\u0007\u0001\"\u0001m\u0003\u0011QGMY2\u0015\tUkw.\u001d\u0005\u0006]*\u0004\rAJ\u0001\u0004kJd\u0007\"\u00029k\u0001\u00041\u0013!\u0002;bE2,\u0007\"\u0002:k\u0001\u0004\u0019\u0018A\u00039s_B,'\u000f^5fgB\u0011A\n^\u0005\u0003k6\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0015Y\u0007\u0001\"\u0001x)-)\u00060\u001f>}\u0003\u0007\t9!!\u0005\t\u000b94\b\u0019\u0001\u0014\t\u000bA4\b\u0019\u0001\u0014\t\u000bm4\b\u0019\u0001\u0014\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0003~m\u0002\u0007a0\u0001\u0006m_^,'OQ8v]\u0012\u0004\"!D@\n\u0007\u0005\u0005aB\u0001\u0003M_:<\u0007BBA\u0003m\u0002\u0007a0\u0001\u0006vaB,'OQ8v]\u0012Dq!!\u0003w\u0001\u0004\tY!A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004\u001b\u00055\u0011bAA\b\u001d\t\u0019\u0011J\u001c;\t\r\u0005Ma\u000f1\u0001t\u0003Q\u0019wN\u001c8fGRLwN\u001c)s_B,'\u000f^5fg\"11\u000e\u0001C\u0001\u0003/!\u0012\"VA\r\u00037\ti\"a\n\t\r9\f)\u00021\u0001'\u0011\u0019\u0001\u0018Q\u0003a\u0001M!A\u0011qDA\u000b\u0001\u0004\t\t#\u0001\u0006qe\u0016$\u0017nY1uKN\u0004B!DA\u0012M%\u0019\u0011Q\u0005\b\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005M\u0011Q\u0003a\u0001g\"11\u000e\u0001C\u0005\u0003W!\u0012\"VA\u0017\u0003_\t\t$!\u0010\t\r9\fI\u00031\u0001'\u0011\u0019\u0001\u0018\u0011\u0006a\u0001M!A\u00111GA\u0015\u0001\u0004\t)$A\u0003qCJ$8\u000fE\u0003\u000e\u0003G\t9\u0004E\u0002\u0014\u0003sI1!a\u000f\u0005\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0014\u0005%\u0002\u0019A:\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D\u0005!!n]8o)\r)\u0016Q\t\u0005\u00073\u0006}\u0002\u0019\u0001\u0014\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002JQ\u0019Q+a\u0013\t\r}\u000b9\u00051\u0001a\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u001f\"2!VA)\u0011!\t\u0019&!\u0014A\u0002\u0005U\u0013a\u00026t_:\u0014F\t\u0012\t\u0006\u0003/\nyFJ\u0007\u0003\u00033R1\u0001UA.\u0015\r\ti\u0006B\u0001\u0004CBL\u0017\u0002BA1\u00033\u0012qAS1wCJ#E\tC\u0004\u0002B\u0001!\t!!\u001a\u0015\u0007U\u000b9\u0007\u0003\u0005\u0002T\u0005\r\u0004\u0019AA5!\u0015\tY'!\u001d'\u001b\t\tiGC\u0002\u0002p\u0011\t1A\u001d3e\u0013\u0011\t\u0019(!\u001c\u0003\u0007I#E\tC\u0004\u0002x\u0001!\t!!\u001f\u0002\u000fA\f'/];fiR\u0019Q+a\u001f\t\r}\u000b)\b1\u0001aQ\r\t)\b\u001a\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\ry'o\u0019\u000b\u0004+\u0006\u0015\u0005BB-\u0002\u0000\u0001\u0007a\u0005\u0003\u0004q\u0001\u0011\u0005\u0011\u0011\u0012\u000b\u0004+\u0006-\u0005bBAG\u0003\u000f\u0003\rAJ\u0001\ni\u0006\u0014G.\u001a(b[\u0016Dq!!%\u0001\t\u0003\t\u0019*\u0001\u0003uKb$HcA+\u0002\u0016\"1q,a$A\u0002\u0001D3!a$e\u0011!)\u0003\u00011A\u0005\n\u0005mU#\u0001\u0014\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0016AC:pkJ\u001cWm\u0018\u0013fcR!\u00111UAU!\ri\u0011QU\u0005\u0004\u0003Os!\u0001B+oSRD\u0011\"a+\u0002\u001e\u0006\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013\u0007C\u0004\u00020\u0002\u0001\u000b\u0015\u0002\u0014\u0002\u000fM|WO]2fA!I\u00111\u0017\u0001A\u0002\u0013%\u0011QW\u0001\u0014kN,'o\u00159fG&4\u0017.\u001a3TG\",W.Y\u000b\u0003\u0003o\u0003B!DA]c%\u0019\u00111\u0018\b\u0003\r=\u0003H/[8o\u0011%\ty\f\u0001a\u0001\n\u0013\t\t-A\fvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017m\u0018\u0013fcR!\u00111UAb\u0011)\tY+!0\u0002\u0002\u0003\u0007\u0011q\u0017\u0005\t\u0003\u000f\u0004\u0001\u0015)\u0003\u00028\u0006!Ro]3s'B,7-\u001b4jK\u0012\u001c6\r[3nC\u0002B\u0011\"a3\u0001\u0001\u0004%I!!4\u0002\u0019\u0015DHO]1PaRLwN\\:\u0016\u0005\u0005=\u0007CBAi\u0003/4c%\u0004\u0002\u0002T*\u0019\u0011Q\u001b#\u0002\u000f5,H/\u00192mK&!\u0011\u0011\\Aj\u0005\u001dA\u0015m\u001d5NCBD\u0011\"!8\u0001\u0001\u0004%I!a8\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BAR\u0003CD!\"a+\u0002\\\u0006\u0005\t\u0019AAh\u0011!\t)\u000f\u0001Q!\n\u0005=\u0017!D3yiJ\fw\n\u001d;j_:\u001c\b\u0005K\u0002\u0001\u0003S\u0004B!a;\u0002p6\u0011\u0011Q\u001e\u0006\u0003O\u0012IA!!=\u0002n\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class DataFrameReader
implements Logging {
    public final SQLContext org$apache$spark$sql$DataFrameReader$$sqlContext;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DataFrame load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrame parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrame text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema2) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema2));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader options(Map<String, String> options2) {
        this.extraOptions().$plus$plus$eq(options2);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options2) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options2).asScala()));
        return this;
    }

    public DataFrame load(String path) {
        return this.option("path", path).load();
    }

    public DataFrame load() {
        ResolvedDataSource resolved = ResolvedDataSource$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, this.userSpecifiedSchema(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), this.source(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        return DataFrame$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, (LogicalPlan)new LogicalRelation(resolved.relation(), LogicalRelation$.MODULE$.apply$default$2()));
    }

    public DataFrame load(Seq<String> paths) {
        return this.option("paths", ((TraversableOnce)paths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return StringUtils.escapeString((String)x$1, (char)'\\', (char)',');
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",")).load();
    }

    public DataFrame jdbc(String url, String table, Properties properties) {
        return this.jdbc(url, table, JDBCRelation$.MODULE$.columnPartition(null), properties);
    }

    public DataFrame jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        JDBCPartitioningInfo partitioning = new JDBCPartitioningInfo(columnName, lowerBound, upperBound, numPartitions);
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitioning);
        return this.jdbc(url, table, parts, connectionProperties);
    }

    public DataFrame jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        return this.jdbc(url, table, parts, connectionProperties);
    }

    private DataFrame jdbc(String url, String table, Partition[] parts, Properties connectionProperties) {
        Properties props = new Properties();
        this.extraOptions().foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Object object = this.props$1.put(key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        props.putAll((java.util.Map<?, ?>)connectionProperties);
        JDBCRelation relation = new JDBCRelation(url, table, parts, props, this.org$apache$spark$sql$DataFrameReader$$sqlContext);
        return this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(relation);
    }

    public DataFrame json(String path) {
        return this.format("json").load(path);
    }

    public DataFrame json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public DataFrame json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public DataFrame json(RDD<String> jsonRDD) {
        Some x$3 = new Some(jsonRDD);
        Option<StructType> x$4 = this.userSpecifiedSchema();
        None$ x$5 = None$.MODULE$;
        None$ x$6 = None$.MODULE$;
        scala.collection.immutable.Map x$7 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        String[] x$8 = JSONRelation$.MODULE$.$lessinit$greater$default$5();
        SQLContext x$9 = this.org$apache$spark$sql$DataFrameReader$$sqlContext;
        return this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(new JSONRelation((Option<RDD<String>>)x$3, x$4, (Option<PartitionSpec>)x$5, (Option<StructType>)x$6, x$8, (scala.collection.immutable.Map<String, String>)x$7, x$9));
    }

    public DataFrame parquet(Seq<String> paths) {
        DataFrame dataFrame;
        if (paths.isEmpty()) {
            dataFrame = this.org$apache$spark$sql$DataFrameReader$$sqlContext.emptyDataFrame();
        } else {
            Path[] globbedPaths = (Path[])((TraversableOnce)paths.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DataFrameReader $outer;

                public final Seq<Path> apply(String path) {
                    Path hdfsPath = new Path(path);
                    FileSystem fs = hdfsPath.getFileSystem(this.$outer.org$apache$spark$sql$DataFrameReader$$sqlContext.sparkContext().hadoopConfiguration());
                    Path qualified = hdfsPath.makeQualified(fs.getUri(), fs.getWorkingDirectory());
                    return SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(qualified);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Path.class));
            dataFrame = this.org$apache$spark$sql$DataFrameReader$$sqlContext.baseRelationToDataFrame(new ParquetRelation((String[])Predef$.MODULE$.refArrayOps((Object[])globbedPaths).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Path x$2) {
                    return x$2.toString();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), this.userSpecifiedSchema(), (Option<PartitionSpec>)None$.MODULE$, (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameReader$$sqlContext));
        }
        return dataFrame;
    }

    public DataFrame orc(String path) {
        return this.format("orc").load(path);
    }

    public DataFrame table(String tableName) {
        return DataFrame$.MODULE$.apply(this.org$apache$spark$sql$DataFrameReader$$sqlContext, this.org$apache$spark$sql$DataFrameReader$$sqlContext.catalog().lookupRelation(SqlParser$.MODULE$.parseTableIdentifier(tableName), this.org$apache$spark$sql$DataFrameReader$$sqlContext.catalog().lookupRelation$default$2()));
    }

    public DataFrame text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataFrameReader(SQLContext sqlContext) {
        this.org$apache$spark$sql$DataFrameReader$$sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
        this.source = sqlContext.conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

