/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.ContinuousQuery;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ProcessingTime;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.Trigger;
import org.apache.spark.sql.catalyst.analysis.Append$;
import org.apache.spark.sql.catalyst.analysis.OutputMode;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.streaming.ContinuousQueryListenerBus;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.util.ContinuousQueryListener;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001-\u0011acQ8oi&tWo\\;t#V,'/_'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001c9A\u0011Q\u0003\u0001\u0005\u0006'a\u0001\r\u0001\u0006\u0005\t=\u0001\u0011\r\u0011\"\u0001\u0003?\u0005)2\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014X#\u0001\u0011\u0011\u0005\u0005BS\"\u0001\u0012\u000b\u0005\r\"\u0013!B:uCR,'BA\u0013'\u0003%\u0019HO]3b[&twM\u0003\u0002(\u0005\u0005IQ\r_3dkRLwN\\\u0005\u0003S\t\u0012\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0011\u0019Y\u0003\u0001)A\u0005A\u000512\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002_A\u0011\u0001'M\u0007\u0002I%\u0011!\u0007\n\u0002\u001b\u0007>tG/\u001b8v_V\u001c\u0018+^3ss2K7\u000f^3oKJ\u0014Uo\u001d\u0005\u0007i\u0001\u0001\u000b\u0011B\u0018\u0002\u00191L7\u000f^3oKJ\u0014Uo\u001d\u0011\t\u000fY\u0002!\u0019!C\u0005o\u0005i\u0011m\u0019;jm\u0016\fV/\u001a:jKN,\u0012\u0001\u000f\t\u0005sy\u0002u)D\u0001;\u0015\tYD(A\u0004nkR\f'\r\\3\u000b\u0005ur\u0011AC2pY2,7\r^5p]&\u0011qH\u000f\u0002\b\u0011\u0006\u001c\b.T1q!\t\tEI\u0004\u0002\u000e\u0005&\u00111ID\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D\u001dA\u0011Q\u0003S\u0005\u0003\u0013\n\u0011qbQ8oi&tWo\\;t#V,'/\u001f\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002\u001d\u0002\u001d\u0005\u001cG/\u001b<f#V,'/[3tA!9Q\n\u0001b\u0001\n\u0013q\u0015!E1di&4X-U;fe&,7\u000fT8dWV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!A.\u00198h\u0015\u0005!\u0016\u0001\u00026bm\u0006L!AV)\u0003\r=\u0013'.Z2u\u0011\u0019A\u0006\u0001)A\u0005\u001f\u0006\u0011\u0012m\u0019;jm\u0016\fV/\u001a:jKNdunY6!\u0011\u001dQ\u0006A1A\u0005\n9\u000bA#Y<bSR$VM]7j]\u0006$\u0018n\u001c8M_\u000e\\\u0007B\u0002/\u0001A\u0003%q*A\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m\u001b\u0011\t\u000fy\u0003\u0001\u0019!C\u0005?\u0006\u0019B.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ssV\tq\tC\u0004b\u0001\u0001\u0007I\u0011\u00022\u0002/1\f7\u000f\u001e+fe6Lg.\u0019;fIF+XM]=`I\u0015\fHCA2g!\tiA-\u0003\u0002f\u001d\t!QK\\5u\u0011\u001d9\u0007-!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0011\u0019I\u0007\u0001)Q\u0005\u000f\u0006!B.Y:u)\u0016\u0014X.\u001b8bi\u0016$\u0017+^3ss\u0002BQa\u001b\u0001\u0005\u00021\fa!Y2uSZ,W#A7\u0011\u00075qw)\u0003\u0002p\u001d\t)\u0011I\u001d:bs\")\u0011\u000f\u0001C\u0001e\u0006\u0019q-\u001a;\u0015\u0005\u001d\u001b\b\"\u0002;q\u0001\u0004\u0001\u0015\u0001\u00028b[\u0016DQA\u001e\u0001\u0005\u0002]\f1#Y<bSR\fe.\u001f+fe6Lg.\u0019;j_:$\u0012a\u0019\u0005\u0006m\u0002!\t!\u001f\u000b\u0003uv\u0004\"!D>\n\u0005qt!a\u0002\"p_2,\u0017M\u001c\u0005\u0006}b\u0004\ra`\u0001\ni&lWm\\;u\u001bN\u00042!DA\u0001\u0013\r\t\u0019A\u0004\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\b\u0001!\ta^\u0001\u0010e\u0016\u001cX\r\u001e+fe6Lg.\u0019;fI\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011aC1eI2K7\u000f^3oKJ$2aYA\b\u0011!\t\t\"!\u0003A\u0002\u0005M\u0011\u0001\u00037jgR,g.\u001a:\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007\u0003\u0003\u0011)H/\u001b7\n\t\u0005u\u0011q\u0003\u0002\u0018\u0007>tG/\u001b8v_V\u001c\u0018+^3ss2K7\u000f^3oKJDq!!\t\u0001\t\u0003\t\u0019#\u0001\bsK6|g/\u001a'jgR,g.\u001a:\u0015\u0007\r\f)\u0003\u0003\u0005\u0002\u0012\u0005}\u0001\u0019AA\n\u0011!\tI\u0003\u0001C\u0001\u0005\u0005-\u0012!\u00059pgRd\u0015n\u001d;f]\u0016\u0014XI^3oiR\u00191-!\f\t\u0011\u0005=\u0012q\u0005a\u0001\u0003c\tQ!\u001a<f]R\u0004B!a\r\u0002:9!\u0011QCA\u001b\u0013\u0011\t9$a\u0006\u0002/\r{g\u000e^5ok>,8/U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BA\u001e\u0003{\u0011Q!\u0012<f]RTA!a\u000e\u0002\u0018!A\u0011\u0011\t\u0001\u0005\u0002\t\t\u0019%\u0001\u0006ti\u0006\u0014H/U;fef$rbRA#\u0003\u000f\nY%!\u0018\u0002h\u0005E\u0014q\u0010\u0005\u0007i\u0006}\u0002\u0019\u0001!\t\u000f\u0005%\u0013q\ba\u0001\u0001\u0006\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011!\ti%a\u0010A\u0002\u0005=\u0013A\u00013g!\u0011\t\t&a\u0016\u000f\u0007U\t\u0019&C\u0002\u0002V\t\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#!\u0003#bi\u00064%/Y7f\u0015\r\t)F\u0001\u0005\t\u0003?\ny\u00041\u0001\u0002b\u0005!1/\u001b8l!\r\u0001\u00141M\u0005\u0004\u0003K\"#\u0001B*j].D!\"!\u001b\u0002@A\u0005\t\u0019AA6\u0003\u001d!(/[4hKJ\u00042!FA7\u0013\r\tyG\u0001\u0002\b)JLwmZ3s\u0011)\t\u0019(a\u0010\u0011\u0002\u0003\u0007\u0011QO\u0001\riJLwmZ3s\u00072|7m\u001b\t\u0005\u0003o\nY(\u0004\u0002\u0002z)\u0019\u0011\u0011\u0004\u0003\n\t\u0005u\u0014\u0011\u0010\u0002\u0006\u00072|7m\u001b\u0005\u000b\u0003\u0003\u000by\u0004%AA\u0002\u0005\r\u0015AC8viB,H/T8eKB!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001C1oC2L8/[:\u000b\u0007\u00055%!\u0001\u0005dCR\fG._:u\u0013\u0011\t\t*a\"\u0003\u0015=+H\u000f];u\u001b>$W\r\u0003\u0005\u0002\u0016\u0002!\tAAAL\u0003Yqw\u000e^5gsF+XM]=UKJl\u0017N\\1uS>tGcA2\u0002\u001a\"9\u00111TAJ\u0001\u00049\u0015a\u0004;fe6Lg.\u0019;fIF+XM]=\t\u0013\u0005}\u0005!%A\u0005\u0002\u0005\u0005\u0016\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$S'\u0006\u0002\u0002$*\"\u00111NASW\t\t9\u000b\u0005\u0003\u0002*\u0006MVBAAV\u0015\u0011\ti+a,\u0002\u0013Ut7\r[3dW\u0016$'bAAY\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00161\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA]\u0001E\u0005I\u0011AA^\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011Q\u0018\u0016\u0005\u0003k\n)\u000bC\u0005\u0002B\u0002\t\n\u0011\"\u0001\u0002D\u0006!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uI]*\"!!2+\t\u0005\r\u0015Q\u0015\u0015\u0004\u0001\u0005%\u0007\u0003BAf\u0003\u001fl!!!4\u000b\u0007\u0005EF!\u0003\u0003\u0002R\u00065'\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class ContinuousQueryManager {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final ContinuousQueryListenerBus listenerBus;
    private final HashMap<String, ContinuousQuery> activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    private ContinuousQuery lastTerminatedQuery;

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private ContinuousQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<String, ContinuousQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private ContinuousQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(ContinuousQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public ContinuousQuery[] active() {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            Object object2 = this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(ContinuousQuery.class));
            return (ContinuousQuery[])object2;
        }
    }

    public ContinuousQuery get(String name) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            Object object2 = this.activeQueries().getOrElse((Object)name, (Function0)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final Nothing$ apply() {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There is no active query with name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1})));
                }
                {
                    this.name$1 = name$1;
                }
            });
            return (ContinuousQuery)object2;
        }
    }

    public void awaitAnyTermination() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            return;
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) {
        long startTime = System.currentTimeMillis();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!this.isTimedout$1(timeoutMs, startTime) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            Boolean bl = BoxesRunTime.boxToBoolean((this.lastTerminatedQuery() != null ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
            return;
        }
    }

    public void addListener(ContinuousQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(ContinuousQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public void postListenerEvent(ContinuousQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    public ContinuousQuery startQuery(String name, String checkpointLocation, Dataset<Row> df, Sink sink, Trigger trigger, Clock triggerClock, OutputMode outputMode) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            if (this.activeQueries().contains((Object)name)) {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot start query with name ", " as a query with that name is already active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
            }
            LogicalPlan analyzedPlan = df.queryExecution().analyzed();
            df.queryExecution().assertAnalyzed();
            if (BoxesRunTime.unboxToBoolean((Object)this.sparkSession.conf().get(SQLConf$.MODULE$.UNSUPPORTED_OPERATION_CHECK_ENABLED()))) {
                UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
            }
            LongRef nextSourceId = LongRef.create((long)0L);
            LogicalPlan logicalPlan = (LogicalPlan)analyzedPlan.transform((PartialFunction)new Serializable(this, checkpointLocation, nextSourceId){
                public static final long serialVersionUID = 0L;
                private final String checkpointLocation$1;
                private final LongRef nextSourceId$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StreamingRelation) {
                        StreamingRelation streamingRelation = (StreamingRelation)A1;
                        DataSource dataSource = streamingRelation.dataSource();
                        Seq<Attribute> output2 = streamingRelation.output();
                        String metadataPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/sources/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointLocation$1, BoxesRunTime.boxToLong((long)this.nextSourceId$1.elem)}));
                        Source source = dataSource.createSource(metadataPath);
                        ++this.nextSourceId$1.elem;
                        object = new StreamingExecutionRelation(source, output2);
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof StreamingRelation;
                    return bl;
                }
                {
                    this.checkpointLocation$1 = checkpointLocation$1;
                    this.nextSourceId$1 = nextSourceId$1;
                }
            });
            StreamExecution query2 = new StreamExecution(this.sparkSession, name, checkpointLocation, logicalPlan, sink, trigger, triggerClock, outputMode);
            query2.start();
            this.activeQueries().put((Object)name, (Object)query2);
            StreamExecution streamExecution = query2;
            return streamExecution;
        }
    }

    public Trigger startQuery$default$5() {
        return new ProcessingTime(0L);
    }

    public Clock startQuery$default$6() {
        return new SystemClock();
    }

    public OutputMode startQuery$default$7() {
        return Append$.MODULE$;
    }

    /*
     * Exception decompiling
     */
    public void notifyQueryTermination(ContinuousQuery terminatedQuery) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[MONITOR]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final boolean isTimedout$1(long timeoutMs$1, long startTime$1) {
        return System.currentTimeMillis() - startTime$1 >= timeoutMs$1;
    }

    public ContinuousQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new ContinuousQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
    }
}

