/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.ProcessingTime;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;

@Experimental
public final class ProcessingTime$
implements Serializable {
    public static final ProcessingTime$ MODULE$;

    static {
        new ProcessingTime$();
    }

    public ProcessingTime apply(String interval) {
        CalendarInterval cal;
        if (StringUtils.isBlank((CharSequence)interval)) {
            throw new IllegalArgumentException("interval cannot be null or blank.");
        }
        CalendarInterval calendarInterval = cal = interval.startsWith("interval") ? CalendarInterval.fromString((String)interval) : CalendarInterval.fromString((String)new StringBuilder().append((Object)"interval ").append((Object)interval).toString());
        if (cal == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        if (cal.months > 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Doesn't support month or year interval: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{interval})));
        }
        return new ProcessingTime(cal.microseconds / 1000L);
    }

    public ProcessingTime apply(Duration interval) {
        return new ProcessingTime(interval.toMillis());
    }

    public ProcessingTime create(String interval) {
        return this.apply(interval);
    }

    public ProcessingTime create(long interval, TimeUnit unit) {
        return new ProcessingTime(unit.toMillis(interval));
    }

    public ProcessingTime apply(long intervalMs) {
        return new ProcessingTime(intervalMs);
    }

    public Option<Object> unapply(ProcessingTime x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)x$0.intervalMs()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ProcessingTime$() {
        MODULE$ = this;
    }
}

