/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class CSVTypeCast$ {
    public static final CSVTypeCast$ MODULE$;

    static {
        new CSVTypeCast$();
    }

    public Object castTo(String datum, DataType castType, boolean nullable, CSVOptions options) {
        block30: {
            Comparable<Byte> comparable;
            block18: {
                DataType dataType;
                block29: {
                    boolean bl;
                    block28: {
                        DateType dateType;
                        block27: {
                            boolean bl2;
                            block26: {
                                TimestampType timestampType;
                                block25: {
                                    Decimal decimal;
                                    block24: {
                                        block23: {
                                            Object object;
                                            block22: {
                                                Object object2;
                                                block21: {
                                                    block20: {
                                                        block19: {
                                                            block17: {
                                                                bl2 = false;
                                                                timestampType = null;
                                                                bl = false;
                                                                dateType = null;
                                                                dataType = castType;
                                                                if (!(dataType instanceof ByteType)) break block17;
                                                                String string = datum;
                                                                String string2 = options.nullValue();
                                                                comparable = !(string != null ? !string.equals(string2) : string2 != null) && nullable ? null : BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
                                                                break block18;
                                                            }
                                                            if (!(dataType instanceof ShortType)) break block19;
                                                            String string = datum;
                                                            String string3 = options.nullValue();
                                                            comparable = !(string != null ? !string.equals(string3) : string3 != null) && nullable ? null : BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
                                                            break block18;
                                                        }
                                                        if (!(dataType instanceof IntegerType)) break block20;
                                                        String string = datum;
                                                        String string4 = options.nullValue();
                                                        comparable = !(string != null ? !string.equals(string4) : string4 != null) && nullable ? null : BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
                                                        break block18;
                                                    }
                                                    if (!(dataType instanceof LongType)) break block21;
                                                    String string = datum;
                                                    String string5 = options.nullValue();
                                                    comparable = !(string != null ? !string.equals(string5) : string5 != null) && nullable ? null : BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
                                                    break block18;
                                                }
                                                if (!(dataType instanceof FloatType)) break block22;
                                                String string = datum;
                                                String string6 = options.nullValue();
                                                if (!(string != null ? !string.equals(string6) : string6 != null) && nullable) {
                                                    object2 = null;
                                                } else {
                                                    String string7 = datum;
                                                    String string8 = options.nanValue();
                                                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                                                        object2 = BoxesRunTime.boxToFloat((float)Float.NaN);
                                                    } else {
                                                        String string9 = datum;
                                                        String string10 = options.negativeInf();
                                                        if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                                            object2 = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                                                        } else {
                                                            String string11 = datum;
                                                            String string12 = options.positiveInf();
                                                            object2 = !(string11 != null ? !string11.equals(string12) : string12 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : Try$.MODULE$.apply((Function0)new Serializable(datum){
                                                                public static final long serialVersionUID = 0L;
                                                                private final String datum$1;

                                                                public final float apply() {
                                                                    return this.apply$mcF$sp();
                                                                }

                                                                public float apply$mcF$sp() {
                                                                    return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toFloat();
                                                                }
                                                                {
                                                                    this.datum$1 = datum$1;
                                                                }
                                                            }).getOrElse((Function0)new Serializable(datum){
                                                                public static final long serialVersionUID = 0L;
                                                                private final String datum$1;

                                                                public final float apply() {
                                                                    return this.apply$mcF$sp();
                                                                }

                                                                public float apply$mcF$sp() {
                                                                    return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).floatValue();
                                                                }
                                                                {
                                                                    this.datum$1 = datum$1;
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
                                                comparable = object2;
                                                break block18;
                                            }
                                            if (!(dataType instanceof DoubleType)) break block23;
                                            String string = datum;
                                            String string13 = options.nullValue();
                                            if (!(string != null ? !string.equals(string13) : string13 != null) && nullable) {
                                                object = null;
                                            } else {
                                                String string14 = datum;
                                                String string15 = options.nanValue();
                                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                                    object = BoxesRunTime.boxToDouble((double)Double.NaN);
                                                } else {
                                                    String string16 = datum;
                                                    String string17 = options.negativeInf();
                                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                                        object = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                                                    } else {
                                                        String string18 = datum;
                                                        String string19 = options.positiveInf();
                                                        object = !(string18 != null ? !string18.equals(string19) : string19 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : Try$.MODULE$.apply((Function0)new Serializable(datum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String datum$1;

                                                            public final double apply() {
                                                                return this.apply$mcD$sp();
                                                            }

                                                            public double apply$mcD$sp() {
                                                                return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toDouble();
                                                            }
                                                            {
                                                                this.datum$1 = datum$1;
                                                            }
                                                        }).getOrElse((Function0)new Serializable(datum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String datum$1;

                                                            public final double apply() {
                                                                return this.apply$mcD$sp();
                                                            }

                                                            public double apply$mcD$sp() {
                                                                return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).doubleValue();
                                                            }
                                                            {
                                                                this.datum$1 = datum$1;
                                                            }
                                                        });
                                                    }
                                                }
                                            }
                                            comparable = object;
                                            break block18;
                                        }
                                        if (!(dataType instanceof BooleanType)) break block24;
                                        comparable = BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(datum)).toBoolean());
                                        break block18;
                                    }
                                    if (!(dataType instanceof DecimalType)) break block25;
                                    DecimalType decimalType = (DecimalType)dataType;
                                    String string = datum;
                                    String string20 = options.nullValue();
                                    if (!(string != null ? !string.equals(string20) : string20 != null) && nullable) {
                                        decimal = null;
                                    } else {
                                        BigDecimal value = new BigDecimal(datum.replaceAll(",", ""));
                                        decimal = Decimal$.MODULE$.apply(value, decimalType.precision(), decimalType.scale());
                                    }
                                    comparable = decimal;
                                    break block18;
                                }
                                if (!(dataType instanceof TimestampType)) break block26;
                                bl2 = true;
                                timestampType = (TimestampType)dataType;
                                if (options.dateFormat() == null) break block26;
                                comparable = BoxesRunTime.boxToLong((long)(options.dateFormat().parse(datum).getTime() * 1000L));
                                break block18;
                            }
                            if (!bl2) break block27;
                            comparable = BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.stringToTime(datum).getTime() * 1000L));
                            break block18;
                        }
                        if (!(dataType instanceof DateType)) break block28;
                        bl = true;
                        dateType = (DateType)dataType;
                        if (options.dateFormat() == null) break block28;
                        comparable = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(options.dateFormat().parse(datum).getTime()));
                        break block18;
                    }
                    if (!bl) break block29;
                    comparable = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime(datum).getTime()));
                    break block18;
                }
                if (!(dataType instanceof StringType)) break block30;
                comparable = UTF8String.fromString((String)datum);
            }
            return comparable;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castType.typeName()})));
    }

    public boolean castTo$default$3() {
        return true;
    }

    public CSVOptions castTo$default$4() {
        return CSVOptions$.MODULE$.apply();
    }

    public char toChar(String str) throws IllegalArgumentException {
        block15: {
            char c;
            block14: {
                block13: {
                    if (str.charAt(0) != '\\') break block13;
                    char c2 = str.charAt(1);
                    switch (c2) {
                        case 'u': {
                            String string = str;
                            String string2 = "\u0000";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                c = '\u0000';
                                break;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                    }
                    break block14;
                }
                if (str.length() != 1) break block15;
                c = str.charAt(0);
            }
            return c;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
    }

    private CSVTypeCast$() {
        MODULE$ = this;
    }
}

