/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.json.InferSchema$;
import org.apache.spark.sql.execution.datasources.json.JSONOptions;
import org.apache.spark.sql.execution.datasources.json.JacksonParser$;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001E\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00131q\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005!\u0011BA\u000e\u0005\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003;\u0001j\u0011A\b\u0006\u0003?!\tqa]8ve\u000e,7/\u0003\u0002\"=\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t!\u0001C\u0003)\u0001\u0011\u0005\u0013&A\u0005tQ>\u0014HOT1nKR\t!\u0006\u0005\u0002,]9\u00111\u0003L\u0005\u0003[Q\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\u0006\u0005\u0006e\u0001!\teM\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u00035{\rC\u0005cA\n6o%\u0011a\u0007\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005aZT\"A\u001d\u000b\u0005iB\u0011!\u0002;za\u0016\u001c\u0018B\u0001\u001f:\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006}E\u0002\raP\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003\u0001\u0006k\u0011\u0001C\u0005\u0003\u0005\"\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001R\u0019A\u0002\u0015\u000bqa\u001c9uS>t7\u000f\u0005\u0003,\r*R\u0013BA$1\u0005\ri\u0015\r\u001d\u0005\u0006\u0013F\u0002\rAS\u0001\u0006M&dWm\u001d\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty\u0005#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011!\u000bF\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0002TKFT!A\u0015\u000b\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016A\u00014t\u0015\tYF\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003;b\u0013!BR5mKN#\u0018\r^;t\u0011\u0015y\u0006\u0001\"\u0011a\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u0015\tG-Z7o!\tI\"-\u0003\u0002d\t\t\u0019r*\u001e;qkR<&/\u001b;fe\u001a\u000b7\r^8ss\")aH\u0018a\u0001\u007f!)aM\u0018a\u0001O\u0006\u0019!n\u001c2\u0011\u0005!\\W\"A5\u000b\u0005)T\u0016!C7baJ,G-^2f\u0013\ta\u0017NA\u0002K_\nDQ\u0001\u00120A\u0002\u0015CQa\u001c0A\u0002]\n!\u0002Z1uCN\u001b\u0007.Z7b\u0011\u0015\t\b\u0001\"\u0011s\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015\u001fM\f)!a\u0002\u0002\n\u00055\u0011\u0011CA\u000f\u0003?\u0001Ba\u0005;ws&\u0011Q\u000f\u0006\u0002\n\rVt7\r^5p]F\u0002\"!G<\n\u0005a$!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u0007-SH0\u0003\u0002|+\nA\u0011\n^3sCR|'\u000fE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\"\t\u0001bY1uC2L8\u000f^\u0005\u0004\u0003\u0007q(aC%oi\u0016\u0014h.\u00197S_^DQA\u00109A\u0002}BQa\u001c9A\u0002]Ba!a\u0003q\u0001\u00049\u0014a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005=\u0001\u000f1\u00018\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a\u0005q\u0001\u0004\t)\"A\u0004gS2$XM]:\u0011\t-\u001b\u0016q\u0003\t\u0004;\u0005e\u0011bAA\u000e=\t1a)\u001b7uKJDQ\u0001\u00129A\u0002\u0015Cq!!\tq\u0001\u0004\t\u0019#\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003SQ\u0016\u0001B2p]\u001aLA!!\f\u0002(\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\r\u0001\t\u0013\t\u0019$A\u0007de\u0016\fG/\u001a\"bg\u0016\u0014F\r\u001a\u000b\u0007\u0003k\t\t%a\u0011\u0011\u000b\u0005]\u0012Q\b\u0016\u000e\u0005\u0005e\"bAA\u001e\u0015\u0005\u0019!\u000f\u001a3\n\t\u0005}\u0012\u0011\b\u0002\u0004%\u0012#\u0005B\u0002 \u00020\u0001\u0007q\bC\u0004\u0002F\u0005=\u0002\u0019\u0001&\u0002\u0015%t\u0007/\u001e;QCRD7\u000fC\u0004\u0002J\u0001!I!a\u0013\u0002!\rDWmY6D_:\u001cHO]1j]R\u001cH\u0003BA'\u0003'\u00022aEA(\u0013\r\t\t\u0006\u0006\u0002\u0005+:LG\u000fC\u0004\u0002V\u0005\u001d\u0003\u0019A\u001c\u0002\rM\u001c\u0007.Z7b\u0011\u0019\tI\u0006\u0001C!S\u0005AAo\\*ue&tw\rC\u0004\u0002^\u0001!\t%a\u0018\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0019\u0011\u0007M\t\u0019'C\u0002\u0002fQ\u00111!\u00138u\u0011\u001d\tI\u0007\u0001C!\u0003W\na!Z9vC2\u001cH\u0003BA7\u0003g\u00022aEA8\u0013\r\t\t\b\u0006\u0002\b\u0005>|G.Z1o\u0011!\t)(a\u001aA\u0002\u0005]\u0014!B8uQ\u0016\u0014\bcA\n\u0002z%\u0019\u00111\u0010\u000b\u0003\u0007\u0005s\u0017\u0010")
public class DefaultSource
implements FileFormat,
DataSourceRegister {
    @Override
    public Map<String, String> prepareRead(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return FileFormat$class.prepareRead(this, sparkSession, options, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat$class.supportBatch(this, sparkSession, dataSchema);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat$class.buildReaderWithPartitionValues(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return FileFormat$class.buildWriter(this, sqlContext, dataSchema, options);
    }

    @Override
    public String shortName() {
        return "json";
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        None$ none$;
        if (files.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            JSONOptions parsedOptions = new JSONOptions(options);
            String columnNameOfCorruptRecord = (String)parsedOptions.columnNameOfCorruptRecord().getOrElse((Function0)new Serializable(this, sparkSession){
                public static final long serialVersionUID = 0L;
                private final SparkSession sparkSession$1;

                public final String apply() {
                    return this.sparkSession$1.sessionState().conf().columnNameOfCorruptRecord();
                }
                {
                    this.sparkSession$1 = sparkSession$1;
                }
            });
            FileStatus[] jsonFiles = (FileStatus[])((TraversableOnce)files.filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    String name = status.getPath().getName();
                    return name.startsWith("_") || name.startsWith(".");
                }
            })).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            StructType jsonSchema = InferSchema$.MODULE$.infer(this.createBaseRdd(sparkSession, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])jsonFiles)), columnNameOfCorruptRecord, parsedOptions);
            this.checkConstraints(jsonSchema);
            none$ = new Some((Object)jsonSchema);
        }
        return none$;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options);
        parsedOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, bucketId, dataSchema, context);
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptions parsedOptions = new JSONOptions(options);
        String columnNameOfCorruptRecord = (String)parsedOptions.columnNameOfCorruptRecord().getOrElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$2;

            public final String apply() {
                return this.sparkSession$2.sessionState().conf().columnNameOfCorruptRecord();
            }
            {
                this.sparkSession$2 = sparkSession$2;
            }
        });
        return new Serializable(this, requiredSchema, broadcastedHadoopConf, parsedOptions, columnNameOfCorruptRecord){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final JSONOptions parsedOptions$1;
            private final String columnNameOfCorruptRecord$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<B> lines = new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value()).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Text x$1) {
                        return x$1.toString();
                    }
                });
                return JacksonParser$.MODULE$.parseJson(lines, this.requiredSchema$1, this.columnNameOfCorruptRecord$1, this.parsedOptions$1);
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.parsedOptions$1 = parsedOptions$1;
                this.columnNameOfCorruptRecord$1 = columnNameOfCorruptRecord$1;
            }
        };
    }

    private RDD<String> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths) {
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConf());
        Configuration conf = job.getConfiguration();
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$2) {
                return x$2.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (paths.nonEmpty()) {
            FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        }
        return sparkSession.sparkContext().hadoopRDD((JobConf)conf, TextInputFormat.class, LongWritable.class, Text.class, sparkSession.sparkContext().hadoopRDD$default$5()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<LongWritable, Text> x$3) {
                return ((Text)x$3._2()).toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    private void checkConstraints(StructType schema) {
        if (schema.fieldNames().length != ((String[])Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).distinct()).length) {
            String duplicateColumns = ((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames()).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(this){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, String[]>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        String[] ys = (String[])A1._2();
                        if (ys.length > 1) {
                            object = new StringBuilder().append((Object)"\"").append((Object)x).append((Object)"\"").toString();
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, String[]> x1) {
                    String[] ys;
                    Tuple2<String, String[]> tuple2 = x1;
                    boolean bl = tuple2 != null && (ys = (String[])tuple2._2()).length > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate column(s) : ", " found, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateColumns}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot save to JSON format"})).s((Seq)Nil$.MODULE$)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
    }

    public String toString() {
        return "JSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof DefaultSource;
    }

    public DefaultSource() {
        FileFormat$class.$init$(this);
    }
}

