/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001E\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\u0011!X\r\u001f;\u000b\u0005\u00151\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0002\u0005\u0002\u0013\u0015DXmY;uS>t'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u00131q\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005!\u0011BA\u000e\u0005\u0005)1\u0015\u000e\\3G_Jl\u0017\r\u001e\t\u0003;\u0001j\u0011A\b\u0006\u0003?!\tqa]8ve\u000e,7/\u0003\u0002\"=\t\u0011B)\u0019;b'>,(oY3SK\u001eL7\u000f^3s\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002'\u00015\t!\u0001C\u0003)\u0001\u0011\u0005\u0013&A\u0005tQ>\u0014HOT1nKR\t!\u0006\u0005\u0002,]9\u00111\u0003L\u0005\u0003[Q\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\u0006\u0005\u0006e\u0001!IaM\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0003i]\u0002\"aE\u001b\n\u0005Y\"\"\u0001B+oSRDQ\u0001O\u0019A\u0002e\naa]2iK6\f\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\t\u0003\u0015!\u0018\u0010]3t\u0013\tq4H\u0001\u0006TiJ,8\r\u001e+za\u0016DQ\u0001\u0011\u0001\u0005B\u0005\u000b1\"\u001b8gKJ\u001c6\r[3nCR!!)R&Q!\r\u00192)O\u0005\u0003\tR\u0011aa\u00149uS>t\u0007\"\u0002$@\u0001\u00049\u0015\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001%J\u001b\u0005A\u0011B\u0001&\t\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015au\b1\u0001N\u0003\u001dy\u0007\u000f^5p]N\u0004Ba\u000b(+U%\u0011q\n\r\u0002\u0004\u001b\u0006\u0004\b\"B)@\u0001\u0004\u0011\u0016!\u00024jY\u0016\u001c\bcA*\\=:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/B\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005i#\u0012a\u00029bG.\fw-Z\u0005\u00039v\u00131aU3r\u0015\tQF\u0003\u0005\u0002`I6\t\u0001M\u0003\u0002bE\u0006\u0011am\u001d\u0006\u0003G2\ta\u0001[1e_>\u0004\u0018BA3a\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006O\u0002!\t\u0005[\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006S2lWO\u001e\t\u00033)L!a\u001b\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000b\u00193\u0007\u0019A$\t\u000b94\u0007\u0019A8\u0002\u0007)|'\r\u0005\u0002qg6\t\u0011O\u0003\u0002sE\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003iF\u00141AS8c\u0011\u0015ae\r1\u0001N\u0011\u00159h\r1\u0001:\u0003)!\u0017\r^1TG\",W.\u0019\u0005\u0007s\u0002!\t\u0005\u0003>\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cHcD>\u0002\u0016\u0005]\u0011\u0011DA\u000f\u0003C\ti#a\f\u0011\u000bMah0a\u0001\n\u0005u$\"!\u0003$v]\u000e$\u0018n\u001c82!\tIr0C\u0002\u0002\u0002\u0011\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0006'\u0006\u0015\u0011\u0011B\u0005\u0004\u0003\u000fi&\u0001C%uKJ\fGo\u001c:\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004\t\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA\n\u0003\u001b\u00111\"\u00138uKJt\u0017\r\u001c*po\")a\t\u001fa\u0001\u000f\")q\u000f\u001fa\u0001s!1\u00111\u0004=A\u0002e\nq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003?A\b\u0019A\u001d\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u00111\u0005=A\u0002\u0005\u0015\u0012a\u00024jYR,'o\u001d\t\u0005'n\u000b9\u0003E\u0002\u001e\u0003SI1!a\u000b\u001f\u0005\u00191\u0015\u000e\u001c;fe\")A\n\u001fa\u0001\u001b\"9\u0011\u0011\u0007=A\u0002\u0005M\u0012A\u00035bI>|\u0007oQ8oMB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\t\fAaY8oM&!\u0011QHA\u001c\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011\u0011\t\u0001\u0005B\u0005\r\u0013a\u00032vS2$'+Z1eKJ$rb_A#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011\u000b\u0005\u0007\r\u0006}\u0002\u0019A$\t\r]\fy\u00041\u0001:\u0011\u001d\tY\"a\u0010A\u0002eBq!a\b\u0002@\u0001\u0007\u0011\b\u0003\u0005\u0002$\u0005}\u0002\u0019AA\u0013\u0011\u0019a\u0015q\ba\u0001\u001b\"A\u0011\u0011GA \u0001\u0004\t\u0019\u0004")
public class DefaultSource
implements FileFormat,
DataSourceRegister {
    @Override
    public Map<String, String> prepareRead(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return FileFormat$class.prepareRead(this, sparkSession, options, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat$class.supportBatch(this, sparkSession, dataSchema);
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return FileFormat$class.buildWriter(this, sqlContext, dataSchema, options);
    }

    @Override
    public String shortName() {
        return "text";
    }

    private void verifySchema(StructType schema) {
        DataType tpe;
        if (schema.size() != 1) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a single column, and you have ", " columns."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schema.size())})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
        }
        DataType dataType = tpe = schema.apply(0).dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a string column, but you have ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe.simpleString()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        Option compressionCodec = options.get((Object)"compression").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return CompressionCodecs$.MODULE$.getCodecClassName(name);
            }
        });
        compressionCodec.foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                if (bucketId.isDefined()) {
                    throw new AnalysisException("Text doesn't support bucketing", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
                }
                return new TextOutputWriter(path, dataSchema, context);
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return this.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                UnsafeRow unsafeRow = new UnsafeRow(1);
                BufferHolder bufferHolder = new BufferHolder(unsafeRow);
                UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(bufferHolder, 1);
                return new HadoopFileLinesReader(file, ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value()).map(new Serializable(this, unsafeRow, bufferHolder, unsafeRowWriter){
                    public static final long serialVersionUID = 0L;
                    private final UnsafeRow unsafeRow$1;
                    private final BufferHolder bufferHolder$1;
                    private final UnsafeRowWriter unsafeRowWriter$1;

                    public final UnsafeRow apply(Text line) {
                        this.bufferHolder$1.reset();
                        this.unsafeRowWriter$1.write(0, line.getBytes(), 0, line.getLength());
                        this.unsafeRow$1.setTotalSize(this.bufferHolder$1.totalSize());
                        return this.unsafeRow$1;
                    }
                    {
                        this.unsafeRow$1 = unsafeRow$1;
                        this.bufferHolder$1 = bufferHolder$1;
                        this.unsafeRowWriter$1 = unsafeRowWriter$1;
                    }
                });
            }
            {
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    public DefaultSource() {
        FileFormat$class.$init$(this);
    }
}

