/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.util.Arrays;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.spark_project.guava.annotations.VisibleForTesting;

public class AggregateHashMap {
    private ColumnarBatch batch;
    private int[] buckets;
    private int numBuckets;
    private int numRows = 0;
    private int maxSteps = 3;
    private static int DEFAULT_CAPACITY = 65536;
    private static double DEFAULT_LOAD_FACTOR = 0.25;
    private static int DEFAULT_MAX_STEPS = 3;

    public AggregateHashMap(StructType schema, int capacity, double loadFactor, int maxSteps) {
        assert (schema.size() == 2 && schema.fields()[0].dataType() == DataTypes.LongType && schema.fields()[1].dataType() == DataTypes.LongType);
        assert (capacity > 0 && (capacity & capacity - 1) == 0);
        this.maxSteps = maxSteps;
        this.numBuckets = (int)((double)capacity / loadFactor);
        this.batch = ColumnarBatch.allocate(schema, MemoryMode.ON_HEAP, capacity);
        this.buckets = new int[this.numBuckets];
        Arrays.fill(this.buckets, -1);
    }

    public AggregateHashMap(StructType schema) {
        this(schema, DEFAULT_CAPACITY, DEFAULT_LOAD_FACTOR, DEFAULT_MAX_STEPS);
    }

    public ColumnarBatch.Row findOrInsert(long key) {
        int idx = this.find(key);
        if (idx != -1 && this.buckets[idx] == -1) {
            this.batch.column(0).putLong(this.numRows, key);
            this.batch.column(1).putLong(this.numRows, 0L);
            ++this.numRows;
        }
        return this.batch.getRow(this.buckets[idx]);
    }

    @VisibleForTesting
    public int find(long key) {
        long h = this.hash(key);
        int idx = (int)h & this.numBuckets - 1;
        for (int step = 0; step < this.maxSteps; ++step) {
            if (this.buckets[idx] == -1) {
                return idx;
            }
            if (this.equals(idx, key)) {
                return idx;
            }
            idx = idx + 1 & this.numBuckets - 1;
        }
        return -1;
    }

    private long hash(long key) {
        return key;
    }

    private boolean equals(int idx, long key1) {
        return this.batch.column(0).getLong(this.buckets[idx]) == key1;
    }
}

