/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Properties;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameWriter$$anonfun$org$apache$spark$sql$DataFrameWriter$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteOptions;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteOptions$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t=f\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019m\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u0013)\u0012A\u00013t!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\b\t\u0006$\u0018m]3u!\tQ2\u0004\u0004\u0001\u0005\u000bq\u0001!\u0019A\u000f\u0003\u0003Q\u000b\"AH\u0011\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0012\n\u0005\rz!aA!os\"1Q\u0005\u0001C\u0001\u0005\u0019\na\u0001P5oSRtDCA\u0014)!\r1\u0002!\u0007\u0005\u0006)\u0011\u0002\r!\u0006\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\t!g-F\u0001-!\ti\u0003G\u0004\u0002\u0017]%\u0011qFA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011qF\u0001\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0007\u00114\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0003n_\u0012,GCA\u00149\u0011\u0015IT\u00071\u0001;\u0003!\u0019\u0018M^3N_\u0012,\u0007C\u0001\f<\u0013\ta$A\u0001\u0005TCZ,Wj\u001c3f\u0011\u00151\u0004\u0001\"\u0001?)\t9s\bC\u0003:{\u0001\u0007\u0001\t\u0005\u0002B\t:\u0011aBQ\u0005\u0003\u0007>\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111i\u0004\u0005\u0006\u0011\u0002!\t!S\u0001\u0007M>\u0014X.\u0019;\u0015\u0005\u001dR\u0005\"B&H\u0001\u0004\u0001\u0015AB:pkJ\u001cW\rC\u0003N\u0001\u0011\u0005a*\u0001\u0004paRLwN\u001c\u000b\u0004O=\u000b\u0006\"\u0002)M\u0001\u0004\u0001\u0015aA6fs\")!\u000b\u0014a\u0001\u0001\u0006)a/\u00197vK\")Q\n\u0001C\u0001)R\u0019q%\u0016,\t\u000bA\u001b\u0006\u0019\u0001!\t\u000bI\u001b\u0006\u0019A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:DQ!\u0014\u0001\u0005\u0002m#2a\n/^\u0011\u0015\u0001&\f1\u0001A\u0011\u0015\u0011&\f1\u0001_!\tqq,\u0003\u0002a\u001f\t!Aj\u001c8h\u0011\u0015i\u0005\u0001\"\u0001c)\r93\r\u001a\u0005\u0006!\u0006\u0004\r\u0001\u0011\u0005\u0006%\u0006\u0004\r!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\r\u0011{WO\u00197f\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u001dy\u0007\u000f^5p]N$\"aJ6\t\u000b%D\u0007\u0019\u00017\u0011\t5\u0004\b\tQ\u0007\u0002]*\u0011qnD\u0001\u000bG>dG.Z2uS>t\u0017BA9o\u0005\ri\u0015\r\u001d\u0005\u0006S\u0002!\ta\u001d\u000b\u0003OQDQ!\u001b:A\u0002U\u0004BA^>A\u00016\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!!]<\t\u000bu\u0004A\u0011\u0001@\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0003O}Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\u0005d_2t\u0015-\\3t!\u0011q\u0011Q\u0001!\n\u0007\u0005\u001dqB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3\u0001`A\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0011q\u0002\u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0001BY;dW\u0016$()\u001f\u000b\bO\u0005u\u0011qEA\u0016\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012A\u00038v[\n+8m[3ugB\u0019a\"a\t\n\u0007\u0005\u0015rBA\u0002J]RDq!!\u000b\u0002\u0018\u0001\u0007\u0001)A\u0004d_2t\u0015-\\3\t\u0011\u0005\u0005\u0011q\u0003a\u0001\u0003\u0007AC!a\u0006\u0002\f!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012AB:peR\u0014\u0015\u0010F\u0003(\u0003k\t9\u0004C\u0004\u0002*\u0005=\u0002\u0019\u0001!\t\u0011\u0005\u0005\u0011q\u0006a\u0001\u0003\u0007AC!a\f\u0002\f!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001B:bm\u0016$B!!\u0011\u0002HA\u0019a\"a\u0011\n\u0007\u0005\u0015sB\u0001\u0003V]&$\bbBA%\u0003w\u0001\r\u0001Q\u0001\u0005a\u0006$\b\u000eC\u0004\u0002>\u0001!\t!!\u0014\u0015\u0005\u0005\u0005\u0003bBA)\u0001\u0011\u0005\u00111K\u0001\u000bS:\u001cXM\u001d;J]R|G\u0003BA!\u0003+Bq!a\u0016\u0002P\u0001\u0007\u0001)A\u0005uC\ndWMT1nK\"9\u0011\u0011\u000b\u0001\u0005\n\u0005mC\u0003BA!\u0003;B\u0001\"a\u0018\u0002Z\u0001\u0007\u0011\u0011M\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d$!\u0001\u0005dCR\fG._:u\u0013\u0011\tY'!\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJDq!a\u001c\u0001\t\u0013\t\t(A\to_Jl\u0017\r\\5{K\u0012\u0004\u0016M]\"pYN,\"!a\u001d\u0011\u000b9\t)(!\u001f\n\u0007\u0005]tB\u0001\u0004PaRLwN\u001c\t\u0006\u0003w\nI\t\u0011\b\u0005\u0003{\n9I\u0004\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019IC\u0001\u0007yI|w\u000e\u001e \n\u0003AI!aL\b\n\t\u0005-\u0015Q\u0012\u0002\u0004'\u0016\f(BA\u0018\u0010\u0011\u001d\t\t\n\u0001C\u0005\u0003c\n\u0001D\\8s[\u0006d\u0017N_3e\u0005V\u001c7.\u001a;D_2t\u0015-\\3t\u0011\u001d\t)\n\u0001C\u0005\u0003c\naC\\8s[\u0006d\u0017N_3e'>\u0014HoQ8m\u001d\u0006lWm\u001d\u0005\b\u00033\u0003A\u0011BAN\u000359W\r\u001e\"vG.,Go\u00159fGV\u0011\u0011Q\u0014\t\u0006\u001d\u0005U\u0014q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*!\u0011QUA3\u0003\u001d\u0019\u0017\r^1m_\u001eLA!!+\u0002$\nQ!)^2lKR\u001c\u0006/Z2\t\u000f\u00055\u0006\u0001\"\u0003\u00020\u0006Ian\u001c:nC2L'0\u001a\u000b\u0006\u0001\u0006E\u0016Q\u0017\u0005\b\u0003g\u000bY\u000b1\u0001A\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\b\u0003o\u000bY\u000b1\u0001A\u0003)\u0019w\u000e\\;n]RK\b/\u001a\u0005\b\u0003w\u0003A\u0011BA_\u0003E\t7o]3si:{GOQ;dW\u0016$X\r\u001a\u000b\u0005\u0003\u0003\ny\fC\u0004\u0002B\u0006e\u0006\u0019\u0001!\u0002\u0013=\u0004XM]1uS>t\u0007bBAc\u0001\u0011%\u0011qY\u0001\u0015CN\u001cXM\u001d;O_R\u0004\u0016M\u001d;ji&|g.\u001a3\u0015\t\u0005\u0005\u0013\u0011\u001a\u0005\b\u0003\u0003\f\u0019\r1\u0001A\u0011\u001d\ti\r\u0001C\u0001\u0003\u001f\f1b]1wK\u0006\u001bH+\u00192mKR!\u0011\u0011IAi\u0011\u001d\t9&a3A\u0002\u0001Cq!!4\u0001\t\u0013\t)\u000e\u0006\u0003\u0002B\u0005]\u0007\u0002CA0\u0003'\u0004\r!!\u0019\t\u000f\u0005m\u0007\u0001\"\u0001\u0002^\u0006!!\u000e\u001a2d)!\t\t%a8\u0002d\u0006\u001d\bbBAq\u00033\u0004\r\u0001Q\u0001\u0004kJd\u0007bBAs\u00033\u0004\r\u0001Q\u0001\u0006i\u0006\u0014G.\u001a\u0005\t\u0003S\fI\u000e1\u0001\u0002l\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u00042A^Aw\u0013\r\tyo\u001e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAz\u0001\u0011\u0005\u0011Q_\u0001\u0005UN|g\u000e\u0006\u0003\u0002B\u0005]\bbBA%\u0003c\u0004\r\u0001\u0011\u0005\b\u0003w\u0004A\u0011AA\u007f\u0003\u001d\u0001\u0018M]9vKR$B!!\u0011\u0002\u0000\"9\u0011\u0011JA}\u0001\u0004\u0001\u0005b\u0002B\u0002\u0001\u0011\u0005!QA\u0001\u0004_J\u001cG\u0003BA!\u0005\u000fAq!!\u0013\u0003\u0002\u0001\u0007\u0001\tC\u0004\u0003\f\u0001!\tA!\u0004\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003\u0003\u0012y\u0001C\u0004\u0002J\t%\u0001\u0019\u0001!\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016\u0005\u00191m\u001d<\u0015\t\u0005\u0005#q\u0003\u0005\b\u0003\u0013\u0012\t\u00021\u0001A\u0011!Y\u0005\u00011A\u0005\n\tmQ#\u0001!\t\u0013\t}\u0001\u00011A\u0005\n\t\u0005\u0012AC:pkJ\u001cWm\u0018\u0013fcR!\u0011\u0011\tB\u0012\u0011%\u0011)C!\b\u0002\u0002\u0003\u0007\u0001)A\u0002yIEBqA!\u000b\u0001A\u0003&\u0001)A\u0004t_V\u00148-\u001a\u0011\t\u0011Y\u0002\u0001\u0019!C\u0005\u0005[)\u0012A\u000f\u0005\n\u0005c\u0001\u0001\u0019!C\u0005\u0005g\t\u0001\"\\8eK~#S-\u001d\u000b\u0005\u0003\u0003\u0012)\u0004C\u0005\u0003&\t=\u0012\u0011!a\u0001u!9!\u0011\b\u0001!B\u0013Q\u0014!B7pI\u0016\u0004\u0003\"\u0003B\u001f\u0001\u0001\u0007I\u0011\u0002B \u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t+\t\u0011\t\u0005\u0005\u0004\u0003D\t%\u0003\tQ\u0007\u0003\u0005\u000bR1Aa\u0012o\u0003\u001diW\u000f^1cY\u0016LAAa\u0013\u0003F\t9\u0001*Y:i\u001b\u0006\u0004\b\"\u0003B(\u0001\u0001\u0007I\u0011\u0002B)\u0003A)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002B\tM\u0003B\u0003B\u0013\u0005\u001b\n\t\u00111\u0001\u0003B!A!q\u000b\u0001!B\u0013\u0011\t%A\u0007fqR\u0014\u0018m\u00149uS>t7\u000f\t\u0005\n\u00057\u0002\u0001\u0019!C\u0005\u0003c\n1\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]ND\u0011Ba\u0018\u0001\u0001\u0004%IA!\u0019\u0002/A\f'\u000f^5uS>t\u0017N\\4D_2,XN\\:`I\u0015\fH\u0003BA!\u0005GB!B!\n\u0003^\u0005\u0005\t\u0019AA:\u0011!\u00119\u0007\u0001Q!\n\u0005M\u0014\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b\u0005C\u0005\u0003l\u0001\u0001\r\u0011\"\u0003\u0002r\u0005\t\"-^2lKR\u001cu\u000e\\;n]:\u000bW.Z:\t\u0013\t=\u0004\u00011A\u0005\n\tE\u0014!\u00062vG.,GoQ8mk6tg*Y7fg~#S-\u001d\u000b\u0005\u0003\u0003\u0012\u0019\b\u0003\u0006\u0003&\t5\u0014\u0011!a\u0001\u0003gB\u0001Ba\u001e\u0001A\u0003&\u00111O\u0001\u0013EV\u001c7.\u001a;D_2,XN\u001c(b[\u0016\u001c\b\u0005C\u0005\u0002 \u0001\u0001\r\u0011\"\u0003\u0003|U\u0011!Q\u0010\t\u0006\u001d\u0005U\u0014\u0011\u0005\u0005\n\u0005\u0003\u0003\u0001\u0019!C\u0005\u0005\u0007\u000baB\\;n\u0005V\u001c7.\u001a;t?\u0012*\u0017\u000f\u0006\u0003\u0002B\t\u0015\u0005B\u0003B\u0013\u0005\u007f\n\t\u00111\u0001\u0003~!A!\u0011\u0012\u0001!B\u0013\u0011i(A\u0006ok6\u0014UoY6fiN\u0004\u0003\"\u0003BG\u0001\u0001\u0007I\u0011BA9\u0003=\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\b\"\u0003BI\u0001\u0001\u0007I\u0011\u0002BJ\u0003M\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001cx\fJ3r)\u0011\t\tE!&\t\u0015\t\u0015\"qRA\u0001\u0002\u0004\t\u0019\b\u0003\u0005\u0003\u001a\u0002\u0001\u000b\u0015BA:\u0003A\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\b\u0005K\u0002\u0001\u0005;\u0003BAa(\u0003*:!!\u0011\u0015BS\u001b\t\u0011\u0019KC\u0002\u0002\u0012\u0011IAAa*\u0003$\u0006\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u0011YK!,\u0003\rM#\u0018M\u00197f\u0015\u0011\u00119Ka)")
public final class DataFrameWriter<T> {
    private final Dataset<Row> org$apache$spark$sql$DataFrameWriter$$df;
    private String source;
    private SaveMode mode;
    private HashMap<String, String> extraOptions;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$partitioningColumns;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> org$apache$spark$sql$DataFrameWriter$$df() {
        return this.org$apache$spark$sql$DataFrameWriter$$df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        block6: {
            SaveMode saveMode2;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = saveMode.toLowerCase();
                            if (!"overwrite".equals(string)) break block2;
                            saveMode2 = SaveMode.Overwrite;
                            break block3;
                        }
                        if (!"append".equals(string)) break block4;
                        saveMode2 = SaveMode.Append;
                        break block3;
                    }
                    if (!"ignore".equals(string)) break block5;
                    saveMode2 = SaveMode.Ignore;
                    break block3;
                }
                boolean bl = "error".equals(string) ? true : "default".equals(string);
                if (!bl) break block6;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted save modes are 'overwrite', 'append', 'ignore', 'error'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        this.assertNotBucketed("save");
        SparkSession x$8 = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession();
        String x$9 = this.source();
        Seq x$10 = (Seq)this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Option<BucketSpec> x$11 = this.getBucketSpec();
        scala.collection.immutable.Map x$12 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$13 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$14 = DataSource$.MODULE$.apply$default$4();
        Option<CatalogTable> x$15 = DataSource$.MODULE$.apply$default$8();
        DataSource dataSource = new DataSource(x$8, x$9, x$13, x$14, (Seq<String>)x$10, x$11, (scala.collection.immutable.Map<String, String>)x$12, x$15);
        dataSource.write(this.mode(), this.org$apache$spark$sql$DataFrameWriter$$df());
    }

    public void insertInto(String tableName) {
        this.insertInto(this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already be defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().executePlan((LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2()), Predef$.MODULE$.Map().empty(), this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan(), new OverwriteOptions(!(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), OverwriteOptions$.MODULE$.apply$default$2()), false)).toRdd();
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedParCols() {
        return this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedParCols$1 $outer;

                    public final String apply(String x$3) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$3, "Partition");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames$1 $outer;

                    public final String apply(String x$4) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$4, "Bucketing");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames() {
        return this.sortColumnNames().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames$1 $outer;

                    public final String apply(String x$5) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$5, "Sorting");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined()) {
            Predef$.MODULE$.require(this.numBuckets().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "sortBy must be used together with bucketBy";
                }
            });
        }
        return this.numBuckets().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final BucketSpec apply(int n) {
                Predef$.MODULE$.require(n > 0 && n < 100000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Bucket number must be greater than 0 and less than 100000.";
                    }
                });
                if (this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedParCols().nonEmpty() && ((TraversableOnce)((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames().get()).toSet().intersect((GenSet)((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedParCols().get()).toSet())).nonEmpty()) {
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketBy columns '", "' should not be part of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().get()).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionBy columns '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().get()).mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                return new BucketSpec(n, (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames().get(), (Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String org$apache$spark$sql$DataFrameWriter$$normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan().output().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$6) {
                return x$6.name();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (String)validColumnNames.find((Function1)new Serializable(this, columnName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;
            private final String columnName$1;

            public final boolean apply(String x$7) {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$7, (Object)this.columnName$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }).getOrElse((Function0)new Serializable(this, columnName, columnType, validColumnNames){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final String columnType$1;
            private final Seq validColumnNames$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column ", " not found in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnType$1, this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"existing columns (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.validColumnNames$1.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                void var4_4;
                void var3_3;
                this.columnName$1 = columnName$1;
                this.columnType$1 = var3_3;
                this.validColumnNames$1 = var4_4;
            }
        });
    }

    private void assertNotBucketed(String operation) {
        if (this.numBuckets().isDefined() || this.sortColumnNames().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support bucketing right now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support partitioning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage;
        String string = this.source().toLowerCase();
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (string == null) {
            if (string2 == null) throw new AnalysisException("Cannot create hive serde table with saveAsTable API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        } else if (string.equals(string2)) {
            throw new AnalysisException("Cannot create hive serde table with saveAsTable API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        boolean tableExists2 = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().catalog().tableExists(tableIdent);
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists2), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdent})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        None$ existingTable = tableExists2 ? new Some((Object)this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().catalog().getTableMetadata(tableIdent)) : None$.MODULE$;
        CatalogStorageFormat catalogStorageFormat = storage = tableExists2 ? ((CatalogTable)existingTable.get()).storage() : DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = tableExists2 ? ((CatalogTable)existingTable.get()).tableType() : (storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED());
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        }), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17());
        this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().executePlan((LogicalPlan)new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan()))).toRdd();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions_$eq((HashMap<String, String>)((HashMap)this.extraOptions().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala(), HashMap$.MODULE$.canBuildFrom())));
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$partitioningColumns() {
        return this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns;
    }

    private void org$apache$spark$sql$DataFrameWriter$$partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.org$apache$spark$sql$DataFrameWriter$$df = ds.toDF();
        this.source = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

