/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.ProgressReporter;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StateStoreSaveExec;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class ProgressReporter$class {
    public static StreamingQueryStatus status(ProgressReporter $this) {
        return $this.currentStatus();
    }

    public static StreamingQueryProgress[] recentProgress(ProgressReporter $this) {
        Queue<StreamingQueryProgress> queue = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            Object object = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
            return (StreamingQueryProgress[])object;
        }
    }

    public static StreamingQueryProgress lastProgress(ProgressReporter $this) {
        Queue<StreamingQueryProgress> queue = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            Object object = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
            return (StreamingQueryProgress)object;
        }
    }

    public static void startTrigger(ProgressReporter $this) {
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting Trigger Calculation";
            }
        });
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq($this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq($this.triggerClock().getTimeMillis());
        StreamingQueryStatus qual$1 = $this.currentStatus();
        boolean x$9 = true;
        String x$10 = qual$1.copy$default$1();
        boolean x$11 = qual$1.copy$default$2();
        $this.currentStatus_$eq(qual$1.copy(x$10, x$11, x$9));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateProgress(ProgressReporter $this, StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while ($this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= $this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : queue
            $this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        }
        $this.logInfo((Function0)new Serializable($this, newProgress){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryProgress newProgress$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming query made progress: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newProgress$1}));
            }
            {
                this.newProgress$1 = newProgress$1;
            }
        });
    }

    public static void finishTrigger(ProgressReporter $this, boolean hasNewData) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq($this.triggerClock().getTimeMillis());
        ProgressReporter.ExecutionStats executionStats = ProgressReporter$class.extractExecutionStats($this, hasNewData);
        double processingTimeSec = (double)($this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()) / (double)1000;
        double inputTimeSec = $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)($this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000 : Double.NaN;
        $this.logDebug((Function0)new Serializable($this, executionStats){
            public static final long serialVersionUID = 0L;
            private final ProgressReporter.ExecutionStats executionStats$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Execution stats: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.executionStats$1}));
            }
            {
                this.executionStats$1 = executionStats$1;
            }
        });
        Seq sourceProgress = (Seq)$this.sources().map((Function1)new Serializable($this, executionStats, processingTimeSec, inputTimeSec){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;
            private final ProgressReporter.ExecutionStats executionStats$1;
            private final double processingTimeSec$1;
            private final double inputTimeSec$1;

            public final SourceProgress apply(Source source) {
                long numRecords = BoxesRunTime.unboxToLong((Object)this.executionStats$1.inputRows().getOrElse((Object)source, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                }));
                return new SourceProgress(source.toString(), (String)this.$outer.committedOffsets().get(source).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Offset x$1) {
                        return x$1.json();
                    }
                }).orNull(Predef$.MODULE$.$conforms()), (String)this.$outer.availableOffsets().get(source).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Offset x$2) {
                        return x$2.json();
                    }
                }).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / this.inputTimeSec$1, (double)numRecords / this.processingTimeSec$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.executionStats$1 = executionStats$1;
                this.processingTimeSec$1 = processingTimeSec$1;
                this.inputTimeSec$1 = inputTimeSec$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        SinkProgress sinkProgress = new SinkProgress($this.sink().toString());
        StreamingQueryProgress newProgress = new StreamingQueryProgress($this.id(), $this.runId(), $this.name(), ProgressReporter$class.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp($this, $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), $this.currentBatchId(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)$this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Long apply(long x) {
                return Predef$.MODULE$.long2Long(x);
            }
        })).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava(), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress);
        if (hasNewData) {
            $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
            ProgressReporter$class.updateProgress($this, newProgress);
        } else {
            long now = $this.triggerClock().getTimeMillis();
            if (now - $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime()) {
                $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(now);
                ProgressReporter$class.updateProgress($this, newProgress);
            }
        }
        StreamingQueryStatus qual$2 = $this.currentStatus();
        boolean x$12 = false;
        String x$13 = qual$2.copy$default$1();
        boolean x$14 = qual$2.copy$default$2();
        $this.currentStatus_$eq(qual$2.copy(x$13, x$14, x$12));
    }

    /*
     * WARNING - void declaration
     */
    private static ProgressReporter.ExecutionStats extractExecutionStats(ProgressReporter $this, boolean hasNewData) {
        void var2_2;
        scala.collection.immutable.Map watermarkTimestamp = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)ProgressReporter$class.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp($this, $this.offsetSeqMetadata().batchWatermarkMs()))}));
        if (hasNewData) {
            scala.collection.immutable.Map map2;
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)$this.newData().flatMap((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Seq<Tuple2<LogicalPlan, Source>> apply(Tuple2<Source, Dataset<Row>> x0$1) {
                    Tuple2<Source, Dataset<Row>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Source source = (Source)tuple2._1();
                        Dataset df = (Dataset)tuple2._2();
                        Seq seq = (Seq)df.logicalPlan().collectLeaves().map((Function1)new Serializable(this, source){
                            public static final long serialVersionUID = 0L;
                            private final Source source$1;

                            public final Tuple2<LogicalPlan, Source> apply(LogicalPlan leaf) {
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaf), (Object)this.source$1);
                            }
                            {
                                this.source$1 = source$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
            }, Map$.MODULE$.canBuildFrom());
            Seq allLogicalPlanLeaves = $this.lastExecution().logical().collectLeaves();
            Seq allExecPlanLeaves = $this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable($this, logicalPlanLeafToSource){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map logicalPlanLeafToSource$1;

                    public final Iterable<Tuple2<SparkPlan, Source>> apply(Tuple2<LogicalPlan, SparkPlan> x0$2) {
                        Tuple2<LogicalPlan, SparkPlan> tuple2 = x0$2;
                        if (tuple2 != null) {
                            LogicalPlan lp = (LogicalPlan)tuple2._1();
                            SparkPlan ep = (SparkPlan)((Object)tuple2._2());
                            Iterable iterable = Option$.MODULE$.option2Iterable(this.logicalPlanLeafToSource$1.get((Object)lp).map((Function1)new Serializable(this, ep){
                                public static final long serialVersionUID = 0L;
                                private final SparkPlan ep$1;

                                public final Tuple2<SparkPlan, Source> apply(Source source) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)this.ep$1)), (Object)source);
                                }
                                {
                                    this.ep$1 = ep$1;
                                }
                            }));
                            return iterable;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.logicalPlanLeafToSource$1 = logicalPlanLeafToSource$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToNumInputRows = (Seq)execLeafToSource.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Source, Object> apply(Tuple2<SparkPlan, Source> x0$3) {
                        Tuple2<SparkPlan, Source> tuple2 = x0$3;
                        if (tuple2 != null) {
                            SparkPlan execLeaf = (SparkPlan)((Object)tuple2._1());
                            Source source = (Source)tuple2._2();
                            long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(SQLMetric x$3) {
                                    return x$3.value();
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply() {
                                    return this.apply$mcJ$sp();
                                }

                                public long apply$mcJ$sp() {
                                    return 0L;
                                }
                            }));
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                map2 = sourceToNumInputRows.groupBy((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final Source apply(Tuple2<Source, Object> x$4) {
                        return (Source)x$4._1();
                    }
                }).mapValues((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Seq<Tuple2<Source, Object>> x$5) {
                        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$5.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Tuple2<Source, Object> x$6) {
                                return x$6._2$mcJ$sp();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    }
                });
            } else {
                if (!$this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) {
                    $this.logWarning((Function0)new Serializable($this, allLogicalPlanLeaves, allExecPlanLeaves){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ProgressReporter $outer;
                        private final Seq allLogicalPlanLeaves$1;
                        private final Seq allExecPlanLeaves$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Could not report metrics as number leaves in trigger logical plan did not match that").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of the execution plan:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"logical plan leaves: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ProgressReporter$class.toString$1(this.$outer, this.allLogicalPlanLeaves$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"execution plan leaves: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ProgressReporter$class.toString$1(this.$outer, this.allExecPlanLeaves$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.allLogicalPlanLeaves$1 = allLogicalPlanLeaves$1;
                            this.allExecPlanLeaves$1 = allExecPlanLeaves$1;
                        }
                    });
                    $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
                }
                map2 = Predef$.MODULE$.Map().empty();
            }
            scala.collection.immutable.Map numInputRows2 = map2;
            Seq stateNodes = $this.lastExecution().executedPlan().collect((PartialFunction)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = A1 instanceof StateStoreSaveExec ? A1 : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof StateStoreSaveExec;
                    return bl;
                }
            });
            Seq stateOperators = (Seq)stateNodes.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final StateOperatorProgress apply(SparkPlan node) {
                    return new StateOperatorProgress(BoxesRunTime.unboxToLong((Object)node.metrics().get((Object)"numTotalStateRows").map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(SQLMetric x$7) {
                            return x$7.value();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    })), BoxesRunTime.unboxToLong((Object)node.metrics().get((Object)"numUpdatedStateRows").map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(SQLMetric x$8) {
                            return x$8.value();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    })));
                }
            }, Seq$.MODULE$.canBuildFrom());
            scala.collection.immutable.Map eventTimeStats = ((MapLike)$this.lastExecution().executedPlan().collect((PartialFunction)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProgressReporter $outer;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    EventTimeWatermarkExec eventTimeWatermarkExec;
                    A1 A1 = x2;
                    if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                        EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                        object = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)stats.avg()))}))).mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ProgressReporter$.anonfun.5 $outer;

                            public final String apply(long millis) {
                                return ProgressReporter$class.org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(this.$outer.org$apache$spark$sql$execution$streaming$ProgressReporter$$anonfun$$$outer(), millis);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x2) {
                    EventTimeWatermarkExec eventTimeWatermarkExec;
                    SparkPlan sparkPlan = x2;
                    boolean bl = sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
                    return bl;
                }

                public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).headOption().getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<String, Nothing$> apply() {
                    return Predef$.MODULE$.Map().empty();
                }
            })).$plus$plus((GenTraversableOnce)watermarkTimestamp);
            return new ProgressReporter.ExecutionStats($this, (scala.collection.immutable.Map<Source, Object>)numInputRows2, (Seq<StateOperatorProgress>)stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
        }
        return new ProgressReporter.ExecutionStats($this, (scala.collection.immutable.Map<Source, Object>)Predef$.MODULE$.Map().empty(), (Seq<StateOperatorProgress>)((Seq)Seq$.MODULE$.empty()), (scala.collection.immutable.Map<String, String>)var2_2);
    }

    public static Object reportTimeTaken(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        long startTime = $this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = $this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)$this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        $this.logDebug((Function0)new Serializable($this, timeTaken, triggerDetailKey){
            public static final long serialVersionUID = 0L;
            private final long timeTaken$1;
            private final String triggerDetailKey$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " took ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.triggerDetailKey$1, BoxesRunTime.boxToLong((long)this.timeTaken$1)}));
            }
            {
                this.timeTaken$1 = timeTaken$1;
                this.triggerDetailKey$1 = triggerDetailKey$1;
            }
        });
        return result;
    }

    public static String org$apache$spark$sql$execution$streaming$ProgressReporter$$formatTimestamp(ProgressReporter $this, long millis) {
        return $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static void updateStatusMessage(ProgressReporter $this, String message) {
        StreamingQueryStatus qual$3 = $this.currentStatus();
        String x$15 = message;
        boolean x$16 = qual$3.copy$default$2();
        boolean x$17 = qual$3.copy$default$3();
        $this.currentStatus_$eq(qual$3.copy(x$15, x$16, x$17));
    }

    public static final String toString$1(ProgressReporter $this, Seq seq) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(size = ", "), ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)seq.size()), seq.mkString(", ")}));
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(new HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoDataProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(TimeZone.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }
}

