/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedPlainValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedRleValuesReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedValuesReader;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;

public class VectorizedColumnReader {
    private long valuesRead;
    private long endOfPageValueCount;
    private final Dictionary dictionary;
    private boolean isCurrentPageDictionaryEncoded;
    private final int maxDefLevel;
    private SpecificParquetRecordReaderBase.IntIterator repetitionLevelColumn;
    private SpecificParquetRecordReaderBase.IntIterator definitionLevelColumn;
    private ValuesReader dataColumn;
    private VectorizedRleValuesReader defColumn;
    private final long totalValueCount;
    private int pageValueCount;
    private final PageReader pageReader;
    private final ColumnDescriptor descriptor;

    public VectorizedColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
        this.descriptor = descriptor;
        this.pageReader = pageReader;
        this.maxDefLevel = descriptor.getMaxDefinitionLevel();
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                this.isCurrentPageDictionaryEncoded = true;
            }
            catch (IOException e) {
                throw new IOException("could not decode the dictionary for " + descriptor, e);
            }
        } else {
            this.dictionary = null;
            this.isCurrentPageDictionaryEncoded = false;
        }
        this.totalValueCount = pageReader.getTotalValueCount();
        if (this.totalValueCount == 0L) {
            throw new IOException("totalValueCount == 0");
        }
    }

    private boolean next() throws IOException {
        if (this.valuesRead >= this.endOfPageValueCount) {
            if (this.valuesRead >= this.totalValueCount) {
                return false;
            }
            this.readPage();
        }
        ++this.valuesRead;
        return this.definitionLevelColumn.nextInt() == this.maxDefLevel;
    }

    void readBatch(int total, ColumnVector column) throws IOException {
        int rowId = 0;
        ColumnVector dictionaryIds = null;
        if (this.dictionary != null) {
            dictionaryIds = column.reserveDictionaryIds(total);
        }
        while (total > 0) {
            int leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            if (leftInPage == 0) {
                this.readPage();
                leftInPage = (int)(this.endOfPageValueCount - this.valuesRead);
            }
            int num = Math.min(total, leftInPage);
            if (this.isCurrentPageDictionaryEncoded) {
                this.defColumn.readIntegers(num, dictionaryIds, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
                if (column.hasDictionary() || rowId == 0 && (this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32 || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64 || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.FLOAT || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.DOUBLE || this.descriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY)) {
                    column.setDictionary(this.dictionary);
                } else {
                    this.decodeDictionaryIds(rowId, num, column, dictionaryIds);
                }
            } else {
                if (column.hasDictionary() && rowId != 0) {
                    this.decodeDictionaryIds(0, rowId, column, column.getDictionaryIds());
                }
                column.setDictionary(null);
                switch (this.descriptor.getType()) {
                    case BOOLEAN: {
                        this.readBooleanBatch(rowId, num, column);
                        break;
                    }
                    case INT32: {
                        this.readIntBatch(rowId, num, column);
                        break;
                    }
                    case INT64: {
                        this.readLongBatch(rowId, num, column);
                        break;
                    }
                    case INT96: {
                        this.readBinaryBatch(rowId, num, column);
                        break;
                    }
                    case FLOAT: {
                        this.readFloatBatch(rowId, num, column);
                        break;
                    }
                    case DOUBLE: {
                        this.readDoubleBatch(rowId, num, column);
                        break;
                    }
                    case BINARY: {
                        this.readBinaryBatch(rowId, num, column);
                        break;
                    }
                    case FIXED_LEN_BYTE_ARRAY: {
                        this.readFixedLenByteArrayBatch(rowId, num, column, this.descriptor.getTypeLength());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported type: " + this.descriptor.getType());
                    }
                }
            }
            this.valuesRead += (long)num;
            rowId += num;
            total -= num;
        }
    }

    private void decodeDictionaryIds(int rowId, int num, ColumnVector column, ColumnVector dictionaryIds) {
        switch (this.descriptor.getType()) {
            case INT32: {
                if (column.dataType() == DataTypes.IntegerType || DecimalType.is32BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putInt(i, this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (column.dataType() == DataTypes.ByteType) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putByte(i, (byte)this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                if (column.dataType() == DataTypes.ShortType) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putShort(i, (short)this.dictionary.decodeToInt(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
            }
            case INT64: {
                if (column.dataType() == DataTypes.LongType || DecimalType.is64BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        column.putLong(i, this.dictionary.decodeToLong(dictionaryIds.getDictId(i)));
                    }
                    break;
                }
                throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
            }
            case FLOAT: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    column.putFloat(i, this.dictionary.decodeToFloat(dictionaryIds.getDictId(i)));
                }
                break;
            }
            case DOUBLE: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    column.putDouble(i, this.dictionary.decodeToDouble(dictionaryIds.getDictId(i)));
                }
                break;
            }
            case INT96: {
                if (column.dataType() == DataTypes.TimestampType) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putLong(i, ParquetRowConverter.binaryToSQLTimestamp(v));
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            case BINARY: {
                for (int i = rowId; i < rowId + num; ++i) {
                    if (column.isNullAt(i)) continue;
                    Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                    column.putByteArray(i, v.getBytes());
                }
                break;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                if (DecimalType.is32BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putInt(i, (int)ParquetRowConverter.binaryToUnscaledLong(v));
                    }
                    break;
                }
                if (DecimalType.is64BitDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putLong(i, ParquetRowConverter.binaryToUnscaledLong(v));
                    }
                    break;
                }
                if (DecimalType.isByteArrayDecimalType((DataType)column.dataType())) {
                    for (int i = rowId; i < rowId + num; ++i) {
                        if (column.isNullAt(i)) continue;
                        Binary v = this.dictionary.decodeToBinary(dictionaryIds.getDictId(i));
                        column.putByteArray(i, v.getBytes());
                    }
                    break;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type: " + this.descriptor.getType());
            }
        }
    }

    private void readBooleanBatch(int rowId, int num, ColumnVector column) throws IOException {
        assert (column.dataType() == DataTypes.BooleanType);
        this.defColumn.readBooleans(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readIntBatch(int rowId, int num, ColumnVector column) throws IOException {
        if (column.dataType() == DataTypes.IntegerType || column.dataType() == DataTypes.DateType || DecimalType.is32BitDecimalType((DataType)column.dataType())) {
            this.defColumn.readIntegers(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (column.dataType() == DataTypes.ByteType) {
            this.defColumn.readBytes(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else if (column.dataType() == DataTypes.ShortType) {
            this.defColumn.readShorts(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
        } else {
            throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
        }
    }

    private void readLongBatch(int rowId, int num, ColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.LongType && !DecimalType.is64BitDecimalType((DataType)column.dataType())) {
            throw new UnsupportedOperationException("Unsupported conversion to: " + column.dataType());
        }
        this.defColumn.readLongs(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readFloatBatch(int rowId, int num, ColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.FloatType) {
            throw new UnsupportedOperationException("Unsupported conversion to: " + column.dataType());
        }
        this.defColumn.readFloats(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readDoubleBatch(int rowId, int num, ColumnVector column) throws IOException {
        if (column.dataType() != DataTypes.DoubleType) {
            throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
        }
        this.defColumn.readDoubles(num, column, rowId, this.maxDefLevel, (VectorizedValuesReader)this.dataColumn);
    }

    private void readBinaryBatch(int rowId, int num, ColumnVector column) throws IOException {
        VectorizedValuesReader data = (VectorizedValuesReader)this.dataColumn;
        if (column.isArray()) {
            this.defColumn.readBinarys(num, column, rowId, this.maxDefLevel, data);
        } else if (column.dataType() == DataTypes.TimestampType) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putLong(rowId + i, ParquetRowConverter.binaryToSQLTimestamp(data.readBinary(12)));
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else {
            throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
        }
    }

    private void readFixedLenByteArrayBatch(int rowId, int num, ColumnVector column, int arrayLen) throws IOException {
        VectorizedValuesReader data = (VectorizedValuesReader)this.dataColumn;
        if (DecimalType.is32BitDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putInt(rowId + i, (int)ParquetRowConverter.binaryToUnscaledLong(data.readBinary(arrayLen)));
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else if (DecimalType.is64BitDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putLong(rowId + i, ParquetRowConverter.binaryToUnscaledLong(data.readBinary(arrayLen)));
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else if (DecimalType.isByteArrayDecimalType((DataType)column.dataType())) {
            for (int i = 0; i < num; ++i) {
                if (this.defColumn.readInteger() == this.maxDefLevel) {
                    column.putByteArray(rowId + i, data.readBinary(arrayLen).getBytes());
                    continue;
                }
                column.putNull(rowId + i);
            }
        } else {
            throw new UnsupportedOperationException("Unimplemented type: " + column.dataType());
        }
    }

    private void readPage() throws IOException {
        DataPage page = this.pageReader.readPage();
        page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

            public Void visit(DataPageV1 dataPageV1) {
                try {
                    VectorizedColumnReader.this.readPageV1(dataPageV1);
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public Void visit(DataPageV2 dataPageV2) {
                try {
                    VectorizedColumnReader.this.readPageV2(dataPageV2);
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void initDataReader(Encoding dataEncoding, byte[] bytes, int offset) throws IOException {
        this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
        if (dataEncoding.usesDictionary()) {
            this.dataColumn = null;
            if (this.dictionary == null) {
                throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
            }
            Encoding plainDict = Encoding.PLAIN_DICTIONARY;
            if (dataEncoding != plainDict && dataEncoding != Encoding.RLE_DICTIONARY) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedRleValuesReader();
            this.isCurrentPageDictionaryEncoded = true;
        } else {
            if (dataEncoding != Encoding.PLAIN) {
                throw new UnsupportedOperationException("Unsupported encoding: " + dataEncoding);
            }
            this.dataColumn = new VectorizedPlainValuesReader();
            this.isCurrentPageDictionaryEncoded = false;
        }
        try {
            this.dataColumn.initFromPage(this.pageValueCount, bytes, offset);
        }
        catch (IOException e) {
            throw new IOException("could not read page in col " + this.descriptor, e);
        }
    }

    private void readPageV1(DataPageV1 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
        if (page.getDlEncoding() != Encoding.RLE && this.descriptor.getMaxDefinitionLevel() != 0) {
            throw new UnsupportedOperationException("Unsupported encoding: " + page.getDlEncoding());
        }
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        VectorizedRleValuesReader dlReader = this.defColumn = new VectorizedRleValuesReader(bitWidth);
        this.repetitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(rlReader);
        this.definitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(dlReader);
        try {
            byte[] bytes = page.getBytes().toByteArray();
            rlReader.initFromPage(this.pageValueCount, bytes, 0);
            int next2 = rlReader.getNextOffset();
            dlReader.initFromPage(this.pageValueCount, bytes, next2);
            next2 = dlReader.getNextOffset();
            this.initDataReader(page.getValueEncoding(), bytes, next2);
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }

    private void readPageV2(DataPageV2 page) throws IOException {
        this.pageValueCount = page.getValueCount();
        this.repetitionLevelColumn = SpecificParquetRecordReaderBase.createRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels(), this.descriptor);
        int bitWidth = BytesUtils.getWidthFromMaxInt((int)this.descriptor.getMaxDefinitionLevel());
        this.defColumn = new VectorizedRleValuesReader(bitWidth);
        this.definitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(this.defColumn);
        this.defColumn.initFromBuffer(this.pageValueCount, page.getDefinitionLevels().toByteArray());
        try {
            this.initDataReader(page.getDataEncoding(), page.getData().toByteArray(), 0);
        }
        catch (IOException e) {
            throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
        }
    }
}

