/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.streaming.ForeachSink;
import org.apache.spark.sql.execution.streaming.MemoryPlan;
import org.apache.spark.sql.execution.streaming.MemorySink;
import org.apache.spark.sql.streaming.DataStreamWriter$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Experimental
@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u00055\u0011\u0001\u0003R1uCN#(/Z1n/JLG/\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tqQd\u0005\u0002\u0001\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001aD\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0003IN\u00042\u0001G\r\u001c\u001b\u0005!\u0011B\u0001\u000e\u0005\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001H\u000f\r\u0001\u0011)a\u0004\u0001b\u0001?\t\tA+\u0005\u0002!GA\u0011\u0001#I\u0005\u0003EE\u0011qAT8uQ&tw\r\u0005\u0002\u0011I%\u0011Q%\u0005\u0002\u0004\u0003:L\bBB\u0014\u0001\t\u0003!\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u00022A\u000b\u0001\u001c\u001b\u0005\u0011\u0001\"\u0002\f'\u0001\u00049\u0002bB\u0017\u0001\u0005\u0004%IAL\u0001\u0003I\u001a,\u0012a\f\t\u0003aMr!\u0001G\u0019\n\u0005I\"\u0011a\u00029bG.\fw-Z\u0005\u0003iU\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005I\"\u0001BB\u001c\u0001A\u0003%q&A\u0002eM\u0002BQ!\u000f\u0001\u0005\u0002i\n!b\\;uaV$Xj\u001c3f)\tI3\bC\u0003:q\u0001\u0007A\b\u0005\u0002+{%\u0011aH\u0001\u0002\u000b\u001fV$\b/\u001e;N_\u0012,\u0007\"B\u001d\u0001\t\u0003\u0001ECA\u0015B\u0011\u0015It\b1\u0001C!\t\u0019eI\u0004\u0002\u0011\t&\u0011Q)E\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F#!)!\n\u0001C\u0001\u0017\u00069AO]5hO\u0016\u0014HCA\u0015M\u0011\u0015Q\u0015\n1\u0001N!\tQc*\u0003\u0002P\u0005\t9AK]5hO\u0016\u0014\b\"B)\u0001\t\u0003\u0011\u0016!C9vKJLh*Y7f)\tI3\u000bC\u0003R!\u0002\u0007!\tC\u0003V\u0001\u0011\u0005a+\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003S]CQ\u0001\u0017+A\u0002\t\u000baa]8ve\u000e,\u0007\"\u0002.\u0001\t\u0003Y\u0016a\u00039beRLG/[8o\u0005f$\"!\u000b/\t\u000buK\u0006\u0019\u00010\u0002\u0011\r|GNT1nKN\u00042\u0001E0C\u0013\t\u0001\u0017C\u0001\u0006=e\u0016\u0004X-\u0019;fIzB#!\u00172\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\f\u0012AC1o]>$\u0018\r^5p]&\u0011q\r\u001a\u0002\bm\u0006\u0014\u0018M]4t\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0019y\u0007\u000f^5p]R\u0019\u0011f[7\t\u000b1D\u0007\u0019\u0001\"\u0002\u0007-,\u0017\u0010C\u0003oQ\u0002\u0007!)A\u0003wC2,X\rC\u0003j\u0001\u0011\u0005\u0001\u000fF\u0002*cJDQ\u0001\\8A\u0002\tCQA\\8A\u0002M\u0004\"\u0001\u0005;\n\u0005U\f\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006S\u0002!\ta\u001e\u000b\u0004SaL\b\"\u00027w\u0001\u0004\u0011\u0005\"\u00028w\u0001\u0004Q\bC\u0001\t|\u0013\ta\u0018C\u0001\u0003M_:<\u0007\"B5\u0001\t\u0003qH\u0003B\u0015\u0000\u0003\u0003AQ\u0001\\?A\u0002\tCaA\\?A\u0002\u0005\r\u0001c\u0001\t\u0002\u0006%\u0019\u0011qA\t\u0003\r\u0011{WO\u00197f\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tqa\u001c9uS>t7\u000fF\u0002*\u0003\u001fA\u0001\"a\u0003\u0002\n\u0001\u0007\u0011\u0011\u0003\t\u0007\u0003'\tIB\u0011\"\u000e\u0005\u0005U!bAA\f#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0011Q\u0003\u0002\u0004\u001b\u0006\u0004\bbBA\u0006\u0001\u0011\u0005\u0011q\u0004\u000b\u0004S\u0005\u0005\u0002\u0002CA\u0006\u0003;\u0001\r!a\t\u0011\r\u0005\u0015\u0012q\u0006\"C\u001b\t\t9C\u0003\u0003\u0002*\u0005-\u0012\u0001B;uS2T!!!\f\u0002\t)\fg/Y\u0005\u0005\u00037\t9\u0003C\u0004\u00024\u0001!\t!!\u000e\u0002\u000bM$\u0018M\u001d;\u0015\t\u0005]\u0012Q\b\t\u0004U\u0005e\u0012bAA\u001e\u0005\tq1\u000b\u001e:fC6LgnZ)vKJL\bbBA \u0003c\u0001\rAQ\u0001\u0005a\u0006$\b\u000eC\u0004\u00024\u0001!\t!a\u0011\u0015\u0005\u0005]\u0002bBA$\u0001\u0011\u0005\u0011\u0011J\u0001\bM>\u0014X-Y2i)\rI\u00131\n\u0005\t\u0003\u001b\n)\u00051\u0001\u0002P\u00051qO]5uKJ\u0004B\u0001GA)7%\u0019\u00111\u000b\u0003\u0003\u001b\u0019{'/Z1dQ^\u0013\u0018\u000e^3s\u0011\u001d\t9\u0006\u0001C\u0005\u00033\n\u0011C\\8s[\u0006d\u0017N_3e!\u0006\u00148i\u001c7t+\t\tY\u0006E\u0003\u0011\u0003;\n\t'C\u0002\u0002`E\u0011aa\u00149uS>t\u0007#BA2\u0003c\u0012e\u0002BA3\u0003_rA!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003Wb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t\u0011\u0014#\u0003\u0003\u0002t\u0005U$aA*fc*\u0011!'\u0005\u0005\b\u0003s\u0002A\u0011BA>\u0003%qwN]7bY&TX\rF\u0003C\u0003{\n\t\tC\u0004\u0002\u0000\u0005]\u0004\u0019\u0001\"\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u0002\u0004\u0006]\u0004\u0019\u0001\"\u0002\u0015\r|G.^7o)f\u0004X\rC\u0004\u0002\b\u0002!I!!#\u0002)\u0005\u001c8/\u001a:u\u001d>$\b+\u0019:uSRLwN\\3e)\u0011\tY)!%\u0011\u0007A\ti)C\u0002\u0002\u0010F\u0011A!\u00168ji\"9\u00111SAC\u0001\u0004\u0011\u0015!C8qKJ\fG/[8o\u0011!A\u0006\u00011A\u0005\n\u0005]U#\u0001\"\t\u0013\u0005m\u0005\u00011A\u0005\n\u0005u\u0015AC:pkJ\u001cWm\u0018\u0013fcR!\u00111RAP\u0011%\t\t+!'\u0002\u0002\u0003\u0007!)A\u0002yIEBq!!*\u0001A\u0003&!)A\u0004t_V\u00148-\u001a\u0011\t\u0011e\u0002\u0001\u0019!C\u0005\u0003S+\u0012\u0001\u0010\u0005\n\u0003[\u0003\u0001\u0019!C\u0005\u0003_\u000bab\\;uaV$Xj\u001c3f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006E\u0006\"CAQ\u0003W\u000b\t\u00111\u0001=\u0011\u001d\t)\f\u0001Q!\nq\n1b\\;uaV$Xj\u001c3fA!A!\n\u0001a\u0001\n\u0013\tI,F\u0001N\u0011%\ti\f\u0001a\u0001\n\u0013\ty,A\u0006ue&<w-\u001a:`I\u0015\fH\u0003BAF\u0003\u0003D\u0011\"!)\u0002<\u0006\u0005\t\u0019A'\t\u000f\u0005\u0015\u0007\u0001)Q\u0005\u001b\u0006AAO]5hO\u0016\u0014\b\u0005C\u0005\u0002J\u0002\u0001\r\u0011\"\u0003\u0002L\u0006aQ\r\u001f;sC>\u0003H/[8ogV\u0011\u0011Q\u001a\t\u0007\u0003\u001f\f)N\u0011\"\u000e\u0005\u0005E'\u0002BAj\u0003+\tq!\\;uC\ndW-\u0003\u0003\u0002X\u0006E'a\u0002%bg\"l\u0015\r\u001d\u0005\n\u00037\u0004\u0001\u0019!C\u0005\u0003;\f\u0001#\u001a=ue\u0006|\u0005\u000f^5p]N|F%Z9\u0015\t\u0005-\u0015q\u001c\u0005\u000b\u0003C\u000bI.!AA\u0002\u00055\u0007\u0002CAr\u0001\u0001\u0006K!!4\u0002\u001b\u0015DHO]1PaRLwN\\:!\u0011%\t9\u000f\u0001a\u0001\n\u0013\tI/A\u0007g_J,\u0017m\u00195Xe&$XM]\u000b\u0003\u0003\u001fB\u0011\"!<\u0001\u0001\u0004%I!a<\u0002#\u0019|'/Z1dQ^\u0013\u0018\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006E\bBCAQ\u0003W\f\t\u00111\u0001\u0002P!A\u0011Q\u001f\u0001!B\u0013\ty%\u0001\bg_J,\u0017m\u00195Xe&$XM\u001d\u0011\t\u0013\u0005e\b\u00011A\u0005\n\u0005e\u0013a\u00059beRLG/[8oS:<7i\u001c7v[:\u001c\b\"CA\u007f\u0001\u0001\u0007I\u0011BA\u0000\u0003]\u0001\u0018M\u001d;ji&|g.\u001b8h\u0007>dW/\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\n\u0005\u0001BCAQ\u0003w\f\t\u00111\u0001\u0002\\!A!Q\u0001\u0001!B\u0013\tY&\u0001\u000bqCJ$\u0018\u000e^5p]&twmQ8mk6t7\u000f\t\u0015\u0004\u0001\t%\u0001\u0003\u0002B\u0006\u0005+qAA!\u0004\u0003\u00125\u0011!q\u0002\u0006\u0003K\u001aIAAa\u0005\u0003\u0010\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u00119B!\u0007\u0003\u0011\u00153x\u000e\u001c<j]\u001eTAAa\u0005\u0003\u0010!\u001a\u0001A!\b\u0011\t\t5!qD\u0005\u0005\u0005C\u0011yA\u0001\u0007FqB,'/[7f]R\fG\u000e")
public final class DataStreamWriter<T> {
    private final Dataset<T> ds;
    private final Dataset<Row> org$apache$spark$sql$streaming$DataStreamWriter$$df;
    private String source;
    private OutputMode outputMode;
    private Trigger trigger;
    private HashMap<String, String> extraOptions;
    private ForeachWriter<T> foreachWriter;
    private Option<Seq<String>> partitioningColumns;

    public DataStreamWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> org$apache$spark$sql$streaming$DataStreamWriter$$df() {
        return this.org$apache$spark$sql$streaming$DataStreamWriter$$df;
    }

    public DataStreamWriter<T> outputMode(OutputMode outputMode) {
        this.outputMode_$eq(outputMode);
        return this;
    }

    public DataStreamWriter<T> outputMode(String outputMode) {
        block5: {
            OutputMode outputMode2;
            block3: {
                String string;
                block4: {
                    block2: {
                        string = outputMode.toLowerCase();
                        if (!"append".equals(string)) break block2;
                        outputMode2 = OutputMode.Append();
                        break block3;
                    }
                    if (!"complete".equals(string)) break block4;
                    outputMode2 = OutputMode.Complete();
                    break block3;
                }
                if (!"update".equals(string)) break block5;
                outputMode2 = OutputMode.Update();
            }
            this.outputMode_$eq(outputMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown output mode ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputMode}))).append((Object)"Accepted output modes are 'append', 'complete', 'update'").toString());
    }

    public DataStreamWriter<T> trigger(Trigger trigger) {
        this.trigger_$eq(trigger);
        return this;
    }

    public DataStreamWriter<T> queryName(String queryName) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"queryName"), (Object)queryName));
        return this;
    }

    public DataStreamWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataStreamWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataStreamWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataStreamWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataStreamWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataStreamWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataStreamWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataStreamWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public StreamingQuery start(String path) {
        return this.option("path", path).start();
    }

    public StreamingQuery start() {
        Tuple2.mcZZ.sp sp2;
        block7: {
            StreamingQuery streamingQuery;
            block5: {
                Tuple2.mcZZ.sp sp3;
                block6: {
                    block4: {
                        String string = this.source();
                        String string2 = "memory";
                        if (string != null ? !string.equals(string2) : string2 != null) break block4;
                        this.assertNotPartitioned("memory");
                        if (this.extraOptions().get((Object)"queryName").isEmpty()) {
                            throw new AnalysisException("queryName must be specified for memory sink", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        MemorySink sink = new MemorySink(this.org$apache$spark$sql$streaming$DataStreamWriter$$df().schema(), this.outputMode());
                        Dataset<Row> resultDf = Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession(), (LogicalPlan)new MemoryPlan(sink));
                        Option chkpointLoc = this.extraOptions().get((Object)"checkpointLocation");
                        OutputMode outputMode = this.outputMode();
                        OutputMode outputMode2 = OutputMode.Complete();
                        boolean recoverFromChkpoint = !(outputMode != null ? !outputMode.equals(outputMode2) : outputMode2 != null);
                        StreamingQuery query = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)this.extraOptions().get((Object)"queryName"), (Option<String>)chkpointLoc, this.org$apache$spark$sql$streaming$DataStreamWriter$$df(), sink, this.outputMode(), true, recoverFromChkpoint, this.trigger(), this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery$default$9());
                        resultDf.createOrReplaceTempView(query.name());
                        streamingQuery = query;
                        break block5;
                    }
                    String string = this.source();
                    String string3 = "foreach";
                    if (string != null ? !string.equals(string3) : string3 != null) break block6;
                    this.assertNotPartitioned("foreach");
                    ForeachSink<T> sink = new ForeachSink<T>(this.foreachWriter(), this.ds.exprEnc());
                    Option x$5 = this.extraOptions().get((Object)"queryName");
                    Option x$6 = this.extraOptions().get((Object)"checkpointLocation");
                    Dataset<Row> x$7 = this.org$apache$spark$sql$streaming$DataStreamWriter$$df();
                    ForeachSink<T> x$8 = sink;
                    OutputMode x$9 = this.outputMode();
                    boolean x$10 = true;
                    Trigger x$11 = this.trigger();
                    boolean x$12 = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery$default$7();
                    Clock x$13 = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery$default$9();
                    streamingQuery = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)x$5, (Option<String>)x$6, x$7, x$8, x$9, x$10, x$12, x$11, x$13);
                    break block5;
                }
                String string = this.source();
                String string4 = "console";
                Tuple2.mcZZ.sp sp4 = !(string != null ? !string.equals(string4) : string4 != null) ? new Tuple2.mcZZ.sp(true, false) : (sp2 = new Tuple2.mcZZ.sp(false, true));
                if (sp2 == null) break block7;
                boolean useTempCheckpointLocation = sp2._1$mcZ$sp();
                boolean recoverFromCheckpointLocation = sp2._2$mcZ$sp();
                Tuple2.mcZZ.sp sp5 = sp3 = new Tuple2.mcZZ.sp(useTempCheckpointLocation, recoverFromCheckpointLocation);
                boolean useTempCheckpointLocation2 = sp5._1$mcZ$sp();
                boolean recoverFromCheckpointLocation2 = sp5._2$mcZ$sp();
                SparkSession x$14 = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession();
                String x$15 = this.source();
                scala.collection.immutable.Map x$16 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
                Seq x$17 = (Seq)this.normalizedParCols().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                });
                Seq<String> x$18 = DataSource$.MODULE$.apply$default$3();
                Option<StructType> x$19 = DataSource$.MODULE$.apply$default$4();
                Option<BucketSpec> x$20 = DataSource$.MODULE$.apply$default$6();
                Option<CatalogTable> x$21 = DataSource$.MODULE$.apply$default$8();
                DataSource dataSource = new DataSource(x$14, x$15, x$18, x$19, (Seq<String>)x$17, x$20, (scala.collection.immutable.Map<String, String>)x$16, x$21);
                streamingQuery = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery((Option<String>)this.extraOptions().get((Object)"queryName"), (Option<String>)this.extraOptions().get((Object)"checkpointLocation"), this.org$apache$spark$sql$streaming$DataStreamWriter$$df(), dataSource.createSink(this.outputMode()), this.outputMode(), useTempCheckpointLocation2, recoverFromCheckpointLocation2, this.trigger(), this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().streamingQueryManager().startQuery$default$9());
            }
            return streamingQuery;
        }
        throw new MatchError((Object)sp2);
    }

    public DataStreamWriter<T> foreach(ForeachWriter<T> writer) {
        this.source_$eq("foreach");
        if (writer == null) {
            throw new IllegalArgumentException("foreach writer cannot be null");
        }
        this.foreachWriter_$eq((ForeachWriter)this.ds.sparkSession().sparkContext().clean(writer, this.ds.sparkSession().sparkContext().clean$default$2()));
        return this;
    }

    private Option<Seq<String>> normalizedParCols() {
        return this.partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataStreamWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$normalizedParCols$1 $outer;

                    public final String apply(String x$2) {
                        return this.$outer.org$apache$spark$sql$streaming$DataStreamWriter$$anonfun$$$outer().org$apache$spark$sql$streaming$DataStreamWriter$$normalize(x$2, "Partition");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataStreamWriter org$apache$spark$sql$streaming$DataStreamWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String org$apache$spark$sql$streaming$DataStreamWriter$$normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.org$apache$spark$sql$streaming$DataStreamWriter$$df().logicalPlan().output().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (String)validColumnNames.find((Function1)new Serializable(this, columnName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataStreamWriter $outer;
            private final String columnName$1;

            public final boolean apply(String x$4) {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$4, (Object)this.columnName$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }).getOrElse((Function0)new Serializable(this, columnName, columnType, validColumnNames){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final String columnType$1;
            private final Seq validColumnNames$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column ", " not found in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnType$1, this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"existing columns (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.validColumnNames$1.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                void var4_4;
                void var3_3;
                this.columnName$1 = columnName$1;
                this.columnType$1 = var3_3;
                this.validColumnNames$1 = var4_4;
            }
        });
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support partitioning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private OutputMode outputMode() {
        return this.outputMode;
    }

    private void outputMode_$eq(OutputMode x$1) {
        this.outputMode = x$1;
    }

    private Trigger trigger() {
        return this.trigger;
    }

    private void trigger_$eq(Trigger x$1) {
        this.trigger = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    private ForeachWriter<T> foreachWriter() {
        return this.foreachWriter;
    }

    private void foreachWriter_$eq(ForeachWriter<T> x$1) {
        this.foreachWriter = x$1;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    public DataStreamWriter(Dataset<T> ds) {
        this.ds = ds;
        this.org$apache$spark$sql$streaming$DataStreamWriter$$df = ds.toDF();
        this.source = this.org$apache$spark$sql$streaming$DataStreamWriter$$df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.outputMode = OutputMode.Append();
        this.trigger = new ProcessingTime(0L);
        this.extraOptions = new HashMap();
        this.foreachWriter = null;
        this.partitioningColumns = None$.MODULE$;
    }
}

