/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import java.util.EnumSet;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.local.LocalFs;
import org.apache.hadoop.fs.local.RawLocalFs;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.apache.spark.util.UninterruptibleThread;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]\u0019\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011\u0012!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011AB\u0005\u0003]\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023k9\u0011!cM\u0005\u0003iM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011Ag\u0005\u0005\ts\u0001\u0011\u0019\u0011)A\u0006u\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007mr4$D\u0001=\u0015\ti4#A\u0004sK\u001adWm\u0019;\n\u0005}b$\u0001C\"mCN\u001cH+Y4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\r\u0019ei\u0012\u000b\u0003\t\u0016\u00032\u0001\u0007\u0001\u001c\u0011\u0015I\u0004\tq\u0001;\u0011\u0015Q\u0003\t1\u0001,\u0011\u0015\u0001\u0004\t1\u00012\u0011\u001dI\u0005A1A\u0005\f)\u000bqAZ8s[\u0006$8/F\u0001L%\ra\u0015c\u0015\u0004\u0005\u001b\u0002\u00011J\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002J\u001f&\u0011\u0001+\u0015\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ic\u0011A\u00026t_:$4\u000f\u0005\u0002U+6\t\u0011+\u0003\u0002W#\n9ai\u001c:nCR\u001c\bb\u0002-M\u0005\u0004%\t!W\u0001\u000bI\u0006$XMR8s[\u0006$X#\u0001.\u0011\u0005Q[\u0016B\u0001/R\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\b=2\u0013\r\u0011\"\u0011`\u0003%!\u0018\u0010]3IS:$8/F\u0001a!\t!\u0016-\u0003\u0002c#\nIA+\u001f9f\u0011&tGo\u001d\u0005\u0007I\u0002\u0001\u000b\u0011B&\u0002\u0011\u0019|'/\\1ug\u0002BqA\u001a\u0001C\u0002\u0013-q-\u0001\u0005nC:Lg-Z:u+\u0005A\u0007cA\u001ej7%\u0011!\u000e\u0010\u0002\t\u001b\u0006t\u0017NZ3ti\"1A\u000e\u0001Q\u0001\n!\f\u0011\"\\1oS\u001a,7\u000f\u001e\u0011\t\u000f9\u0004!\u0019!C\u0001_\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0011am\u001d\u0006\u0003k*\ta\u0001[1e_>\u0004\u0018BA<s\u0005\u0011\u0001\u0016\r\u001e5\t\re\u0004\u0001\u0015!\u0003q\u00035iW\r^1eCR\f\u0007+\u0019;iA!91\u0010\u0001b\u0001\n#a\u0018a\u00034jY\u0016l\u0015M\\1hKJ,\u0012! \t\u0004}\u00065aB\u0001\r\u0000\u000f\u001d\t\tA\u0001E\u0001\u0003\u0007\tq\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u00041\u0005\u0015aAB\u0001\u0003\u0011\u0003\t9aE\u0002\u0002\u0006EAq!QA\u0003\t\u0003\tY\u0001\u0006\u0002\u0002\u0004\u0019Q\u0011qBA\u0003!\u0003\r\n!!\u0005\u0003\u0017\u0019KG.Z'b]\u0006<WM]\n\u0004\u0003\u001b\t\u0002\u0002CA\u000b\u0003\u001b1\t!a\u0006\u0002\t1L7\u000f\u001e\u000b\u0007\u00033\t)#a\n\u0011\u000bI\tY\"a\b\n\u0007\u0005u1CA\u0003BeJ\f\u0017\u0010E\u0002r\u0003CI1!a\ts\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0007a\u0005M\u0001\u0019\u00019\t\u0011\u0005%\u00121\u0003a\u0001\u0003W\taAZ5mi\u0016\u0014\bcA9\u0002.%\u0019\u0011q\u0006:\u0003\u0015A\u000bG\u000f\u001b$jYR,'\u000f\u0003\u0005\u00024\u00055a\u0011AA\u001b\u0003\u0019i7\u000eZ5sgR!\u0011qGA\u001f!\r\u0011\u0012\u0011H\u0005\u0004\u0003w\u0019\"\u0001B+oSRDa\u0001MA\u0019\u0001\u0004\u0001\b\u0002CA!\u0003\u001b1\t!a\u0011\u0002\r\u0015D\u0018n\u001d;t)\u0011\t)%a\u0013\u0011\u0007I\t9%C\u0002\u0002JM\u0011qAQ8pY\u0016\fg\u000e\u0003\u00041\u0003\u007f\u0001\r\u0001\u001d\u0005\t\u0003\u001f\niA\"\u0001\u0002R\u0005!q\u000e]3o)\u0011\t\u0019&!\u0017\u0011\u0007E\f)&C\u0002\u0002XI\u0014\u0011CR*ECR\f\u0017J\u001c9viN#(/Z1n\u0011\u0019\u0001\u0014Q\na\u0001a\"A\u0011QLA\u0007\r\u0003\ty&\u0001\u0004de\u0016\fG/\u001a\u000b\u0005\u0003C\n9\u0007E\u0002r\u0003GJ1!!\u001as\u0005I15\u000bR1uC>+H\u000f];u'R\u0014X-Y7\t\rA\nY\u00061\u0001q\u0011!\tY'!\u0004\u0007\u0002\u00055\u0014A\u0002:f]\u0006lW\r\u0006\u0004\u00028\u0005=\u00141\u000f\u0005\b\u0003c\nI\u00071\u0001q\u0003\u001d\u0019(o\u0019)bi\"Dq!!\u001e\u0002j\u0001\u0007\u0001/\u0001\u0005eKN$\b+\u0019;i\u0011!\tI(!\u0004\u0007\u0002\u0005m\u0014A\u00023fY\u0016$X\r\u0006\u0003\u00028\u0005u\u0004B\u0002\u0019\u0002x\u0001\u0007\u0001\u000f\u0003\u0005\u0002\u0002\u00065a\u0011AAB\u0003EI7\u000fT8dC24\u0015\u000e\\3TsN$X-\\\u000b\u0003\u0003\u000b2q!a\"\u0002\u0006\u0001\tII\u0001\nGS2,7i\u001c8uKb$X*\u00198bO\u0016\u00148#BAC#\u0005-\u0005\u0003BAG\u0003\u001bi!!!\u0002\t\u0013A\n)I!A!\u0002\u0013\u0001\bbCAJ\u0003\u000b\u0013\t\u0011)A\u0005\u0003+\u000b!\u0002[1e_>\u00048i\u001c8g!\u0011\t9*!(\u000e\u0005\u0005e%bAANi\u0006!1m\u001c8g\u0013\u0011\ty*!'\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\t\u0015Q\u0011C\u0001\u0003G#b!!*\u0002(\u0006%\u0006\u0003BAG\u0003\u000bCa\u0001MAQ\u0001\u0004\u0001\b\u0002CAJ\u0003C\u0003\r!!&\t\u0015\u00055\u0016Q\u0011b\u0001\n\u0013\ty+\u0001\u0002gGV\u0011\u0011\u0011\u0017\t\u0004c\u0006M\u0016bAA[e\nYa)\u001b7f\u0007>tG/\u001a=u\u0011%\tI,!\"!\u0002\u0013\t\t,A\u0002gG\u0002B\u0001\"!\u0006\u0002\u0006\u0012\u0005\u0013Q\u0018\u000b\u0007\u00033\ty,!1\t\rA\nY\f1\u0001q\u0011!\tI#a/A\u0002\u0005-\u0002\u0002CA6\u0003\u000b#\t%!2\u0015\r\u0005]\u0012qYAe\u0011\u001d\t\t(a1A\u0002ADq!!\u001e\u0002D\u0002\u0007\u0001\u000f\u0003\u0005\u00024\u0005\u0015E\u0011IAg)\u0011\t9$a4\t\rA\nY\r1\u0001q\u0011!\ty%!\"\u0005B\u0005MG\u0003BA*\u0003+Da\u0001MAi\u0001\u0004\u0001\b\u0002CA/\u0003\u000b#\t%!7\u0015\t\u0005\u0005\u00141\u001c\u0005\u0007a\u0005]\u0007\u0019\u00019\t\u0011\u0005\u0005\u0013Q\u0011C!\u0003?$B!!\u0012\u0002b\"1\u0001'!8A\u0002AD\u0001\"!\u001f\u0002\u0006\u0012\u0005\u0013Q\u001d\u000b\u0005\u0003o\t9\u000f\u0003\u00041\u0003G\u0004\r\u0001\u001d\u0005\t\u0003\u0003\u000b)\t\"\u0011\u0002\u0004\u001a9\u0011Q^A\u0003\u0001\u0005=(!\u0005$jY\u0016\u001c\u0016p\u001d;f[6\u000bg.Y4feN)\u00111^\t\u0002\f\"I\u0001'a;\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\f\u0003'\u000bYO!A!\u0002\u0013\t)\nC\u0004B\u0003W$\t!a>\u0015\r\u0005e\u00181`A\u007f!\u0011\ti)a;\t\rA\n)\u00101\u0001q\u0011!\t\u0019*!>A\u0002\u0005U\u0005\"C:\u0002l\n\u0007I\u0011\u0002B\u0001+\t\u0011\u0019\u0001E\u0002r\u0005\u000bI1Aa\u0002s\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\n\u0005\u0017\tY\u000f)A\u0005\u0005\u0007\t1AZ:!\u0011!\t)\"a;\u0005B\t=ACBA\r\u0005#\u0011\u0019\u0002\u0003\u00041\u0005\u001b\u0001\r\u0001\u001d\u0005\t\u0003S\u0011i\u00011\u0001\u0002,!A\u00111NAv\t\u0003\u00129\u0002\u0006\u0004\u00028\te!1\u0004\u0005\b\u0003c\u0012)\u00021\u0001q\u0011\u001d\t)H!\u0006A\u0002AD\u0001\"a\r\u0002l\u0012\u0005#q\u0004\u000b\u0005\u0003o\u0011\t\u0003\u0003\u00041\u0005;\u0001\r\u0001\u001d\u0005\t\u0003\u001f\nY\u000f\"\u0011\u0003&Q!\u00111\u000bB\u0014\u0011\u0019\u0001$1\u0005a\u0001a\"A\u0011QLAv\t\u0003\u0012Y\u0003\u0006\u0003\u0002b\t5\u0002B\u0002\u0019\u0003*\u0001\u0007\u0001\u000f\u0003\u0005\u0002B\u0005-H\u0011\tB\u0019)\u0011\t)Ea\r\t\rA\u0012y\u00031\u0001q\u0011!\tI(a;\u0005B\t]B\u0003BA\u001c\u0005sAa\u0001\rB\u001b\u0001\u0004\u0001\b\u0002CAA\u0003W$\t%a!\t\u000f\t}\u0002\u0001)A\u0005{\u0006aa-\u001b7f\u001b\u0006t\u0017mZ3sA!9!1\t\u0001\u0005\n\t\u0015\u0013!\u0007:v]Vs\u0017N\u001c;feJ,\b\u000f^5cYfLe\rT8dC2,BAa\u0012\u0003LQ!!\u0011\nB+!\ra\"1\n\u0003\b=\t\u0005#\u0019\u0001B'#\r\u0001#q\n\t\u0004%\tE\u0013b\u0001B*'\t\u0019\u0011I\\=\t\u0013\t]#\u0011\tCA\u0002\te\u0013\u0001\u00022pIf\u0004RA\u0005B.\u0005\u0013J1A!\u0018\u0014\u0005!a$-\u001f8b[\u0016t\u0004\"\u0003B1\u0001\t\u0007I\u0011\u0003B2\u0003A\u0011\u0017\r^2i\r&dWm\u001d$jYR,'/\u0006\u0002\u0003fI1!q\rB7\u0003W1a!\u0014B5\u0001\t\u0015\u0004\u0002\u0003B6\u0001\u0001\u0006IA!\u001a\u0002#\t\fGo\u00195GS2,7OR5mi\u0016\u0014\b\u0005\u0005\u0003\u0003p\teTB\u0001B9\u0015\u0011\u0011\u0019H!\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0005o\nAA[1wC&!!1\u0010B9\u0005\u0019y%M[3di\"9!q\u0010\u0001\u0005\u0012\t\u0005\u0015!\u00042bi\u000eD\u0017\n\u001a+p!\u0006$\b\u000eF\u0002q\u0005\u0007C\u0001B!\"\u0003~\u0001\u0007!qQ\u0001\bE\u0006$8\r[%e!\r\u0011\"\u0011R\u0005\u0004\u0005\u0017\u001b\"\u0001\u0002'p]\u001eDqAa$\u0001\t#\u0011\t*A\u0007qCRDGk\u001c\"bi\u000eD\u0017\n\u001a\u000b\u0005\u0005\u000f\u0013\u0019\n\u0003\u00041\u0005\u001b\u0003\r\u0001\u001d\u0005\b\u0005/\u0003A\u0011\u0003BM\u0003-I7OQ1uG\"4\u0015\u000e\\3\u0015\t\u0005\u0015#1\u0014\u0005\u0007a\tU\u0005\u0019\u00019\t\u000f\t}\u0005\u0001\"\u0005\u0003\"\u0006I1/\u001a:jC2L'0\u001a\u000b\u0007\u0003o\u0011\u0019Ka*\t\u000f\t\u0015&Q\u0014a\u00017\u0005AQ.\u001a;bI\u0006$\u0018\r\u0003\u0005\u0003*\nu\u0005\u0019\u0001BV\u0003\ryW\u000f\u001e\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*!!\u0011\u0017B;\u0003\tIw.\u0003\u0003\u00036\n=&\u0001D(viB,Ho\u0015;sK\u0006l\u0007b\u0002B]\u0001\u0011E!1X\u0001\fI\u0016\u001cXM]5bY&TX\rF\u0002\u001c\u0005{C\u0001Ba0\u00038\u0002\u0007!\u0011Y\u0001\u0003S:\u0004BA!,\u0003D&!!Q\u0019BX\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\t%\u0007\u0001\"\u0011\u0003L\u0006\u0019\u0011\r\u001a3\u0015\r\u0005\u0015#Q\u001aBh\u0011!\u0011)Ia2A\u0002\t\u001d\u0005b\u0002BS\u0005\u000f\u0004\ra\u0007\u0005\b\u0005'\u0004A\u0011\u0002Bk\u000399(/\u001b;f)\u0016l\u0007OQ1uG\"$BAa6\u0003^B!!C!7q\u0013\r\u0011Yn\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t\u0015&\u0011\u001ba\u00017!9!\u0011\u001d\u0001\u0005\n\t\r\u0018AC<sSR,')\u0019;dQR1\u0011q\u0007Bs\u0005OD\u0001B!\"\u0003`\u0002\u0007!q\u0011\u0005\b\u0005K\u0013y\u000e1\u0001\u001c\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[\fA$[:GS2,\u0017\t\u001c:fC\u0012LX\t_5tiN,\u0005pY3qi&|g\u000e\u0006\u0003\u0002F\t=\b\u0002\u0003By\u0005S\u0004\rAa=\u0002\u0003\u0015\u0004BA!,\u0003v&!!q\u001fBX\u0005-Iu*\u0012=dKB$\u0018n\u001c8\t\u000f\tm\b\u0001\"\u0001\u0003~\u0006\u0019q-\u001a;\u0015\t\t}8\u0011\u0001\t\u0005%\te7\u0004C\u0004\u0004\u0004\te\b\u0019\u00019\u0002\u0013\t\fGo\u00195GS2,\u0007b\u0002B~\u0001\u0011\u00053q\u0001\u000b\u0005\u0005\u007f\u001cI\u0001\u0003\u0005\u0003\u0006\u000e\u0015\u0001\u0019\u0001BD\u0011\u001d\u0011Y\u0010\u0001C!\u0007\u001b!baa\u0004\u0004\u0018\ru\u0001#\u0002\n\u0002\u001c\rE\u0001C\u0002\n\u0004\u0014\t\u001d5$C\u0002\u0004\u0016M\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CB\r\u0007\u0017\u0001\raa\u0007\u0002\u000fM$\u0018M\u001d;JIB)!C!7\u0003\b\"A1qDB\u0006\u0001\u0004\u0019Y\"A\u0003f]\u0012LE\rC\u0004\u0004$\u0001!\te!\n\u0002\u0013\u001d,G\u000fT1uKN$HCAB\u0014!\u0015\u0011\"\u0011\\B\t\u0011\u001d\u0019Y\u0003\u0001C\u0001\u0007[\tAcZ3u\u001fJ$WM]3e\u0005\u0006$8\r\u001b$jY\u0016\u001cHCAA\r\u0011\u001d\u0019\t\u0004\u0001C!\u0007g\tQ\u0001];sO\u0016$B!a\u000e\u00046!A1qGB\u0018\u0001\u0004\u00119)\u0001\tuQJ,7\u000f[8mI\n\u000bGo\u00195JI\"911\b\u0001\u0005\n\ru\u0012!E2sK\u0006$XMR5mK6\u000bg.Y4feR\tQ\u0010\u0003\u0005\u0004B\u0001!\tABB\"\u00031\u0001\u0018M]:f-\u0016\u00148/[8o)\u0019\u0019)ea\u0013\u0004PA\u0019!ca\u0012\n\u0007\r%3CA\u0002J]RDqa!\u0014\u0004@\u0001\u0007\u0011'\u0001\u0003uKb$\b\u0002CB)\u0007\u007f\u0001\ra!\u0012\u0002'5\f\u0007pU;qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final FileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public FileManager fileManager() {
        return this.fileManager;
    }

    public <T> T org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$runUninterruptiblyIfLocal(Function0<T> body) {
        return (T)(this.fileManager().isLocalFileSystem() && Thread.currentThread() instanceof UninterruptibleThread ? ((UninterruptibleThread)Thread.currentThread()).runUninterruptibly(body) : body.apply());
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            public final long batchId$1;
            public final Object metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$runUninterruptiblyIfLocal(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$add$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer().org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(this.$outer.batchId$1, this.$outer.metadata$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return true;
            }

            public /* synthetic */ HDFSMetadataLog org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.metadata$1 = var4_3;
            }
        }));
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Option<Path> writeTempBatch(T metadata) {
        Throwable throwable322;
        while (true) {
            Path tempPath = new Path(this.metadataPath(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString()})));
            try {
                FSDataOutputStream output2 = this.fileManager().create(tempPath);
                this.serialize(metadata, (OutputStream)output2);
                Some some = new Some((Object)tempPath);
                {
                    catch (Throwable throwable2) {
                        void var4_8;
                        IOUtils.closeQuietly((OutputStream)var4_8);
                        throw throwable2;
                    }
                }
                IOUtils.closeQuietly((OutputStream)output2);
                return some;
            }
            catch (Throwable throwable322) {
                IOException iOException;
                Throwable throwable4 = throwable322;
                if (!(throwable4 instanceof IOException) || !this.isFileAlreadyExistsException(iOException = (IOException)throwable4)) break;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            break;
        }
        throw throwable322;
    }

    /*
     * WARNING - void declaration
     */
    public void org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatch(long batchId, T metadata) {
        Path tempPath = (Path)this.writeTempBatch(metadata).getOrElse((Function0)new Serializable(this, batchId){
            public static final long serialVersionUID = 0L;
            private final long batchId$2;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to create temp batch file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.batchId$2)})));
            }
            {
                this.batchId$2 = batchId$2;
            }
        });
        try {
            this.logDebug((Function0<String>)new Serializable(this, batchId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;
                private final long batchId$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to write log #", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.batchIdToPath(this.batchId$2)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchId$2 = batchId$2;
                }
            });
            this.fileManager().rename(tempPath, this.batchIdToPath(batchId));
            Path crcPath = new Path(tempPath.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".crc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath.getName()})));
            if (this.fileManager().exists(crcPath)) {
                this.fileManager().delete(crcPath);
            }
            this.fileManager().delete(tempPath);
            return;
        }
        catch (Throwable throwable) {
            try {
                IOException iOException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException && this.isFileAlreadyExistsException(iOException = (IOException)throwable2)) {
                    throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple HDFSMetadataLog are using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path})), iOException);
                }
                throw throwable;
            }
            catch (Throwable throwable3) {
                void var4_3;
                this.fileManager().delete((Path)var4_3);
                throw throwable3;
            }
        }
    }

    private boolean isFileAlreadyExistsException(IOException e) {
        return e instanceof FileAlreadyExistsException || e.getMessage() != null && e.getMessage().startsWith("File already exists: ");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<T> get(Path batchFile) {
        Option<T> option;
        if (this.fileManager().exists(batchFile)) {
            if (!this.isBatchFile(batchFile)) throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " is not a batch file!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchFile})));
            option = this.get(this.pathToBatchId(batchFile));
            return option;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Option<T> get(long batchId) {
        Some some;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (!this.fileManager().exists(batchMetadataFile)) {
            this.logDebug((Function0<String>)new Serializable(this, batchMetadataFile){
                public static final long serialVersionUID = 0L;
                private final Path batchMetadataFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadataFile$1}));
                }
                {
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                }
            });
            some = None$.MODULE$;
            return some;
        }
        FSDataInputStream input = this.fileManager().open(batchMetadataFile);
        try {
            some = new Some(this.deserialize((InputStream)input));
        }
        catch (IllegalStateException illegalStateException) {
            try {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read log file ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchMetadataFile, illegalStateException.getMessage()})), illegalStateException);
            }
            catch (Throwable throwable) {
                void var4_3;
                IOUtils.closeQuietly((InputStream)var4_3);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return some;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        });
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps(batchIds).sorted((Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;

                    public final long apply(FileStatus f) {
                        return this.$outer.pathToBatchId(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted((Ordering)Ordering.Long$.MODULE$)).reverse();
                Predef$.MODULE$.longArrayOps(batchIds).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long batchId) {
                        this.apply$mcVJ$sp(batchId);
                    }

                    public void apply$mcVJ$sp(long batchId) {
                        Option<T> batch = this.$outer.get(batchId);
                        if (batch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private FileManager createFileManager() {
        FileManager fileManager;
        Configuration hadoopConf = this.sparkSession.sessionState().newHadoopConf();
        try {
            fileManager = new FileContextManager(this.metadataPath(), hadoopConf);
        }
        catch (UnsupportedFileSystemException unsupportedFileSystemException) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HDFSMetadataLog $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Could not use FileContext API for managing metadata log files at path ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Using FileSystem API instead for managing log files. The log may be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.metadataPath()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"inconsistent under failures."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            fileManager = new FileSystemManager(this.metadataPath(), hadoopConf);
        }
        return fileManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int parseVersion(String text, int maxSupportedVersion) {
        int version;
        if (text.length() <= 0 || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) != 'v') throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        try {
            version = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
            if (version <= 0) throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
            if (version <= maxSupportedVersion) return version;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnsupportedLogVersion: maximum supported log version "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is v", ", but encountered v", ". The log file was produced "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSupportedVersion), BoxesRunTime.boxToInteger((int)version)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by a newer version of Spark and cannot be read by this version. Please upgrade."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        this.sparkSession = sparkSession;
        this.path = path;
        Logging.class.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = this.createFileManager();
        this.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$runUninterruptiblyIfLocal((Function0<T>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.$outer.fileManager().exists(this.$outer.metadataPath())) {
                    this.$outer.fileManager().mkdirs(this.$outer.metadataPath());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public static interface FileManager {
        public FileStatus[] list(Path var1, PathFilter var2);

        public void mkdirs(Path var1);

        public boolean exists(Path var1);

        public FSDataInputStream open(Path var1);

        public FSDataOutputStream create(Path var1);

        public void rename(Path var1, Path var2);

        public void delete(Path var1);

        public boolean isLocalFileSystem();
    }

    public static class FileSystemManager
    implements FileManager {
        private final FileSystem fs;

        private FileSystem fs() {
            return this.fs;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fs().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            if (this.fs().exists(srcPath)) {
                if (this.fs().exists(destPath)) {
                    throw new FileAlreadyExistsException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination path already exists: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destPath})));
                }
                if (this.fs().rename(srcPath, destPath)) {
                    return;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath, destPath})));
            }
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Source path does not exist: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcPath})));
        }

        @Override
        public void mkdirs(Path path) {
            this.fs().mkdirs(path, FsPermission.getDirDefault());
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fs().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fs().create(path, false);
        }

        @Override
        public boolean exists(Path path) {
            return this.fs().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fs().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            FileSystem fileSystem = this.fs();
            boolean bl = fileSystem instanceof LocalFileSystem ? true : fileSystem instanceof RawLocalFileSystem;
            boolean bl2 = bl;
            return bl2;
        }

        public FileSystemManager(Path path, Configuration hadoopConf) {
            this.fs = path.getFileSystem(hadoopConf);
        }
    }

    public static class FileContextManager
    implements FileManager {
        private final FileContext fc;

        private FileContext fc() {
            return this.fc;
        }

        @Override
        public FileStatus[] list(Path path, PathFilter filter2) {
            return this.fc().util().listStatus(path, filter2);
        }

        @Override
        public void rename(Path srcPath, Path destPath) {
            this.fc().rename(srcPath, destPath, new Options.Rename[0]);
        }

        @Override
        public void mkdirs(Path path) {
            this.fc().mkdir(path, FsPermission.getDirDefault(), true);
        }

        @Override
        public FSDataInputStream open(Path path) {
            return this.fc().open(path);
        }

        @Override
        public FSDataOutputStream create(Path path) {
            return this.fc().create(path, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
        }

        @Override
        public boolean exists(Path path) {
            return this.fc().util().exists(path);
        }

        @Override
        public void delete(Path path) {
            try {
                this.fc().delete(path, true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }

        @Override
        public boolean isLocalFileSystem() {
            AbstractFileSystem abstractFileSystem = this.fc().getDefaultFileSystem();
            boolean bl = abstractFileSystem instanceof LocalFs ? true : abstractFileSystem instanceof RawLocalFs;
            boolean bl2 = bl;
            return bl2;
        }

        public FileContextManager(Path path, Configuration hadoopConf) {
            this.fc = path.toUri().getScheme() == null ? FileContext.getFileContext((Configuration)hadoopConf) : FileContext.getFileContext((URI)path.toUri(), (Configuration)hadoopConf);
        }
    }
}

