/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.TextSocketSource;
import org.apache.spark.sql.execution.streaming.TextSocketSource$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.StreamSourceProvider;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001f\tAB+\u001a=u'>\u001c7.\u001a;T_V\u00148-\u001a)s_ZLG-\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\f\u001d?A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u000fM|WO]2fg&\u00111\u0004\u0007\u0002\u0015'R\u0014X-Y7T_V\u00148-\u001a)s_ZLG-\u001a:\u0011\u0005]i\u0012B\u0001\u0010\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tB\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0011\n#a\u0002'pO\u001eLgn\u001a\u0005\u0006M\u0001!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"!\u000b\u0001\u000e\u0003\tAQa\u000b\u0001\u0005\n1\nQ\u0003]1sg\u0016Len\u00197vI\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002.aA\u0011\u0011CL\u0005\u0003_I\u0011qAQ8pY\u0016\fg\u000eC\u00032U\u0001\u0007!'\u0001\u0004qCJ\fWn\u001d\t\u0005gYJ\u0014H\u0004\u0002\u0012i%\u0011QGE\u0001\u0007!J,G-\u001a4\n\u0005]B$aA'ba*\u0011QG\u0005\t\u0003giJ!a\u000f\u001d\u0003\rM#(/\u001b8h\u0011\u0015i\u0004\u0001\"\u0011?\u00031\u0019x.\u001e:dKN\u001b\u0007.Z7b)\u0015y\u0004JT*V!\u0011\t\u0002)\u000f\"\n\u0005\u0005\u0013\"A\u0002+va2,'\u0007\u0005\u0002D\r6\tAI\u0003\u0002F\r\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B%=\u0001\u0004Q\u0015AC:rY\u000e{g\u000e^3yiB\u00111\nT\u0007\u0002\r%\u0011QJ\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\"B(=\u0001\u0004\u0001\u0016AB:dQ\u0016l\u0017\rE\u0002\u0012#\nK!A\u0015\n\u0003\r=\u0003H/[8o\u0011\u0015!F\b1\u0001:\u00031\u0001(o\u001c<jI\u0016\u0014h*Y7f\u0011\u00151F\b1\u00013\u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\u00061\u0002!\t%W\u0001\rGJ,\u0017\r^3T_V\u00148-\u001a\u000b\u00075vs\u0006-\u00192\u0011\u0005%Z\u0016B\u0001/\u0003\u0005\u0019\u0019v.\u001e:dK\")\u0011j\u0016a\u0001\u0015\")ql\u0016a\u0001s\u0005aQ.\u001a;bI\u0006$\u0018\rU1uQ\")qj\u0016a\u0001!\")Ak\u0016a\u0001s!)ak\u0016a\u0001e!)A\r\u0001C!K\u0006I1\u000f[8si:\u000bW.\u001a\u000b\u0002s\u0001")
public class TextSocketSourceProvider
implements StreamSourceProvider,
DataSourceRegister,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private boolean parseIncludeTimestamp(Map<String, String> params) {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, params){
            public static final long serialVersionUID = 0L;
            private final Map params$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString((String)this.params$1.getOrElse((Object)"includeTimestamp", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "false";
                    }
                }))).toBoolean();
            }
            {
                this.params$1 = params$1;
            }
        });
        if (try_ instanceof Success) {
            boolean bool;
            Success success = (Success)try_;
            boolean bl = bool = BoxesRunTime.unboxToBoolean((Object)success.value());
            return bl;
        }
        if (try_ instanceof Failure) {
            throw new AnalysisException("includeTimestamp must be set to either \"true\" or \"false\"", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Tuple2<String, StructType> sourceSchema(SQLContext sqlContext, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The socket source should not be used for production applications! It does not support recovery.";
            }
        });
        if (parameters.contains((Object)"host")) {
            if (parameters.contains((Object)"port")) {
                StructType schema2 = this.parseIncludeTimestamp(parameters) ? TextSocketSource$.MODULE$.SCHEMA_TIMESTAMP() : TextSocketSource$.MODULE$.SCHEMA_REGULAR();
                return new Tuple2((Object)"textSocket", (Object)schema2);
            }
            throw new AnalysisException("Set a port to read from with option(\"port\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        throw new AnalysisException("Set a host to read from with option(\"host\", ...).", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public Source createSource(SQLContext sqlContext, String metadataPath, Option<StructType> schema, String providerName, Map<String, String> parameters) {
        String host = (String)parameters.apply((Object)"host");
        int port = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)"port"))).toInt();
        return new TextSocketSource(host, port, this.parseIncludeTimestamp(parameters), sqlContext);
    }

    @Override
    public String shortName() {
        return "socket";
    }

    public TextSocketSourceProvider() {
        Logging.class.$init$((Logging)this);
    }
}

