/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import org.spark_project.guava.annotations.VisibleForTesting;

public abstract class ColumnVector
implements AutoCloseable {
    protected int capacity;
    @VisibleForTesting
    protected int MAX_CAPACITY = Integer.MAX_VALUE;
    protected final DataType type;
    protected int numNulls;
    protected boolean anyNullsSet;
    protected boolean isConstant;
    protected static final int DEFAULT_ARRAY_LENGTH = 4;
    protected int elementsAppended;
    protected final ColumnVector[] childColumns;
    protected final Array resultArray;
    protected final ColumnarBatch.Row resultStruct;
    protected Dictionary dictionary;
    protected ColumnVector dictionaryIds;

    public static ColumnVector allocate(int capacity, DataType type, MemoryMode mode) {
        if (mode == MemoryMode.OFF_HEAP) {
            return new OffHeapColumnVector(capacity, type);
        }
        return new OnHeapColumnVector(capacity, type);
    }

    public final DataType dataType() {
        return this.type;
    }

    public void reset() {
        if (this.isConstant) {
            return;
        }
        if (this.childColumns != null) {
            for (ColumnVector c : this.childColumns) {
                c.reset();
            }
        }
        this.numNulls = 0;
        this.elementsAppended = 0;
        if (this.anyNullsSet) {
            this.putNotNulls(0, this.capacity);
            this.anyNullsSet = false;
        }
    }

    @Override
    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                if (this.childColumns[i] == null) continue;
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
        }
        if (this.dictionaryIds != null) {
            this.dictionaryIds.close();
            this.dictionaryIds = null;
        }
        this.dictionary = null;
    }

    public void reserve(int requiredCapacity) {
        if (requiredCapacity > this.capacity) {
            int newCapacity = (int)Math.min((long)this.MAX_CAPACITY, (long)requiredCapacity * 2L);
            if (requiredCapacity <= newCapacity) {
                try {
                    this.reserveInternal(newCapacity);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.throwUnsupportedException(requiredCapacity, outOfMemoryError);
                }
            } else {
                this.throwUnsupportedException(requiredCapacity, null);
            }
        }
    }

    private void throwUnsupportedException(int requiredCapacity, Throwable cause) {
        String message = "Cannot reserve additional contiguous bytes in the vectorized reader (requested = " + requiredCapacity + " bytes). As a workaround, you can disable the vectorized reader by setting " + SQLConf.PARQUET_VECTORIZED_READER_ENABLED().key() + " to false.";
        if (cause != null) {
            throw new RuntimeException(message, cause);
        }
        throw new RuntimeException(message);
    }

    protected abstract void reserveInternal(int var1);

    public final int numNulls() {
        return this.numNulls;
    }

    public final boolean anyNullsSet() {
        return this.anyNullsSet;
    }

    public abstract long nullsNativeAddress();

    public abstract long valuesNativeAddress();

    public abstract void putNotNull(int var1);

    public abstract void putNull(int var1);

    public abstract void putNulls(int var1, int var2);

    public abstract void putNotNulls(int var1, int var2);

    public abstract boolean isNullAt(int var1);

    public abstract void putBoolean(int var1, boolean var2);

    public abstract void putBooleans(int var1, int var2, boolean var3);

    public abstract boolean getBoolean(int var1);

    public abstract void putByte(int var1, byte var2);

    public abstract void putBytes(int var1, int var2, byte var3);

    public abstract void putBytes(int var1, int var2, byte[] var3, int var4);

    public abstract byte getByte(int var1);

    public abstract void putShort(int var1, short var2);

    public abstract void putShorts(int var1, int var2, short var3);

    public abstract void putShorts(int var1, int var2, short[] var3, int var4);

    public abstract short getShort(int var1);

    public abstract void putInt(int var1, int var2);

    public abstract void putInts(int var1, int var2, int var3);

    public abstract void putInts(int var1, int var2, int[] var3, int var4);

    public abstract void putIntsLittleEndian(int var1, int var2, byte[] var3, int var4);

    public abstract int getInt(int var1);

    public abstract int getDictId(int var1);

    public abstract void putLong(int var1, long var2);

    public abstract void putLongs(int var1, int var2, long var3);

    public abstract void putLongs(int var1, int var2, long[] var3, int var4);

    public abstract void putLongsLittleEndian(int var1, int var2, byte[] var3, int var4);

    public abstract long getLong(int var1);

    public abstract void putFloat(int var1, float var2);

    public abstract void putFloats(int var1, int var2, float var3);

    public abstract void putFloats(int var1, int var2, float[] var3, int var4);

    public abstract void putFloats(int var1, int var2, byte[] var3, int var4);

    public abstract float getFloat(int var1);

    public abstract void putDouble(int var1, double var2);

    public abstract void putDoubles(int var1, int var2, double var3);

    public abstract void putDoubles(int var1, int var2, double[] var3, int var4);

    public abstract void putDoubles(int var1, int var2, byte[] var3, int var4);

    public abstract double getDouble(int var1);

    public abstract void putArray(int var1, int var2, int var3);

    public abstract int getArrayLength(int var1);

    public abstract int getArrayOffset(int var1);

    public ColumnarBatch.Row getStruct(int rowId) {
        this.resultStruct.rowId = rowId;
        return this.resultStruct;
    }

    public ColumnarBatch.Row getStruct(int rowId, int size) {
        this.resultStruct.rowId = rowId;
        return this.resultStruct;
    }

    public final Array getArray(int rowId) {
        this.resultArray.length = this.getArrayLength(rowId);
        this.resultArray.offset = this.getArrayOffset(rowId);
        return this.resultArray;
    }

    public abstract void loadBytes(Array var1);

    public abstract int putByteArray(int var1, byte[] var2, int var3, int var4);

    public final int putByteArray(int rowId, byte[] value) {
        return this.putByteArray(rowId, value, 0, value.length);
    }

    private Array getByteArray(int rowId) {
        Array array2 = this.getArray(rowId);
        array2.data.loadBytes(array2);
        return array2;
    }

    public MapData getMap(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public final Decimal getDecimal(int rowId, int precision, int scale) {
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            return Decimal.createUnsafe((long)this.getInt(rowId), (int)precision, (int)scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.createUnsafe((long)this.getLong(rowId), (int)precision, (int)scale);
        }
        byte[] bytes = this.getBinary(rowId);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply((BigDecimal)javaDecimal, (int)precision, (int)scale);
    }

    public final void putDecimal(int rowId, Decimal value, int precision) {
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            this.putInt(rowId, (int)value.toUnscaledLong());
        } else if (precision <= Decimal.MAX_LONG_DIGITS()) {
            this.putLong(rowId, value.toUnscaledLong());
        } else {
            BigInteger bigInteger = value.toJavaBigDecimal().unscaledValue();
            this.putByteArray(rowId, bigInteger.toByteArray());
        }
    }

    public final UTF8String getUTF8String(int rowId) {
        if (this.dictionary == null) {
            Array a = this.getByteArray(rowId);
            return UTF8String.fromBytes((byte[])a.byteArray, (int)a.byteArrayOffset, (int)a.length);
        }
        Binary v = this.dictionary.decodeToBinary(this.dictionaryIds.getDictId(rowId));
        return UTF8String.fromBytes((byte[])v.getBytes());
    }

    public final byte[] getBinary(int rowId) {
        if (this.dictionary == null) {
            Array array2 = this.getByteArray(rowId);
            byte[] bytes = new byte[array2.length];
            System.arraycopy(array2.byteArray, array2.byteArrayOffset, bytes, 0, bytes.length);
            return bytes;
        }
        Binary v = this.dictionary.decodeToBinary(this.dictionaryIds.getDictId(rowId));
        return v.getBytes();
    }

    public final int appendNull() {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + 1);
        this.putNull(this.elementsAppended);
        return this.elementsAppended++;
    }

    public final int appendNotNull() {
        this.reserve(this.elementsAppended + 1);
        this.putNotNull(this.elementsAppended);
        return this.elementsAppended++;
    }

    public final int appendNulls(int count2) {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putNulls(this.elementsAppended, count2);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendNotNulls(int count2) {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putNotNulls(this.elementsAppended, count2);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendBoolean(boolean v) {
        this.reserve(this.elementsAppended + 1);
        this.putBoolean(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendBooleans(int count2, boolean v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putBooleans(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendByte(byte v) {
        this.reserve(this.elementsAppended + 1);
        this.putByte(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendBytes(int count2, byte v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putBytes(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendBytes(int length, byte[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putBytes(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendShort(short v) {
        this.reserve(this.elementsAppended + 1);
        this.putShort(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendShorts(int count2, short v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putShorts(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendShorts(int length, short[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putShorts(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendInt(int v) {
        this.reserve(this.elementsAppended + 1);
        this.putInt(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendInts(int count2, int v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putInts(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendInts(int length, int[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putInts(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendLong(long v) {
        this.reserve(this.elementsAppended + 1);
        this.putLong(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendLongs(int count2, long v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putLongs(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendLongs(int length, long[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putLongs(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendFloat(float v) {
        this.reserve(this.elementsAppended + 1);
        this.putFloat(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendFloats(int count2, float v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putFloats(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendDouble(double v) {
        this.reserve(this.elementsAppended + 1);
        this.putDouble(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendDoubles(int count2, double v) {
        this.reserve(this.elementsAppended + count2);
        int result = this.elementsAppended;
        this.putDoubles(this.elementsAppended, count2, v);
        this.elementsAppended += count2;
        return result;
    }

    public final int appendDoubles(int length, double[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putDoubles(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendByteArray(byte[] value, int offset, int length) {
        int copiedOffset = this.arrayData().appendBytes(length, value, offset);
        this.reserve(this.elementsAppended + 1);
        this.putArray(this.elementsAppended, copiedOffset, length);
        return this.elementsAppended++;
    }

    public final int appendArray(int length) {
        this.reserve(this.elementsAppended + 1);
        this.putArray(this.elementsAppended, this.arrayData().elementsAppended, length);
        return this.elementsAppended++;
    }

    public final int appendStruct(boolean isNull) {
        if (isNull) {
            this.appendNull();
            for (ColumnVector c : this.childColumns) {
                if (c.type instanceof StructType) {
                    c.appendStruct(true);
                    continue;
                }
                c.appendNull();
            }
        } else {
            this.appendNotNull();
        }
        return this.elementsAppended;
    }

    public final ColumnVector arrayData() {
        return this.childColumns[0];
    }

    public final ColumnVector getChildColumn(int ordinal) {
        return this.childColumns[ordinal];
    }

    public final int getElementsAppended() {
        return this.elementsAppended;
    }

    public final boolean isArray() {
        return this.resultArray != null;
    }

    public final void setIsConstant() {
        this.isConstant = true;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public boolean hasDictionary() {
        return this.dictionary != null;
    }

    public ColumnVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = ColumnVector.allocate(capacity, DataTypes.IntegerType, this instanceof OnHeapColumnVector ? MemoryMode.ON_HEAP : MemoryMode.OFF_HEAP);
        } else {
            this.dictionaryIds.reset();
            this.dictionaryIds.reserve(capacity);
        }
        return this.dictionaryIds;
    }

    public ColumnVector getDictionaryIds() {
        return this.dictionaryIds;
    }

    protected ColumnVector(int capacity, DataType type, MemoryMode memMode) {
        this.capacity = capacity;
        this.type = type;
        if (type instanceof ArrayType || type instanceof BinaryType || type instanceof StringType || DecimalType.isByteArrayDecimalType((DataType)type)) {
            DataType childType;
            int childCapacity = capacity;
            if (type instanceof ArrayType) {
                childType = ((ArrayType)type).elementType();
            } else {
                childType = DataTypes.ByteType;
                childCapacity *= 4;
            }
            this.childColumns = new ColumnVector[1];
            this.childColumns[0] = ColumnVector.allocate(childCapacity, childType, memMode);
            this.resultArray = new Array(this.childColumns[0]);
            this.resultStruct = null;
        } else if (type instanceof StructType) {
            StructType st = (StructType)type;
            this.childColumns = new ColumnVector[st.fields().length];
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = ColumnVector.allocate(capacity, st.fields()[i].dataType(), memMode);
            }
            this.resultArray = null;
            this.resultStruct = new ColumnarBatch.Row(this.childColumns);
        } else if (type instanceof CalendarIntervalType) {
            this.childColumns = new ColumnVector[2];
            this.childColumns[0] = ColumnVector.allocate(capacity, DataTypes.IntegerType, memMode);
            this.childColumns[1] = ColumnVector.allocate(capacity, DataTypes.LongType, memMode);
            this.resultArray = null;
            this.resultStruct = new ColumnarBatch.Row(this.childColumns);
        } else {
            this.childColumns = null;
            this.resultArray = null;
            this.resultStruct = null;
        }
    }

    public static final class Array
    extends ArrayData {
        public final ColumnVector data;
        public int length;
        public int offset;
        public byte[] byteArray;
        public int byteArrayOffset;
        protected byte[] tmpByteArray = new byte[1];

        protected Array(ColumnVector data) {
            this.data = data;
        }

        public int numElements() {
            return this.length;
        }

        public ArrayData copy() {
            throw new UnsupportedOperationException();
        }

        public Object[] array() {
            DataType dt = this.data.dataType();
            Object[] list = new Object[this.length];
            if (dt instanceof BooleanType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getBoolean(this.offset + i);
                }
            } else if (dt instanceof ByteType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getByte(this.offset + i);
                }
            } else if (dt instanceof ShortType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getShort(this.offset + i);
                }
            } else if (dt instanceof IntegerType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getInt(this.offset + i);
                }
            } else if (dt instanceof FloatType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = Float.valueOf(this.data.getFloat(this.offset + i));
                }
            } else if (dt instanceof DoubleType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getDouble(this.offset + i);
                }
            } else if (dt instanceof LongType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.data.getLong(this.offset + i);
                }
            } else if (dt instanceof DecimalType) {
                DecimalType decType = (DecimalType)dt;
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.getDecimal(i, decType.precision(), decType.scale());
                }
            } else if (dt instanceof StringType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.getUTF8String(i).toString();
                }
            } else if (dt instanceof CalendarIntervalType) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data.isNullAt(this.offset + i)) continue;
                    list[i] = this.getInterval(i);
                }
            } else {
                throw new UnsupportedOperationException("Type " + dt);
            }
            return list;
        }

        public boolean isNullAt(int ordinal) {
            return this.data.isNullAt(this.offset + ordinal);
        }

        public boolean getBoolean(int ordinal) {
            return this.data.getBoolean(this.offset + ordinal);
        }

        public byte getByte(int ordinal) {
            return this.data.getByte(this.offset + ordinal);
        }

        public short getShort(int ordinal) {
            return this.data.getShort(this.offset + ordinal);
        }

        public int getInt(int ordinal) {
            return this.data.getInt(this.offset + ordinal);
        }

        public long getLong(int ordinal) {
            return this.data.getLong(this.offset + ordinal);
        }

        public float getFloat(int ordinal) {
            return this.data.getFloat(this.offset + ordinal);
        }

        public double getDouble(int ordinal) {
            return this.data.getDouble(this.offset + ordinal);
        }

        public Decimal getDecimal(int ordinal, int precision, int scale) {
            return this.data.getDecimal(this.offset + ordinal, precision, scale);
        }

        public UTF8String getUTF8String(int ordinal) {
            return this.data.getUTF8String(this.offset + ordinal);
        }

        public byte[] getBinary(int ordinal) {
            return this.data.getBinary(this.offset + ordinal);
        }

        public CalendarInterval getInterval(int ordinal) {
            int month = this.data.getChildColumn(0).getInt(this.offset + ordinal);
            long microseconds = this.data.getChildColumn(1).getLong(this.offset + ordinal);
            return new CalendarInterval(month, microseconds);
        }

        public InternalRow getStruct(int ordinal, int numFields) {
            return this.data.getStruct(this.offset + ordinal);
        }

        public ArrayData getArray(int ordinal) {
            return this.data.getArray(this.offset + ordinal);
        }

        public MapData getMap(int ordinal) {
            throw new UnsupportedOperationException();
        }

        public Object get(int ordinal, DataType dataType) {
            throw new UnsupportedOperationException();
        }

        public void update(int ordinal, Object value) {
            throw new UnsupportedOperationException();
        }

        public void setNullAt(int ordinal) {
            throw new UnsupportedOperationException();
        }
    }
}

