/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.compression.AllCompressionSchemes;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionSchemeBenchmark$;
import org.apache.spark.sql.execution.columnar.compression.CompressionSchemeBenchmark$$anonfun$runDecodeBenchmark$2$;
import org.apache.spark.sql.execution.columnar.compression.CompressionSchemeBenchmark$$anonfun$runEncodeBenchmark$2$;
import org.apache.spark.sql.execution.columnar.compression.Decoder;
import org.apache.spark.sql.execution.columnar.compression.Encoder;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

public final class CompressionSchemeBenchmark$
implements AllCompressionSchemes {
    public static final CompressionSchemeBenchmark$ MODULE$;
    private final Seq<CompressionScheme> schemes;

    static {
        new CompressionSchemeBenchmark$();
    }

    public Seq<CompressionScheme> schemes() {
        return this.schemes;
    }

    public void org$apache$spark$sql$execution$columnar$compression$AllCompressionSchemes$_setter_$schemes_$eq(Seq x$1) {
        this.schemes = x$1;
    }

    private ByteBuffer allocateLocal(int size) {
        return ByteBuffer.allocate(size).order(ByteOrder.nativeOrder());
    }

    private Function0<Object> genLowerSkewData() {
        LogNormalDistribution rng = new LogNormalDistribution(0.0, 0.01);
        return new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final LogNormalDistribution rng$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rng$1.sample();
            }
            {
                this.rng$1 = rng$1;
            }
        };
    }

    private Function0<Object> genHigherSkewData() {
        LogNormalDistribution rng = new LogNormalDistribution(0.0, 1.0);
        return new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final LogNormalDistribution rng$2;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rng$2.sample();
            }
            {
                this.rng$2 = rng$2;
            }
        };
    }

    public <T extends AtomicType> Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$prepareEncodeInternal(int count, NativeColumnType<T> tpe, CompressionScheme supportedScheme, ByteBuffer input) {
        Predef$.MODULE$.assert(supportedScheme.supports(tpe));
        Encoder encoder = supportedScheme.encoder(tpe);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(tpe, input, encoder){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType tpe$1;
            private final ByteBuffer input$1;
            private final Encoder encoder$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.encoder$1.gatherCompressibilityStats((InternalRow)CompressionSchemeBenchmark$.MODULE$.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$toRow$1(this.tpe$1.extract(this.input$1)), 0);
            }
            {
                this.tpe$1 = tpe$1;
                this.input$1 = input$1;
                this.encoder$1 = encoder$1;
            }
        });
        input.rewind();
        int compressedSize = encoder.compressedSize() == 0 ? input.remaining() : encoder.compressedSize();
        return new Tuple3((Object)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final Encoder encoder$1;

            public final ByteBuffer apply(ByteBuffer from, ByteBuffer to) {
                return this.encoder$1.compress(from, to);
            }
            {
                this.encoder$1 = encoder$1;
            }
        }, (Object)BoxesRunTime.boxToDouble((double)encoder.compressionRatio()), (Object)this.allocateLocal(4 + compressedSize));
    }

    private <T extends AtomicType> void runEncodeBenchmark(String name, int iters, int count, NativeColumnType<T> tpe, ByteBuffer input) {
        Benchmark benchmark = new Benchmark(name, (long)(iters * count), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        ((IterableLike)this.schemes().filter((Function1)new Serializable(tpe){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType tpe$2;

            public final boolean apply(CompressionScheme x$1) {
                return x$1.supports((ColumnType)this.tpe$2);
            }
            {
                this.tpe$2 = tpe$2;
            }
        })).foreach((Function1)new Serializable(iters, count, tpe, input, benchmark){
            public static final long serialVersionUID = 0L;
            public final int iters$1;
            private final int count$1;
            private final NativeColumnType tpe$2;
            public final ByteBuffer input$2;
            private final Benchmark benchmark$1;

            public final void apply(CompressionScheme scheme) {
                Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> tuple3 = CompressionSchemeBenchmark$.MODULE$.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$prepareEncodeInternal(this.count$1, this.tpe$2, scheme, this.input$2);
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    Function2 compressFunc = (Function2)tuple3._1();
                    double compressionRatio = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    ByteBuffer buf = (ByteBuffer)tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)compressFunc, (Object)BoxesRunTime.boxToDouble((double)compressionRatio), (Object)buf);
                    Function2 compressFunc2 = (Function2)tuple33._1();
                    double compressionRatio2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
                    ByteBuffer buf2 = (ByteBuffer)tuple33._3();
                    String label = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getFormattedClassName((Object)scheme), Predef.StringFormat$.MODULE$.formatted$extension(Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)compressionRatio2)), "%.3f")}));
                    this.benchmark$1.addCase(label, this.benchmark$1.addCase$default$2(), (Function1)new Serializable(this, compressFunc2, buf2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.runEncodeBenchmark.2 $outer;
                        public final Function2 compressFunc$1;
                        public final ByteBuffer buf$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.$outer.iters$1)).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$runEncodeBenchmark$2$$anonfun$apply$1 $outer;

                                public final Buffer apply(long n) {
                                    this.$outer.compressFunc$1.apply((Object)this.$outer.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$anonfun$$anonfun$$$outer().input$2, (Object)this.$outer.buf$1);
                                    this.$outer.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$anonfun$$anonfun$$$outer().input$2.rewind();
                                    return this.$outer.buf$1.rewind();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.runEncodeBenchmark.2 org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compressFunc$1 = compressFunc$1;
                            this.buf$1 = buf$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
                this.tpe$2 = tpe$2;
                this.input$2 = input$2;
                this.benchmark$1 = benchmark$1;
            }
        });
        benchmark.run();
    }

    private <T extends AtomicType> void runDecodeBenchmark(String name, int iters, int count, NativeColumnType<T> tpe, ByteBuffer input) {
        Benchmark benchmark = new Benchmark(name, (long)(iters * count), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        ((IterableLike)this.schemes().filter((Function1)new Serializable(tpe){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType tpe$3;

            public final boolean apply(CompressionScheme x$3) {
                return x$3.supports((ColumnType)this.tpe$3);
            }
            {
                this.tpe$3 = tpe$3;
            }
        })).foreach((Function1)new Serializable(iters, count, tpe, input, benchmark){
            public static final long serialVersionUID = 0L;
            public final int iters$2;
            private final int count$2;
            public final NativeColumnType tpe$3;
            private final ByteBuffer input$3;
            private final Benchmark benchmark$2;

            public final void apply(CompressionScheme scheme) {
                Tuple3<Function2<ByteBuffer, ByteBuffer, ByteBuffer>, Object, ByteBuffer> tuple3 = CompressionSchemeBenchmark$.MODULE$.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$prepareEncodeInternal(this.count$2, this.tpe$3, scheme, this.input$3);
                if (tuple3 != null) {
                    Tuple2 tuple2;
                    Function2 compressFunc = (Function2)tuple3._1();
                    ByteBuffer buf = (ByteBuffer)tuple3._3();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)compressFunc, (Object)buf);
                    Function2 compressFunc2 = (Function2)tuple22._1();
                    ByteBuffer buf2 = (ByteBuffer)tuple22._2();
                    ByteBuffer compressedBuf = (ByteBuffer)compressFunc2.apply((Object)this.input$3, (Object)buf2);
                    String label = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.getFormattedClassName((Object)scheme)}));
                    this.input$3.rewind();
                    this.benchmark$2.addCase(label, this.benchmark$2.addCase$default$2(), (Function1)new Serializable(this, compressedBuf, scheme){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.runDecodeBenchmark.2 $outer;
                        public final ByteBuffer compressedBuf$1;
                        public final CompressionScheme scheme$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            GenericInternalRow rowBuf = new GenericInternalRow(1);
                            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.$outer.iters$2)).foreach((Function1)new Serializable(this, rowBuf){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$runDecodeBenchmark$2$$anonfun$apply$2 $outer;
                                private final GenericInternalRow rowBuf$1;

                                public final void apply(long n) {
                                    this.apply$mcVJ$sp(n);
                                }

                                public void apply$mcVJ$sp(long n) {
                                    this.$outer.compressedBuf$1.rewind().position(4);
                                    Decoder decoder = this.$outer.scheme$1.decoder(this.$outer.compressedBuf$1, this.$outer.org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$anonfun$$anonfun$$$outer().tpe$3);
                                    while (decoder.hasNext()) {
                                        decoder.next((InternalRow)this.rowBuf$1, 0);
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.rowBuf$1 = rowBuf$1;
                                }
                            });
                        }

                        public /* synthetic */ anonfun.runDecodeBenchmark.2 org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compressedBuf$1 = compressedBuf$1;
                            this.scheme$1 = scheme$1;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple3);
            }
            {
                this.iters$2 = iters$2;
                this.count$2 = count$2;
                this.tpe$3 = tpe$3;
                this.input$3 = input$3;
                this.benchmark$2 = benchmark$2;
            }
        });
        benchmark.run();
    }

    public void bitEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * BOOLEAN$.MODULE$.defaultSize());
        Function0<Object> rng = this.genLowerSkewData();
        Serializable g = new Serializable(rng){
            public static final long serialVersionUID = 0L;
            private final Function0 rng$3;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return (byte)((int)this.rng$3.apply$mcD$sp() % 2);
            }
            {
                this.rng$3 = rng$3;
            }
        };
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, (Function0)g){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$1;
            private final Function0 g$1;

            public final ByteBuffer apply(int i) {
                return this.testData$1.put(i * BOOLEAN$.MODULE$.defaultSize(), this.g$1.apply$mcB$sp());
            }
            {
                this.testData$1 = testData$1;
                this.g$1 = g$1;
            }
        });
        this.runEncodeBenchmark("BOOLEAN Encode", iters, count, (NativeColumnType)BOOLEAN$.MODULE$, testData);
        this.runDecodeBenchmark("BOOLEAN Decode", iters, count, (NativeColumnType)BOOLEAN$.MODULE$, testData);
    }

    public void shortEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * SHORT$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g1){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$2;
            private final Function0 g1$1;

            public final ByteBuffer apply(int i) {
                return this.testData$2.putShort(i * SHORT$.MODULE$.defaultSize(), (short)this.g1$1.apply$mcD$sp());
            }
            {
                this.testData$2 = testData$2;
                this.g1$1 = g1$1;
            }
        });
        this.runEncodeBenchmark("SHORT Encode (Lower Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        this.runDecodeBenchmark("SHORT Decode (Lower Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$2;
            private final Function0 g2$1;

            public final ByteBuffer apply(int i) {
                return this.testData$2.putShort(i * SHORT$.MODULE$.defaultSize(), (short)this.g2$1.apply$mcD$sp());
            }
            {
                this.testData$2 = testData$2;
                this.g2$1 = g2$1;
            }
        });
        this.runEncodeBenchmark("SHORT Encode (Higher Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
        this.runDecodeBenchmark("SHORT Decode (Higher Skew)", iters, count, (NativeColumnType)SHORT$.MODULE$, testData);
    }

    public void intEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * INT$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g1){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$3;
            private final Function0 g1$2;

            public final ByteBuffer apply(int i) {
                return this.testData$3.putInt(i * INT$.MODULE$.defaultSize(), (int)this.g1$2.apply$mcD$sp());
            }
            {
                this.testData$3 = testData$3;
                this.g1$2 = g1$2;
            }
        });
        this.runEncodeBenchmark("INT Encode (Lower Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        this.runDecodeBenchmark("INT Decode (Lower Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$3;
            private final Function0 g2$2;

            public final ByteBuffer apply(int i) {
                return this.testData$3.putInt(i * INT$.MODULE$.defaultSize(), (int)this.g2$2.apply$mcD$sp());
            }
            {
                this.testData$3 = testData$3;
                this.g2$2 = g2$2;
            }
        });
        this.runEncodeBenchmark("INT Encode (Higher Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
        this.runDecodeBenchmark("INT Decode (Higher Skew)", iters, count, (NativeColumnType)INT$.MODULE$, testData);
    }

    public void longEncodingBenchmark(int iters) {
        int count = 65536;
        ByteBuffer testData = this.allocateLocal(count * LONG$.MODULE$.defaultSize());
        Function0<Object> g1 = this.genLowerSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g1){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$4;
            private final Function0 g1$3;

            public final ByteBuffer apply(int i) {
                return this.testData$4.putLong(i * LONG$.MODULE$.defaultSize(), (long)this.g1$3.apply$mcD$sp());
            }
            {
                this.testData$4 = testData$4;
                this.g1$3 = g1$3;
            }
        });
        this.runEncodeBenchmark("LONG Encode (Lower Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        this.runDecodeBenchmark("LONG Decode (Lower Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        Function0<Object> g2 = this.genHigherSkewData();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(testData, g2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer testData$4;
            private final Function0 g2$3;

            public final ByteBuffer apply(int i) {
                return this.testData$4.putLong(i * LONG$.MODULE$.defaultSize(), (long)this.g2$3.apply$mcD$sp());
            }
            {
                this.testData$4 = testData$4;
                this.g2$3 = g2$3;
            }
        });
        this.runEncodeBenchmark("LONG Encode (Higher Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
        this.runDecodeBenchmark("LONG Decode (Higher Skew)", iters, count, (NativeColumnType)LONG$.MODULE$, testData);
    }

    public void stringEncodingBenchmark(int iters) {
        int count = 65536;
        int strLen = 8;
        int tableSize = 16;
        ByteBuffer testData = this.allocateLocal(count * (4 + strLen));
        IndexedSeq dataTable = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tableSize).map((Function1)new Serializable(strLen){
            public static final long serialVersionUID = 0L;
            private final int strLen$1;

            public final String apply(int x$5) {
                return RandomStringUtils.randomAlphabetic((int)this.strLen$1);
            }
            {
                this.strLen$1 = strLen$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Function0<Object> rng = this.genHigherSkewData();
        Serializable g = new Serializable(tableSize, dataTable, rng){
            public static final long serialVersionUID = 0L;
            private final int tableSize$1;
            private final IndexedSeq dataTable$1;
            private final Function0 rng$4;

            public final String apply() {
                return (String)this.dataTable$1.apply((int)this.rng$4.apply$mcD$sp() % this.tableSize$1);
            }
            {
                this.tableSize$1 = tableSize$1;
                this.dataTable$1 = dataTable$1;
                this.rng$4 = rng$4;
            }
        };
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)new Serializable(strLen, testData, (Function0)g){
            public static final long serialVersionUID = 0L;
            private final int strLen$1;
            private final ByteBuffer testData$5;
            private final Function0 g$2;

            public final ByteBuffer apply(int i) {
                this.testData$5.putInt(this.strLen$1);
                return this.testData$5.put(((String)this.g$2.apply()).getBytes(StandardCharsets.UTF_8));
            }
            {
                this.strLen$1 = strLen$1;
                this.testData$5 = testData$5;
                this.g$2 = g$2;
            }
        });
        testData.rewind();
        this.runEncodeBenchmark("STRING Encode", iters, count, (NativeColumnType)STRING$.MODULE$, testData);
        this.runDecodeBenchmark("STRING Decode", iters, count, (NativeColumnType)STRING$.MODULE$, testData);
    }

    public void main(String[] args) {
        this.bitEncodingBenchmark(1024);
        this.shortEncodingBenchmark(1024);
        this.intEncodingBenchmark(1024);
        this.longEncodingBenchmark(1024);
        this.stringEncodingBenchmark(1024);
    }

    public final GenericInternalRow org$apache$spark$sql$execution$columnar$compression$CompressionSchemeBenchmark$$toRow$1(Object d) {
        return new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d}), ClassTag$.MODULE$.Any()));
    }

    private CompressionSchemeBenchmark$() {
        MODULE$ = this;
        AllCompressionSchemes.class.$init$((AllCompressionSchemes)this);
    }
}

