/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\t1\"+\u001e8MK:<G\u000f[#oG>$\u0017N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Y1m\\7qe\u0016\u001c8/[8o\u0015\t)a!\u0001\u0005d_2,XN\\1s\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\tQ\u0002!D\u0001\u0003\u0011\u001da\u0002A1A\u0005\u0002u\t\u0011B\\;mYZ\u000bG.^3\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u00121!\u00138u\u0011\u0019)\u0003\u0001)A\u0005=\u0005Qa.\u001e7m-\u0006dW/\u001a\u0011\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002+Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oOV\u0011\u0011F\u000f\u000b\u0005U5\u001ad\t\u0005\u0002 W%\u0011A\u0006\t\u0002\u0005+:LG\u000fC\u0003/M\u0001\u0007q&A\u0006d_2,XN\\*uCR\u001c\bC\u0001\u00192\u001b\u0005!\u0011B\u0001\u001a\u0005\u0005-\u0019u\u000e\\;n]N#\u0018\r^:\t\u000bQ2\u0003\u0019A\u001b\u0002\u0015\r|G.^7o)f\u0004X\rE\u00021maJ!a\u000e\u0003\u0003!9\u000bG/\u001b<f\u0007>dW/\u001c8UsB,\u0007CA\u001d;\u0019\u0001!Qa\u000f\u0014C\u0002q\u0012\u0011\u0001V\t\u0003{\u0001\u0003\"a\b \n\u0005}\u0002#a\u0002(pi\"Lgn\u001a\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\tQ\u0001^=qKNL!!\u0012\"\u0003\u0015\u0005#x.\\5d)f\u0004X\rC\u0004HMA\u0005\t\u0019\u0001%\u0002\u001dQ,7\u000f\u001e#fG>l\u0007O]3tgB\u0011q$S\u0005\u0003\u0015\u0002\u0012qAQ8pY\u0016\fg\u000eC\u0004M\u0001E\u0005I\u0011A'\u0002?Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oO\u0012\"WMZ1vYR$3'\u0006\u0002O3V\tqJ\u000b\u0002I!.\n\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003-\u0002\n!\"\u00198o_R\fG/[8o\u0013\tA6KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$QaO&C\u0002q\u0002")
public class RunLengthEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testRunLengthEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": run length == 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": single long run"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty column for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeletonForDecompress$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))})), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": single long run for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeletonForDecompress$1(1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000))})), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": single case with null for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RunLengthEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RunLengthEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.$outer.nullValue())), (Object)BoxesRunTime.boxToInteger((int)2))})), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    public <T extends AtomicType> boolean testRunLengthEncoding$default$3() {
        return true;
    }

    public final void org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeleton$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq inputSeq = (Seq)inputRuns.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Seq<Object> apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        Seq seq = (Seq)Seq$.MODULE$.fill(run2, (Function0)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final int index$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.index$1;
                            }
                            {
                                this.index$1 = index$1;
                            }
                        });
                        return seq;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            inputSeq.foreach((Function1)new Serializable(this, builder, rows2){
                public static final long serialVersionUID = 0L;
                private final TestCompressibleColumnBuilder builder$1;
                private final Seq rows$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.builder$1.appendFrom((InternalRow)this.rows$1.apply(i), 0);
                }
                {
                    this.builder$1 = builder$1;
                    this.rows$1 = rows$1;
                }
            });
            ByteBuffer buffer = builder.build();
            int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
            int compressedSize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputRuns.map((Function1)new Serializable(this, columnType$1, rows2){
                public static final long serialVersionUID = 0L;
                private final NativeColumnType columnType$1;
                private final Seq rows$1;

                public final int apply(Tuple2<Object, Object> x0$2) {
                    Tuple2<Object, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int n = this.columnType$1.actualSize((InternalRow)this.rows$1.apply(index), 0) + 4;
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.columnType$1 = columnType$1;
                    this.rows$1 = rows$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
            buffer.position(headerSize);
            this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
            inputRuns.foreach((Function1)new Serializable(this, columnType$1, values2, buffer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RunLengthEncodingSuite $outer;
                private final NativeColumnType columnType$1;
                private final Seq values$1;
                private final ByteBuffer buffer$1;

                public final Assertion apply(Tuple2<Object, Object> x0$3) {
                    Tuple2<Object, Object> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int index = tuple2._1$mcI$sp();
                        int run2 = tuple2._2$mcI$sp();
                        this.$outer.assertResult(this.values$1.apply(index), "Wrong column element value", this.columnType$1.extract(this.buffer$1), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                        Assertion assertion = this.$outer.assertResult(BoxesRunTime.boxToInteger((int)run2), "Wrong run length", BoxesRunTime.boxToInteger((int)this.buffer$1.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                        return assertion;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.columnType$1 = columnType$1;
                    this.values$1 = values$1;
                    this.buffer$1 = buffer$1;
                }
            });
            buffer.rewind().position(headerSize + 4);
            RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
            GenericInternalRow mutableRow = new GenericInternalRow(1);
            if (inputSeq.nonEmpty()) {
                inputSeq.foreach((Function1)new Serializable(this, columnType$1, values2, decoder, mutableRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RunLengthEncodingSuite $outer;
                    private final NativeColumnType columnType$1;
                    private final Seq values$1;
                    private final RunLengthEncoding.Decoder decoder$1;
                    private final GenericInternalRow mutableRow$1;

                    public final Assertion apply(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
                        Object object = this.values$1.apply(i);
                        this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                        return this.$outer.assertResult(object, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.columnType$1 = columnType$1;
                        this.values$1 = values$1;
                        this.decoder$1 = decoder$1;
                        this.mutableRow$1 = mutableRow$1;
                    }
                });
            }
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            return;
        }
        throw new MatchError(tuple2);
    }

    public final void org$apache$spark$sql$execution$columnar$compression$RunLengthEncodingSuite$$skeletonForDecompress$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1, boolean testDecompress$1) {
        if (testDecompress$1) {
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
            Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Seq values = (Seq)tuple2._1();
                Seq rows = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
                Seq values2 = (Seq)tuple23._1();
                Seq rows2 = (Seq)tuple23._2();
                Seq inputSeq = (Seq)inputRuns.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(Tuple2<Object, Object> x0$4) {
                        Tuple2<Object, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int index = tuple2._1$mcI$sp();
                            int run2 = tuple2._2$mcI$sp();
                            Seq seq = (Seq)Seq$.MODULE$.fill(run2, (Function0)new Serializable(this, index){
                                public static final long serialVersionUID = 0L;
                                private final int index$2;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return this.index$2;
                                }
                                {
                                    this.index$2 = index$2;
                                }
                            });
                            return seq;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                GenericInternalRow nullRow = new GenericInternalRow(1);
                nullRow.setNullAt(0);
                inputSeq.foreach((Function1)new Serializable(this, builder, rows2, nullRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RunLengthEncodingSuite $outer;
                    private final TestCompressibleColumnBuilder builder$2;
                    private final Seq rows$2;
                    private final GenericInternalRow nullRow$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (i == this.$outer.nullValue()) {
                            this.builder$2.appendFrom((InternalRow)this.nullRow$1, 0);
                        } else {
                            this.builder$2.appendFrom((InternalRow)this.rows$2.apply(i), 0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$2 = builder$2;
                        this.rows$2 = rows$2;
                        this.nullRow$1 = nullRow$1;
                    }
                });
                ByteBuffer buffer = builder.build();
                int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
                buffer.position(headerSize);
                this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
                OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), (DataType)columnType$1.dataType());
                decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
                if (inputSeq.nonEmpty()) {
                    ((IterableLike)inputSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, columnType$1, values2, columnVector){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ RunLengthEncodingSuite $outer;
                        private final NativeColumnType columnType$1;
                        private final Seq values$2;
                        private final OnHeapColumnVector columnVector$1;

                        public final Assertion apply(Tuple2<Object, Object> x0$5) {
                            block4: {
                                block10: {
                                    Assertion assertion;
                                    block3: {
                                        Assertion assertion2;
                                        block6: {
                                            NativeColumnType nativeColumnType;
                                            int n;
                                            int n2;
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block5: {
                                                            Tuple2<Object, Object> tuple2;
                                                            block2: {
                                                                tuple2 = x0$5;
                                                                if (tuple2 == null) break block2;
                                                                int expected2 = tuple2._1$mcI$sp();
                                                                int index = tuple2._2$mcI$sp();
                                                                int n3 = expected2;
                                                                int n4 = index;
                                                                if (n3 != this.$outer.nullValue()) break block2;
                                                                assertion = this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong null ", "th-position"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n4)})), BoxesRunTime.boxToBoolean((boolean)this.columnVector$1.isNullAt(n4)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                                                                break block3;
                                                            }
                                                            if (tuple2 == null) break block4;
                                                            int i = tuple2._1$mcI$sp();
                                                            int index = tuple2._2$mcI$sp();
                                                            n2 = i;
                                                            n = index;
                                                            nativeColumnType = this.columnType$1;
                                                            if (!BOOLEAN$.MODULE$.equals(nativeColumnType)) break block5;
                                                            assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded boolean value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToBoolean((boolean)this.columnVector$1.getBoolean(n)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                                                            break block6;
                                                        }
                                                        if (!BYTE$.MODULE$.equals(nativeColumnType)) break block7;
                                                        assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded byte value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToByte((byte)this.columnVector$1.getByte(n)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                                                        break block6;
                                                    }
                                                    if (!SHORT$.MODULE$.equals(nativeColumnType)) break block8;
                                                    assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded short value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToShort((short)this.columnVector$1.getShort(n)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                                                    break block6;
                                                }
                                                if (!INT$.MODULE$.equals(nativeColumnType)) break block9;
                                                assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded int value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToInteger((int)this.columnVector$1.getInt(n)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                                                break block6;
                                            }
                                            if (!LONG$.MODULE$.equals(nativeColumnType)) break block10;
                                            assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded long value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToLong((long)this.columnVector$1.getLong(n)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                                        }
                                        assertion = assertion2;
                                    }
                                    return assertion;
                                }
                                throw this.$outer.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                            }
                            throw this.$outer.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.columnType$1 = columnType$1;
                            this.values$2 = values$2;
                            this.columnVector$1 = columnVector$1;
                        }
                    });
                }
                return;
            }
            throw new MatchError(tuple2);
        }
    }

    public RunLengthEncodingSuite() {
        this.nullValue = -1;
        this.testRunLengthEncoding((ColumnStats)new NoopColumnStats(), (NativeColumnType)BOOLEAN$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

