/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.security.CryptoStreamUtils$;
import org.apache.spark.security.EncryptionFunSuite;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.DiskRowQueue;
import org.apache.spark.sql.execution.python.HybridRowQueue;
import org.apache.spark.sql.execution.python.InMemoryRowQueue;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001\u001f\ti!k\\<Rk\u0016,XmU;ji\u0016T!a\u0001\u0003\u0002\rALH\u000f[8o\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000b\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u0005A1/Z2ve&$\u00180\u0003\u0002\u001a-\t\u0011RI\\2ssB$\u0018n\u001c8Gk:\u001cV/\u001b;f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011%\u0011%A\fde\u0016\fG/Z*fe&\fG.\u001b>fe6\u000bg.Y4feR\u0011!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K!\t!b]3sS\u0006d\u0017N_3s\u0013\t9CEA\tTKJL\u0017\r\\5{KJl\u0015M\\1hKJDQ!K\u0010A\u0002)\nAaY8oMB\u0011\u0011cK\u0005\u0003Y!\u0011\u0011b\u00159be.\u001cuN\u001c4")
public class RowQueueSuite
extends SparkFunSuite
implements EncryptionFunSuite {
    public final void encryptionTest(String name, Function1<SparkConf, BoxedUnit> fn) {
        EncryptionFunSuite.class.encryptionTest((SparkFunSuite)this, (String)name, fn);
    }

    public SerializerManager org$apache$spark$sql$execution$python$RowQueueSuite$$createSerializerManager(SparkConf conf) {
        None$ ioEncryptionKey = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_ENCRYPTION_ENABLED())) ? new Some((Object)CryptoStreamUtils$.MODULE$.createKey(conf)) : None$.MODULE$;
        return new SerializerManager((Serializer)new JavaSerializer(conf), conf, (Option)ioEncryptionKey);
    }

    public RowQueueSuite() {
        EncryptionFunSuite.class.$init$((SparkFunSuite)this);
        this.test("in-memory queue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemoryBlock page = MemoryBlock.fromLongArray((long[])new long[1024]);
                InMemoryRowQueue queue = new InMemoryRowQueue(this, page){

                    public void close() {
                    }
                };
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                long n = page.size() / (long)(4 + row.getSizeInBytes());
                int i = 0;
                while ((long)i < n) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                    ++i;
                }
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should not add more", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
                i = 0;
                while ((long)i < n) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                    Object var13_12 = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, unsafeRow != null ? !unsafeRow.equals(var13_12) : var13_12 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"fail to poll", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
                    long $org_scalatest_assert_macro_left2 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right2 = i;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"does not match", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
                    ++i;
                }
                UnsafeRow $org_scalatest_assert_macro_left = queue.remove();
                Object $org_scalatest_assert_macro_right = null;
                UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                Object var21_18 = null;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(unsafeRow != null ? !unsafeRow.equals(var21_18) : var21_18 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should be empty", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        this.encryptionTest("disk queue", (Function1<SparkConf, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply(SparkConf conf) {
                UnsafeRow first;
                int i;
                SerializerManager serManager = this.$outer.org$apache$spark$sql$execution$python$RowQueueSuite$$createSerializerManager(conf);
                File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
                dir.mkdirs();
                DiskRowQueue queue = new DiskRowQueue(new File(dir, "buffer"), 1, serManager);
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                int n = 1000;
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                }
                UnsafeRow $org_scalatest_assert_macro_left = first = queue.remove();
                Object $org_scalatest_assert_macro_right = null;
                UnsafeRow unsafeRow = $org_scalatest_assert_macro_left;
                Object var13_12 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, unsafeRow != null ? !unsafeRow.equals(var13_12) : var13_12 != null, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"first should not be null", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                long $org_scalatest_assert_macro_left2 = first.getLong(0);
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"first should be 0", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not add more", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                for (i = 1; i < n; ++i) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left3 = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right3 = null;
                    UnsafeRow unsafeRow2 = $org_scalatest_assert_macro_left3;
                    Object var23_22 = null;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", null, unsafeRow2 != null ? !unsafeRow2.equals(var23_22) : var23_22 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"fail to poll", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
                    long $org_scalatest_assert_macro_left4 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right4 = i;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == (long)$org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"does not match", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
                }
                UnsafeRow $org_scalatest_assert_macro_left5 = queue.remove();
                Object $org_scalatest_assert_macro_right5 = null;
                UnsafeRow unsafeRow3 = $org_scalatest_assert_macro_left5;
                Object var31_28 = null;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", null, !(unsafeRow3 != null ? !unsafeRow3.equals(var31_28) : var31_28 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"should be empty", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.encryptionTest("hybrid queue", (Function1<SparkConf, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RowQueueSuite $outer;

            public final void apply(SparkConf conf) {
                int i;
                SerializerManager serManager = this.$outer.org$apache$spark$sql$execution$python$RowQueueSuite$$createSerializerManager(conf);
                TestMemoryManager mem = new TestMemoryManager(conf);
                mem.limit(4096L);
                TaskMemoryManager taskM = new TaskMemoryManager((MemoryManager)mem, 0L);
                HybridRowQueue queue = new HybridRowQueue(taskM, Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile(), 1, serManager);
                UnsafeRow row = new UnsafeRow(1);
                row.pointTo(new byte[16], 16);
                int n = 768;
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"fail to add", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
                }
                int $org_scalatest_assert_macro_left = queue.numQueues();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should have more than one queue", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                queue.spill(0x100000L, null);
                for (i = 0; i < n; ++i) {
                    UnsafeRow row2;
                    UnsafeRow $org_scalatest_assert_macro_left2 = row2 = queue.remove();
                    Object $org_scalatest_assert_macro_right2 = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left2;
                    Object var17_17 = null;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", null, unsafeRow != null ? !unsafeRow.equals(var17_17) : var17_17 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"fail to poll", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                    long $org_scalatest_assert_macro_left3 = row2.getLong(0);
                    int $org_scalatest_assert_macro_right3 = i;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"does not match", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                }
                for (i = 0; i < n; ++i) {
                    row.setLong(0, (long)i);
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(queue.add(row), "queue.add(row)", Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"fail to add", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                }
                int $org_scalatest_assert_macro_left4 = queue.numQueues();
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should have more than one queue", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                queue.spill(0x100000L, null);
                int $org_scalatest_assert_macro_left5 = queue.numQueues();
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 > $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"should have more than one queue", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                for (i = 0; i < n; ++i) {
                    UnsafeRow row3;
                    UnsafeRow $org_scalatest_assert_macro_left6 = row3 = queue.remove();
                    Object $org_scalatest_assert_macro_right6 = null;
                    UnsafeRow unsafeRow = $org_scalatest_assert_macro_left6;
                    Object var33_32 = null;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!=", null, unsafeRow != null ? !unsafeRow.equals(var33_32) : var33_32 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"fail to poll", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                    long $org_scalatest_assert_macro_left7 = row3.getLong(0);
                    int $org_scalatest_assert_macro_right7 = i;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == (long)$org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"does not match", Prettifier$.MODULE$.default(), new Position("RowQueueSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                }
                queue.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

