/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.vectorized.ColumnarBatchBenchmark$;
import org.apache.spark.sql.execution.vectorized.OffHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.collection.BitSet;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class ColumnarBatchBenchmark$ {
    public static final ColumnarBatchBenchmark$ MODULE$;

    static {
        new ColumnarBatchBenchmark$();
    }

    public void intAccess(long iters) {
        int count = 8000;
        Serializable javaArray = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int[] data = new int[this.count$1];
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, data, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final int[] data$1;
                    private final LongRef sum$1;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.data$1[i] = i;
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$1.elem += (long)this.data$1[i];
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$1 = data$1;
                        this.sum$1 = sum$1;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable byteBufferUnsafe = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBuffer data = ByteBuffer.allocate(this.count$1 * 4);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, data, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;
                    private final ByteBuffer data$2;
                    private final LongRef sum$2;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            Platform.putInt((Object)this.data$2.array(), (long)(Platform.BYTE_ARRAY_OFFSET + i * 4), (int)i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$2.elem += (long)Platform.getInt((Object)this.data$2.array(), (long)(Platform.BYTE_ARRAY_OFFSET + i * 4));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$2 = data$2;
                        this.sum$2 = sum$2;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable directByteBuffer = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                IntBuffer data = ByteBuffer.allocateDirect(this.count$1 * 4).asIntBuffer();
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, data, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final IntBuffer data$3;
                    private final LongRef sum$3;

                    public final Buffer apply(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.data$3.put(i);
                        }
                        this.data$3.rewind();
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$3.elem += (long)this.data$3.get();
                        }
                        return this.data$3.rewind();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$3 = data$3;
                        this.sum$3 = sum$3;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable byteBufferApi = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                ByteBuffer data = ByteBuffer.allocate(this.count$1 * 4);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, data, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;
                    private final ByteBuffer data$4;
                    private final LongRef sum$4;

                    public final Buffer apply(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.data$4.putInt(i);
                        }
                        this.data$4.rewind();
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$4.elem += (long)this.data$4.getInt();
                        }
                        return this.data$4.rewind();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$4 = data$4;
                        this.sum$4 = sum$4;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable unsafeBuffer = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long data = Platform.allocateMemory((long)(this.count$1 * 4));
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, data, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;
                    private final long data$5;
                    private final LongRef sum$5;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        long ptr = this.data$5;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            Platform.putInt(null, (long)ptr, (int)i);
                            ptr += 4L;
                        }
                        ptr = this.data$5;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$5.elem += (long)Platform.getInt(null, (long)ptr);
                            ptr += 4L;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$5 = data$5;
                        this.sum$5 = sum$5;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable columnOnHeap = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                OnHeapColumnVector col = new OnHeapColumnVector(this.count$1, (DataType)IntegerType$.MODULE$);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, col, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.6 $outer;
                    private final OnHeapColumnVector col$1;
                    private final LongRef sum$6;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.col$1.putInt(i, i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$6.elem += (long)this.col$1.getInt(i);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$1 = col$1;
                        this.sum$6 = sum$6;
                    }
                });
                col.close();
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable columnOffheapDirect = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                OffHeapColumnVector col = new OffHeapColumnVector(this.count$1, (DataType)IntegerType$.MODULE$);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, col, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.7 $outer;
                    private final OffHeapColumnVector col$3;
                    private final LongRef sum$8;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        long addr = this.col$3.valuesNativeAddress();
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            Platform.putInt(null, (long)addr, (int)i);
                            addr += 4L;
                        }
                        addr = this.col$3.valuesNativeAddress();
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$8.elem += (long)Platform.getInt(null, (long)addr);
                            addr += 4L;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$3 = col$3;
                        this.sum$8 = sum$8;
                    }
                });
                col.close();
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable unsafeRowOnheap = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                byte[] buffer = new byte[this.count$1 * 16];
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, buffer, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.8 $outer;
                    private final byte[] buffer$1;
                    private final LongRef sum$9;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        UnsafeRow row = new UnsafeRow(1);
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            row.pointTo((Object)this.buffer$1, (long)(Platform.BYTE_ARRAY_OFFSET + i * 16), 16);
                            row.setInt(0, i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            row.pointTo((Object)this.buffer$1, (long)(Platform.BYTE_ARRAY_OFFSET + i * 16), 16);
                            this.sum$9.elem += (long)row.getInt(0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer$1 = buffer$1;
                        this.sum$9 = sum$9;
                    }
                });
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable unsafeRowOffheap = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long buffer = Platform.allocateMemory((long)(this.count$1 * 16));
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, buffer, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.9 $outer;
                    private final long buffer$2;
                    private final LongRef sum$10;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        UnsafeRow row = new UnsafeRow(1);
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            row.pointTo(null, this.buffer$2 + (long)(i * 16), 16);
                            row.setInt(0, i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            row.pointTo(null, this.buffer$2 + (long)(i * 16), 16);
                            this.sum$10.elem += (long)row.getInt(0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer$2 = buffer$2;
                        this.sum$10 = sum$10;
                    }
                });
                Platform.freeMemory((long)buffer);
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Serializable onHeapAppend = new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                OnHeapColumnVector col = new OnHeapColumnVector(this.count$1, (DataType)IntegerType$.MODULE$);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, col, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.10 $outer;
                    private final OnHeapColumnVector col$4;
                    private final LongRef sum$11;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.col$4.appendInt(i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$11.elem += (long)this.col$4.getInt(i);
                        }
                        this.col$4.reset();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$4 = col$4;
                        this.sum$11 = sum$11;
                    }
                });
                col.close();
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
        Benchmark benchmark = new Benchmark("Int Read/Write", (long)count * iters, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Java Array", benchmark.addCase$default$2(), (Function1)javaArray);
        benchmark.addCase("ByteBuffer Unsafe", benchmark.addCase$default$2(), (Function1)byteBufferUnsafe);
        benchmark.addCase("ByteBuffer API", benchmark.addCase$default$2(), (Function1)byteBufferApi);
        benchmark.addCase("DirectByteBuffer", benchmark.addCase$default$2(), (Function1)directByteBuffer);
        benchmark.addCase("Unsafe Buffer", benchmark.addCase$default$2(), (Function1)unsafeBuffer);
        benchmark.addCase("Column(on heap)", benchmark.addCase$default$2(), (Function1)columnOnHeap);
        benchmark.addCase("Column(off heap)", benchmark.addCase$default$2(), this.columnOffHeap$1(iters, count));
        benchmark.addCase("Column(off heap direct)", benchmark.addCase$default$2(), (Function1)columnOffheapDirect);
        benchmark.addCase("UnsafeRow (on heap)", benchmark.addCase$default$2(), (Function1)unsafeRowOnheap);
        benchmark.addCase("UnsafeRow (off heap)", benchmark.addCase$default$2(), (Function1)unsafeRowOffheap);
        benchmark.addCase("Column On Heap Append", benchmark.addCase$default$2(), (Function1)onHeapAppend);
        benchmark.run();
    }

    public void booleanAccess(int iters) {
        int count = 8192;
        Benchmark benchmark = new Benchmark("Boolean Read/Write", (long)(iters * count), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Bitset", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final int iters$2;
            public final int count$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                BitSet b = new BitSet(this.count$2);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$2)).foreach((Function1)new Serializable(this, b, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.booleanAccess.1 $outer;
                    private final BitSet b$1;
                    private final LongRef sum$12;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$2; ++i) {
                            if (i % 2 != 0) continue;
                            this.b$1.set(i);
                        }
                        for (i = 0; i < this.$outer.count$2; ++i) {
                            if (!this.b$1.get(i)) continue;
                            ++this.sum$12.elem;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$1 = b$1;
                        this.sum$12 = sum$12;
                    }
                });
            }
            {
                this.iters$2 = iters$2;
                this.count$2 = count$2;
            }
        });
        benchmark.addCase("Byte Array", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count){
            public static final long serialVersionUID = 0L;
            private final int iters$2;
            public final int count$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                byte[] b = new byte[this.count$2];
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$2)).foreach((Function1)new Serializable(this, b, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.booleanAccess.2 $outer;
                    private final byte[] b$2;
                    private final LongRef sum$13;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$2; ++i) {
                            if (i % 2 != 0) continue;
                            this.b$2[i] = 1;
                        }
                        for (i = 0; i < this.$outer.count$2; ++i) {
                            if (this.b$2[i] != 1) continue;
                            ++this.sum$13.elem;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.b$2 = b$2;
                        this.sum$13 = sum$13;
                    }
                });
            }
            {
                this.iters$2 = iters$2;
                this.count$2 = count$2;
            }
        });
        benchmark.run();
    }

    public void stringAccess(long iters) {
        String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random random = new Random(0);
        int minString = 3;
        int maxString = 32;
        int count = 4000;
        byte[][] data = (byte[][])((TraversableOnce)((TraversableLike)Seq$.MODULE$.fill(count, (Function0)new Serializable(chars, random, minString, maxString){
            public static final long serialVersionUID = 0L;
            private final String chars$1;
            private final Random random$1;
            private final int minString$1;
            private final int maxString$1;

            public final String apply() {
                return ColumnarBatchBenchmark$.MODULE$.org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$randomString$1(this.minString$1, this.maxString$1, this.chars$1, this.random$1);
            }
            {
                this.chars$1 = chars$1;
                this.random$1 = random$1;
                this.minString$1 = minString$1;
                this.maxString$1 = maxString$1;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(String x$1) {
                return x$1.getBytes(StandardCharsets.UTF_8);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Benchmark benchmark = new Benchmark("String Read/Write", (long)count * iters, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("On Heap", benchmark.addCase$default$2(), this.column$1(MemoryMode.ON_HEAP, iters, count, data));
        benchmark.addCase("Off Heap", benchmark.addCase$default$2(), this.column$1(MemoryMode.OFF_HEAP, iters, count, data));
        benchmark.run();
    }

    public void arrayAccess(int iters) {
        Random random = new Random(0);
        int count = 4000;
        OnHeapColumnVector onHeapVector = new OnHeapColumnVector(count, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        OffHeapColumnVector offHeapVector = new OffHeapColumnVector(count, (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$));
        int minSize = 3;
        int maxSize = 32;
        int elementsCount = 0;
        for (int arraysCount = 0; arraysCount < count; ++arraysCount) {
            int size = random.nextInt(maxSize - minSize) + minSize;
            WritableColumnVector onHeapArrayData = onHeapVector.arrayData();
            WritableColumnVector offHeapArrayData = offHeapVector.arrayData();
            for (int i = 0; i < size; ++i) {
                int value = random.nextInt();
                onHeapArrayData.appendInt(value);
                offHeapArrayData.appendInt(value);
            }
            onHeapVector.putArray(arraysCount, elementsCount, size);
            offHeapVector.putArray(arraysCount, elementsCount, size);
            elementsCount += size;
        }
        Benchmark benchmark = new Benchmark("Array Vector Read", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("On Heap Read Size Only", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count, onHeapVector, offHeapVector){
            public static final long serialVersionUID = 0L;
            private final int iters$4;
            private final int count$4;
            private final OnHeapColumnVector onHeapVector$1;
            private final OffHeapColumnVector offHeapVector$1;

            public final void apply(int x$2) {
                this.apply$mcVI$sp(x$2);
            }

            public void apply$mcVI$sp(int x$2) {
                ColumnarBatchBenchmark$.MODULE$.org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrays$1(true, this.iters$4, this.count$4, this.onHeapVector$1, this.offHeapVector$1);
            }
            {
                this.iters$4 = iters$4;
                this.count$4 = count$4;
                this.onHeapVector$1 = onHeapVector$1;
                this.offHeapVector$1 = offHeapVector$1;
            }
        });
        benchmark.addCase("Off Heap Read Size Only", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count, onHeapVector, offHeapVector){
            public static final long serialVersionUID = 0L;
            private final int iters$4;
            private final int count$4;
            private final OnHeapColumnVector onHeapVector$1;
            private final OffHeapColumnVector offHeapVector$1;

            public final void apply(int x$3) {
                this.apply$mcVI$sp(x$3);
            }

            public void apply$mcVI$sp(int x$3) {
                ColumnarBatchBenchmark$.MODULE$.org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrays$1(false, this.iters$4, this.count$4, this.onHeapVector$1, this.offHeapVector$1);
            }
            {
                this.iters$4 = iters$4;
                this.count$4 = count$4;
                this.onHeapVector$1 = onHeapVector$1;
                this.offHeapVector$1 = offHeapVector$1;
            }
        });
        benchmark.addCase("On Heap Read Elements", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count, onHeapVector, offHeapVector){
            public static final long serialVersionUID = 0L;
            private final int iters$4;
            private final int count$4;
            private final OnHeapColumnVector onHeapVector$1;
            private final OffHeapColumnVector offHeapVector$1;

            public final void apply(int x$4) {
                this.apply$mcVI$sp(x$4);
            }

            public void apply$mcVI$sp(int x$4) {
                ColumnarBatchBenchmark$.MODULE$.org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrayElements$1(true, this.iters$4, this.count$4, this.onHeapVector$1, this.offHeapVector$1);
            }
            {
                this.iters$4 = iters$4;
                this.count$4 = count$4;
                this.onHeapVector$1 = onHeapVector$1;
                this.offHeapVector$1 = offHeapVector$1;
            }
        });
        benchmark.addCase("Off Heap Read Elements", benchmark.addCase$default$2(), (Function1)new Serializable(iters, count, onHeapVector, offHeapVector){
            public static final long serialVersionUID = 0L;
            private final int iters$4;
            private final int count$4;
            private final OnHeapColumnVector onHeapVector$1;
            private final OffHeapColumnVector offHeapVector$1;

            public final void apply(int x$5) {
                this.apply$mcVI$sp(x$5);
            }

            public void apply$mcVI$sp(int x$5) {
                ColumnarBatchBenchmark$.MODULE$.org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrayElements$1(false, this.iters$4, this.count$4, this.onHeapVector$1, this.offHeapVector$1);
            }
            {
                this.iters$4 = iters$4;
                this.count$4 = count$4;
                this.onHeapVector$1 = onHeapVector$1;
                this.offHeapVector$1 = offHeapVector$1;
            }
        });
        benchmark.run();
    }

    public void main(String[] args) {
        this.intAccess(40960L);
        this.booleanAccess(40960);
        this.stringAccess(4096L);
        this.arrayAccess(40960);
    }

    private final Function1 columnOffHeap$1(long iters$1, int count$1) {
        return new Serializable(iters$1, count$1){
            public static final long serialVersionUID = 0L;
            private final long iters$1;
            public final int count$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                OffHeapColumnVector col = new OffHeapColumnVector(this.count$1, (DataType)IntegerType$.MODULE$);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$1)).foreach((Function1)new Serializable(this, col, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.columnOffHeap.1.1 $outer;
                    private final OffHeapColumnVector col$2;
                    private final LongRef sum$7;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.col$2.putInt(i, i);
                        }
                        for (i = 0; i < this.$outer.count$1; ++i) {
                            this.sum$7.elem += (long)this.col$2.getInt(i);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.col$2 = col$2;
                        this.sum$7 = sum$7;
                    }
                });
                col.close();
            }
            {
                this.iters$1 = iters$1;
                this.count$1 = count$1;
            }
        };
    }

    public final String org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$randomString$1(int min, int max, String chars$1, Random random$1) {
        int len = random$1.nextInt(max - min) + min;
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append(chars$1.charAt(random$1.nextInt(chars$1.length())));
        }
        return sb.toString();
    }

    private final Function1 column$1(MemoryMode memoryMode, long iters$3, int count$3, byte[][] data$6) {
        return new Serializable(iters$3, count$3, data$6, memoryMode){
            public static final long serialVersionUID = 0L;
            private final long iters$3;
            public final int count$3;
            public final byte[][] data$6;
            private final MemoryMode memoryMode$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MemoryMode memoryMode = this.memoryMode$1;
                MemoryMode memoryMode2 = MemoryMode.OFF_HEAP;
                OffHeapColumnVector column2 = !(memoryMode != null ? !memoryMode.equals(memoryMode2) : memoryMode2 != null) ? new OffHeapColumnVector(this.count$3, (DataType)BinaryType$.MODULE$) : new OnHeapColumnVector(this.count$3, (DataType)BinaryType$.MODULE$);
                LongRef sum = LongRef.create((long)0L);
                new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)this.iters$3)).foreach((Function1)new Serializable(this, (WritableColumnVector)column2, sum){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.column.1.1 $outer;
                    private final WritableColumnVector column$2;
                    private final LongRef sum$14;

                    public final void apply(long n) {
                        this.apply$mcVJ$sp(n);
                    }

                    public void apply$mcVJ$sp(long n) {
                        int i;
                        for (i = 0; i < this.$outer.count$3; ++i) {
                            this.column$2.putByteArray(i, this.$outer.data$6[i]);
                        }
                        for (i = 0; i < this.$outer.count$3; ++i) {
                            this.sum$14.elem += (long)this.column$2.getUTF8String(i).numBytes();
                        }
                        this.column$2.reset();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.column$2 = column$2;
                        this.sum$14 = sum$14;
                    }
                });
            }
            {
                this.iters$3 = iters$3;
                this.count$3 = count$3;
                this.data$6 = data$6;
                this.memoryMode$1 = memoryMode$1;
            }
        };
    }

    public final void org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrays$1(boolean onHeap, int iters$4, int count$4, OnHeapColumnVector onHeapVector$1, OffHeapColumnVector offHeapVector$1) {
        OnHeapColumnVector vector = onHeap ? onHeapVector$1 : offHeapVector$1;
        LongRef sum = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iters$4).foreach$mVc$sp((Function1)new Serializable(count$4, (WritableColumnVector)vector, sum){
            public static final long serialVersionUID = 0L;
            private final int count$4;
            private final WritableColumnVector vector$1;
            private final LongRef sum$15;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                for (int i = 0; i < this.count$4; ++i) {
                    this.sum$15.elem += (long)this.vector$1.getArray(i).numElements();
                }
            }
            {
                this.count$4 = count$4;
                this.vector$1 = vector$1;
                this.sum$15 = sum$15;
            }
        });
    }

    public final void org$apache$spark$sql$execution$vectorized$ColumnarBatchBenchmark$$readArrayElements$1(boolean onHeap, int iters$4, int count$4, OnHeapColumnVector onHeapVector$1, OffHeapColumnVector offHeapVector$1) {
        OnHeapColumnVector vector = onHeap ? onHeapVector$1 : offHeapVector$1;
        LongRef sum = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), iters$4).foreach$mVc$sp((Function1)new Serializable(count$4, (WritableColumnVector)vector, sum){
            public static final long serialVersionUID = 0L;
            private final int count$4;
            private final WritableColumnVector vector$2;
            private final LongRef sum$16;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                for (int i = 0; i < this.count$4; ++i) {
                    ColumnarArray array = this.vector$2.getArray(i);
                    int size = array.numElements();
                    for (int j = 0; j < size; ++j) {
                        this.sum$16.elem += (long)array.getInt(j);
                    }
                }
            }
            {
                this.count$4 = count$4;
                this.vector$2 = vector$2;
                this.sum$16 = sum$16;
            }
        });
    }

    private ColumnarBatchBenchmark$() {
        MODULE$ = this;
    }
}

