/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.InternalRowCSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.apache.spark.sql.sources.v2.SimpleCSVDataReaderFactory;
import org.apache.spark.sql.sources.v2.SimpleCSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.SupportsWriteInternalRow;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001=\u0011\u0001dU5na2,wK]5uC\ndW\rR1uCN{WO]2f\u0015\t\u0019A!\u0001\u0002we)\u0011QAB\u0001\bg>,(oY3t\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0001\u0003\u0007\u000f EA\u0011\u0011CF\u0007\u0002%)\u00111\u0003F\u0001\u0005Y\u0006twMC\u0001\u0016\u0003\u0011Q\u0017M^1\n\u0005]\u0011\"AB(cU\u0016\u001cG\u000f\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\taA)\u0019;b'>,(oY3WeA\u0011\u0011$H\u0005\u0003=\t\u00111BU3bIN+\b\u000f]8siB\u0011\u0011\u0004I\u0005\u0003C\t\u0011Ab\u0016:ji\u0016\u001cV\u000f\u001d9peR\u0004\"!G\u0012\n\u0005\u0011\u0012!\u0001F*fgNLwN\\\"p]\u001aLwmU;qa>\u0014H\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0004\u0001\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\u0019\u00198\r[3nCV\tA\u0006\u0005\u0002.a5\taF\u0003\u00020\r\u0005)A/\u001f9fg&\u0011\u0011G\f\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u001a\u0001A\u0003%A&A\u0004tG\",W.\u0019\u0011\t\u000bU\u0002A\u0011\t\u001c\u0002\u0013-,\u0017\u0010\u0015:fM&DH#A\u001c\u0011\u0005ardBA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR\u0014A\u0002)sK\u0012,g-\u0003\u0002@\u0001\n11\u000b\u001e:j]\u001eT!!\u0010\u001e\u0007\t\t\u0003\u0001a\u0011\u0002\u0007%\u0016\fG-\u001a:\u0014\u0007\u0005\u0003B\t\u0005\u0002F\u00116\taI\u0003\u0002H\u0005\u00051!/Z1eKJL!!\u0013$\u0003!\u0011\u000bG/Y*pkJ\u001cWMU3bI\u0016\u0014\b\u0002C&B\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\tA\fG\u000f\u001b\u0005\t\u001b\u0006\u0013\t\u0011)A\u0005\u001d\u0006!1m\u001c8g!\ty5+D\u0001Q\u0015\ti\u0015K\u0003\u0002S\u0015\u00051\u0001.\u00193p_BL!\u0001\u0016)\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u00151\u0013\t\"\u0001W)\r9\u0016L\u0017\t\u00031\u0006k\u0011\u0001\u0001\u0005\u0006\u0017V\u0003\ra\u000e\u0005\u0006\u001bV\u0003\rA\u0014\u0005\u00069\u0006#\t%X\u0001\u000be\u0016\fGmU2iK6\fG#\u0001\u0017\t\u000b}\u000bE\u0011\t1\u00023\r\u0014X-\u0019;f\t\u0006$\u0018MU3bI\u0016\u0014h)Y2u_JLWm\u001d\u000b\u0002CB\u0019!-Z4\u000e\u0003\rT!\u0001\u001a\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003M\u000e\u0014A\u0001T5tiB\u0019Q\t\u001b6\n\u0005%4%!\u0005#bi\u0006\u0014V-\u00193fe\u001a\u000b7\r^8ssB\u00111\u000e\\\u0007\u0002\r%\u0011QN\u0002\u0002\u0004%><h\u0001B8\u0001\u0001A\u0014aa\u0016:ji\u0016\u00148c\u00018\u0011cB\u0011!/^\u0007\u0002g*\u0011AOA\u0001\u0007oJLG/\u001a:\n\u0005Y\u001c(\u0001\u0005#bi\u0006\u001cv.\u001e:dK^\u0013\u0018\u000e^3s\u0011!AhN!A!\u0002\u00139\u0014!\u00026pE&#\u0007\u0002C&o\u0005\u0003\u0005\u000b\u0011B\u001c\t\u00115s'\u0011!Q\u0001\n9CQA\n8\u0005\u0002q$R! @\u0000\u0003\u0003\u0001\"\u0001\u00178\t\u000ba\\\b\u0019A\u001c\t\u000b-[\b\u0019A\u001c\t\u000b5[\b\u0019\u0001(\t\u000f\u0005\u0015a\u000e\"\u0011\u0002\b\u0005\u00192M]3bi\u0016<&/\u001b;fe\u001a\u000b7\r^8ssR\u0011\u0011\u0011\u0002\t\u0005e\u0006-!.C\u0002\u0002\u000eM\u0014\u0011\u0003R1uC^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u001d\t\tB\u001cC!\u0003'\taaY8n[&$H\u0003BA\u000b\u00037\u00012!OA\f\u0013\r\tIB\u000f\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u001e\u0005=\u0001\u0019AA\u0010\u0003!iWm]:bO\u0016\u001c\b#B\u001d\u0002\"\u0005\u0015\u0012bAA\u0012u\t)\u0011I\u001d:bsB\u0019!/a\n\n\u0007\u0005%2OA\nXe&$XM]\"p[6LG/T3tg\u0006<W\rC\u0004\u0002.9$\t%a\f\u0002\u000b\u0005\u0014wN\u001d;\u0015\t\u0005U\u0011\u0011\u0007\u0005\t\u0003;\tY\u00031\u0001\u0002 \u00191\u0011Q\u0007\u0001\u0001\u0003o\u0011\u0011#\u00138uKJt\u0017\r\u001c*po^\u0013\u0018\u000e^3s'\u0015\t\u0019$`A\u001d!\r\u0011\u00181H\u0005\u0004\u0003{\u0019(\u0001G*vaB|'\u000f^:Xe&$X-\u00138uKJt\u0017\r\u001c*po\"I\u00010a\r\u0003\u0002\u0003\u0006Ia\u000e\u0005\n\u0017\u0006M\"\u0011!Q\u0001\n]B\u0011\"TA\u001a\u0005\u0003\u0005\u000b\u0011\u0002(\t\u000f\u0019\n\u0019\u0004\"\u0001\u0002HQA\u0011\u0011JA&\u0003\u001b\ny\u0005E\u0002Y\u0003gAa\u0001_A#\u0001\u00049\u0004BB&\u0002F\u0001\u0007q\u0007\u0003\u0004N\u0003\u000b\u0002\rA\u0014\u0005\t\u0003\u000b\t\u0019\u0004\"\u0011\u0002\b!A\u0011QKA\u001a\t\u0003\n9&\u0001\u0010de\u0016\fG/Z%oi\u0016\u0014h.\u00197S_^<&/\u001b;fe\u001a\u000b7\r^8ssR\u0011\u0011\u0011\f\t\u0006e\u0006-\u00111\f\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0004\u0002\u0011\r\fG/\u00197zgRLA!!\u001a\u0002`\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\tI\u0007\u0001C!\u0003W\nAb\u0019:fCR,'+Z1eKJ$2\u0001RA7\u0011!\ty'a\u001aA\u0002\u0005E\u0014aB8qi&|gn\u001d\t\u00043\u0005M\u0014bAA;\u0005\t\tB)\u0019;b'>,(oY3PaRLwN\\:\t\u000f\u0005e\u0004\u0001\"\u0011\u0002|\u0005a1M]3bi\u0016<&/\u001b;feRQ\u0011QPAB\u0003\u000b\u000b9)!%\u0011\t\t\fy(]\u0005\u0004\u0003\u0003\u001b'\u0001C(qi&|g.\u00197\t\ra\f9\b1\u00018\u0011\u0019Q\u0013q\u000fa\u0001Y!A\u0011\u0011RA<\u0001\u0004\tY)\u0001\u0003n_\u0012,\u0007cA6\u0002\u000e&\u0019\u0011q\u0012\u0004\u0003\u0011M\u000bg/Z'pI\u0016D\u0001\"a\u001c\u0002x\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003s\u0002A\u0011BAK)%\t\u0018qSAM\u0003O\u000bI\u000b\u0003\u0004y\u0003'\u0003\ra\u000e\u0005\b\u0017\u0006M\u0005\u0019AAN!\u0011\ti*a)\u000e\u0005\u0005}%bAAQ#\u0006\u0011am]\u0005\u0005\u0003K\u000byJ\u0001\u0003QCRD\u0007BB'\u0002\u0014\u0002\u0007a\n\u0003\u0005\u0002,\u0006M\u0005\u0019AAW\u0003!Ig\u000e^3s]\u0006d\u0007cA\u001d\u00020&\u0019\u0011\u0011\u0017\u001e\u0003\u000f\t{w\u000e\\3b]\u0002")
public class SimpleWritableDataSource
implements ReadSupport,
WriteSupport,
SessionConfigSupport {
    private final StructType org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema = new StructType().add("i", "long").add("j", "long");

    public StructType org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema() {
        return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema;
    }

    public String keyPrefix() {
        return "simpleWritableDataSource";
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        return new Reader(this, path.toUri().toString(), conf);
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType schema2, SaveMode mode, DataSourceOptions options) {
        Predef$.MODULE$.assert(DataType$.MODULE$.equalsStructurally((DataType)schema2.asNullable(), (DataType)this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema().asNullable(), DataType$.MODULE$.equalsStructurally$default$3()));
        Predef$.MODULE$.assert(!((SparkContext)SparkContext$.MODULE$.getActive().get()).conf().getBoolean("spark.speculation", false));
        Path path = new Path((String)options.get("path").get());
        boolean internal = options.get("internal").isPresent();
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        FileSystem fs = path.getFileSystem(conf);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && fs.exists(path)) {
            throw new RuntimeException("data already exists.");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && fs.exists(path)) {
            return Optional.empty();
        }
        SaveMode saveMode5 = mode;
        SaveMode saveMode6 = SaveMode.Overwrite;
        Object object = !(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true)) : BoxedUnit.UNIT;
        return Optional.of(this.createWriter(jobId, path, conf, internal));
    }

    private DataSourceWriter createWriter(String jobId, Path path, Configuration conf, boolean internal) {
        String pathStr = path.toUri().toString();
        return internal ? new InternalRowWriter(this, jobId, pathStr, conf) : new Writer(this, jobId, pathStr, conf);
    }

    public class Reader
    implements DataSourceReader {
        private final String path;
        public final Configuration org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public StructType readSchema() {
            return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer().org$apache$spark$sql$sources$v2$SimpleWritableDataSource$$schema();
        }

        public List<DataReaderFactory<Row>> createDataReaderFactories() {
            Path dataPath = new Path(this.path);
            FileSystem fs = dataPath.getFileSystem(this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
            return fs.exists(dataPath) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(dataPath)).filterNot((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(FileStatus status) {
                    String name = status.getPath().getName();
                    return name.startsWith("_") || name.startsWith(".");
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Reader $outer;

                public final DataReaderFactory<Row> apply(FileStatus f) {
                    SerializableConfiguration serializableConf = new SerializableConfiguration(this.$outer.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf);
                    return new SimpleCSVDataReaderFactory(f.getPath().toUri().toString(), serializableConf);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataReaderFactory.class)))).toList()).asJava() : Collections.emptyList();
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer() {
            return this.$outer;
        }

        public Reader(SimpleWritableDataSource $outer, String path, Configuration conf) {
            this.path = path;
            this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class Writer
    implements DataSourceWriter {
        private final String jobId;
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public DataWriterFactory<Row> createWriterFactory() {
            return new SimpleCSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        /*
         * WARNING - void declaration
         */
        public void commit(WriterCommitMessage[] messages) {
            Path finalPath = new Path(this.path);
            Path jobPath = new Path(new Path(finalPath, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            try {
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(jobPath)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).foreach((Function1)new Serializable(this, finalPath, fs){
                    public static final long serialVersionUID = 0L;
                    private final Path finalPath$1;
                    private final FileSystem fs$1;

                    public final void apply(Path file) {
                        Path dest = new Path(this.finalPath$1, file.getName());
                        if (this.fs$1.rename(file, dest)) {
                            return;
                        }
                        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failed to rename(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, dest})));
                    }
                    {
                        this.finalPath$1 = finalPath$1;
                        this.fs$1 = fs$1;
                    }
                });
            }
            catch (Throwable throwable) {
                void var3_3;
                void var4_4;
                var4_4.delete((Path)var3_3, true);
                throw throwable;
            }
            fs.delete(jobPath, true);
        }

        public void abort(WriterCommitMessage[] messages) {
            Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            fs.delete(jobPath, true);
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Writer$$$outer() {
            return this.$outer;
        }

        public Writer(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class InternalRowWriter
    extends Writer
    implements SupportsWriteInternalRow {
        private final String jobId;
        private final String path;
        private final Configuration conf;

        @Override
        public DataWriterFactory<Row> createWriterFactory() {
            throw new IllegalArgumentException("not expected!");
        }

        public DataWriterFactory<InternalRow> createInternalRowWriterFactory() {
            return new InternalRowCSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$InternalRowWriter$$$outer() {
            return this.$outer;
        }

        public InternalRowWriter(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            super($outer, jobId, path, conf);
        }
    }
}

