/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataReader;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.SupportsScanColumnarBatch;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class JavaBatchDataSourceV2
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class JavaBatchDataReaderFactory
    implements DataReaderFactory<ColumnarBatch>,
    DataReader<ColumnarBatch> {
        private int start;
        private int end;
        private static final int BATCH_SIZE = 20;
        private OnHeapColumnVector i;
        private OnHeapColumnVector j;
        private ColumnarBatch batch;

        JavaBatchDataReaderFactory(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public DataReader<ColumnarBatch> createDataReader() {
            this.i = new OnHeapColumnVector(20, DataTypes.IntegerType);
            this.j = new OnHeapColumnVector(20, DataTypes.IntegerType);
            ColumnVector[] vectors = new ColumnVector[]{this.i, this.j};
            this.batch = new ColumnarBatch(vectors);
            return this;
        }

        public boolean next() {
            int count;
            this.i.reset();
            this.j.reset();
            for (count = 0; this.start < this.end && count < 20; ++count) {
                this.i.putInt(count, this.start);
                this.j.putInt(count, -this.start);
                ++this.start;
            }
            if (count == 0) {
                return false;
            }
            this.batch.setNumRows(count);
            return true;
        }

        public ColumnarBatch get() {
            return this.batch;
        }

        public void close() throws IOException {
            this.batch.close();
        }
    }

    class Reader
    implements DataSourceReader,
    SupportsScanColumnarBatch {
        private final StructType schema = new StructType().add("i", "int").add("j", "int");

        Reader() {
        }

        public StructType readSchema() {
            return this.schema;
        }

        public List<DataReaderFactory<ColumnarBatch>> createBatchDataReaderFactories() {
            return Arrays.asList(new JavaBatchDataReaderFactory(0, 50), new JavaBatchDataReaderFactory(50, 90));
        }
    }
}

