/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataReader;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.types.StructType;

public class JavaSimpleDataSourceV2
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class JavaSimpleDataReaderFactory
    implements DataReaderFactory<Row>,
    DataReader<Row> {
        private int start;
        private int end;

        JavaSimpleDataReaderFactory(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public DataReader<Row> createDataReader() {
            return new JavaSimpleDataReaderFactory(this.start - 1, this.end);
        }

        public boolean next() {
            ++this.start;
            return this.start < this.end;
        }

        public Row get() {
            return new GenericRow(new Object[]{this.start, -this.start});
        }

        public void close() throws IOException {
        }
    }

    class Reader
    implements DataSourceReader {
        private final StructType schema = new StructType().add("i", "int").add("j", "int");

        Reader() {
        }

        public StructType readSchema() {
            return this.schema;
        }

        public List<DataReaderFactory<Row>> createDataReaderFactories() {
            return Arrays.asList(new JavaSimpleDataReaderFactory(0, 5), new JavaSimpleDataReaderFactory(5, 10));
        }
    }
}

