/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.reader.DataReader;
import org.apache.spark.sql.sources.v2.reader.DataReaderFactory;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.SupportsScanUnsafeRow;
import org.apache.spark.sql.types.StructType;

public class JavaUnsafeRowDataSourceV2
implements DataSourceV2,
ReadSupport {
    public DataSourceReader createReader(DataSourceOptions options) {
        return new Reader();
    }

    static class JavaUnsafeRowDataReaderFactory
    implements DataReaderFactory<UnsafeRow>,
    DataReader<UnsafeRow> {
        private int start;
        private int end;
        private UnsafeRow row;

        JavaUnsafeRowDataReaderFactory(int start, int end) {
            this.start = start;
            this.end = end;
            this.row = new UnsafeRow(2);
            this.row.pointTo(new byte[24], 24);
        }

        public DataReader<UnsafeRow> createDataReader() {
            return new JavaUnsafeRowDataReaderFactory(this.start - 1, this.end);
        }

        public boolean next() {
            ++this.start;
            return this.start < this.end;
        }

        public UnsafeRow get() {
            this.row.setInt(0, this.start);
            this.row.setInt(1, -this.start);
            return this.row;
        }

        public void close() throws IOException {
        }
    }

    class Reader
    implements DataSourceReader,
    SupportsScanUnsafeRow {
        private final StructType schema = new StructType().add("i", "int").add("j", "int");

        Reader() {
        }

        public StructType readSchema() {
            return this.schema;
        }

        public List<DataReaderFactory<UnsafeRow>> createUnsafeRowReaderFactories() {
            return Arrays.asList(new JavaUnsafeRowDataReaderFactory(0, 5), new JavaUnsafeRowDataReaderFactory(5, 10));
        }
    }
}

