/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.KeyValueGroupedDataset;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.expressions.javalang.typed;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;
import test.org.apache.spark.sql.JavaDatasetAggregatorSuiteBase;

public class JavaDatasetAggregatorSuite
extends JavaDatasetAggregatorSuiteBase {
    @Test
    public void testTypedAggregationAnonClass() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset agged = grouped.agg(new IntSumOf().toColumn());
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"b", (Object)3)), (Object)agged.collectAsList());
        Dataset agged2 = grouped.agg(new IntSumOf().toColumn()).as(Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.INT()));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"b", (Object)3)), (Object)agged2.collectAsList());
    }

    @Test
    public void testTypedAggregationAverage() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset agged = grouped.agg(typed.avg((MapFunction & Serializable)value -> (double)((Integer)value._2()).intValue() * 2.0));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3.0), new Tuple2((Object)"b", (Object)6.0)), (Object)agged.collectAsList());
    }

    @Test
    public void testTypedAggregationCount() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset agged = grouped.agg(typed.count((MapFunction & Serializable)value -> value));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)2L), new Tuple2((Object)"b", (Object)1L)), (Object)agged.collectAsList());
    }

    @Test
    public void testTypedAggregationSumDouble() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset agged = grouped.agg(typed.sum((MapFunction & Serializable)value -> (double)((Integer)value._2())));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3.0), new Tuple2((Object)"b", (Object)3.0)), (Object)agged.collectAsList());
    }

    @Test
    public void testTypedAggregationSumLong() {
        KeyValueGroupedDataset<String, Tuple2<String, Integer>> grouped = this.generateGroupedDataset();
        Dataset agged = grouped.agg(typed.sumLong((MapFunction & Serializable)value -> (long)((Integer)value._2())));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3L), new Tuple2((Object)"b", (Object)3L)), (Object)agged.collectAsList());
    }

    static class IntSumOf
    extends Aggregator<Tuple2<String, Integer>, Integer, Integer> {
        IntSumOf() {
        }

        public Integer zero() {
            return 0;
        }

        public Integer reduce(Integer l, Tuple2<String, Integer> t) {
            return l + (Integer)t._2();
        }

        public Integer merge(Integer b1, Integer b2) {
            return b1 + b2;
        }

        public Integer finish(Integer reduction) {
            return reduction;
        }

        public Encoder<Integer> bufferEncoder() {
            return Encoders.INT();
        }

        public Encoder<Integer> outputEncoder() {
            return Encoders.INT();
        }
    }
}

