/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import org.apache.spark.sql.execution.command.TruncateTableCommand$$anonfun$run$4$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u0001\u0003\u0001>\u0011A\u0003\u0016:v]\u000e\fG/\u001a+bE2,7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005IA/\u00192mK:\u000bW.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0006uC\ndWMT1nK\u0002B\u0001\"\r\u0001\u0003\u0016\u0004%\tAM\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0016\u0003M\u00022a\b\u001b7\u0013\t)\u0004E\u0001\u0004PaRLwN\u001c\t\u0003o-s!\u0001\u000f%\u000f\u0005e2eB\u0001\u001eF\u001d\tYDI\u0004\u0002=\u0007:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011qIF\u0001\bG\u0006$\u0018\r\\8h\u0013\tI%*\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002H-%\u0011A*\u0014\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002J\u0015\"Aq\n\u0001B\tB\u0003%1'\u0001\bqCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u00037\u0001AQ\u0001\u000b)A\u0002)BQ!\r)A\u0002MBQa\u0016\u0001\u0005Ba\u000b1A];o)\tIf\rE\u0002[?\nt!aW/\u000f\u0005yb\u0016\"A\u0011\n\u0005y\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003A\u0006\u00141aU3r\u0015\tq\u0006\u0005\u0005\u0002dI6\ta!\u0003\u0002f\r\t\u0019!k\\<\t\u000b%1\u0006\u0019A4\u0011\u0005\rD\u0017BA5\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015Y\u0007\u0001\"\u0003m\u0003-qWm^!dY\u0016sGO]=\u0015\u000b5<H0a\u0001\u0011\u00059,X\"A8\u000b\u0005A\f\u0018A\u00039fe6L7o]5p]*\u0011!o]\u0001\u0003MNT!\u0001\u001e\u0006\u0002\r!\fGm\\8q\u0013\t1xN\u0001\u0005BG2,e\u000e\u001e:z\u0011\u0015A(\u000e1\u0001z\u0003\u0015\u00198m\u001c9f!\tq'0\u0003\u0002|_\ni\u0011i\u00197F]R\u0014\u0018pU2pa\u0016DQ! 6A\u0002y\fq!Y2m)f\u0004X\r\u0005\u0002o\u007f&\u0019\u0011\u0011A8\u0003\u0019\u0005\u001bG.\u00128uef$\u0016\u0010]3\t\rAT\u0007\u0019AA\u0003!\rq\u0017qA\u0005\u0004\u0003\u0013y'\u0001\u0003$t\u0003\u000e$\u0018n\u001c8\t\u0013\u00055\u0001!!A\u0005\u0002\u0005=\u0011\u0001B2paf$RaUA\t\u0003'A\u0001\u0002KA\u0006!\u0003\u0005\rA\u000b\u0005\tc\u0005-\u0001\u0013!a\u0001g!I\u0011q\u0003\u0001\u0012\u0002\u0013\u0005\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYBK\u0002+\u0003;Y#!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003S\u0001\u0013AC1o]>$\u0018\r^5p]&!\u0011QFA\u0012\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003c\u0001\u0011\u0013!C\u0001\u0003g\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00026)\u001a1'!\b\t\u0013\u0005e\u0002!!A\u0005B\u0005m\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002>A!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013\u0001\u00027b]\u001eT!!a\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\n\tE\u0001\u0004TiJLgn\u001a\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0015\u0011\u0007}\t)&C\u0002\u0002X\u0001\u00121!\u00138u\u0011%\tY\u0006AA\u0001\n\u0003\ti&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005}\u0013Q\r\t\u0004?\u0005\u0005\u0014bAA2A\t\u0019\u0011I\\=\t\u0015\u0005\u001d\u0014\u0011LA\u0001\u0002\u0004\t\u0019&A\u0002yIEB\u0011\"a\u001b\u0001\u0003\u0003%\t%!\u001c\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001c\u0011\r\u0005E\u0014qOA0\u001b\t\t\u0019HC\u0002\u0002v\u0001\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI(a\u001d\u0003\u0011%#XM]1u_JD\u0011\"! \u0001\u0003\u0003%\t!a \u0002\u0011\r\fg.R9vC2$B!!!\u0002\bB\u0019q$a!\n\u0007\u0005\u0015\u0005EA\u0004C_>dW-\u00198\t\u0015\u0005\u001d\u00141PA\u0001\u0002\u0004\ty\u0006C\u0005\u0002\f\u0002\t\t\u0011\"\u0011\u0002\u000e\u00061Q-];bYN$B!!!\u0002\u0010\"Q\u0011qMAE\u0003\u0003\u0005\r!a\u0018\b\u0013\u0005M%!!A\t\u0002\u0005U\u0015\u0001\u0006+sk:\u001c\u0017\r^3UC\ndWmQ8n[\u0006tG\rE\u0002\u001c\u0003/3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011T\n\u0006\u0003/\u000bY\n\n\t\b\u0003;\u000b\u0019KK\u001aT\u001b\t\tyJC\u0002\u0002\"\u0002\nqA];oi&lW-\u0003\u0003\u0002&\u0006}%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9\u0011+a&\u0005\u0002\u0005%FCAAK\u0011)\ti+a&\u0002\u0002\u0013\u0015\u0013qV\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\b\u0005\u000b\u0003g\u000b9*!A\u0005\u0002\u0006U\u0016!B1qa2LH#B*\u00028\u0006e\u0006B\u0002\u0015\u00022\u0002\u0007!\u0006\u0003\u00042\u0003c\u0003\ra\r\u0005\u000b\u0003{\u000b9*!A\u0005\u0002\u0006}\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0003\fI\r\u0005\u0003 i\u0005\r\u0007#B\u0010\u0002F*\u001a\u0014bAAdA\t1A+\u001e9mKJB\u0011\"a3\u0002<\u0006\u0005\t\u0019A*\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002P\u0006]\u0015\u0011!C\u0005\u0003#\f1B]3bIJ+7o\u001c7wKR\u0011\u00111\u001b\t\u0005\u0003\u007f\t).\u0003\u0003\u0002X\u0006\u0005#AB(cU\u0016\u001cG\u000f")
public class TruncateTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    private Map metrics$lzycompute() {
        TruncateTableCommand truncateTableCommand = this;
        synchronized (truncateTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand$class.metrics(this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        Seq partCols;
        SessionCatalog catalog2 = spark.sessionState().catalog();
        CatalogTable table = catalog2.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on external tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CatalogTableType catalogTableType3 = table.tableType();
        CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on views: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for tables that are not partitioned: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partitionSpec().isDefined()) {
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, table, "TRUNCATE TABLE ... PARTITION");
        }
        if ((partCols = table.partitionColumnNames()).isEmpty()) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().locationUri()}));
        } else {
            Option normalizedSpec = this.partitionSpec().map((Function1)new Serializable(this, spark, table, partCols){
                public static final long serialVersionUID = 0L;
                private final SparkSession spark$1;
                private final CatalogTable table$1;
                private final Seq partCols$1;

                public final Map<String, String> apply(Map<String, String> spec) {
                    return PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)this.partCols$1, this.table$1.identifier().quotedString(), (Function2<String, String, Object>)this.spark$1.sessionState().conf().resolver());
                }
                {
                    this.spark$1 = spark$1;
                    this.table$1 = table$1;
                    this.partCols$1 = partCols$1;
                }
            });
            Seq partLocations = (Seq)catalog2.listPartitions(table.identifier(), normalizedSpec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Option<URI> apply(CatalogTablePartition x$4) {
                    return x$4.storage().locationUri();
                }
            }, Seq$.MODULE$.canBuildFrom());
            this.partitionSpec().withFilter((Function1)new Serializable(this, partCols, partLocations){
                public static final long serialVersionUID = 0L;
                private final Seq partCols$1;
                private final Seq partLocations$1;

                public final boolean apply(Map<String, String> spec) {
                    return this.partLocations$1.isEmpty() && spec.size() == this.partCols$1.length();
                }
                {
                    this.partCols$1 = partCols$1;
                    this.partLocations$1 = partLocations$1;
                }
            }).foreach((Function1)new Serializable(this, table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$1;

                public final Nothing$ apply(Map<String, String> spec) {
                    throw new NoSuchPartitionException(this.table$1.database(), this.table$1.identifier().table(), spec);
                }
                {
                    this.table$1 = table$1;
                }
            });
            seq = partLocations;
        }
        Seq locations = seq;
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        boolean ignorePermissionAcl = SQLConf$.MODULE$.get().truncateTableIgnorePermissionAcl();
        locations.foreach((Function1)new Serializable(this, tableIdentWithDB, hadoopConf, ignorePermissionAcl){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TruncateTableCommand $outer;
            private final String tableIdentWithDB$1;
            private final Configuration hadoopConf$1;
            private final boolean ignorePermissionAcl$1;

            public final void apply(Option<URI> location) {
                if (location.isDefined()) {
                    Path path = new Path((URI)location.get());
                    try {
                        FileSystem fs = path.getFileSystem(this.hadoopConf$1);
                        ObjectRef optPermission = ObjectRef.create((Object)None$.MODULE$);
                        None$ optAcls = None$.MODULE$;
                        if (!this.ignorePermissionAcl$1) {
                            try {
                                FileStatus fileStatus = fs.getFileStatus(path);
                                optPermission.elem = new Some((Object)fileStatus.getPermission());
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (option.isEmpty()) {
                                    throw throwable;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            try {
                                optAcls = new Some((Object)fs.getAclStatus(path).getEntries());
                            }
                            catch (Throwable throwable) {
                                Throwable throwable3 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable3);
                                if (option.isEmpty()) {
                                    throw throwable;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        fs.delete(path, true);
                        fs.mkdirs(path);
                        if (!this.ignorePermissionAcl$1) {
                            ((Option)optPermission.elem).foreach((Function1)new Serializable(this, path, fs){
                                public static final long serialVersionUID = 0L;
                                private final Path path$1;
                                private final FileSystem fs$1;

                                public final void apply(FsPermission permission) {
                                    try {
                                        this.fs$1.setPermission(this.path$1, permission);
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        Throwable throwable2 = throwable;
                                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                                        if (option.isEmpty()) {
                                            throw throwable;
                                        }
                                        Throwable e = (Throwable)option.get();
                                        throw new SecurityException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to set original permission ", " back to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{permission}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the created path: ", ". Exception: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, e.getMessage()}))).toString());
                                    }
                                }
                                {
                                    this.path$1 = path$1;
                                    this.fs$1 = fs$1;
                                }
                            });
                            optAcls.foreach((Function1)new Serializable(this, path, fs, optPermission){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$run$4 $outer;
                                private final Path path$1;
                                private final FileSystem fs$1;
                                private final ObjectRef optPermission$1;

                                public final void apply(List<AclEntry> acls) {
                                    List aclEntries = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(AclEntry x$5) {
                                            return x$5.getName() != null;
                                        }
                                    })).asJava();
                                    ((Option)this.optPermission$1.elem).map((Function1)new Serializable(this, aclEntries){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$run$4$$anonfun$apply$2 $outer;
                                        private final List aclEntries$1;

                                        public final boolean apply(FsPermission permission) {
                                            this.aclEntries$1.add(this.$outer.org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, permission.getUserAction()));
                                            this.aclEntries$1.add(this.$outer.org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, permission.getGroupAction()));
                                            return this.aclEntries$1.add(this.$outer.org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$$outer().org$apache$spark$sql$execution$command$TruncateTableCommand$$newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, permission.getOtherAction()));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.aclEntries$1 = aclEntries$1;
                                        }
                                    });
                                    try {
                                        this.fs$1.setAcl(this.path$1, aclEntries);
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        Throwable throwable2 = throwable;
                                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                                        if (option.isEmpty()) {
                                            throw throwable;
                                        }
                                        Throwable e = (Throwable)option.get();
                                        throw new SecurityException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to set original ACL ", " back to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aclEntries}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the created path: ", ". Exception: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1, e.getMessage()}))).toString());
                                    }
                                }

                                public /* synthetic */ $anonfun$run$4 org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.path$1 = path$1;
                                    this.fs$1 = fs$1;
                                    this.optPermission$1 = optPermission$1;
                                }
                            });
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable4 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable4);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable e = (Throwable)option.get();
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate table ", " when removing data of the path: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentWithDB$1, path}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                }
            }

            public /* synthetic */ TruncateTableCommand org$apache$spark$sql$execution$command$TruncateTableCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableIdentWithDB$1 = tableIdentWithDB$1;
                this.hadoopConf$1 = hadoopConf$1;
                this.ignorePermissionAcl$1 = ignorePermissionAcl$1;
            }
        });
        spark.sessionState().refreshTable(this.tableName().unquotedString());
        try {
            spark.sharedState().cacheManager().uncacheQuery(spark.table(table.identifier()), true, spark.sharedState().cacheManager().uncacheQuery$default$3());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (table.stats().nonEmpty()) {
            CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(0), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), CatalogStatistics$.MODULE$.apply$default$3());
            catalog2.alterTableStats(this.tableName(), (Option)new Some((Object)newStats));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AclEntry org$apache$spark$sql$execution$command$TruncateTableCommand$$newAclEntry(AclEntryScope scope, AclEntryType aclType, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(aclType).setPermission(permission).build();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        return new TruncateTableCommand(tableName, partitionSpec2);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.partitionSpec();
                break;
            }
            case 0: {
                tableIdentifier = this.tableName();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec2;
        Command.class.$init$((Command)this);
        RunnableCommand$class.$init$(this);
    }
}

