/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u0001E\u0011aBS:p]\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!!n]8o\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0011$\u0003%\u0019\bn\u001c:u\u001d\u0006lW-F\u0001%!\t)3F\u0004\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0011\u0019y\u0003\u0001)A\u0005I\u0005Q1\u000f[8si:\u000bW.\u001a\u0011\t\u000bE\u0002A\u0011\t\u001a\u0002\u0017%\u001c8\u000b\u001d7ji\u0006\u0014G.\u001a\u000b\u0005gYb\u0014\t\u0005\u0002'i%\u0011Qg\n\u0002\b\u0005>|G.Z1o\u0011\u00159\u0004\u00071\u00019\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\tI$(D\u0001\t\u0013\tY\u0004B\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003>a\u0001\u0007a(A\u0004paRLwN\\:\u0011\t\u0015zD\u0005J\u0005\u0003\u00016\u00121!T1q\u0011\u0015\u0011\u0005\u00071\u0001D\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015A\u00014t\u0015\tAE\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0015\u0016\u0013A\u0001U1uQ\")A\n\u0001C!\u001b\u0006Y\u0011N\u001c4feN\u001b\u0007.Z7b)\u0011qu\u000bW-\u0011\u0007\u0019z\u0015+\u0003\u0002QO\t1q\n\u001d;j_:\u0004\"AU+\u000e\u0003MS!\u0001\u0016\u0005\u0002\u000bQL\b/Z:\n\u0005Y\u001b&AC*ueV\u001cG\u000fV=qK\")qg\u0013a\u0001q!)Qh\u0013a\u0001}!)!l\u0013a\u00017\u0006)a-\u001b7fgB\u0019A\fZ4\u000f\u0005u\u0013gB\u00010b\u001b\u0005y&B\u00011\u0011\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002dO\u00059\u0001/Y2lC\u001e,\u0017BA3g\u0005\r\u0019V-\u001d\u0006\u0003G\u001e\u0002\"\u0001\u00125\n\u0005%,%A\u0003$jY\u0016\u001cF/\u0019;vg\")1\u000e\u0001C!Y\u0006a\u0001O]3qCJ,wK]5uKR)Q\u000e]9zuB\u00111C\\\u0005\u0003_\u0012\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQa\u000e6A\u0002aBQA\u001d6A\u0002M\f1A[8c!\t!x/D\u0001v\u0015\t1x)A\u0005nCB\u0014X\rZ;dK&\u0011\u00010\u001e\u0002\u0004\u0015>\u0014\u0007\"B\u001fk\u0001\u0004q\u0004\"B>k\u0001\u0004\t\u0016A\u00033bi\u0006\u001c6\r[3nC\")Q\u0010\u0001C!}\u0006Y!-^5mIJ+\u0017\rZ3s)=y\u0018QDA\u0010\u0003C\t)#!\u000b\u00026\u0005]\u0002c\u0002\u0014\u0002\u0002\u0005\u0015\u00111B\u0005\u0004\u0003\u00079#!\u0003$v]\u000e$\u0018n\u001c82!\r\u0019\u0012qA\u0005\u0004\u0003\u0013!!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000bq\u000bi!!\u0005\n\u0007\u0005=aM\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002\u001c\u0005U!aC%oi\u0016\u0014h.\u00197S_^DQa\u000e?A\u0002aBQa\u001f?A\u0002ECa!a\t}\u0001\u0004\t\u0016a\u00049beRLG/[8o'\u000eDW-\\1\t\r\u0005\u001dB\u00101\u0001R\u00039\u0011X-];je\u0016$7k\u00195f[\u0006Dq!a\u000b}\u0001\u0004\ti#A\u0004gS2$XM]:\u0011\tq#\u0017q\u0006\t\u0004/\u0005E\u0012bAA\u001a1\t1a)\u001b7uKJDQ!\u0010?A\u0002yBq!!\u000f}\u0001\u0004\tY$\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003:\u0015\u0001B2p]\u001aLA!!\u0012\u0002@\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\u0013\u0001\t\u0003\nY%\u0001\u0005u_N#(/\u001b8h)\u0005!\u0003bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111\u000b\t\u0004M\u0005U\u0013bAA,O\t\u0019\u0011J\u001c;\t\u000f\u0005m\u0003\u0001\"\u0011\u0002^\u00051Q-];bYN$2aMA0\u0011!\t\t'!\u0017A\u0002\u0005\r\u0014!B8uQ\u0016\u0014\bc\u0001\u0014\u0002f%\u0019\u0011qM\u0014\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002l\u0001!\t%!\u001c\u0002\u001fM,\b\u000f]8si\u0012\u000bG/\u0019+za\u0016$RaMA8\u0003sB\u0001\"!\u001d\u0002j\u0001\u0007\u00111O\u0001\tI\u0006$\u0018\rV=qKB\u0019!+!\u001e\n\u0007\u0005]4K\u0001\u0005ECR\fG+\u001f9f\u0011\u001d\tY(!\u001bA\u0002M\n!\"[:SK\u0006$\u0007+\u0019;i\u0001")
public class JsonFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    private final String shortName;

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        JsonDataSource jsonDataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
        return jsonDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        return JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).inferSchema(sparkSession, files, (JSONOptions)parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this, parsedOptions){
            private final JSONOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, this.parsedOptions$1, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".json").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1)new Serializable(this, parsedOptions){
            public static final long serialVersionUID = 0L;
            private final JSONOptionsInRead parsedOptions$2;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.parsedOptions$2.columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parsedOptions$2 = parsedOptions$2;
            }
        }));
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)new Serializable(this, dataSchema){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;

            public final void apply(int corruptFieldIndex) {
                this.apply$mcVI$sp(corruptFieldIndex);
            }

            public void apply$mcVI$sp(int corruptFieldIndex) {
                StructField f = this.dataSchema$1.apply(corruptFieldIndex);
                DataType dataType = f.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && f.nullable()) {
                    return;
                }
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.dataSchema$1 = dataSchema$1;
            }
        });
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new AnalysisException(new StringBuilder().append((Object)"Since Spark 2.3, the queries from raw JSON/CSV files are disallowed when the\nreferenced columns only include the internal corrupt record column\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(named _corrupt_record by default). For example:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)"spark.read.schema(schema).json(file).filter($\"_corrupt_record\".isNotNull).count()\n").append((Object)"and spark.read.schema(schema).json(file).select(\"_corrupt_record\").show().\n").append((Object)"Instead, you can cache or save the parsed results and then send the same query.\n").append((Object)"For example, val df = spark.read.schema(schema).json(file).cache() and then\n").append((Object)"df.filter($\"_corrupt_record\".isNotNull).count().").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        return new Serializable(this, requiredSchema, broadcastedHadoopConf, parsedOptions, actualSchema){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final JSONOptionsInRead parsedOptions$2;
            private final StructType actualSchema$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                JacksonParser parser = new JacksonParser((DataType)this.actualSchema$1, (JSONOptions)this.parsedOptions$2);
                return JsonDataSource$.MODULE$.apply((JSONOptions)this.parsedOptions$2).readFile(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), file, parser, this.requiredSchema$1);
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.parsedOptions$2 = parsedOptions$2;
                this.actualSchema$1 = actualSchema$1;
            }
        };
    }

    public String toString() {
        return "JSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof JsonFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1)new Serializable(this, isReadPath){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JsonFileFormat $outer;
                private final boolean isReadPath$1;

                public final boolean apply(StructField f) {
                    return this.$outer.supportDataType(f.dataType(), this.isReadPath$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.isReadPath$1 = isReadPath$1;
                }
            });
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public JsonFileFormat() {
        this.shortName = "json";
    }
}

