/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.RelationalGroupedDataset$;
import org.apache.spark.sql.RelationalGroupedDataset$CubeType$;
import org.apache.spark.sql.RelationalGroupedDataset$GroupByType$;
import org.apache.spark.sql.RelationalGroupedDataset$RollupType$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cube;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.Rollup;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInR$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.aggregate.TypedAggregateExpression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\rmc\u0001B\u0001\u0003\u0001-\u0011\u0001DU3mCRLwN\\1m\u000fJ|W\u000f]3e\t\u0006$\u0018m]3u\u0015\t\u0019A!A\u0002tc2T!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005\u0011AM\u001a\t\u0003+eq!AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0002\u000fA\f7m[1hK&\u0011!d\u0007\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!\u0001\u0007\u0002\t\u0011u\u0001!\u0011!Q\u0001\ny\tQb\u001a:pkBLgnZ#yaJ\u001c\bcA\u0010'S9\u0011\u0001%\n\b\u0003C\u0011j\u0011A\t\u0006\u0003G)\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005aq\u0011BA\u0014)\u0005\r\u0019V-\u001d\u0006\u000319\u0001\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]\t\t\u0001bY1uC2L8\u000f^\u0005\u0003a-\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014!C4s_V\u0004H+\u001f9f!\t!dI\u0004\u0002\u0017k\u001d1aG\u0001E\u0001\u0005]\n\u0001DU3mCRLwN\\1m\u000fJ|W\u000f]3e\t\u0006$\u0018m]3u!\t1\u0002H\u0002\u0004\u0002\u0005!\u0005!!O\n\u0003q1AQa\u000f\u001d\u0005\u0002q\na\u0001P5oSRtD#A\u001c\t\u000byBD\u0011A \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\u0001\u000b%i\u0011\t\u0003-\u0001AQaE\u001fA\u0002QAQ!H\u001fA\u0002yAQAM\u001fA\u0002\u0011\u0003\"!\u0012$\u000e\u0003a2\u0001b\u0012\u001d\u0011\u0002\u0007\u0005!\u0001\u0013\u0002\n\u000fJ|W\u000f\u001d+za\u0016\u001c\"A\u0012\u0007\t\u000b)3E\u0011A&\u0002\r\u0011Jg.\u001b;%)\u0005a\u0005CA\u0007N\u0013\tqeB\u0001\u0003V]&$\b\"\u0002)G\t\u0003\n\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003I\u0003\"aU,\u000f\u0005Q+\u0006CA\u0011\u000f\u0013\t1f\"\u0001\u0004Qe\u0016$WMZ\u0005\u00031f\u0013aa\u0015;sS:<'B\u0001,\u000f\u000f\u0019Y\u0006\b#\u0001\u00039\u0006YqI]8va\nKH+\u001f9f!\t)UL\u0002\u0004_q!\u0005!a\u0018\u0002\f\u000fJ|W\u000f\u001d\"z)f\u0004XmE\u0002^\u0019\u0011CQaO/\u0005\u0002\u0005$\u0012\u0001X\u0004\u0007GbB\tA\u00013\u0002\u0011\r+(-\u001a+za\u0016\u0004\"!R3\u0007\r\u0019D\u0004\u0012\u0001\u0002h\u0005!\u0019UOY3UsB,7cA3\r\t\")1(\u001aC\u0001SR\tAm\u0002\u0004lq!\u0005!\u0001\\\u0001\u000b%>dG.\u001e9UsB,\u0007CA#n\r\u0019q\u0007\b#\u0001\u0003_\nQ!k\u001c7mkB$\u0016\u0010]3\u0014\u00075dA\tC\u0003<[\u0012\u0005\u0011\u000fF\u0001m\r\u0015\u0019\b\b\u0011\u0002u\u0005%\u0001\u0016N^8u)f\u0004XmE\u0003s\u0019\u0011+\b\u0010\u0005\u0002\u000em&\u0011qO\u0004\u0002\b!J|G-^2u!\ti\u00110\u0003\u0002{\u001d\ta1+\u001a:jC2L'0\u00192mK\"AAP\u001dBK\u0002\u0013\u0005Q0\u0001\u0005qSZ|GoQ8m+\u0005I\u0003\u0002C@s\u0005#\u0005\u000b\u0011B\u0015\u0002\u0013ALgo\u001c;D_2\u0004\u0003BCA\u0002e\nU\r\u0011\"\u0001\u0002\u0006\u00051a/\u00197vKN,\"!a\u0002\u0011\t}1\u0013\u0011\u0002\t\u0004U\u0005-\u0011bAA\u0007W\t9A*\u001b;fe\u0006d\u0007BCA\te\nE\t\u0015!\u0003\u0002\b\u00059a/\u00197vKN\u0004\u0003BB\u001es\t\u0003\t)\u0002\u0006\u0004\u0002\u0018\u0005e\u00111\u0004\t\u0003\u000bJDa\u0001`A\n\u0001\u0004I\u0003\u0002CA\u0002\u0003'\u0001\r!a\u0002\t\u0013\u0005}!/!A\u0005\u0002\u0005\u0005\u0012\u0001B2paf$b!a\u0006\u0002$\u0005\u0015\u0002\u0002\u0003?\u0002\u001eA\u0005\t\u0019A\u0015\t\u0015\u0005\r\u0011Q\u0004I\u0001\u0002\u0004\t9\u0001C\u0005\u0002*I\f\n\u0011\"\u0001\u0002,\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0017U\rI\u0013qF\u0016\u0003\u0003c\u0001B!a\r\u0002>5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0005v]\u000eDWmY6fI*\u0019\u00111\b\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005U\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\t:\u0012\u0002\u0013\u0005\u0011QI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9E\u000b\u0003\u0002\b\u0005=\u0002\"CA&e\u0006\u0005I\u0011IA'\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006L1\u0001WA*\u0011%\tyF]A\u0001\n\u0003\t\t'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002dA\u0019Q\"!\u001a\n\u0007\u0005\u001ddBA\u0002J]RD\u0011\"a\u001bs\u0003\u0003%\t!!\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qNA;!\ri\u0011\u0011O\u0005\u0004\u0003gr!aA!os\"Q\u0011qOA5\u0003\u0003\u0005\r!a\u0019\u0002\u0007a$\u0013\u0007C\u0005\u0002|I\f\t\u0011\"\u0011\u0002~\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000A1\u0011\u0011QAD\u0003_j!!a!\u000b\u0007\u0005\u0015e\"\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u000eJ\f\t\u0011\"\u0001\u0002\u0010\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0012\u0006]\u0005cA\u0007\u0002\u0014&\u0019\u0011Q\u0013\b\u0003\u000f\t{w\u000e\\3b]\"Q\u0011qOAF\u0003\u0003\u0005\r!a\u001c\t\u0013\u0005m%/!A\u0005B\u0005u\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\r\u0004\"CAQe\u0006\u0005I\u0011IAR\u0003\u0019)\u0017/^1mgR!\u0011\u0011SAS\u0011)\t9(a(\u0002\u0002\u0003\u0007\u0011qN\u0004\u000b\u0003SC\u0014\u0011!E\u0001\u0005\u0005-\u0016!\u0003)jm>$H+\u001f9f!\r)\u0015Q\u0016\u0004\ngb\n\t\u0011#\u0001\u0003\u0003_\u001bR!!,\u00022b\u0004\u0012\"a-\u0002:&\n9!a\u0006\u000e\u0005\u0005U&bAA\\\u001d\u00059!/\u001e8uS6,\u0017\u0002BA^\u0003k\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001dY\u0014Q\u0016C\u0001\u0003\u007f#\"!a+\t\u0013A\u000bi+!A\u0005F\u0005\rGCAA(\u0011%q\u0014QVA\u0001\n\u0003\u000b9\r\u0006\u0004\u0002\u0018\u0005%\u00171\u001a\u0005\u0007y\u0006\u0015\u0007\u0019A\u0015\t\u0011\u0005\r\u0011Q\u0019a\u0001\u0003\u000fA!\"a4\u0002.\u0006\u0005I\u0011QAi\u0003\u001d)h.\u00199qYf$B!a5\u0002`B)Q\"!6\u0002Z&\u0019\u0011q\u001b\b\u0003\r=\u0003H/[8o!\u0019i\u00111\\\u0015\u0002\b%\u0019\u0011Q\u001c\b\u0003\rQ+\b\u000f\\33\u0011)\t\t/!4\u0002\u0002\u0003\u0007\u0011qC\u0001\u0004q\u0012\u0002\u0004BCAs\u0003[\u000b\t\u0011\"\u0003\u0002h\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u000f\u0005\u0003\u0002R\u0005-\u0018\u0002BAw\u0003'\u0012aa\u00142kK\u000e$\bbB\u001e\u0001\t#\u0011\u0011\u0011\u001f\u000b\b\u0001\u0006M\u0018Q_A|\u0011\u0019\u0019\u0012q\u001ea\u0001)!1Q$a<A\u0002yAaAMAx\u0001\u0004\u0019\u0004\u0002CA~\u0001\u0001&I!!@\u0002\tQ|GI\u0012\u000b\u0004)\u0005}\bb\u0002B\u0001\u0003s\u0004\rAH\u0001\tC\u001e<W\t\u001f9sg\"A!Q\u0001\u0001!\n\u0013\u00119!A\u0003bY&\f7\u000f\u0006\u0003\u0003\n\t=\u0001c\u0001\u0016\u0003\f%\u0019!QB\u0016\u0003\u001f9\u000bW.\u001a3FqB\u0014Xm]:j_:DqA!\u0005\u0003\u0004\u0001\u0007\u0011&\u0001\u0003fqB\u0014\b\u0002\u0003B\u000b\u0001\u0001&IAa\u0006\u0002/\u0005<wM]3hCR,g*^7fe&\u001c7i\u001c7v[:\u001cH\u0003\u0002B\r\u0005c!2\u0001\u0006B\u000e\u0011!\u0011iBa\u0005A\u0002\t}\u0011!\u00014\u0011\r5\u0011\t#\u000bB\u0013\u0013\r\u0011\u0019C\u0004\u0002\n\rVt7\r^5p]F\u0002BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0004\u0005WY\u0013!C1hOJ,w-\u0019;f\u0013\u0011\u0011yC!\u000b\u0003#\u0005;wM]3hCR,g)\u001e8di&|g\u000e\u0003\u0005\u00034\tM\u0001\u0019\u0001B\u001b\u0003!\u0019w\u000e\u001c(b[\u0016\u001c\b\u0003B\u0007\u00038IK1A!\u000f\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0005\t\u0005{\u0001\u0001\u0015\"\u0003\u0003@\u0005I1\u000f\u001e:U_\u0016C\bO\u001d\u000b\u0005\u0005\u0003\u0012\u0019\u0005E\u0003\u000e\u0005CI\u0013\u0006C\u0004\u0003\u0012\tm\u0002\u0019\u0001*\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003J\u0005\u0019\u0011mZ4\u0015\u000bQ\u0011YE!\u0015\t\u0011\t5#Q\ta\u0001\u0005\u001f\nq!Y4h\u000bb\u0004(\u000fE\u0003\u000e\u00037\u0014&\u000b\u0003\u0005\u0003\u0002\t\u0015\u0003\u0019\u0001B*!\u0015i!q\u0007B(\u0011\u001d\u00119\u0005\u0001C\u0001\u0005/\"2\u0001\u0006B-\u0011!\u0011YF!\u0016A\u0002\tu\u0013!B3yaJ\u001c\b#B*\u0003`I\u0013\u0016b\u0001B13\n\u0019Q*\u00199\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003fQ\u0019ACa\u001a\t\u0011\tm#1\ra\u0001\u0005S\u0002bAa\u001b\u0003rI\u0013VB\u0001B7\u0015\u0011\u0011y'a\u0016\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005C\u0012i\u0007C\u0004\u0003H\u0001!\tA!\u001e\u0015\u000bQ\u00119Ha \t\u0011\tE!1\u000fa\u0001\u0005s\u00022A\u0006B>\u0013\r\u0011iH\u0001\u0002\u0007\u0007>dW/\u001c8\t\u0011\tm#1\u000fa\u0001\u0005\u0003\u0003R!\u0004B\u001c\u0005sBCAa\u001d\u0003\u0006B!!q\u0011BE\u001b\t\tI$\u0003\u0003\u0003\f\u0006e\"a\u0002<be\u0006\u0014xm\u001d\u0005\b\u0005\u001f\u0003A\u0011\u0001BI\u0003\u0015\u0019w.\u001e8u)\u0005!\u0002b\u0002BK\u0001\u0011\u0005!qS\u0001\u0005[\u0016\fg\u000eF\u0002\u0015\u00053C\u0001Ba\r\u0003\u0014\u0002\u0007!Q\u0007\u0015\u0005\u0005'\u0013)\tC\u0004\u0003 \u0002!\tA!)\u0002\u00075\f\u0007\u0010F\u0002\u0015\u0005GC\u0001Ba\r\u0003\u001e\u0002\u0007!Q\u0007\u0015\u0005\u0005;\u0013)\tC\u0004\u0003*\u0002!\tAa+\u0002\u0007\u00054x\rF\u0002\u0015\u0005[C\u0001Ba\r\u0003(\u0002\u0007!Q\u0007\u0015\u0005\u0005O\u0013)\tC\u0004\u00034\u0002!\tA!.\u0002\u00075Lg\u000eF\u0002\u0015\u0005oC\u0001Ba\r\u00032\u0002\u0007!Q\u0007\u0015\u0005\u0005c\u0013)\tC\u0004\u0003>\u0002!\tAa0\u0002\u0007M,X\u000eF\u0002\u0015\u0005\u0003D\u0001Ba\r\u0003<\u0002\u0007!Q\u0007\u0015\u0005\u0005w\u0013)\tC\u0004\u0003H\u0002!\tA!3\u0002\u000bALgo\u001c;\u0015\u0007\u0001\u0013Y\rC\u0004\u0003N\n\u0015\u0007\u0019\u0001*\u0002\u0017ALgo\u001c;D_2,XN\u001c\u0005\b\u0005\u000f\u0004A\u0011\u0001Bi)\u0015\u0001%1\u001bBk\u0011\u001d\u0011iMa4A\u0002IC\u0001\"a\u0001\u0003P\u0002\u0007!q\u001b\t\u0005?\u0019\ny\u0007C\u0004\u0003H\u0002!\tAa7\u0015\u000b\u0001\u0013iNa8\t\u000f\t5'\u0011\u001ca\u0001%\"A\u00111\u0001Bm\u0001\u0004\u0011\t\u000f\u0005\u0004\u0003l\t\r\u0018qN\u0005\u0005\u0005K\u0014iG\u0001\u0003MSN$\bb\u0002Bd\u0001\u0011\u0005!\u0011\u001e\u000b\u0004\u0001\n-\b\u0002\u0003Bg\u0005O\u0004\rA!\u001f\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003pR)\u0001I!=\u0003t\"A!Q\u001aBw\u0001\u0004\u0011I\b\u0003\u0005\u0002\u0004\t5\b\u0019\u0001Bl\u0011\u001d\u00119\r\u0001C\u0001\u0005o$R\u0001\u0011B}\u0005wD\u0001B!4\u0003v\u0002\u0007!\u0011\u0010\u0005\t\u0003\u0007\u0011)\u00101\u0001\u0003b\"A!q \u0001\u0005\u0002\t\u0019\t!\u0001\tgY\u0006$X*\u00199He>,\bo]%o%RIAca\u0001\u0004\u0012\rU1q\u0005\u0005\t\u0005;\u0011i\u00101\u0001\u0004\u0006A)Qba\u0002\u0004\f%\u00191\u0011\u0002\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\u0019i!C\u0002\u0004\u00109\u0011AAQ=uK\"A11\u0003B\u007f\u0001\u0004\u0019)!\u0001\u0007qC\u000e\\\u0017mZ3OC6,7\u000f\u0003\u0005\u0004\u0018\tu\b\u0019AB\r\u00035\u0011'o\\1eG\u0006\u001cHOV1sgB)Qba\u0002\u0004\u001cA11QDB\u0012\u0003Sl!aa\b\u000b\u0007\r\u0005B!A\u0005ce>\fGmY1ti&!1QEB\u0010\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0003\u0005\u0004*\tu\b\u0019AB\u0016\u00031yW\u000f\u001e9viN\u001b\u0007.Z7b!\u0011\u0019ica\r\u000e\u0005\r=\"bAB\u0019\u0005\u0005)A/\u001f9fg&!1QGB\u0018\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0007s\u0001A\u0011\u0001\u0002\u0004<\u0005)b\r\\1u\u001b\u0006\u0004xI]8vaNLe\u000eU1oI\u0006\u001cHc\u0001\u000b\u0004>!A!\u0011CB\u001c\u0001\u0004\u0019y\u0004E\u0002+\u0007\u0003J1aa\u0011,\u0005%\u0001\u0016\u0010\u001e5p]V#e\tC\u0003Q\u0001\u0011\u0005\u0013\u000bK\u0002\u0001\u0007\u0013\u0002Baa\u0013\u0004V9!1QJB)\u001b\t\u0019yEC\u0002\u0002<\u0011IAaa\u0015\u0004P\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u00199f!\u0017\u0003\rM#\u0018M\u00197f\u0015\u0011\u0019\u0019fa\u0014")
public class RelationalGroupedDataset {
    private final Dataset<Row> df;
    private final Seq<Expression> groupingExprs;
    private final GroupType groupType;

    public static RelationalGroupedDataset apply(Dataset<Row> dataset, Seq<Expression> seq, GroupType groupType) {
        return RelationalGroupedDataset$.MODULE$.apply(dataset, seq, groupType);
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        return this.agg(expr, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> mean(String ... colNames) {
        return this.mean((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> max(String ... colNames) {
        return this.max((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> avg(String ... colNames) {
        return this.avg((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> min(String ... colNames) {
        return this.min((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> sum(String ... colNames) {
        return this.sum((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> toDF(Seq<Expression> aggExprs) {
        Dataset<Row> dataset;
        Seq aggregates = this.df.sparkSession().sessionState().conf().dataFrameRetainGroupColumns() ? (Seq)this.groupingExprs.$plus$plus(aggExprs, Seq$.MODULE$.canBuildFrom()) : aggExprs;
        Seq aliasedAgg = (Seq)aggregates.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate(this.groupingExprs, aliasedAgg, this.df.logicalPlan()));
        } else if (RelationalGroupedDataset$RollupType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rollup[]{new Rollup(this.groupingExprs)})), aliasedAgg, this.df.logicalPlan()));
        } else if (RelationalGroupedDataset$CubeType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cube[]{new Cube(this.groupingExprs)})), aliasedAgg, this.df.logicalPlan()));
        } else if (groupType instanceof PivotType) {
            PivotType pivotType = (PivotType)groupType;
            Expression pivotCol = pivotType.pivotCol();
            Seq<Literal> values = pivotType.values();
            Seq aliasedGrps = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
            dataset = Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)new Pivot((Option)new Some((Object)aliasedGrps), pivotCol, values, aggExprs, this.df.logicalPlan()));
        } else {
            throw new MatchError((Object)groupType);
        }
        return dataset;
    }

    private NamedExpression alias(Expression expr) {
        AggregateExpression aggregateExpression;
        NamedExpression namedExpression;
        Expression expression = expr;
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            namedExpression = new UnresolvedAlias((Expression)unresolvedAttribute, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression instanceof NamedExpression) {
            NamedExpression namedExpression2;
            namedExpression = namedExpression2 = (NamedExpression)expression;
        } else if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof TypedAggregateExpression) {
            namedExpression = new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else if (expression != null) {
            Expression expression2;
            Expression x$10 = expression2 = expression;
            String x$11 = package$.MODULE$.toPrettySQL(expression2);
            ExprId x$12 = Alias$.MODULE$.apply$default$3(x$10, x$11);
            Seq x$13 = Alias$.MODULE$.apply$default$4(x$10, x$11);
            Option x$14 = Alias$.MODULE$.apply$default$5(x$10, x$11);
            namedExpression = new Alias(x$10, x$11, x$12, x$13, x$14);
        } else {
            throw new MatchError((Object)expression);
        }
        return namedExpression;
    }

    private Dataset<Row> aggregateNumericColumns(Seq<String> colNames, Function1<Expression, AggregateFunction> f) {
        Seq columnExprs = colNames.isEmpty() ? this.df.numericColumns() : (Seq)colNames.map((Function1 & Serializable & scala.Serializable)colName -> {
            void var2_2;
            NamedExpression namedExpr = $this.df.resolve((String)colName);
            if (!(((Expression)namedExpr).dataType() instanceof NumericType)) {
                throw new AnalysisException(new java.lang.StringBuilder(89).append("\"").append((String)colName).append("\" is not a numeric column. ").append("Aggregation function can only be applied on a numeric column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
        return this.toDF((Seq<Expression>)((Seq)columnExprs.map((Function1 & Serializable & scala.Serializable)expr -> ((AggregateFunction)f.apply(expr)).toAggregateExpression(), Seq$.MODULE$.canBuildFrom())));
    }

    private Function1<Expression, Expression> strToExpr(String expr) {
        Function1 & Serializable & scala.Serializable exprToFunc = (Function1 & Serializable & scala.Serializable)inputExpr -> {
            UnresolvedFunction unresolvedFunction;
            String string = expr.toLowerCase(Locale.ROOT);
            boolean bl = "avg".equals(string) ? true : ("average".equals(string) ? true : "mean".equals(string));
            if (bl) {
                Expression expression = inputExpr;
                unresolvedFunction = UnresolvedFunction$.MODULE$.apply("avg", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
            } else {
                boolean bl2 = "stddev".equals(string) ? true : "std".equals(string);
                if (bl2) {
                    Expression expression = inputExpr;
                    unresolvedFunction = UnresolvedFunction$.MODULE$.apply("stddev", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                } else {
                    boolean bl3 = "count".equals(string) ? true : "size".equals(string);
                    if (bl3) {
                        Expression expression = inputExpr;
                        AggregateExpression aggregateExpression = expression instanceof Star ? Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression() : Count$.MODULE$.apply(inputExpr).toAggregateExpression();
                        unresolvedFunction = aggregateExpression;
                    } else {
                        Expression expression = inputExpr;
                        unresolvedFunction = UnresolvedFunction$.MODULE$.apply(string, (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                    }
                }
            }
            return unresolvedFunction;
        };
        return (Function1 & Serializable & scala.Serializable)inputExpr -> (Expression)exprToFunc.apply(inputExpr);
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        Tuple2<String, String> tuple2 = aggExpr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)aggExprs.$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)$this.df.apply(colName).expr());
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> agg(scala.collection.immutable.Map<String, String> exprs) {
        return this.toDF((Seq<Expression>)((TraversableOnce)exprs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)$this.df.apply(colName).expr());
            return expression;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        return this.agg((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(exprs).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        Column column = expr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)exprs.$plus$colon((Object)column, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Expression expression;
            Column column = x0$3;
            if (column instanceof TypedColumn) {
                TypedColumn typedColumn = (TypedColumn)column;
                expression = typedColumn.withInputType($this.df.exprEnc(), (Seq<Attribute>)$this.df.logicalPlan().output()).expr();
            } else {
                expression = column.expr();
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> count() {
        Alias[] aliasArray = new Alias[1];
        AggregateExpression x$15 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        String x$16 = "count";
        ExprId x$17 = Alias$.MODULE$.apply$default$3((Expression)x$15, x$16);
        Seq x$18 = Alias$.MODULE$.apply$default$4((Expression)x$15, x$16);
        Option x$19 = Alias$.MODULE$.apply$default$5((Expression)x$15, x$16);
        aliasArray[0] = new Alias((Expression)x$15, x$16, x$17, x$18, x$19);
        return this.toDF((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray))));
    }

    public Dataset<Row> mean(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> max(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Max$.MODULE$);
    }

    public Dataset<Row> avg(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> min(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Min$.MODULE$);
    }

    public Dataset<Row> sum(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Sum$.MODULE$);
    }

    public RelationalGroupedDataset pivot(String pivotColumn) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn));
    }

    public RelationalGroupedDataset pivot(String pivotColumn, Seq<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(String pivotColumn, List<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn) {
        int maxValues = this.df.sparkSession().sessionState().conf().dataFramePivotMaxValues();
        Seq values = Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.df.select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
        if (values.length() > maxValues) {
            throw new AnalysisException(new java.lang.StringBuilder(142).append("The pivot column ").append(pivotColumn).append(" has more than ").append(maxValues).append(" distinct values, ").append("this could indicate an error. ").append(new java.lang.StringBuilder(27).append("If this was intended, set ").append(SQLConf$.MODULE$.DATAFRAME_PIVOT_MAX_VALUES().key()).append(" ").toString()).append("to at least the number of distinct values of the pivot column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.pivot(pivotColumn, (Seq<Object>)values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, Seq<Object> values) {
        GroupType groupType = this.groupType;
        if (!RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            if (groupType instanceof PivotType) {
                throw new UnsupportedOperationException("repeated pivots are not supported");
            }
            throw new UnsupportedOperationException("pivot is only supported after a groupBy");
        }
        RelationalGroupedDataset relationalGroupedDataset = new RelationalGroupedDataset(this.df, this.groupingExprs, new PivotType(pivotColumn.expr(), (Seq<Literal>)((Seq)values.map((Function1 & Serializable & scala.Serializable)v -> Literal$.MODULE$.apply(v), Seq$.MODULE$.canBuildFrom()))));
        return relationalGroupedDataset;
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, List<Object> values) {
        return this.pivot(pivotColumn, (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()));
    }

    public Dataset<Row> flatMapGroupsInR(byte[] f, byte[] packageNames, Broadcast<Object>[] broadcastVars, StructType outputSchema) {
        Seq groupingNamedExpressions = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        Seq groupingCols = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$7 -> Column$.MODULE$.apply((Expression)x$7), Seq$.MODULE$.canBuildFrom());
        Dataset<Row> groupingDataFrame = this.df.select((Seq<Column>)groupingCols);
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toAttribute(), Seq$.MODULE$.canBuildFrom());
        return Dataset$.MODULE$.ofRows(this.df.sparkSession(), FlatMapGroupsInR$.MODULE$.apply(f, packageNames, broadcastVars, outputSchema, groupingDataFrame.exprEnc().deserializer(), this.df.exprEnc().deserializer(), this.df.exprEnc().schema(), groupingAttributes, this.df.logicalPlan().output(), this.df.logicalPlan()));
    }

    public Dataset<Row> flatMapGroupsInPandas(PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_GROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a grouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq groupingNamedExpressions = (Seq)this.groupingExprs.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            NamedExpression namedExpression;
            Expression expression = x0$4;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$20 = expression;
                String x$21 = expression.toString();
                ExprId x$22 = Alias$.MODULE$.apply$default$3(x$20, x$21);
                Seq x$23 = Alias$.MODULE$.apply$default$4(x$20, x$21);
                Option x$24 = Alias$.MODULE$.apply$default$5(x$20, x$21);
                namedExpression = new Alias(x$20, x$21, x$22, x$23, x$24);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        LogicalPlan child = this.df.logicalPlan();
        Project project = new Project((Seq)groupingNamedExpressions.$plus$plus((GenTraversableOnce)child.output(), Seq$.MODULE$.canBuildFrom()), child);
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapGroupsInPandas plan = new FlatMapGroupsInPandas(groupingAttributes, (Expression)expr, output, (LogicalPlan)project);
        return Dataset$.MODULE$.ofRows(this.df.sparkSession(), (LogicalPlan)plan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationalGroupedDataset: [grouping expressions: [");
        Seq kFields = (Seq)this.groupingExprs.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string;
                boolean bl = false;
                NamedExpression namedExpression = null;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)A1;
                    if (((Expression)namedExpression).resolved()) {
                        string = new java.lang.StringBuilder(2).append(namedExpression.name()).append(": ").append(((Expression)namedExpression).dataType().simpleString(2)).toString();
                        return (B1)string;
                    }
                }
                if (bl) {
                    string = namedExpression.name();
                    return (B1)string;
                }
                string = A1.toString();
                return (B1)string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                Expression expression = x1;
                if (expression instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)expression;
                    if (((Expression)namedExpression).resolved()) {
                        return true;
                    }
                }
                if (!bl) return true;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        builder.append(((TraversableOnce)kFields.take(2)).mkString(", "));
        Object object = kFields.length() > 2 ? builder.append(new java.lang.StringBuilder(19).append(" ... ").append(kFields.length() - 2).append(" more field(s)").toString()) : BoxedUnit.UNIT;
        return builder.append(new java.lang.StringBuilder(19).append("], value: ").append(this.df.toString()).append(", type: ").append(this.groupType).append("]").toString()).toString();
    }

    public RelationalGroupedDataset(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        this.df = df;
        this.groupingExprs = groupingExprs;
        this.groupType = groupType;
    }

    public static interface GroupType {
        default public String toString() {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getSimpleName())).stripSuffix("$"))).stripSuffix("Type");
        }

        public static void $init$(GroupType $this) {
        }
    }

    public static class PivotType
    implements GroupType,
    Product,
    scala.Serializable {
        private final Expression pivotCol;
        private final Seq<Literal> values;

        @Override
        public String toString() {
            return ((GroupType)this).toString();
        }

        public Expression pivotCol() {
            return this.pivotCol;
        }

        public Seq<Literal> values() {
            return this.values;
        }

        public PivotType copy(Expression pivotCol, Seq<Literal> values) {
            return new PivotType(pivotCol, values);
        }

        public Expression copy$default$1() {
            return this.pivotCol();
        }

        public Seq<Literal> copy$default$2() {
            return this.values();
        }

        public String productPrefix() {
            return "PivotType";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Seq<Literal> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.pivotCol();
                    break;
                }
                case 1: {
                    seq = this.values();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PivotType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PivotType)) return false;
            boolean bl = true;
            if (!bl) return false;
            PivotType pivotType = (PivotType)x$1;
            Expression expression = this.pivotCol();
            Expression expression2 = pivotType.pivotCol();
            if (expression == null) {
                if (expression2 != null) {
                    return false;
                }
            } else if (!expression.equals(expression2)) return false;
            Seq<Literal> seq = this.values();
            Seq<Literal> seq2 = pivotType.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!pivotType.canEqual(this)) return false;
            return true;
        }

        public PivotType(Expression pivotCol, Seq<Literal> values) {
            this.pivotCol = pivotCol;
            this.values = values;
            GroupType.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

