/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.mapred.OrcOutputFormat;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapreduce.OrcInputFormat;
import org.apache.orc.storage.ql.io.sarg.SearchArgument;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rxAB\u0001\u0003\u0011\u0003A\u0001#A\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r\u001e\u0006\u0003\u0007\u0011\t1a\u001c:d\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u0004\"!\u0005\n\u000e\u0003\t1aa\u0005\u0002\t\u0002!!\"!D(sG\u001aKG.\u001a$pe6\fGoE\u0002\u0013+m\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0007C\u0001\f\u001d\u0013\tirC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003 %\u0011\u0005\u0011%\u0001\u0004=S:LGOP\u0002\u0001)\u0005\u0001\u0002\"B\u0012\u0013\t\u0013!\u0013AD2iK\u000e\\g)[3mI:\u000bW.\u001a\u000b\u0003K!\u0002\"A\u0006\u0014\n\u0005\u001d:\"\u0001B+oSRDQ!\u000b\u0012A\u0002)\nAA\\1nKB\u00111F\r\b\u0003YA\u0002\"!L\f\u000e\u00039R!a\f\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\tt#\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019\u0018\u0011\u00151$\u0003\"\u00018\u0003=\u0019\u0007.Z2l\r&,G\u000e\u001a(b[\u0016\u001cHCA\u00139\u0011\u0015IT\u00071\u0001;\u0003\u0015q\u0017-\\3t!\rY\u0004I\u000b\b\u0003yyr!!L\u001f\n\u0003aI!aP\f\u0002\u000fA\f7m[1hK&\u0011\u0011I\u0011\u0002\u0004'\u0016\f(BA \u0018\u0011\u0015!%\u0003\"\u0001F\u0003U9W\r^)v_R,GmU2iK6\f7\u000b\u001e:j]\u001e$\"A\u000b$\t\u000b\u001d\u001b\u0005\u0019\u0001%\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0005\u0002\u000bQL\b/Z:\n\u00055S%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f=\u0013\u0012\u0011!C\u0005!\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\t\u0006C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0011a\u0017M\\4\u000b\u0003Y\u000bAA[1wC&\u0011\u0001l\u0015\u0002\u0007\u001f\nTWm\u0019;\u0007\tM\u0011\u0001AW\n\u00063VYv,\u001a\t\u00039vk\u0011\u0001B\u0005\u0003=\u0012\u0011!BR5mK\u001a{'/\\1u!\t\u00017-D\u0001b\u0015\t\u0011\u0007\"A\u0004t_V\u00148-Z:\n\u0005\u0011\f'A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"AZ5\u000e\u0003\u001dT!\u0001[+\u0002\u0005%|\u0017BA\u000fh\u0011\u0015y\u0012\f\"\u0001l)\u0005a\u0007CA\tZ\u0011\u0015q\u0017\f\"\u0011p\u0003%\u0019\bn\u001c:u\u001d\u0006lW\rF\u0001+\u0011\u0015\t\u0018\f\"\u0011p\u0003!!xn\u0015;sS:<\u0007\"B:Z\t\u0003\"\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003U\u0004\"A\u0006<\n\u0005]<\"aA%oi\")\u00110\u0017C!u\u00061Q-];bYN$\"a\u001f@\u0011\u0005Ya\u0018BA?\u0018\u0005\u001d\u0011un\u001c7fC:Daa =A\u0002\u0005\u0005\u0011!B8uQ\u0016\u0014\bc\u0001\f\u0002\u0004%\u0019\u0011QA\f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\ne#\t%a\u0003\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\t\u0003\u001b\tI\"!\n\u00020A)a#a\u0004\u0002\u0014%\u0019\u0011\u0011C\f\u0003\r=\u0003H/[8o!\rI\u0015QC\u0005\u0004\u0003/Q%AC*ueV\u001cG\u000fV=qK\"A\u00111DA\u0004\u0001\u0004\ti\"\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002 \u0005\u0005R\"\u0001\u0005\n\u0007\u0005\r\u0002B\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0005\u0002(\u0005\u001d\u0001\u0019AA\u0015\u0003\u001dy\u0007\u000f^5p]N\u0004RaKA\u0016U)J1!!\f5\u0005\ri\u0015\r\u001d\u0005\t\u0003c\t9\u00011\u0001\u00024\u0005)a-\u001b7fgB!1\bQA\u001b!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t!AZ:\u000b\u0007\u0005}B\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u0007\nID\u0001\u0006GS2,7\u000b^1ukNDq!a\u0012Z\t\u0003\nI%\u0001\u0007qe\u0016\u0004\u0018M]3Xe&$X\r\u0006\u0006\u0002L\u0005E\u00131KA2\u0003K\u00022\u0001XA'\u0013\r\ty\u0005\u0002\u0002\u0014\u001fV$\b/\u001e;Xe&$XM\u001d$bGR|'/\u001f\u0005\t\u00037\t)\u00051\u0001\u0002\u001e!A\u0011QKA#\u0001\u0004\t9&A\u0002k_\n\u0004B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0005\u0003;\ni$A\u0005nCB\u0014X\rZ;dK&!\u0011\u0011MA.\u0005\rQuN\u0019\u0005\t\u0003O\t)\u00051\u0001\u0002*!A\u0011qMA#\u0001\u0004\t\u0019\"\u0001\u0006eCR\f7k\u00195f[\u0006Dq!a\u001bZ\t\u0003\ni'\u0001\u0007tkB\u0004xN\u001d;CCR\u001c\u0007\u000eF\u0003|\u0003_\n\t\b\u0003\u0005\u0002\u001c\u0005%\u0004\u0019AA\u000f\u0011!\t\u0019(!\u001bA\u0002\u0005M\u0011AB:dQ\u0016l\u0017\rC\u0004\u0002xe#\t%!\u001f\u0002\u0017%\u001c8\u000b\u001d7ji\u0006\u0014G.\u001a\u000b\bw\u0006m\u0014QPA@\u0011!\tY\"!\u001eA\u0002\u0005u\u0001\u0002CA\u0014\u0003k\u0002\r!!\u000b\t\u0011\u0005\u0005\u0015Q\u000fa\u0001\u0003\u0007\u000bA\u0001]1uQB!\u0011qGAC\u0013\u0011\t9)!\u000f\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003\u0017KF\u0011IAG\u0003y\u0011W/\u001b7e%\u0016\fG-\u001a:XSRD\u0007+\u0019:uSRLwN\u001c,bYV,7\u000f\u0006\t\u0002\u0010\u00065\u0016qVAY\u0003k\u000bI,!2\u0002HB9a#!%\u0002\u0016\u0006m\u0015bAAJ/\tIa)\u001e8di&|g.\r\t\u00049\u0006]\u0015bAAM\t\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003<\u0003;\u000b\t+C\u0002\u0002 \n\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0005\u0002\u0011\r\fG/\u00197zgRLA!a+\u0002&\nY\u0011J\u001c;fe:\fGNU8x\u0011!\tY\"!#A\u0002\u0005u\u0001\u0002CA4\u0003\u0013\u0003\r!a\u0005\t\u0011\u0005M\u0016\u0011\u0012a\u0001\u0003'\tq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\t\u0003o\u000bI\t1\u0001\u0002\u0014\u0005q!/Z9vSJ,GmU2iK6\f\u0007\u0002CA^\u0003\u0013\u0003\r!!0\u0002\u000f\u0019LG\u000e^3sgB!1\bQA`!\r\u0001\u0017\u0011Y\u0005\u0004\u0003\u0007\f'A\u0002$jYR,'\u000f\u0003\u0005\u0002(\u0005%\u0005\u0019AA\u0015\u0011!\tI-!#A\u0002\u0005-\u0017A\u00035bI>|\u0007oQ8oMB!\u0011QZAj\u001b\t\tyM\u0003\u0003\u0002R\u0006u\u0012\u0001B2p]\u001aLA!!6\u0002P\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!!7Z\t\u0003\nY.A\btkB\u0004xN\u001d;ECR\fG+\u001f9f)\u0015Y\u0018Q\\Ap\u0011\u00199\u0015q\u001ba\u0001\u0011\"9\u0011\u0011]Al\u0001\u0004Y\u0018AC5t%\u0016\fG\rU1uQ\u0002")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static String getQuotedSchemaString(DataType dataType) {
        return OrcFileFormat$.MODULE$.getQuotedSchemaString(dataType);
    }

    public static void checkFieldNames(Seq<String> seq) {
        OrcFileFormat$.MODULE$.checkFieldNames(seq);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.readSchema(sparkSession, files);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatch$1(x$1)));
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(dataSchema, filters).foreach((Function1 & Serializable & scala.Serializable)f -> {
                OrcFileFormat.$anonfun$buildReaderWithPartitionValues$1(dataSchema, hadoopConf, f);
                return BoxedUnit.UNIT;
            });
        }
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        boolean copyToSpark = BoxesRunTime.unboxToBoolean((Object)sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK()));
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            RecordReaderIterator<ColumnarBatch> recordReaderIterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)conf).filesystem(fs);
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)readerOptions);
            Option<int[]> requestedColIdsOrEmptyFile = OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, reader, conf);
            if (requestedColIdsOrEmptyFile.isEmpty()) {
                recordReaderIterator = package$.MODULE$.Iterator().empty();
            } else {
                int[] requestedColIds = (int[])requestedColIdsOrEmptyFile.get();
                Predef$.MODULE$.assert(requestedColIds.length == requiredSchema.length(), (Function0 & Serializable & scala.Serializable)() -> "[BUG] requested column IDs do not match required schema");
                Configuration taskConf = new Configuration(conf);
                taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != -1))).sorted((Ordering)Ordering.Int$.MODULE$))).mkString(","));
                FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                if (enableVectorizedReader) {
                    OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(enableOffHeapColumnVector && taskContext.isDefined(), copyToSpark, capacity);
                    RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    batchReader.initBatch(reader.getSchema(), requestedColIds, requiredSchema.fields(), partitionSchema, file.partitionValues());
                    recordReaderIterator = iter;
                } else {
                    RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> x$5.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$6 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    OrcDeserializer deserializer = new OrcDeserializer(dataSchema, requiredSchema, requestedColIds);
                    if (partitionSchema.length() == 0) {
                        recordReaderIterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        recordReaderIterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
                    }
                }
            }
            return recordReaderIterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType(), isReadPath)));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = dataType2 instanceof NullType ? isReadPath : false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$1(StructType dataSchema$1, Configuration hadoopConf$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument((Configuration)hadoopConf$1, (SearchArgument)f, (String[])dataSchema$1.fieldNames());
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
    }
}

