/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Try$;

public final class ParquetFileFormat$
implements Logging,
scala.Serializable {
    public static ParquetFileFormat$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ParquetFileFormat$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> readSchema(Seq<Footer> footers, SparkSession sparkSession) {
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(sparkSession.sessionState().conf().isParquetBinaryAsString(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        HashSet seen = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq finalSchemas = (Seq)footers.flatMap((Function1 & Serializable & scala.Serializable)footer -> {
            Iterable iterable;
            FileMetaData metadata = footer.getParquetMetadata().getFileMetaData();
            Option serializedSchema = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY());
            if (serializedSchema.isEmpty()) {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)converter.convert(metadata.getSchema())));
            } else if (!seen.contains(serializedSchema.get())) {
                seen.$plus$eq(serializedSchema.get());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DataType$.MODULE$.fromJson((String)serializedSchema.get())).recover((PartialFunction)new scala.Serializable(serializedSchema){
                    public static final long serialVersionUID = 0L;
                    private final Option serializedSchema$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            ParquetFileFormat$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.");
                            object = LegacyTypeStringParser$.MODULE$.parse((String)this.serializedSchema$1.get());
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.serializedSchema$1 = serializedSchema$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
                    }
                }).recover((PartialFunction)new scala.Serializable(serializedSchema){
                    public static final long serialVersionUID = 0L;
                    private final Option serializedSchema$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 != null) {
                            A1 A12 = A1;
                            ParquetFileFormat$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("Failed to parse serialized Spark schema in Parquet key-value metadata:\n                 |\t").append($this.serializedSchema$1).append("\n               ").toString())).stripMargin(), A12);
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x2) {
                        Throwable throwable = x2;
                        boolean bl = throwable != null;
                        return bl;
                    }
                    {
                        this.serializedSchema$1 = serializedSchema$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$$nestedInanonfun$readSchema$1$2 )}, serializedLambda);
                    }
                }).map((Function1 & Serializable & scala.Serializable)x$11 -> (StructType)x$11).getOrElse((Function0 & Serializable & scala.Serializable)() -> converter.convert(metadata.getSchema()))));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        return finalSchemas.reduceOption((Function2 & Serializable & scala.Serializable)(left, right) -> {
            StructType structType;
            try {
                structType = left.merge(right);
            }
            catch (Throwable e) {
                throw new SparkException(new StringBuilder(42).append("Failed to merge incompatible schemas ").append(left).append(" and ").append(right).toString(), e);
            }
            return structType;
        });
    }

    public Seq<Footer> readParquetFootersInParallel(Configuration conf, Seq<FileStatus> partFiles, boolean ignoreCorruptFiles) {
        return (Seq)((GenericTraversableTemplate)ThreadUtils$.MODULE$.parmap(partFiles, "readingParquetFooters", 8, (Function1 & Serializable & scala.Serializable)currentFile -> {
            Some some;
            try {
                some = new Some((Object)new Footer(currentFile.getPath(), ParquetFileReader.readFooter((Configuration)conf, (FileStatus)currentFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS)));
            }
            catch (RuntimeException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(currentFile).toString(), e);
                    some = None$.MODULE$;
                }
                throw new IOException(new StringBuilder(32).append("Could not read footer for file: ").append(currentFile).toString(), e);
            }
            return some;
        }, Seq$.MODULE$.canBuildFrom(), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public Option<StructType> mergeSchemasInParallel(Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        None$ none$;
        boolean x$13;
        Function1 & Serializable & scala.Serializable x$12;
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        SerializableConfiguration serializedConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConf());
        Seq partialFileStatusInfo = (Seq)filesToTouch.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen())), Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)(x$12 = (Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            Seq fakeFileStatuses = iterator.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                long length = tuple2._2$mcJ$sp();
                FileStatus fileStatus = new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                return fileStatus;
            }).toSeq();
            Seq<Footer> footers = MODULE$.readParquetFootersInParallel(serializedConf.value(), (Seq<FileStatus>)fakeFileStatuses, ignoreCorruptFiles);
            ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(assumeBinaryIsString, assumeInt96IsTimestamp);
            if (footers.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                ObjectRef mergedSchema = ObjectRef.create((Object)MODULE$.readSchemaFromFooter((Footer)footers.head(), converter));
                ((IterableLike)footers.tail()).foreach((Function1 & Serializable & scala.Serializable)footer -> {
                    ParquetFileFormat$.$anonfun$mergeSchemasInParallel$4(converter, mergedSchema, footer);
                    return BoxedUnit.UNIT;
                });
                iterator2 = package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
            }
            return iterator2;
        }), x$13 = qual$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef finalSchema = ObjectRef.create((Object)((StructType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).head()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).tail())).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                ParquetFileFormat$.$anonfun$mergeSchemasInParallel$5(finalSchema, schema);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)((StructType)finalSchema.elem));
        }
        return none$;
    }

    public StructType readSchemaFromFooter(Footer footer, ParquetToSparkSchemaConverter converter) {
        FileMetaData fileMetaData = footer.getParquetMetadata().getFileMetaData();
        return (StructType)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileMetaData.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1 & Serializable & scala.Serializable)schemaString -> MODULE$.deserializeSchemaString((String)schemaString)).getOrElse((Function0 & Serializable & scala.Serializable)() -> converter.convert(fileMetaData.getSchema()));
    }

    private Option<StructType> deserializeSchemaString(String schemaString) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (StructType)DataType$.MODULE$.fromJson(schemaString)).recover((PartialFunction)new scala.Serializable(schemaString){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 != null) {
                    ParquetFileFormat$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.");
                    object = (StructType)LegacyTypeStringParser$.MODULE$.parse(this.schemaString$1);
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3()}, serializedLambda);
            }
        }).recoverWith((PartialFunction)new scala.Serializable(schemaString){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 != null) {
                    A1 A12 = A1;
                    ParquetFileFormat$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Failed to parse and ignored serialized Spark schema in ").append(new StringBuilder(29).append("Parquet key-value metadata:\n\t").append($this.schemaString$1).toString()).toString(), A12);
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x4) {
                Throwable throwable = x4;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$deserializeSchemaString$3 )}, serializedLambda);
            }
        }).toOption();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$4(ParquetToSparkSchemaConverter converter$2, ObjectRef mergedSchema$1, Footer footer) {
        StructType schema = MODULE$.readSchemaFromFooter(footer, converter$2);
        try {
            mergedSchema$1.elem = ((StructType)mergedSchema$1.elem).merge(schema);
        }
        catch (SparkException cause) {
            throw new SparkException(new StringBuilder(32).append("Failed merging schema of file ").append(footer.getFile()).append(":\n").append(schema.treeString()).toString(), (Throwable)cause);
        }
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$5(ObjectRef finalSchema$1, StructType schema) {
        try {
            finalSchema$1.elem = ((StructType)finalSchema$1.elem).merge(schema);
        }
        catch (SparkException cause) {
            throw new SparkException(new StringBuilder(23).append("Failed merging schema:\n").append(schema.treeString()).toString(), (Throwable)cause);
        }
    }

    private ParquetFileFormat$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

