/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SparkFatalException;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005mh\u0001B\u0001\u0003\u0001>\u0011QC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7M\u0003\u0002\u0004\t\u0005AQ\r_2iC:<WM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tAQ\t_2iC:<W\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004Qe>$Wo\u0019;\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0002A!f\u0001\n\u0003y\u0012\u0001B7pI\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003K\u0019\nQ\u0001\u001d7b]NT!a\n\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0012\u0003\u001b\t\u0013x.\u00193dCN$Xj\u001c3f\u0011!Y\u0003A!E!\u0002\u0013\u0001\u0013!B7pI\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\u0011I!A\r\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005E\u0001\u0001\"\u0002\u00106\u0001\u0004\u0001\u0003\"B\u00176\u0001\u0004y\u0003\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011I\u001f\u0002\u000f5,GO]5dgV\ta\b\u0005\u0003@\t\u001asU\"\u0001!\u000b\u0005\u0005\u0013\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0019e#\u0001\u0006d_2dWm\u0019;j_:L!!\u0012!\u0003\u00075\u000b\u0007\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h!\ty%+D\u0001Q\u0015\t\tF!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003'B\u0013\u0011bU)M\u001b\u0016$(/[2\t\u000bU\u0003A\u0011\t,\u0002%=,H\u000f];u!\u0006\u0014H/\u001b;j_:LgnZ\u000b\u0002/B\u0011\u0011\u0005W\u0005\u00033\n\u0012A\u0002U1si&$\u0018n\u001c8j]\u001eDQa\u0017\u0001\u0005Bq\u000ba\u0002Z8DC:|g.[2bY&TX\rF\u00010\u0011\u001dq\u0006A1A\u0005\n}\u000bq\u0001^5nK>,H/F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0005ekJ\fG/[8o\u0015\t)g#\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001a2\u0003\u0011\u0011+(/\u0019;j_:Da!\u001b\u0001!\u0002\u0013\u0001\u0017\u0001\u0003;j[\u0016|W\u000f\u001e\u0011)\u0005!\\\u0007CA\u000bm\u0013\tigCA\u0005ue\u0006t7/[3oi\"Aq\u000e\u0001EC\u0002\u0013%\u0001/\u0001\bsK2\fG/[8o\rV$XO]3\u0016\u0003E\u00042A]:v\u001b\u0005!\u0017B\u0001;e\u0005\u00191U\u000f^;sKB\u0019a/_>\u000e\u0003]T!\u0001\u001f\u0005\u0002\u0013\t\u0014x.\u00193dCN$\u0018B\u0001>x\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0002\u0016y&\u0011QP\u0006\u0002\u0004\u0003:L\bF\u00018l\u0011\u001d\t\t\u0001\u0001C)\u0003\u0007\t\u0011\u0002Z8Qe\u0016\u0004\u0018M]3\u0015\u0005\u0005\u0015\u0001cA\u000b\u0002\b%\u0019\u0011\u0011\u0002\f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u001b\u0001A\u0011KA\b\u0003%!w.\u0012=fGV$X\r\u0006\u0002\u0002\u0012A1\u00111CA\r\u0003;i!!!\u0006\u000b\u0007\u0005]\u0001\"A\u0002sI\u0012LA!a\u0007\u0002\u0016\t\u0019!\u000b\u0012#\u0011\t\u0005}\u0011\u0011E\u0007\u0002M%\u0019\u00111\u0005\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\t\u0003O\u0001A\u0011\u000b\u0004\u0002*\u0005\u0011Bm\\#yK\u000e,H/\u001a\"s_\u0006$7-Y:u+\u0011\tY#a\r\u0015\u0005\u00055\u0002\u0003\u0002<z\u0003_\u0001B!!\r\u000241\u0001A\u0001CA\u001b\u0003K\u0011\r!a\u000e\u0003\u0003Q\u000b2!!\u000f|!\r)\u00121H\u0005\u0004\u0003{1\"a\u0002(pi\"Lgn\u001a\u0005\n\u0003\u0003\u0002\u0011\u0011!C\u0001\u0003\u0007\nAaY8qsR)\u0001(!\u0012\u0002H!Aa$a\u0010\u0011\u0002\u0003\u0007\u0001\u0005\u0003\u0005.\u0003\u007f\u0001\n\u00111\u00010\u0011%\tY\u0005AI\u0001\n\u0003\ti%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=#f\u0001\u0011\u0002R-\u0012\u00111\u000b\t\u0005\u0003+\ny&\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003%)hn\u00195fG.,GMC\u0002\u0002^Y\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t'a\u0016\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002f\u0001\t\n\u0011\"\u0001\u0002h\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA5U\ry\u0013\u0011\u000b\u0005\n\u0003[\u0002\u0011\u0011!C!\u0003_\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001$\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0014\u0001\u00049s_\u0012,8\r^!sSRLXCAA<!\r)\u0012\u0011P\u0005\u0004\u0003w2\"aA%oi\"I\u0011q\u0010\u0001\u0002\u0002\u0013\u0005\u0011\u0011Q\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\rY\u00181\u0011\u0005\u000b\u0003\u000b\u000bi(!AA\u0002\u0005]\u0014a\u0001=%c!I\u0011\u0011\u0012\u0001\u0002\u0002\u0013\u0005\u00131R\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0012\t\u0006\u0003\u001f\u000b\tj_\u0007\u0002\u0005&\u0019\u00111\u0013\"\u0003\u0011%#XM]1u_JD\u0011\"a&\u0001\u0003\u0003%\t!!'\u0002\u0011\r\fg.R9vC2$B!a'\u0002\"B\u0019Q#!(\n\u0007\u0005}eCA\u0004C_>dW-\u00198\t\u0013\u0005\u0015\u0015QSA\u0001\u0002\u0004Y\b\"CAS\u0001\u0005\u0005I\u0011IAT\u0003\u0019)\u0017/^1mgR!\u00111TAU\u0011%\t))a)\u0002\u0002\u0003\u00071pB\u0004\u0002.\nA\t!a,\u0002+\t\u0013x.\u00193dCN$X\t_2iC:<W-\u0012=fGB\u0019\u0011#!-\u0007\r\u0005\u0011\u0001\u0012AAZ'\u0015\t\t,!.\u001b!\r)\u0012qW\u0005\u0004\u0003s3\"AB!osJ+g\rC\u00047\u0003c#\t!!0\u0015\u0005\u0005=\u0006bCAa\u0003c\u0013\r\u0011\"\u0001\u0005\u0003\u0007\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0016\u0005\u0005\u0015\u0007c\u0001:\u0002H&\u0019\u0011\u0011\u001a3\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW\rC\u0005\u0002N\u0006E\u0006\u0015!\u0003\u0002F\u0006\tR\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0011\t\u0015\u0005E\u0017\u0011WA\u0001\n\u0003\u000b\u0019.A\u0003baBd\u0017\u0010F\u00039\u0003+\f9\u000e\u0003\u0004\u001f\u0003\u001f\u0004\r\u0001\t\u0005\u0007[\u0005=\u0007\u0019A\u0018\t\u0015\u0005m\u0017\u0011WA\u0001\n\u0003\u000bi.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00171\u001e\t\u0006+\u0005\u0005\u0018Q]\u0005\u0004\u0003G4\"AB(qi&|g\u000eE\u0003\u0016\u0003O\u0004s&C\u0002\u0002jZ\u0011a\u0001V;qY\u0016\u0014\u0004\"CAw\u00033\f\t\u00111\u00019\u0003\rAH\u0005\r\u0005\u000b\u0003c\f\t,!A\u0005\n\u0005M\u0018a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!>\u0011\u0007\u001d\u000b90C\u0002\u0002z\"\u0013aa\u00142kK\u000e$\b")
public class BroadcastExchangeExec
extends Exchange {
    private Map<String, SQLMetric> metrics;
    private transient Future<Broadcast<Object>> relationFuture;
    private final BroadcastMode mode;
    private final SparkPlan child;
    private final transient Duration timeout;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public SparkPlan doCanonicalize() {
        return new BroadcastExchangeExec(this.mode().canonicalized(), (SparkPlan)this.child().canonicalized());
    }

    private Duration timeout() {
        return this.timeout;
    }

    private Future<Broadcast<Object>> relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.sqlContext().sparkSession(), executionId, (Function0 & Serializable & scala.Serializable)() -> {
                    Broadcast broadcast;
                    try {
                        long l;
                        Object relation;
                        long beforeCollect = System.nanoTime();
                        Tuple2<Object, Iterator<InternalRow>> tuple2 = this.child().executeCollectIterator();
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        long numRows = tuple2._1$mcJ$sp();
                        Iterator input = (Iterator)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRows), (Object)input);
                        Tuple2 tuple23 = tuple22;
                        long numRows2 = tuple23._1$mcJ$sp();
                        Iterator input2 = (Iterator)tuple23._2();
                        if (numRows2 >= 512000000L) {
                            throw new SparkException(new StringBuilder(66).append("Cannot broadcast the table with more than 512 millions rows: ").append(numRows2).append(" rows").toString());
                        }
                        long beforeBuild = System.nanoTime();
                        this.longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                        Object object = relation = this.mode().transform(input2, (Option)new Some((Object)BoxesRunTime.boxToLong((long)numRows2)));
                        if (object instanceof HashedRelation) {
                            HashedRelation hashedRelation = (HashedRelation)object;
                            l = hashedRelation.estimatedSize();
                        } else if (object instanceof InternalRow[]) {
                            InternalRow[] internalRowArray = (InternalRow[])object;
                            l = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])internalRowArray)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)BroadcastExchangeExec.$anonfun$relationFuture$3(x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                        } else {
                            throw new SparkException(new StringBuilder(56).append("[BUG] BroadcastMode.transform returned unexpected type: ").append(relation.getClass().getName()).toString());
                        }
                        long dataSize = l;
                        this.longMetric("dataSize").$plus$eq(dataSize);
                        if (dataSize >= 0x200000000L) {
                            throw new SparkException(new StringBuilder(55).append("Cannot broadcast the table that is larger than 8GB: ").append(dataSize >> 30).append(" GB").toString());
                        }
                        long beforeBroadcast = System.nanoTime();
                        this.longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                        Broadcast broadcasted = this.sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                        this.longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                        SQLMetrics$.MODULE$.postDriverMetricUpdates(this.sparkContext(), executionId, (Seq<SQLMetric>)this.metrics().values().toSeq());
                        broadcast = broadcasted;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new SparkFatalException(new OutOfMemoryError(new StringBuilder(133).append("Not enough memory to build and broadcast the table to ").append("all worker nodes. As a workaround, you can either disable broadcast by setting ").append(new StringBuilder(36).append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1 or increase the spark driver ").toString()).append(new StringBuilder(55).append("memory by setting ").append("spark.driver.memory").append(" to a higher value").toString()).toString()).initCause(outOfMemoryError.getCause()));
                    }
                    catch (Throwable throwable) {
                        if (!NonFatal$.MODULE$.apply(throwable)) {
                            throw new SparkFatalException(throwable);
                        }
                        throw throwable;
                    }
                    return broadcast;
                }), (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
        }
        return this.relationFuture;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return !this.bitmap$trans$0 ? this.relationFuture$lzycompute() : this.relationFuture;
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        Broadcast broadcast;
        try {
            broadcast = (Broadcast)ThreadUtils$.MODULE$.awaitResult(this.relationFuture(), this.timeout());
        }
        catch (TimeoutException ex) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Could not execute broadcast in ").append(this.timeout().toSeconds()).append(" secs.").toString(), ex);
            throw new SparkException(new StringBuilder(38).append("Could not execute broadcast in ").append(this.timeout().toSeconds()).append(" secs. ").append(new StringBuilder(52).append("You can increase the timeout for broadcasts via ").append(SQLConf$.MODULE$.BROADCAST_TIMEOUT().key()).append(" or ").toString()).append(new StringBuilder(40).append("disable broadcast join by setting ").append(SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()).append(" to -1").toString()).toString(), (Throwable)ex);
        }
        return broadcast;
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.mode();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$relationFuture$3(InternalRow x$2) {
        return ((UnsafeRow)x$2).getSizeInBytes();
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        long timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0L ? Duration$.MODULE$.Inf() : new package.DurationLong(package$.MODULE$.DurationLong(timeoutValue)).seconds();
    }
}

