/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedList;
import org.apache.spark.SparkException;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.DiskRowQueue;
import org.apache.spark.sql.execution.python.HybridRowQueue$;
import org.apache.spark.sql.execution.python.InMemoryRowQueue;
import org.apache.spark.sql.execution.python.RowQueue;
import org.apache.spark.unsafe.memory.MemoryBlock;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\rc!B\u0001\u0003\u0001\nq!A\u0004%zEJLGMU8x#V,W/\u001a\u0006\u0003\u0007\u0011\ta\u0001]=uQ>t'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cR\u0001A\b\u00163}\u0001\"\u0001E\n\u000e\u0003EQ!A\u0005\u0005\u0002\r5,Wn\u001c:z\u0013\t!\u0012C\u0001\bNK6|'/_\"p]N,X.\u001a:\u0011\u0005Y9R\"\u0001\u0002\n\u0005a\u0011!\u0001\u0003*poF+X-^3\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u000fA\u0013x\u000eZ;diB\u0011!\u0004I\u0005\u0003Cm\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\t\u0001\u0003\u0016\u0004%\t!J\u0001\u000b[\u0016lW*\u00198bO\u0016\u00148\u0001A\u000b\u0002MA\u0011\u0001cJ\u0005\u0003QE\u0011\u0011\u0003V1tW6+Wn\u001c:z\u001b\u0006t\u0017mZ3s\u0011!Q\u0003A!E!\u0002\u00131\u0013aC7f[6\u000bg.Y4fe\u0002B\u0001\u0002\f\u0001\u0003\u0016\u0004%\t!L\u0001\bi\u0016l\u0007\u000fR5s+\u0005q\u0003CA\u00185\u001b\u0005\u0001$BA\u00193\u0003\tIwNC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$\u0001\u0002$jY\u0016D\u0001b\u000e\u0001\u0003\u0012\u0003\u0006IAL\u0001\ti\u0016l\u0007\u000fR5sA!A\u0011\b\u0001BK\u0002\u0013\u0005!(A\u0005ok64\u0015.\u001a7egV\t1\b\u0005\u0002\u001by%\u0011Qh\u0007\u0002\u0004\u0013:$\b\u0002C \u0001\u0005#\u0005\u000b\u0011B\u001e\u0002\u00159,XNR5fY\u0012\u001c\b\u0005\u0003\u0005B\u0001\tU\r\u0011\"\u0001C\u0003\u0019\u0019XM]'heV\t1\t\u0005\u0002E\u000f6\tQI\u0003\u0002G\u0011\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005!+%!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\"A!\n\u0001B\tB\u0003%1)A\u0004tKJluM\u001d\u0011\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)\u0015qu\nU)S!\t1\u0002\u0001C\u0003$\u0017\u0002\u0007a\u0005C\u0003-\u0017\u0002\u0007a\u0006C\u0003:\u0017\u0002\u00071\bC\u0003B\u0017\u0002\u00071\tC\u0004U\u0001\u0001\u0007I\u0011B+\u0002\rE,X-^3t+\u00051\u0006cA,[+5\t\u0001L\u0003\u0002Ze\u0005!Q\u000f^5m\u0013\tY\u0006L\u0001\u0006MS:\\W\r\u001a'jgRDq!\u0018\u0001A\u0002\u0013%a,\u0001\u0006rk\u0016,Xm]0%KF$\"a\u00182\u0011\u0005i\u0001\u0017BA1\u001c\u0005\u0011)f.\u001b;\t\u000f\rd\u0016\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\t\r\u0015\u0004\u0001\u0015)\u0003W\u0003\u001d\tX/Z;fg\u0002B\u0011b\u001a\u0001A\u0002\u0003\u0007I\u0011\u00025\u0002\u000f]\u0014\u0018\u000e^5oOV\tQ\u0003C\u0005k\u0001\u0001\u0007\t\u0019!C\u0005W\u0006YqO]5uS:<w\fJ3r)\tyF\u000eC\u0004dS\u0006\u0005\t\u0019A\u000b\t\u00139\u0004\u0001\u0019!A!B\u0013)\u0012\u0001C<sSRLgn\u001a\u0011\t\u0013A\u0004\u0001\u0019!a\u0001\n\u0013A\u0017a\u0002:fC\u0012Lgn\u001a\u0005\ne\u0002\u0001\r\u00111A\u0005\nM\f1B]3bI&twm\u0018\u0013fcR\u0011q\f\u001e\u0005\bGF\f\t\u00111\u0001\u0016\u0011%1\b\u00011A\u0001B\u0003&Q#\u0001\u0005sK\u0006$\u0017N\\4!\u0011\u0019A\b\u0001\"\u0001\u0003s\u0006Ia.^7Rk\u0016,Xm\u001d\u000b\u0002w!)1\u0010\u0001C\u0001y\u0006)1\u000f]5mYR)Q0!\u0001\u0002\u0006A\u0011!D`\u0005\u0003\u007fn\u0011A\u0001T8oO\"1\u00111\u0001>A\u0002u\fAa]5{K\"1\u0011q\u0001>A\u0002=\tq\u0001\u001e:jO\u001e,'\u000fC\u0004\u0002\f\u0001!I!!\u0004\u0002\u001f\r\u0014X-\u0019;f\t&\u001c8.U;fk\u0016$\u0012!\u0006\u0005\b\u0003#\u0001A\u0011BA\n\u00039\u0019'/Z1uK:+w/U;fk\u0016$2!FA\u000b\u0011\u001d\t9\"a\u0004A\u0002u\f\u0001B]3rk&\u0014X\r\u001a\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\r\tG\r\u001a\u000b\u0005\u0003?\t)\u0003E\u0002\u001b\u0003CI1!a\t\u001c\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\n\u0002\u001a\u0001\u0007\u0011\u0011F\u0001\u0004e><\b\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\fKb\u0004(/Z:tS>t7OC\u0002\u00024\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003o\tiCA\u0005V]N\fg-\u001a*po\"9\u00111\b\u0001\u0005\u0002\u0005u\u0012A\u0002:f[>4X\r\u0006\u0002\u0002*!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0013!B2m_N,G#A0\t\u0013\u0005\u001d\u0003!!A\u0005\u0002\u0005%\u0013\u0001B2paf$\u0012BTA&\u0003\u001b\ny%!\u0015\t\u0011\r\n)\u0005%AA\u0002\u0019B\u0001\u0002LA#!\u0003\u0005\rA\f\u0005\ts\u0005\u0015\u0003\u0013!a\u0001w!A\u0011)!\u0012\u0011\u0002\u0003\u00071\tC\u0005\u0002V\u0001\t\n\u0011\"\u0001\u0002X\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA-U\r1\u00131L\u0016\u0003\u0003;\u0002B!a\u0018\u0002j5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0005v]\u000eDWmY6fI*\u0019\u0011qM\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002l\u0005\u0005$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019HK\u0002/\u00037B\u0011\"a\u001e\u0001#\u0003%\t!!\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0010\u0016\u0004w\u0005m\u0003\"CA@\u0001E\u0005I\u0011AAA\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a!+\u0007\r\u000bY\u0006C\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a#\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%3\u0003\u0011a\u0017M\\4\n\t\u0005U\u0015q\u0012\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005e\u0005!!A\u0005\u0002i\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"!(\u0001\u0003\u0003%\t!a(\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011UAT!\rQ\u00121U\u0005\u0004\u0003K[\"aA!os\"A1-a'\u0002\u0002\u0003\u00071\bC\u0005\u0002,\u0002\t\t\u0011\"\u0011\u0002.\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00020B1\u0011\u0011WA\\\u0003Ck!!a-\u000b\u0007\u0005U6$\u0001\u0006d_2dWm\u0019;j_:LA!!/\u00024\nA\u0011\n^3sCR|'\u000fC\u0005\u0002>\u0002\t\t\u0011\"\u0001\u0002@\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002 \u0005\u0005\u0007\"C2\u0002<\u0006\u0005\t\u0019AAQ\u0011!\t)\rAA\u0001\n\u0003J\u0018\u0001\u00035bg\"\u001cu\u000eZ3\t\u0013\u0005%\u0007!!A\u0005B\u0005-\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005-\u0005\"CAh\u0001\u0005\u0005I\u0011IAi\u0003\u0019)\u0017/^1mgR!\u0011qDAj\u0011%\u0019\u0017QZA\u0001\u0002\u0004\t\t\u000b\u0003\u0007\u0002X\u0002\u0001\n\u0011!A\u0001\n\u0003\tI.\u0001\nqe>$Xm\u0019;fI\u00122'/Z3QC\u001e,G\u0003BAn\u0003[$2aXAo\u0011%\u0019\u0017Q[A\u0001\u0002\u0004\ty\u000e\u0005\u0003\u0002b\u0006%XBAAr\u0015\r\u0011\u0012Q\u001d\u0006\u0004\u0003OD\u0011AB;og\u00064W-\u0003\u0003\u0002l\u0006\r(aC'f[>\u0014\u0018P\u00117pG.D\u0001bYAk\u0003\u0003\u0005\rAT\u0004\t\u0003c\u0014\u0001\u0012\u0001\u0002\u0002t\u0006q\u0001*\u001f2sS\u0012\u0014vn^)vKV,\u0007c\u0001\f\u0002v\u001a9\u0011A\u0001E\u0001\u0005\u0005]8#BA{\u0003s|\u0002c\u0001\u000e\u0002|&\u0019\u0011Q`\u000e\u0003\r\u0005s\u0017PU3g\u0011\u001da\u0015Q\u001fC\u0001\u0005\u0003!\"!a=\t\u0011\t\u0015\u0011Q\u001fC\u0001\u0005\u000f\tQ!\u00199qYf$rA\u0014B\u0005\u0005\u001b\u0011\t\u0002C\u0004\u0003\f\t\r\u0001\u0019\u0001\u0014\u0002\u001bQ\f7o['f[>\u0014\u00180T4s\u0011\u001d\u0011yAa\u0001A\u00029\nAAZ5mK\"9!1\u0003B\u0002\u0001\u0004Y\u0014A\u00024jK2$7\u000f\u0003\u0006\u0003\u0006\u0005U\u0018\u0011!CA\u0005/!\u0012B\u0014B\r\u00057\u0011iBa\b\t\r\r\u0012)\u00021\u0001'\u0011\u0019a#Q\u0003a\u0001]!1\u0011H!\u0006A\u0002mBa!\u0011B\u000b\u0001\u0004\u0019\u0005B\u0003B\u0012\u0003k\f\t\u0011\"!\u0003&\u00059QO\\1qa2LH\u0003\u0002B\u0014\u0005g\u0001RA\u0007B\u0015\u0005[I1Aa\u000b\u001c\u0005\u0019y\u0005\u000f^5p]B9!Da\f']m\u001a\u0015b\u0001B\u00197\t1A+\u001e9mKRB\u0011B!\u000e\u0003\"\u0005\u0005\t\u0019\u0001(\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003:\u0005U\u0018\u0011!C\u0005\u0005w\t1B]3bIJ+7o\u001c7wKR\u0011!Q\b\t\u0005\u0003\u001b\u0013y$\u0003\u0003\u0003B\u0005=%AB(cU\u0016\u001cG\u000f")
public class HybridRowQueue
extends MemoryConsumer
implements RowQueue,
Product,
scala.Serializable {
    private final TaskMemoryManager memManager;
    private final File tempDir;
    private final int numFields;
    private final SerializerManager serMgr;
    private LinkedList<RowQueue> queues;
    private RowQueue writing;
    private RowQueue reading;

    public static Option<Tuple4<TaskMemoryManager, File, Object, SerializerManager>> unapply(HybridRowQueue hybridRowQueue) {
        return HybridRowQueue$.MODULE$.unapply(hybridRowQueue);
    }

    public static HybridRowQueue apply(TaskMemoryManager taskMemoryManager, File file, int n, SerializerManager serializerManager) {
        return HybridRowQueue$.MODULE$.apply(taskMemoryManager, file, n, serializerManager);
    }

    public static HybridRowQueue apply(TaskMemoryManager taskMemoryManager, File file, int n) {
        return HybridRowQueue$.MODULE$.apply(taskMemoryManager, file, n);
    }

    public /* synthetic */ void protected$freePage(HybridRowQueue x$1, MemoryBlock x$12) {
        x$1.freePage(x$12);
    }

    public TaskMemoryManager memManager() {
        return this.memManager;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public int numFields() {
        return this.numFields;
    }

    public SerializerManager serMgr() {
        return this.serMgr;
    }

    private LinkedList<RowQueue> queues() {
        return this.queues;
    }

    private void queues_$eq(LinkedList<RowQueue> x$1) {
        this.queues = x$1;
    }

    private RowQueue writing() {
        return this.writing;
    }

    private void writing_$eq(RowQueue x$1) {
        this.writing = x$1;
    }

    private RowQueue reading() {
        return this.reading;
    }

    private void reading_$eq(RowQueue x$1) {
        this.reading = x$1;
    }

    public int numQueues() {
        return this.queues().size();
    }

    public long spill(long size, MemoryConsumer trigger) {
        MemoryConsumer memoryConsumer = trigger;
        HybridRowQueue hybridRowQueue = this;
        if (!(memoryConsumer != null ? !memoryConsumer.equals(hybridRowQueue) : hybridRowQueue != null)) {
            return 0L;
        }
        long released = 0L;
        HybridRowQueue hybridRowQueue2 = this;
        synchronized (hybridRowQueue2) {
            LinkedList<RowQueue> newQueues = new LinkedList<RowQueue>();
            while (!this.queues().isEmpty()) {
                RowQueue rowQueue;
                RowQueue queue = this.queues().remove();
                if (!this.queues().isEmpty() && queue instanceof InMemoryRowQueue) {
                    RowQueue diskQueue = this.createDiskQueue();
                    UnsafeRow row = queue.remove();
                    while (row != null) {
                        diskQueue.add(row);
                        row = queue.remove();
                    }
                    released += ((InMemoryRowQueue)queue).page().size();
                    queue.close();
                    rowQueue = diskQueue;
                } else {
                    rowQueue = queue;
                }
                RowQueue newQueue = rowQueue;
                newQueues.add(newQueue);
            }
            this.queues_$eq(newQueues);
        }
        return released;
    }

    private RowQueue createDiskQueue() {
        return new DiskRowQueue(File.createTempFile("buffer", "", this.tempDir()), this.numFields(), this.serMgr());
    }

    private RowQueue createNewQueue(long required) {
        MemoryBlock memoryBlock;
        try {
            memoryBlock = this.allocatePage(required);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            memoryBlock = null;
        }
        MemoryBlock page = memoryBlock;
        RowQueue buffer = page != null ? new InMemoryRowQueue(this, page){
            private final /* synthetic */ HybridRowQueue $outer;

            public void close() {
                this.$outer.protected$freePage(this.$outer, this.page());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(page$1, $outer.numFields());
            }
        } : this.createDiskQueue();
        HybridRowQueue hybridRowQueue = this;
        synchronized (hybridRowQueue) {
            this.queues().add(buffer);
        }
        return buffer;
    }

    @Override
    public boolean add(UnsafeRow row) {
        if (this.writing() == null || !this.writing().add(row)) {
            this.writing_$eq(this.createNewQueue(4 + row.getSizeInBytes()));
            if (!this.writing().add(row)) {
                throw new SparkException(new StringBuilder(26).append("failed to push a row into ").append(this.writing()).toString());
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnsafeRow remove() {
        void var1_1;
        block5: {
            UnsafeRow row = null;
            if (this.reading() != null) {
                row = this.reading().remove();
            }
            if (row != null) break block5;
            if (this.reading() != null) {
                this.reading().close();
            }
            HybridRowQueue hybridRowQueue = this;
            synchronized (hybridRowQueue) {
                this.reading_$eq(this.queues().remove());
            }
            Predef$.MODULE$.assert(this.reading() != null, (Function0 & Serializable & scala.Serializable)() -> "queue should not be empty");
            row = this.reading().remove();
            Predef$.MODULE$.assert(row != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append(this.reading()).append(" should have at least one row").toString());
        }
        return var1_1;
    }

    @Override
    public void close() {
        if (this.reading() != null) {
            this.reading().close();
            this.reading_$eq(null);
        }
        HybridRowQueue hybridRowQueue = this;
        synchronized (hybridRowQueue) {
            while (!this.queues().isEmpty()) {
                this.queues().remove().close();
            }
        }
    }

    public HybridRowQueue copy(TaskMemoryManager memManager, File tempDir, int numFields, SerializerManager serMgr) {
        return new HybridRowQueue(memManager, tempDir, numFields, serMgr);
    }

    public TaskMemoryManager copy$default$1() {
        return this.memManager();
    }

    public File copy$default$2() {
        return this.tempDir();
    }

    public int copy$default$3() {
        return this.numFields();
    }

    public SerializerManager copy$default$4() {
        return this.serMgr();
    }

    public String productPrefix() {
        return "HybridRowQueue";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.memManager();
                break;
            }
            case 1: {
                object = this.tempDir();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.numFields());
                break;
            }
            case 3: {
                object = this.serMgr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HybridRowQueue;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.memManager()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tempDir()));
        n = Statics.mix((int)n, (int)this.numFields());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.serMgr()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HybridRowQueue)) return false;
        boolean bl = true;
        if (!bl) return false;
        HybridRowQueue hybridRowQueue = (HybridRowQueue)x$1;
        TaskMemoryManager taskMemoryManager = this.memManager();
        TaskMemoryManager taskMemoryManager2 = hybridRowQueue.memManager();
        if (taskMemoryManager == null) {
            if (taskMemoryManager2 != null) {
                return false;
            }
        } else if (!taskMemoryManager.equals(taskMemoryManager2)) return false;
        File file = this.tempDir();
        File file2 = hybridRowQueue.tempDir();
        if (file == null) {
            if (file2 != null) {
                return false;
            }
        } else if (!((Object)file).equals(file2)) return false;
        if (this.numFields() != hybridRowQueue.numFields()) return false;
        SerializerManager serializerManager = this.serMgr();
        SerializerManager serializerManager2 = hybridRowQueue.serMgr();
        if (serializerManager == null) {
            if (serializerManager2 != null) {
                return false;
            }
        } else if (!serializerManager.equals(serializerManager2)) return false;
        if (!hybridRowQueue.canEqual(this)) return false;
        return true;
    }

    public HybridRowQueue(TaskMemoryManager memManager, File tempDir, int numFields, SerializerManager serMgr) {
        this.memManager = memManager;
        this.tempDir = tempDir;
        this.numFields = numFields;
        this.serMgr = serMgr;
        super(memManager);
        Product.$init$((Product)this);
        this.queues = new LinkedList();
    }
}

